/*
 * Decompiled with CFR 0.152.
 */
package xdman.downloaders.metadata.manifests;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import xdman.util.Logger;
import xdman.util.StringUtils;

public class M3U8Manifest {
    private String playlistUrl;
    private float duration;
    private ArrayList<String> mediaUrls;
    private boolean masterPlaylist;
    private boolean encrypted;
    private ArrayList<M3U8MediaInfo> mediaProperties;

    public M3U8Manifest(String file, String playlistUrl) throws Exception {
        this.playlistUrl = playlistUrl;
        this.mediaUrls = new ArrayList();
        this.mediaProperties = new ArrayList();
        ArrayList<String> urlList = this.parseManifest(file);
        this.makeMediaUrls(urlList);
    }

    public ArrayList<String> getMediaUrls() {
        return this.mediaUrls;
    }

    public M3U8MediaInfo getMediaProperty(int index) {
        return this.mediaProperties.get(index);
    }

    private void makeMediaUrls(ArrayList<String> list) throws Exception {
        String base_url = "";
        URI uri = null;
        int i = 0;
        while (i < list.size()) {
            String item = list.get(i);
            String item_url = this.resolveURL(this.playlistUrl, item);
            if (item_url == null) {
                if (item.startsWith("/")) {
                    if (StringUtils.isNullOrEmpty(base_url)) {
                        if (uri == null) {
                            uri = new URI(this.playlistUrl);
                        }
                        base_url = String.valueOf(uri.getScheme()) + "://" + uri.getHost() + (uri.getPort() > 0 ? ":" + uri.getPort() : "");
                    }
                    item_url = String.valueOf(base_url) + item;
                } else if (item.startsWith("http://") || item.startsWith("https://")) {
                    item_url = item;
                } else {
                    int index = this.playlistUrl.lastIndexOf(47);
                    item_url = String.valueOf(this.playlistUrl.substring(0, index)) + "/";
                    item_url = String.valueOf(item_url) + item;
                }
            }
            this.mediaUrls.add(item_url);
            ++i;
        }
    }

    private String resolveURL(String playlistUrl, String segmentUrl) {
        try {
            Logger.log("Manifest Segment parsing ");
            if (!segmentUrl.startsWith("http://") && !segmentUrl.startsWith("https://")) {
                URI uri = new URI(playlistUrl);
                String str = uri.resolve(segmentUrl).normalize().toString();
                Logger.log("Manifest Segment parsing: " + str);
                return str;
            }
            return segmentUrl;
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.log(e);
            return null;
        }
    }

    private ArrayList<String> parseManifest(String file) throws IOException {
        ArrayList<String> urlList = new ArrayList<String>();
        BufferedReader r = null;
        try {
            try {
                String line;
                r = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                boolean expect = false;
                while ((line = r.readLine()) != null) {
                    String[] arr;
                    String highline = line.toUpperCase().trim();
                    if (highline.length() < 1) continue;
                    if (highline.startsWith("#EXT-X-KEY")) {
                        Logger.log("Encrypted segment detected: " + line);
                        this.encrypted = true;
                        break;
                    }
                    if (expect) {
                        urlList.add(line.trim());
                        expect = false;
                    }
                    if (highline.startsWith("#EXT-X-STREAM-INF")) {
                        this.masterPlaylist = true;
                        expect = true;
                        arr = highline.split(":");
                        if (arr.length > 1) {
                            this.mediaProperties.add(M3U8MediaInfo.parse(arr[1].trim()));
                        }
                    }
                    if (!highline.startsWith("#EXTINF")) continue;
                    this.masterPlaylist = false;
                    expect = true;
                    try {
                        arr = highline.split(":");
                        if (arr.length <= 1) continue;
                        this.mediaProperties.add(M3U8MediaInfo.parse(arr[1].trim()));
                        String str = arr[1].trim().split(",")[0];
                        this.duration += Float.parseFloat(str);
                    }
                    catch (Exception e) {
                        Logger.log(e);
                    }
                }
            }
            catch (Exception e) {
                Logger.log(e);
                throw new IOException("Unable to parse menifest");
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception exception) {}
        }
        return urlList;
    }

    public final float getDuration() {
        return this.duration;
    }

    public final boolean isMasterPlaylist() {
        return this.masterPlaylist;
    }

    public final boolean isEncrypted() {
        return this.encrypted;
    }

    public static class M3U8MediaInfo {
        private String resolution;
        private String bandwidth;

        public final String getResolution() {
            return this.resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public String toString() {
            return "bw: " + this.bandwidth + " res: " + this.resolution;
        }

        public static M3U8MediaInfo parse(String str) {
            String[] arr = str.split(",");
            M3U8MediaInfo info = new M3U8MediaInfo();
            int j = 0;
            while (j < arr.length) {
                try {
                    String ss = arr[j].toUpperCase();
                    if (ss.startsWith("RESOLUTION") && ss.contains("=")) {
                        info.resolution = ss.split("=")[1].trim();
                    }
                    if (ss.startsWith("BANDWIDTH") && ss.contains("=")) {
                        info.bandwidth = ss.split("=")[1].trim();
                        int bps = 0;
                        try {
                            bps = Integer.parseInt(info.bandwidth);
                            info.bandwidth = String.valueOf(bps / 1000) + " kbps";
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            return info;
        }
    }
}

