/*
 * Decompiled with CFR 0.152.
 */
package xdman.network;

import java.io.IOException;
import java.io.InputStream;

public class FixedRangeInputStream
extends InputStream {
    private InputStream baseStream;
    private long rem;

    public FixedRangeInputStream(InputStream baseStream, long length) {
        this.baseStream = baseStream;
        this.rem = length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int x;
        if (this.rem == 0L) {
            return -1;
        }
        if (this.rem > 0L && (long)len > this.rem) {
            len = (int)this.rem;
        }
        if ((x = this.baseStream.read(b, off, len)) == -1) {
            if (this.rem > 0L) {
                throw new IOException("Unexpected eof");
            }
            return -1;
        }
        if (this.rem > 0L) {
            this.rem -= (long)x;
        }
        return x;
    }

    @Override
    public int read() throws IOException {
        if (this.rem == 0L) {
            return -1;
        }
        int x = this.baseStream.read();
        if (x == -1) {
            if (this.rem > 0L) {
                throw new IOException("Unexpected eof");
            }
            return -1;
        }
        if (this.rem > 0L) {
            this.rem -= (long)x;
        }
        return x;
    }

    @Override
    public void close() throws IOException {
        this.baseStream.close();
    }

    public boolean isStreamFinished() {
        return this.rem == 0L;
    }
}

