/*
 * Decompiled with CFR 0.152.
 */
package xdman.network;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import xdman.network.KeepAliveInfo;

public class KeepAliveConnectionCache
implements Runnable {
    private ArrayList<KeepAliveInfo> socketList = new ArrayList();
    private boolean stop;
    private final int MAX_KEEP_ALIVE_INT = 2000;
    private Thread t;
    private static KeepAliveConnectionCache _this;
    private static Object lock;

    static {
        lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeepAliveConnectionCache getInstance() {
        Object object = lock;
        synchronized (object) {
            if (_this == null) {
                _this = new KeepAliveConnectionCache();
                _this.start();
            }
            return _this;
        }
    }

    private KeepAliveConnectionCache() {
    }

    public synchronized void putSocket(Socket socket, String host, int port) {
        KeepAliveInfo info = new KeepAliveInfo();
        info.setLastUsed(System.currentTimeMillis());
        info.setHost(host);
        info.setPort(port);
        info.setSocket(socket);
        this.socketList.add(info);
    }

    public synchronized Socket getReusableSocket(String host, int port) {
        long now = System.currentTimeMillis();
        int i = 0;
        while (i < this.socketList.size()) {
            KeepAliveInfo info = this.socketList.get(i);
            if (info.getHost().equals(host) && info.getPort() == port && now - info.getLastUsed() < 2000L) {
                this.socketList.remove(i);
                return info.getSocket();
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavengeCache() {
        ArrayList<Socket> sockets2Close = new ArrayList<Socket>();
        KeepAliveConnectionCache keepAliveConnectionCache = _this;
        synchronized (keepAliveConnectionCache) {
            int i = 0;
            while (i < this.socketList.size()) {
                KeepAliveInfo info = this.socketList.get(i);
                long now = System.currentTimeMillis();
                if (now - info.getLastUsed() >= 2000L) {
                    this.socketList.remove(i);
                    sockets2Close.add(info.getSocket());
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.socketList.size()) {
            KeepAliveInfo info = this.socketList.get(i);
            long now = System.currentTimeMillis();
            if (now - info.getLastUsed() >= 2000L) {
                this.socketList.remove(i);
                try {
                    info.getSocket().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    @Override
    public void run() {
        while (!this.stop) {
            long lastrun = System.currentTimeMillis();
            this.scavengeCache();
            long now = System.currentTimeMillis();
            if (now - lastrun >= 2000L) continue;
            try {
                Thread.sleep(2000L - (now - lastrun));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void stop() {
        this.stop = true;
        if (this.t != null) {
            this.t.interrupt();
        }
    }
}

