/*
 * Decompiled with CFR 0.152.
 */
package xdman.preview;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import xdman.XDMApp;
import xdman.preview.Chunk;
import xdman.preview.ChunkLoader;

public class PreviewStream
extends InputStream {
    List<Chunk> chunks;
    String currentId;
    long read;
    InputStream chunkStream;
    String id;
    String tag;
    int type;
    Chunk currentChunk;

    public PreviewStream(String id, int type, String tag) {
        this.id = id;
        this.type = type;
        this.tag = tag;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        Chunk c;
        if (this.chunks == null) {
            this.chunks = ChunkLoader.load(this.id, this.type);
            if (this.chunks.size() > 0) {
                int i = 0;
                while (i < this.chunks.size()) {
                    c = this.chunks.get(i);
                    if (this.tag != null && this.tag.equals(c.tag)) {
                        this.currentChunk = c;
                        this.currentId = c.id;
                        break;
                    }
                    if (this.tag == null) {
                        this.currentChunk = c;
                        this.currentId = c.id;
                        break;
                    }
                    ++i;
                }
                this.openstream();
                this.read = 0L;
            }
        }
        int r = -1;
        if (this.chunkStream != null) {
            r = this.chunkStream.read(buf, off, len);
        }
        if (r != -1) {
            this.read += (long)r;
        }
        if (r == -1) {
            int rem;
            if (this.chunkStream != null) {
                this.chunkStream.close();
                this.chunkStream = null;
            }
            this.chunks = ChunkLoader.load(this.id, this.type);
            c = this.findCurrentChunk();
            if (this.read >= c.length) {
                System.out.println("Chunk finished, trying next chunk");
                c = this.findNext();
                this.currentId = c.id;
                this.openstream();
                this.read = 0L;
                r = this.chunkStream.read(buf, off, len);
                if (r == -1) {
                    this.chunkStream.close();
                    return -1;
                }
                this.read += (long)r;
                return r;
            }
            System.out.println("Chunk is not finshed, sending 00000.....");
            r = rem = c.length - this.read > (long)buf.length ? buf.length : (int)(c.length - this.read);
            int i = 0;
            while (i < rem) {
                buf[i] = 0;
                ++i;
            }
            this.read += (long)r;
            return r;
        }
        return r;
    }

    private Chunk findNext() {
        Chunk c = this.findCurrentChunk();
        int index = this.chunks.indexOf(c);
        int i = index + 1;
        while (i < this.chunks.size()) {
            Chunk c2 = this.chunks.get(i);
            if (c.tag != null) {
                if (c.tag.equals(c2.tag)) {
                    return c2;
                }
            } else {
                return c2;
            }
            ++i;
        }
        return null;
    }

    private Chunk findCurrentChunk() {
        for (Chunk c : this.chunks) {
            if (!c.id.equals(this.currentId)) continue;
            return c;
        }
        return null;
    }

    private void openstream() throws IOException {
        String tempFolder = XDMApp.getInstance().getEntry(this.id).getTempFolder();
        File tmpFolder = new File(tempFolder, this.id);
        this.chunkStream = new FileInputStream(new File(tmpFolder, this.currentId));
        System.out.println("Stream opened");
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        if (this.read(buf, 0, 1) == -1) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        try {
            this.chunkStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

