/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import xdman.Config;
import xdman.DownloadQueue;
import xdman.QueueManager;
import xdman.XDMApp;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.ui.components.ClipboardBatchItem;
import xdman.ui.components.CustomButton;
import xdman.ui.components.DarkScrollBar;
import xdman.ui.components.QueueListRenderer;
import xdman.ui.components.SimpleListRenderer;
import xdman.ui.components.TitlePanel;
import xdman.ui.components.XDMFileChooser;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.Logger;
import xdman.util.StringUtils;
import xdman.util.XDMUtils;

public class BatchClipboardWnd
extends JFrame
implements ActionListener {
    JList<ClipboardBatchItem> list;
    DefaultListModel<ClipboardBatchItem> model = new DefaultListModel();
    JTextField txtFile;
    DefaultComboBoxModel<DownloadQueue> queueModel;
    JComboBox<DownloadQueue> cmbQueues;
    JCheckBox chkStartQueue;

    public static List<String> getUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        String text = XDMUtils.getClipBoardText();
        if (!StringUtils.isNullOrEmptyOrBlank(text)) {
            System.out.println(text);
            String[] arr = text.split("\n");
            int i = 0;
            while (i < arr.length) {
                String url = arr[i];
                try {
                    new URL(url);
                    urls.add(url);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        return urls;
    }

    public BatchClipboardWnd(List<String> urls) {
        this.list = new JList<ClipboardBatchItem>(this.model);
        this.initUI();
        int i = 0;
        while (i < urls.size()) {
            String url = urls.get(i);
            try {
                String file = XDMUtils.getFileName(url);
                ClipboardBatchItem item = new ClipboardBatchItem();
                item.file = file;
                item.url = url;
                this.model.addElement(item);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComponent) {
            String name = ((JComponent)e.getSource()).getName();
            if (name.startsWith("CLOSE")) {
                this.dispose();
            } else if (name.startsWith("BROWSE_FOLDER")) {
                JFileChooser jfc = XDMFileChooser.getFileChooser(1, new File(Config.getInstance().getDownloadFolder()));
                if (jfc.showOpenDialog(this) == 0) {
                    this.txtFile.setText(jfc.getSelectedFile().getAbsolutePath());
                }
            } else if (name.equals("DOWNLOAD")) {
                DownloadQueue queue = (DownloadQueue)this.cmbQueues.getSelectedItem();
                if (queue != null) {
                    this.createDownload(queue);
                    if (this.chkStartQueue.isSelected()) {
                        queue.start();
                    }
                }
                this.dispose();
            }
        }
    }

    private void createDownload(DownloadQueue q) {
        String folder = this.txtFile.getText();
        int i = 0;
        while (i < this.model.size()) {
            ClipboardBatchItem item = this.model.getElementAt(i);
            String file = item.file;
            String url = item.url;
            HttpMetadata metadata = new HttpMetadata();
            metadata.setUrl(url);
            folder = this.txtFile.getText();
            XDMApp.getInstance().createDownload(file, folder, metadata, false, q == null ? "" : q.getQueueId(), 0, 0);
            ++i;
        }
    }

    private void initUI() {
        this.setUndecorated(true);
        try {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
                this.setOpacity(0.85f);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        this.setTitle(StringResource.get("MENU_BATCH_DOWNLOAD"));
        this.setIconImage(ImageResource.get("icon.png").getImage());
        this.setSize(500, 420);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(ColorResource.getDarkestBgColor());
        TitlePanel titlePanel = new TitlePanel(null, this);
        titlePanel.setOpaque(false);
        titlePanel.setBounds(0, 0, this.getWidth(), 50);
        CustomButton closeBtn = new CustomButton();
        closeBtn.setBounds(this.getWidth() - 35, 5, 30, 30);
        closeBtn.setBackground(ColorResource.getDarkestBgColor());
        closeBtn.setBorderPainted(false);
        closeBtn.setFocusPainted(false);
        closeBtn.setName("CLOSE");
        closeBtn.setIcon(ImageResource.get("close_btn.png"));
        closeBtn.addActionListener(this);
        titlePanel.add(closeBtn);
        JLabel titleLbl = new JLabel(StringResource.get("MENU_BATCH_DOWNLOAD"));
        titleLbl.setFont(FontResource.getBiggerFont());
        titleLbl.setForeground(ColorResource.getSelectionColor());
        titleLbl.setBounds(25, 15, 200, 30);
        titlePanel.add(titleLbl);
        JLabel lineLbl = new JLabel();
        lineLbl.setBackground(ColorResource.getSelectionColor());
        lineLbl.setBounds(0, 55, this.getWidth(), 1);
        lineLbl.setOpaque(true);
        this.add(lineLbl);
        this.add(titlePanel);
        int y = 55;
        int h = 250;
        this.list.setBorder(null);
        this.list.setOpaque(false);
        this.list.setCellRenderer(new SimpleListRenderer());
        JScrollPane jsp = new JScrollPane(this.list);
        jsp.setBounds(0, y, this.getWidth(), h);
        jsp.getViewport().setOpaque(false);
        jsp.setBorder(null);
        jsp.setOpaque(false);
        DarkScrollBar scrollBar = new DarkScrollBar(1);
        jsp.setVerticalScrollBar(scrollBar);
        jsp.setHorizontalScrollBarPolicy(31);
        this.add(jsp);
        JLabel lineLbl2 = new JLabel();
        lineLbl2.setBackground(ColorResource.getDarkBgColor());
        lineLbl2.setBounds(0, y += h, this.getWidth(), 1);
        lineLbl2.setOpaque(true);
        this.add(lineLbl2);
        JLabel lblFile = new JLabel(StringResource.get("LBL_SAVE_IN"), 4);
        lblFile.setFont(FontResource.getNormalFont());
        lblFile.setForeground(Color.WHITE);
        lblFile.setBounds(0, y += 10, 80, 30);
        this.add(lblFile);
        this.txtFile = new JTextField();
        this.txtFile.setBorder(new LineBorder(ColorResource.getSelectionColor(), 1));
        this.txtFile.setBackground(ColorResource.getDarkestBgColor());
        this.txtFile.setForeground(Color.WHITE);
        this.txtFile.setBounds(90, y + 5, 290, 20);
        this.txtFile.setCaretColor(ColorResource.getSelectionColor());
        this.txtFile.setText(Config.getInstance().getDownloadFolder());
        this.add(this.txtFile);
        CustomButton browse = new CustomButton("...");
        browse.setName("BROWSE_FOLDER");
        browse.setMargin(new Insets(0, 0, 0, 0));
        browse.setBounds(390, y + 5, 40, 20);
        browse.setFocusPainted(false);
        browse.setBackground(ColorResource.getDarkestBgColor());
        browse.setBorder(new LineBorder(ColorResource.getSelectionColor(), 1));
        browse.setForeground(Color.WHITE);
        browse.addActionListener(this);
        browse.setFont(FontResource.getItemFont());
        this.add(browse);
        JLabel lblQueue = new JLabel(StringResource.get("LBL_QUEUE_USE"), 4);
        lblQueue.setFont(FontResource.getNormalFont());
        lblQueue.setForeground(Color.WHITE);
        lblQueue.setBounds(0, y += 30, 80, 30);
        this.add(lblQueue);
        this.queueModel = new DefaultComboBoxModel();
        ArrayList<DownloadQueue> qlist = QueueManager.getInstance().getQueueList();
        int i = 0;
        while (i < qlist.size()) {
            this.queueModel.addElement(qlist.get(i));
            ++i;
        }
        this.cmbQueues = new JComboBox<DownloadQueue>(this.queueModel);
        this.cmbQueues.setRenderer(new QueueListRenderer());
        this.cmbQueues.setBounds(90, y, 340, 20);
        this.add(this.cmbQueues);
        y += 35;
        this.chkStartQueue = new JCheckBox(StringResource.get("LBL_START_QUEUE_PROCESSING"));
        this.chkStartQueue.setBackground(ColorResource.getDarkestBgColor());
        this.chkStartQueue.setName("START_QUEUE");
        this.chkStartQueue.setForeground(Color.WHITE);
        this.chkStartQueue.setFocusPainted(false);
        this.chkStartQueue.setBounds(15, y, 200, 20);
        this.chkStartQueue.setIcon(ImageResource.get("unchecked.png"));
        this.chkStartQueue.setSelectedIcon(ImageResource.get("checked.png"));
        this.chkStartQueue.addActionListener(this);
        this.add(this.chkStartQueue);
        h = 25;
        JButton btnDwn = this.createButton("MB_OK");
        btnDwn.setBounds(this.getWidth() - 15 - 100, y, 100, h);
        btnDwn.setName("DOWNLOAD");
        this.add(btnDwn);
        JButton btnCn = this.createButton("ND_CANCEL");
        btnCn.setBounds(this.getWidth() - 15 - 100 - 110, y, 100, h);
        btnCn.setName("CLOSE");
        this.add(btnCn);
    }

    private JButton createButton(String name) {
        CustomButton btn = new CustomButton(StringResource.get(name));
        btn.setBackground(ColorResource.getDarkBtnColor());
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setForeground(Color.WHITE);
        btn.setFont(FontResource.getNormalFont());
        btn.addActionListener(this);
        return btn;
    }
}

