/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import xdman.XDMApp;
import xdman.downloaders.metadata.DashMetadata;
import xdman.downloaders.metadata.HdsMetadata;
import xdman.downloaders.metadata.HlsMetadata;
import xdman.downloaders.metadata.HttpMetadata;
import xdman.network.http.HttpHeader;
import xdman.ui.components.BatchVideoWnd;
import xdman.ui.components.CustomButton;
import xdman.ui.components.DarkScrollBar;
import xdman.ui.components.MediaImageSource;
import xdman.ui.components.PopupAdapter;
import xdman.ui.components.TitlePanel;
import xdman.ui.components.VideoDownloadItem;
import xdman.ui.components.VideoItemEditor;
import xdman.ui.components.VideoItemRenderer;
import xdman.ui.components.VideoItemWrapper;
import xdman.ui.components.VideoTableModel;
import xdman.ui.res.ColorResource;
import xdman.ui.res.FontResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.FormatUtilities;
import xdman.util.Logger;
import xdman.util.XDMUtils;
import xdman.videoparser.ThumbnailDownloader;
import xdman.videoparser.ThumbnailListener;
import xdman.videoparser.YdlResponse;
import xdman.videoparser.YoutubeDLHandler;

public class MediaDownloaderWnd
extends JFrame
implements ActionListener,
ThumbnailListener,
MediaImageSource {
    private JTextField txtURL;
    JButton btnDwn;
    JButton btnBack;
    JButton btnStart;
    JProgressBar prg;
    JScrollPane jsp;
    private boolean stop;
    YoutubeDLHandler ydl;
    private VideoTableModel model;
    private JTable table;
    private long instancekey;
    private Map<String, ImageIcon> imageMap;
    private ThumbnailDownloader thumbnailDownloader;
    private JCheckBox chkSelectAll;

    public MediaDownloaderWnd() {
        this.initUI();
        this.imageMap = new HashMap<String, ImageIcon>();
        try {
            URL url = new URL(XDMUtils.getClipBoardText());
            this.txtURL.setText(url.toString());
            this.txtURL.setCaretPosition(0);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private void initUI() {
        this.setUndecorated(true);
        try {
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
                this.setOpacity(0.85f);
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        this.setTitle(StringResource.get("TITLE_DOWN_VID"));
        this.setIconImage(ImageResource.get("icon.png").getImage());
        this.setSize(500, 420);
        this.setLocationRelativeTo(null);
        this.getContentPane().setLayout(null);
        this.getContentPane().setBackground(ColorResource.getDarkestBgColor());
        TitlePanel titlePanel = new TitlePanel(null, this);
        titlePanel.setOpaque(false);
        titlePanel.setBounds(0, 0, this.getWidth(), 50);
        CustomButton closeBtn = new CustomButton();
        closeBtn.setBounds(this.getWidth() - 35, 5, 30, 30);
        closeBtn.setBackground(ColorResource.getDarkestBgColor());
        closeBtn.setBorderPainted(false);
        closeBtn.setFocusPainted(false);
        closeBtn.setName("CLOSE");
        closeBtn.setIcon(ImageResource.get("close_btn.png"));
        closeBtn.addActionListener(this);
        titlePanel.add(closeBtn);
        JLabel titleLbl = new JLabel(StringResource.get("TITLE_DOWN_VID"));
        titleLbl.setFont(FontResource.getBiggerFont());
        titleLbl.setForeground(ColorResource.getSelectionColor());
        titleLbl.setBounds(25, 15, 200, 30);
        titlePanel.add(titleLbl);
        JLabel lineLbl = new JLabel();
        lineLbl.setBackground(ColorResource.getSelectionColor());
        lineLbl.setBounds(0, 55, this.getWidth(), 1);
        lineLbl.setOpaque(true);
        this.add(lineLbl);
        this.add(titlePanel);
        int y = 55;
        int h = 30;
        this.prg = new JProgressBar();
        this.prg.setIndeterminate(true);
        this.prg.setBounds(15, y += 15, this.getWidth() - 30, 5);
        this.prg.setBorder(null);
        this.prg.setVisible(false);
        this.add(this.prg);
        this.txtURL = new JTextField();
        PopupAdapter.registerTxtPopup(this.txtURL);
        this.txtURL.setBounds(15, y, this.getWidth() - 30 - 110, h);
        this.add(this.txtURL);
        this.btnStart = this.createButton("BTN_SEARCH_VIDEO");
        this.btnStart.setBounds(this.getWidth() - 15 - 100, y, 100, h);
        this.btnStart.setName("START");
        this.add(this.btnStart);
        VideoDownloadItem item1 = new VideoDownloadItem();
        item1.title = "First item for text test";
        item1.desc = "Sample description for text tesing description";
        h = 300;
        this.model = new VideoTableModel();
        this.table = new JTable(this.model);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setRowHeight(80);
        this.table.setShowGrid(false);
        this.table.setOpaque(false);
        this.table.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.setDefaultRenderer(VideoItemWrapper.class, new VideoItemRenderer(this));
        this.table.setDefaultEditor(VideoItemWrapper.class, new VideoItemEditor(this));
        this.table.setTableHeader(null);
        this.jsp = new JScrollPane();
        this.jsp.setBounds(15, y, this.getWidth() - 30, h);
        this.jsp.setBorder(new LineBorder(ColorResource.getDarkBgColor()));
        this.jsp.getViewport().setOpaque(false);
        this.jsp.setViewportView(this.table);
        this.jsp.setOpaque(false);
        DarkScrollBar scrollBar = new DarkScrollBar(1);
        this.jsp.setVerticalScrollBar(scrollBar);
        this.jsp.setHorizontalScrollBarPolicy(30);
        this.add(this.jsp);
        this.jsp.setVisible(false);
        y += h;
        h = 30;
        this.btnDwn = this.createButton("LBL_DOWNLOAD");
        this.btnDwn.setBounds(this.getWidth() - 15 - 120, y += 10, 120, h);
        this.btnDwn.setName("DOWNLOAD");
        this.btnDwn.setVisible(false);
        this.add(this.btnDwn);
        this.chkSelectAll = new JCheckBox(StringResource.get("LBL_SELECT_ALL"));
        this.chkSelectAll.setBackground(ColorResource.getDarkestBgColor());
        this.chkSelectAll.setName("SELECT_ALL");
        this.chkSelectAll.setForeground(Color.WHITE);
        this.chkSelectAll.setFocusPainted(false);
        this.chkSelectAll.setBounds(120, y + 5, 150, 20);
        this.chkSelectAll.setIcon(ImageResource.get("unchecked.png"));
        this.chkSelectAll.setSelectedIcon(ImageResource.get("checked.png"));
        this.chkSelectAll.addActionListener(this);
        this.chkSelectAll.setVisible(false);
        this.add(this.chkSelectAll);
        this.btnBack = this.createButton("BTN_BACK");
        this.btnBack.setBounds(15, y, 100, h);
        this.btnBack.setName("BACK");
        this.add(this.btnBack);
        this.btnBack.setVisible(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                MediaDownloaderWnd.this.txtURL.requestFocus();
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }
        });
    }

    private JButton createButton(String name) {
        CustomButton btn = new CustomButton(StringResource.get(name));
        btn.setBackground(ColorResource.getDarkBtnColor());
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setForeground(Color.WHITE);
        btn.setFont(FontResource.getNormalFont());
        btn.addActionListener(this);
        return btn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        String name = c.getName();
        if ("START".equals(name)) {
            this.imageMap.clear();
            this.instancekey = System.currentTimeMillis();
            this.model.clear();
            if (this.txtURL.getText().length() < 1) {
                JOptionPane.showMessageDialog(this, StringResource.get("MSG_NO_URL"));
                return;
            }
            if (!XDMUtils.checkComponentsInstalled()) {
                JOptionPane.showMessageDialog(this, StringResource.get("LBL_COMPONENT_MISSING"));
                return;
            }
            if (!this.txtURL.getText().startsWith("http")) {
                this.txtURL.setText("http://" + this.txtURL.getText());
            }
            this.jsp.setVisible(false);
            this.prg.setVisible(true);
            this.btnDwn.setVisible(true);
            this.btnDwn.setText(StringResource.get("BTN_STOP_PROCESSING"));
            this.chkSelectAll.setVisible(false);
            this.btnDwn.setName("STOP");
            this.btnStart.setVisible(false);
            this.txtURL.setVisible(false);
            this.stop = false;
            this.getVideoItems(this.txtURL.getText());
        }
        if ("DOWNLOAD".equals(name)) {
            this.table.getDefaultEditor(YdlResponse.YdlVideo.class).stopCellEditing();
            this.downloadVideo();
        }
        if ("CLOSE".equals(name)) {
            this.stop();
            this.dispose();
        }
        if ("STOP".equals(name)) {
            this.stop();
        }
        if ("BACK".equals(name)) {
            if (this.table.isEditing()) {
                this.table.getCellEditor().stopCellEditing();
            }
            this.model.clear();
            this.prg.setVisible(false);
            this.txtURL.setVisible(true);
            this.btnStart.setVisible(true);
            this.btnDwn.setName("DOWNLOAD");
            this.btnDwn.setText(StringResource.get("LBL_DOWNLOAD"));
            this.chkSelectAll.setVisible(false);
            this.btnDwn.setVisible(false);
            this.jsp.setVisible(false);
            this.btnBack.setVisible(false);
            this.imageMap.clear();
            if (this.thumbnailDownloader != null) {
                this.thumbnailDownloader.stop();
            }
        }
        if ("SELECT_ALL".equals(name)) {
            TableCellEditor editor;
            if (this.table.isEditing() && (editor = this.table.getCellEditor()) != null) {
                editor.stopCellEditing();
            }
            int i = 0;
            while (i < this.model.getRowCount()) {
                VideoItemWrapper wp = (VideoItemWrapper)this.model.getValueAt(i, 0);
                wp.checked = this.chkSelectAll.isSelected();
                ++i;
            }
            this.model.fireTableDataChanged();
        }
    }

    private void stop() {
        this.prg.setVisible(false);
        this.txtURL.setVisible(true);
        this.btnStart.setVisible(true);
        this.btnDwn.setName("DOWNLOAD");
        this.btnDwn.setText(StringResource.get("LBL_DOWNLOAD"));
        this.btnDwn.setVisible(false);
        this.jsp.setVisible(false);
        this.btnBack.setVisible(false);
        this.stop = true;
        if (this.ydl != null) {
            this.ydl.stop();
        }
        this.imageMap.clear();
        if (this.thumbnailDownloader != null) {
            this.thumbnailDownloader.stop();
        }
    }

    private void onVideoListReady() {
        this.btnStart.setVisible(false);
        this.txtURL.setVisible(false);
        this.prg.setVisible(false);
        this.jsp.setVisible(true);
        this.btnDwn.setName("DOWNLOAD");
        this.chkSelectAll.setVisible(true);
        this.chkSelectAll.setSelected(true);
        this.btnDwn.setText(StringResource.get("LBL_DOWNLOAD"));
        this.btnDwn.setVisible(true);
        this.btnBack.setVisible(true);
        ArrayList<String> thumbUrls = new ArrayList<String>();
        int i = 0;
        while (i < this.model.getRowCount()) {
            VideoItemWrapper wp = (VideoItemWrapper)this.model.getValueAt(i, 0);
            YdlResponse.YdlVideo video = wp.videoItem;
            if (video.thumbnail != null) {
                thumbUrls.add(video.thumbnail);
            }
            ++i;
        }
        if (this.model.getRowCount() == 1) {
            VideoItemWrapper wp = (VideoItemWrapper)this.model.getValueAt(0, 0);
            wp.checked = true;
            this.model.fireTableDataChanged();
        }
        this.thumbnailDownloader = new ThumbnailDownloader(thumbUrls, this, this.instancekey);
        this.thumbnailDownloader.download();
    }

    private void getVideoItems(final String url) {
        new Thread(){

            @Override
            public void run() {
                try {
                    MediaDownloaderWnd.this.ydl = new YoutubeDLHandler(url);
                    MediaDownloaderWnd.this.ydl.start();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<VideoItemWrapper> list = new ArrayList<VideoItemWrapper>();
                            Logger.log("Total video found: " + (this).MediaDownloaderWnd.this.ydl.getVideos().size());
                            int i = 0;
                            while (i < (this).MediaDownloaderWnd.this.ydl.getVideos().size()) {
                                YdlResponse.YdlVideo ydln = (this).MediaDownloaderWnd.this.ydl.getVideos().get(i);
                                if (ydln.mediaFormats == null || ydln.mediaFormats.size() < 1) {
                                    Logger.log("media formats not available");
                                } else {
                                    VideoItemWrapper wrapper = new VideoItemWrapper();
                                    wrapper.checked = true;
                                    wrapper.videoItem = ydln;
                                    list.add(wrapper);
                                }
                                ++i;
                            }
                            MediaDownloaderWnd.this.model.setList(list);
                        }
                    });
                }
                catch (Exception e) {
                    Logger.log(e);
                }
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (!MediaDownloaderWnd.this.stop) {
                                MediaDownloaderWnd.this.onVideoListReady();
                            }
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException e) {
                    Logger.log(e);
                }
            }
        }.start();
    }

    private VideoWrapper createDownloadData(YdlResponse.YdlVideo video) {
        YdlResponse.YdlMediaFormat fmt = video.mediaFormats.get(video.index);
        String title = video.title;
        String file = String.valueOf(XDMUtils.getFileName(title)) + "." + fmt.ext;
        HttpMetadata md = null;
        switch (fmt.type) {
            case 99: {
                DashMetadata dm = new DashMetadata();
                dm.setYdlUrl(this.txtURL.getText());
                dm.setUrl(fmt.videoSegments[0]);
                dm.setUrl2(fmt.audioSegments[0]);
                for (HttpHeader header : fmt.headers) {
                    dm.getHeaders().addHeader(header);
                }
                for (HttpHeader header : fmt.headers2) {
                    dm.getHeaders2().addHeader(header);
                }
                md = dm;
                break;
            }
            case 97: {
                md = new HlsMetadata();
                md.setYdlUrl(this.txtURL.getText());
                md.setUrl(fmt.url);
                for (HttpHeader header : fmt.headers) {
                    md.getHeaders().addHeader(header);
                }
                break;
            }
            case 96: {
                HdsMetadata hm = new HdsMetadata();
                hm.setYdlUrl(this.txtURL.getText());
                hm.setUrl(fmt.url);
                for (HttpHeader header : fmt.headers) {
                    hm.getHeaders().addHeader(header);
                }
                md = hm;
                break;
            }
            case 98: {
                HttpMetadata ht = new HttpMetadata();
                ht.setYdlUrl(this.txtURL.getText());
                ht.setUrl(fmt.url);
                for (HttpHeader header : fmt.headers) {
                    ht.getHeaders().addHeader(header);
                }
                md = ht;
            }
        }
        if (md != null) {
            VideoWrapper wp = new VideoWrapper();
            wp.md = md;
            wp.file = file;
            return wp;
        }
        return null;
    }

    private void downloadSingle(YdlResponse.YdlVideo video) {
        VideoWrapper wp = this.createDownloadData(video);
        if (wp != null) {
            XDMApp.getInstance().addVideo(wp.md, wp.file);
        }
    }

    private void downloadBatch(ArrayList<YdlResponse.YdlVideo> items) {
        ArrayList<VideoWrapper> listWrap = new ArrayList<VideoWrapper>();
        int i = 0;
        while (i < items.size()) {
            VideoWrapper wp = this.createDownloadData(items.get(i));
            if (wp != null) {
                listWrap.add(wp);
            }
            ++i;
        }
        new BatchVideoWnd(listWrap).setVisible(true);
    }

    private void downloadVideo() {
        ArrayList<YdlResponse.YdlVideo> items;
        int selectedCount;
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        if ((selectedCount = (items = this.model.getSelectedVideoList()).size()) < 1) {
            return;
        }
        if (selectedCount == 1) {
            this.downloadSingle(items.get(0));
        } else {
            this.downloadBatch(items);
        }
        if (this.thumbnailDownloader != null) {
            this.thumbnailDownloader.stop();
        }
        this.dispose();
    }

    public void launchWithUrl(String url) {
        this.setVisible(true);
        this.txtURL.setText(url);
        this.btnStart.doClick();
    }

    @Override
    public void thumbnailsLoaded(long key, String url, String file) {
        System.out.println("Thumbnail callback");
        if (this.instancekey == key) {
            int i = 0;
            while (i < this.model.getRowCount()) {
                VideoItemWrapper wp = (VideoItemWrapper)this.model.getValueAt(i, 0);
                YdlResponse.YdlVideo video = wp.videoItem;
                if (video.thumbnail != null && video.thumbnail.equals(url)) {
                    ImageIcon ico = this.loadImage(file, video.duration);
                    System.out.println("Icon: " + ico);
                    this.imageMap.put(url, ico);
                    this.model.fireTableCellUpdated(i, 0);
                    break;
                }
                ++i;
            }
        } else {
            System.out.println("diff instance");
        }
    }

    private Image loadImage64(File file) throws IOException {
        BufferedImage img = ImageIO.read(file);
        Image img64 = img.getScaledInstance(64, -1, 4);
        img.flush();
        return img64;
    }

    private ImageIcon loadImage(String file, long duration) {
        File f = new File(file);
        try {
            Image img = this.loadImage64(f);
            BufferedImage image = new BufferedImage(64, 64, 2);
            Graphics2D g = (Graphics2D)image.getGraphics();
            g.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            g.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
            int h = img.getHeight(null);
            g.drawImage(img, 0, 32 - h / 2, null);
            if (duration > 0L) {
                g.setFont(FontResource.getNormalFont());
                String sDuration = FormatUtilities.hms((int)duration);
                if (sDuration.length() > 0) {
                    int textWidth = g.getFontMetrics().stringWidth(sDuration);
                    int textHeight = g.getFontMetrics().getHeight();
                    int y = 64 - textHeight + g.getFontMetrics().getAscent() - g.getFontMetrics().getDescent();
                    g.fillRect(64 - textWidth, 64 - textHeight, textWidth, textHeight);
                    g.setColor(Color.WHITE);
                    g.drawString(sDuration, 64 - textWidth, y);
                }
            }
            g.dispose();
            img.flush();
            ImageIcon imageIcon = new ImageIcon(image);
            return imageIcon;
        }
        catch (Exception e) {
            Logger.log(e);
            return null;
        }
        finally {
            System.out.println(f);
            f.delete();
        }
    }

    @Override
    public ImageIcon getImage(String url) {
        return this.imageMap.get(url);
    }

    class VideoWrapper {
        HttpMetadata md;
        String file;

        VideoWrapper() {
        }
    }
}

