/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import xdman.downloaders.SegmentDetails;
import xdman.downloaders.SegmentInfo;
import xdman.ui.res.ColorResource;

public class SegmentPanel
extends JComponent {
    private static final long serialVersionUID = -6537879808121349569L;
    private SegmentDetails segDet;
    private long length;

    public void setValues(SegmentDetails segDet, long length) {
        this.segDet = segDet;
        this.length = length;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (g == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(Color.GRAY);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.segDet == null || this.segDet.getChunkCount() < 1L || this.length < 0L) {
            return;
        }
        g2.setPaint(ColorResource.getSelectionColor());
        float r = (float)this.getWidth() / (float)this.length;
        ArrayList<SegmentInfo> list = this.segDet.getChunkUpdates();
        int i = 0;
        while ((long)i < this.segDet.getChunkCount()) {
            SegmentInfo info = list.get(i);
            int _start = (int)((float)info.getStart() * r);
            int _length = (int)((float)info.getLength() * r);
            int _dwnld = (int)((float)info.getDownloaded() * r);
            if (_dwnld > _length) {
                _dwnld = _length;
            }
            g2.fillRect(_start, 0, _dwnld + 1, this.getHeight());
            ++i;
        }
    }
}

