/*
 * Decompiled with CFR 0.152.
 */
package xdman.ui.components;

import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import xdman.ui.components.CustomButton;
import xdman.ui.components.LayeredPanel;
import xdman.ui.components.MessageBox;
import xdman.ui.components.TitlePanel;
import xdman.ui.res.ColorResource;
import xdman.ui.res.ImageResource;
import xdman.ui.res.StringResource;
import xdman.util.XDMUtils;

public class XDMFrame
extends JFrame
implements ComponentListener {
    private static final long serialVersionUID = -8094995420106046965L;
    private JLayeredPane layeredPane;
    private boolean maximizeBox = true;
    private boolean minimizeBox = true;
    private JButton menuBtn;
    private JPanel contentPane;
    private JPanel modalPane;
    private JPanel dialogPane;
    private static final int DEFAULT_LAYER = 0;
    private static final int MODAL_LAYER = 30;
    private static final int DIALOG_LAYER = 15;
    private Component lastFocusOwner;
    protected boolean showTwitterIcon;
    protected boolean showFBIcon;
    protected String twitterUrl;
    protected String fbUrl;
    JPanel panTitle;
    JPanel panClient;
    private JLabel lblRightGrip;
    private JLabel lblLeftGrip;
    private JLabel lblTopGrip;
    private JLabel lblBottomGrip;
    int diffx;
    int diffy;
    Box vBox;
    ActionListener actClose = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent action) {
            XDMFrame.this.dispatchEvent(new WindowEvent(XDMFrame.this, 201));
        }
    };
    ActionListener actMax = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent action) {
            XDMFrame.this.setMaximizedBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
            XDMFrame.this.setExtendedState((XDMFrame.this.getExtendedState() & 6) == 6 ? 0 : 6);
        }
    };
    ActionListener actMin = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent action) {
            XDMFrame.this.setExtendedState(XDMFrame.this.getExtendedState() | 1);
        }
    };
    ActionListener actTwitter = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (XDMFrame.this.twitterUrl != null) {
                XDMUtils.browseURL(XDMFrame.this.twitterUrl);
            }
        }
    };
    ActionListener actFb = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (XDMFrame.this.fbUrl != null) {
                XDMUtils.browseURL(XDMFrame.this.fbUrl);
            }
        }
    };
    Cursor curDefault;
    Cursor curNResize;
    Cursor curEResize;
    Cursor curWResize;
    Cursor curSResize;
    Cursor curSEResize;
    Cursor curSWResize;

    public XDMFrame() {
        this.setUndecorated(true);
        this.createCursors();
        this.contentPane = new JPanel(new BorderLayout());
        this.modalPane = new LayeredPanel(150);
        this.modalPane.setVisible(false);
        this.dialogPane = new LayeredPanel(40);
        this.dialogPane.setVisible(false);
        this.createResizeGrip();
        this.panTitle = new TitlePanel((LayoutManager)new BorderLayout(), this);
        this.panTitle.setBackground(ColorResource.getTitleColor());
        this.panTitle.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.panTitle.setOpaque(true);
        this.registerTitlePanel(this.panTitle);
        this.panClient = new JPanel(new BorderLayout());
        this.panClient.setBackground(Color.WHITE);
        JPanel panContent = new JPanel(new BorderLayout());
        panContent.add((Component)this.panTitle, "North");
        panContent.add(this.panClient);
        this.contentPane.add(panContent);
        this.layeredPane = new JLayeredPane();
        this.layeredPane.add((Component)this.contentPane, new Integer(0));
        this.layeredPane.add((Component)this.modalPane, new Integer(30));
        this.layeredPane.add((Component)this.dialogPane, new Integer(15));
        super.add(this.layeredPane);
        super.addComponentListener(this);
    }

    public JPanel getTitlePanel() {
        return this.panTitle;
    }

    public void setMaximizeBox(boolean maximizeBox) {
        this.maximizeBox = maximizeBox;
    }

    public boolean isMaximizeBox() {
        return this.maximizeBox;
    }

    public void setMinimizeBox(boolean minimizeBox) {
        this.minimizeBox = minimizeBox;
    }

    public boolean isMinimizeBox() {
        return this.minimizeBox;
    }

    @Override
    public Component add(Component c) {
        return this.panClient.add(c);
    }

    private void createResizeGrip() {
        GripMouseAdapter gma = new GripMouseAdapter();
        this.lblRightGrip = new JLabel();
        this.lblRightGrip.setMaximumSize(new Dimension(2, this.lblRightGrip.getMaximumSize().height));
        this.lblRightGrip.setPreferredSize(new Dimension(2, this.lblRightGrip.getPreferredSize().height));
        this.lblRightGrip.setBackground(Color.BLACK);
        this.lblRightGrip.setOpaque(true);
        this.contentPane.add((Component)this.lblRightGrip, "East");
        this.lblBottomGrip = new JLabel();
        this.lblBottomGrip.setMaximumSize(new Dimension(this.lblBottomGrip.getPreferredSize().width, 2));
        this.lblBottomGrip.setPreferredSize(new Dimension(this.lblBottomGrip.getPreferredSize().width, 2));
        this.lblBottomGrip.setBackground(Color.BLACK);
        this.lblBottomGrip.setOpaque(true);
        this.contentPane.add((Component)this.lblBottomGrip, "South");
        this.lblLeftGrip = new JLabel();
        this.lblLeftGrip.setMaximumSize(new Dimension(2, this.lblLeftGrip.getPreferredSize().height));
        this.lblLeftGrip.setPreferredSize(new Dimension(2, this.lblLeftGrip.getPreferredSize().height));
        this.lblLeftGrip.setBackground(Color.BLACK);
        this.lblLeftGrip.setOpaque(true);
        this.contentPane.add((Component)this.lblLeftGrip, "West");
        this.lblTopGrip = new JLabel();
        this.lblTopGrip.setMaximumSize(new Dimension(this.lblTopGrip.getPreferredSize().width, 2));
        this.lblTopGrip.setPreferredSize(new Dimension(this.lblTopGrip.getPreferredSize().width, 2));
        this.lblTopGrip.setBackground(Color.BLACK);
        this.lblTopGrip.setOpaque(true);
        this.contentPane.add((Component)this.lblTopGrip, "North");
        if (this.isResizable()) {
            this.lblTopGrip.addMouseListener(gma);
            this.lblTopGrip.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent me) {
                    int y = me.getYOnScreen();
                    int diff = XDMFrame.this.getLocationOnScreen().y - y;
                    XDMFrame.this.setLocation(XDMFrame.this.getLocation().x, me.getLocationOnScreen().y);
                    XDMFrame.this.setSize(XDMFrame.this.getWidth(), XDMFrame.this.getHeight() + diff);
                }
            });
            this.lblRightGrip.addMouseListener(gma);
            this.lblRightGrip.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent me) {
                    int x = me.getXOnScreen();
                    int diff = x - XDMFrame.this.getLocationOnScreen().x;
                    XDMFrame.this.setSize(diff, XDMFrame.this.getHeight());
                }
            });
            this.lblLeftGrip.addMouseListener(gma);
            this.lblLeftGrip.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent me) {
                    int x = me.getXOnScreen();
                    int diff = XDMFrame.this.getLocationOnScreen().x - x;
                    XDMFrame.this.setLocation(me.getLocationOnScreen().x, XDMFrame.this.getLocation().y);
                    XDMFrame.this.setSize(diff + XDMFrame.this.getWidth(), XDMFrame.this.getHeight());
                }
            });
            this.lblBottomGrip.addMouseListener(gma);
            this.lblBottomGrip.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent me) {
                    int y = me.getYOnScreen();
                    int diff = y - XDMFrame.this.getLocationOnScreen().y;
                    XDMFrame.this.setSize(XDMFrame.this.getWidth(), diff);
                }
            });
        }
    }

    protected void registerTitlePanel(JPanel panel) {
        JButton btn;
        this.vBox = Box.createVerticalBox();
        this.vBox.setOpaque(true);
        this.vBox.setBackground(ColorResource.getTitleColor());
        Box hBox = Box.createHorizontalBox();
        hBox.setBackground(ColorResource.getTitleColor());
        if (this.showTwitterIcon) {
            JButton btnT = this.createTransparentButton(ImageResource.get("twitter16.png"), new Dimension(30, 30), this.actTwitter);
            btnT.setToolTipText(StringResource.get("LBL_TWITTER_PAGE"));
            hBox.add(btnT);
        }
        if (this.showFBIcon) {
            JButton btnF = this.createTransparentButton(ImageResource.get("fb16.png"), new Dimension(30, 30), this.actFb);
            btnF.setToolTipText(StringResource.get("LBL_LIKE_ON_FB"));
            hBox.add(btnF);
        }
        if (this.minimizeBox) {
            btn = this.createTransparentButton(ImageResource.get("min_btn.png"), new Dimension(30, 30), this.actMin);
            hBox.add(btn);
        }
        if (this.maximizeBox) {
            btn = this.createTransparentButton(ImageResource.get("max_btn.png"), new Dimension(30, 30), this.actMax);
            hBox.add(btn);
        }
        btn = this.createTransparentButton(ImageResource.get("close_btn.png"), new Dimension(30, 30), this.actClose);
        hBox.add(btn);
        this.vBox.add(hBox);
        this.vBox.add(Box.createVerticalGlue());
        panel.add((Component)this.vBox, "East");
    }

    private void createCursors() {
        this.curDefault = new Cursor(0);
        this.curNResize = new Cursor(8);
        this.curWResize = new Cursor(10);
        this.curEResize = new Cursor(11);
        this.curSResize = new Cursor(9);
    }

    JButton createTransparentButton(ImageIcon icon, Dimension d, ActionListener actionListener) {
        CustomButton btn = new CustomButton(icon);
        btn.setBackground(ColorResource.getTitleColor());
        btn.setBorderPainted(false);
        btn.setContentAreaFilled(false);
        btn.setFocusPainted(false);
        btn.setPreferredSize(d);
        btn.addActionListener(actionListener);
        return btn;
    }

    protected void setMenuActionListener(ActionListener a) {
        if (this.menuBtn != null) {
            this.menuBtn.addActionListener(a);
        }
    }

    @Override
    public void componentHidden(ComponentEvent c) {
    }

    @Override
    public void componentMoved(ComponentEvent c) {
    }

    @Override
    public void componentResized(ComponentEvent c) {
        this.contentPane.setSize(super.getWidth(), super.getHeight());
        this.modalPane.setSize(super.getWidth(), super.getHeight());
        this.dialogPane.setSize(super.getWidth(), super.getHeight());
        this.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent c) {
    }

    public void showModal(MessageBox component) {
        this.lastFocusOwner = this.getMostRecentFocusOwner();
        System.out.println("Last focus owner: " + this.lastFocusOwner);
        this.modalPane.add(component);
        component.setVisible(true);
        this.modalPane.setVisible(true);
        this.revalidate();
        component.selectDefaultButton();
        this.startModal(component);
    }

    public void hideModal(MessageBox component) {
        this.modalPane.remove(component);
        component.setVisible(false);
        this.modalPane.setVisible(false);
        this.revalidate();
        this.stopModal();
        if (this.lastFocusOwner == null) {
            this.requestFocusInWindow();
        } else {
            this.lastFocusOwner.requestFocusInWindow();
        }
    }

    public void showDialog(JComponent component) {
        this.dialogPane.removeAll();
        this.dialogPane.add(component);
        component.setVisible(true);
        this.dialogPane.setVisible(true);
        this.revalidate();
    }

    public void hideDialog(JComponent component) {
        this.dialogPane.remove(component);
        component.setVisible(false);
        this.dialogPane.setVisible(false);
        this.revalidate();
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void startModal(Component comp) {
        block7: {
            try {
                if (!SwingUtilities.isEventDispatchThread()) ** GOTO lbl20
                theQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                while (comp.isVisible()) {
                    event = theQueue.getNextEvent();
                    source = event.getSource();
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)event).dispatch();
                        continue;
                    }
                    if (source instanceof Component) {
                        ((Component)source).dispatchEvent(event);
                        continue;
                    }
                    if (source instanceof MenuComponent) {
                        ((MenuComponent)source).dispatchEvent(event);
                        continue;
                    }
                    System.err.println("Unable to dispatch: " + event);
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    this.wait();
lbl20:
                    // 2 sources

                    ** while (comp.isVisible())
                }
lbl21:
                // 1 sources

            }
            catch (InterruptedException var2_3) {
                // empty catch block
            }
        }
    }

    private synchronized void stopModal() {
        this.notifyAll();
    }

    class GripMouseAdapter
    extends MouseAdapter {
        GripMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            if (me.getSource() == XDMFrame.this.lblBottomGrip) {
                XDMFrame.this.lblBottomGrip.setCursor(XDMFrame.this.curSResize);
            } else if (me.getSource() == XDMFrame.this.lblRightGrip) {
                XDMFrame.this.lblRightGrip.setCursor(XDMFrame.this.curEResize);
            } else if (me.getSource() == XDMFrame.this.lblLeftGrip) {
                XDMFrame.this.lblLeftGrip.setCursor(XDMFrame.this.curWResize);
            } else if (me.getSource() == XDMFrame.this.lblTopGrip) {
                XDMFrame.this.lblTopGrip.setCursor(XDMFrame.this.curNResize);
            }
        }

        @Override
        public void mouseExited(MouseEvent me) {
            ((JLabel)me.getSource()).setCursor(XDMFrame.this.curDefault);
        }
    }
}

