/*
 * Decompiled with CFR 0.152.
 */
package xdman.util;

import java.io.File;
import java.io.FilenameFilter;
import xdman.Config;
import xdman.network.http.JavaHttpClient;
import xdman.util.Logger;
import xdman.util.XDMUtils;

public class UpdateChecker {
    private static final String APP_UPDAT_URL = "http://xdman.sourceforge.net/update/update_check.php";
    private static final String COMPONENTS_UPDATE_URL = "http://xdman.sourceforge.net/components/update_check.php";
    public static final int APP_UPDATE_AVAILABLE = 10;
    public static final int COMP_UPDATE_AVAILABLE = 20;
    public static final int COMP_NOT_INSTALLED = 30;
    public static final int NO_UPDATE_AVAILABLE = 40;

    public static int getUpdateStat() {
        int stat = UpdateChecker.isComponentUpdateAvailable();
        System.out.println("Stat: " + stat);
        if (stat == 0) {
            return 20;
        }
        if (stat == -1) {
            return 30;
        }
        System.out.println("checking for app update");
        if (UpdateChecker.isAppUpdateAvailable()) {
            return 10;
        }
        return 40;
    }

    private static boolean isAppUpdateAvailable() {
        return UpdateChecker.isUpdateAvailable(true, "7.1.2");
    }

    private static int isComponentUpdateAvailable() {
        String componentVersion = UpdateChecker.getComponentVersion();
        System.out.println("current component version: " + componentVersion);
        if (componentVersion == null) {
            return -1;
        }
        return UpdateChecker.isUpdateAvailable(false, componentVersion) ? 0 : 1;
    }

    public static String getComponentVersion() {
        File f = new File(Config.getInstance().getDataFolder());
        String[] files = f.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".version");
            }
        });
        if (files.length < 1) {
            Logger.log("Component not installed");
            Logger.log("Checking fallback components");
            return UpdateChecker.getFallbackComponentVersion();
        }
        return files[0].split("\\.")[0];
    }

    public static String getFallbackComponentVersion() {
        File f = XDMUtils.getJarFile().getParentFile();
        String[] files = f.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".version");
            }
        });
        if (files.length < 1) {
            Logger.log("Component not installed");
            return null;
        }
        return files[0].split("\\.")[0];
    }

    private static boolean isUpdateAvailable(boolean app, String version) {
        JavaHttpClient client = null;
        try {
            client = new JavaHttpClient(String.valueOf(app ? APP_UPDAT_URL : COMPONENTS_UPDATE_URL) + "?ver=" + version);
            client.setFollowRedirect(true);
            client.connect();
            int resp = client.getStatusCode();
            Logger.log("manifest download response: " + resp);
            if (resp == 200) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.log(e);
        }
        finally {
            try {
                client.dispose();
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

