//------------------------------------------------------------------------------
// <autogenerated>
//     This code was generated by a tool.
//     Runtime Version: 1.1.4322.2032
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </autogenerated>
//------------------------------------------------------------------------------
/// <summary>
/// Loads a ReportFile and set it's Values in the ReportDesigner
/// </summary>
/// <remarks>
/// 	created by - Forstmeier Peter
/// 	created on - 02.12.2004 22:44:39
/// </remarks>

using System;
using System.Xml;
using System.ComponentModel;
using System.Globalization;

using SharpReportCore;

using SharpReport.Visitors;
using SharpReport.Designer;
using SharpReport.ReportItems;


namespace SharpReport.Visitors {
	public class LoadReportVisitor : SharpReport.Visitors.AbstractVisitor {
		
		private string fileName;
		
		SharpReport.Designer.BaseDesignerControl designer;
		SharpReportCore.XmlFormReader xmlFormReader;
		IDesignableFactory designableFactory = new IDesignableFactory();
		
		public LoadReportVisitor(string filename) {
			this.fileName = filename;
			designableFactory = new IDesignableFactory();
		}
		
		/// <summary>
		/// Loads ReportDefinition from File and set the values in the SharpReportDesigner
		/// </summary>
		/// <param name='designer'>SharpReportDesigner</param>
		
		public override void Visit(SharpReport.Designer.BaseDesignerControl designer){
			if (designer != null) {
				XmlDocument xmlDoc;
				try {
					xmlDoc = XmlHelper.OpenSharpReport (fileName);
					this.designer = designer;
					xmlFormReader = new XmlFormReader();
					SetDesigner (xmlDoc);
					AdjustSectionsWidth();
				} catch (Exception ) {
					throw ;
				}
			} else {
				System.ArgumentNullException e = new System.ArgumentNullException ("LoadReportVisitor:Visit -> No valid designer");
				throw e;
			}
		}
		
		private void AdjustSectionsWidth() {
			foreach (ReportSection section in designer.SectionsCollection) {
				section.VisualControl.Width = designer.ReportModel.ReportSettings.PageSettings.Bounds.Width;
				if (section.SectionMargin == 0) {
					section.SectionMargin = designer.ReportModel.ReportSettings.PageSettings.Bounds.Left;
				}
			}
		}
		
		private XmlDocument LoadFromFile (string fileName) {
			XmlDocument xmlDoc = new XmlDocument();
			xmlDoc.Load (fileName);
			return xmlDoc;
		}
		
		
		private void  SetDesigner (XmlDocument doc){
			this.designer.ReportModel.ReportSettings.SetSettings ((XmlElement)doc.DocumentElement.FirstChild);
			SetSections (doc);
		}
		
	
		
		private void SetSections (XmlDocument doc) {
			XmlNodeList sectionNodes = doc.DocumentElement.ChildNodes;
			//Start with node(1)
			XmlNode node;
			BaseSection baseSection = null;
			for (int i = 1;i < sectionNodes.Count ; i++ ) {
				node = sectionNodes[i];
				
				if (node is XmlElement) {
					XmlElement sectionElem = (XmlElement)node;
					baseSection = (BaseSection)designer.ReportModel.SectionCollection.Find(sectionElem.GetAttribute("name"));
					if (baseSection != null) {
						baseSection.SuspendLayout();
						XmlHelper.SetSectionValues (xmlFormReader,sectionElem,baseSection);
						XmlNodeList ctrlList = sectionElem.SelectNodes ("controls/control");
						
						if (ctrlList.Count > 0) {
							foreach (XmlNode ctrlNode in ctrlList) {
								if (ctrlNode is XmlElement) {
									XmlElement ctrlElem = (XmlElement)ctrlNode;
									IItemRenderer rpt = null;
									try {
										rpt = designableFactory.Create(ctrlElem.GetAttribute("type"));
										BaseReportItem br = (BaseReportItem)rpt;
										br.Parent = baseSection;
										baseSection.Items.Add (rpt);
										XmlHelper.BuildControl (xmlFormReader,ctrlElem,br);
									}
									catch (Exception ) {
										string s = String.Format ("Unable to create <{0}>",ctrlElem.GetAttribute("type").ToString());
										throw new SharpReportException (s);
									}
								}
							}
						}
						baseSection.ResumeLayout();
					} else {
						SharpReportException ex = new SharpReportException ("Wrong Section Name <" + sectionElem.GetAttribute("name") + ">");
						throw ex;
					}
				}else {
					throw new System.Xml.XmlException ("Report : SetSection Wrong Node in Report");
				}
				baseSection.ResumeLayout();
			}
			baseSection.ResumeLayout();
		}
	}
}
