//------------------------------------------------------------------------------
// <autogenerated>
//     This code was generated by a tool.
//     Runtime Version: 1.1.4322.2032
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </autogenerated>
//------------------------------------------------------------------------------
using System;
using System.Data;
using System.Data.OleDb;
using System.Collections;
using System.ComponentModel;
using System.Globalization;

/// <summary>
/// This Class is used as a wrapper around Databinding
/// </summary>
/// <remarks>
/// 	created by - Forstmeier Peter
/// 	created on - 16.10.2005 14:49:43
/// </remarks>
namespace SharpReportCore {
	
	public class DataManager : IDataContainer,IEnumerator,IDisposable {
		
		/*
		/// <summary>
		/// Operand to use when filtering...
		/// </summary>
		public enum FilterOperand {
			Equals,
			NotEquals,
			Includes,
			NotIncludes,
		}
		*/
		
		int currentRow = -1;
		
		ReportSettings reportSettings;
		object dataSource;
		string dataMember;
		ConnectionObject connectionObject;
		IDbConnection connection;
		IDataViewStrategy dataViewStrategy;
		
		
//		private ListChangedEventArgs resetList = new ListChangedEventArgs(ListChangedType.Reset,-1,-1);
		
		public event EventHandler <ListChangedEventArgs> ListChanged;
		public event EventHandler <GroupChangedEventArgs> GroupChanged;
		
		/// <summary>
		/// use this Constructor for PullDataReports
		/// </summary>
		/// <param name="connection">A valid connection</param>
		/// <param name="reportSettings">a <see cref="ReportSettings"></see></param>
		
		#region Constructores
		public DataManager(ConnectionObject connectionObject, ReportSettings reportSettings){
			CheckAndSetReportSettings(reportSettings);
			if (connectionObject == null) {
				throw new ArgumentNullException("DataManager:ConnectionObject");
			}
			this.connectionObject = connectionObject;
			try {
				CheckConnection (this.connectionObject);
				CheckAndSetSource(this.FillDataSet().Tables[0]);
				
				this.dataViewStrategy = new TableStrategy((DataTable)this.dataSource,
				                                          reportSettings);
				this.dataViewStrategy.ListChanged += new EventHandler <ListChangedEventArgs> (NotifyListChanged);
			} catch (Exception) {
				throw;
			}
		}
		
		
		public DataManager(DataTable dataSource, ReportSettings reportSettings){
			try {
				CheckAndSetReportSettings(reportSettings);
				CheckAndSetSource(dataSource);
				this.dataViewStrategy = new TableStrategy((DataTable)this.dataSource,
				                                          reportSettings);
				this.dataViewStrategy.ListChanged += new EventHandler <ListChangedEventArgs> (NotifyListChanged);
			} catch (Exception) {
				throw ;
			}
		}
		
		public DataManager(DataSet dataSource, ReportSettings reportSettings)
			:this (dataSource,"",reportSettings){
			
		}
		
		public DataManager(DataSet dataSource,string dataMember, ReportSettings reportSettings){
			
			try {
				this.dataMember = dataMember;
				CheckAndSetReportSettings(reportSettings);
				CheckAndSetSource(dataSource);
				this.dataViewStrategy = new TableStrategy((DataTable)this.dataSource,
				                                          reportSettings);
				this.dataViewStrategy.ListChanged += new EventHandler <ListChangedEventArgs> (NotifyListChanged);
			} catch (Exception ) {
				throw ;
			}
		}
		
		public DataManager(IList dataSource, ReportSettings reportSettings){
			try {
				CheckAndSetReportSettings(reportSettings);
				CheckAndSetSource(dataSource);
				this.dataViewStrategy = new CollectionStrategy ((IList)this.dataSource,
				                                                this.dataMember,
				                                                reportSettings);
				this.dataViewStrategy.ListChanged += new EventHandler <ListChangedEventArgs> (NotifyListChanged);
			} catch (Exception) {
				throw;
			}
		}
		
		#endregion
		
		
		
		void CheckAndSetReportSettings(ReportSettings settings) {
			if (settings == null) {
				throw new ArgumentNullException("settings");
			}
			try {
				if (settings.DataModel != GlobalEnums.enmPushPullModel.PushData) {
					SqlQueryCkecker check = new SqlQueryCkecker();
					check.Check(settings.CommandText);
				}
				
			} catch (Exception) {
				throw;
			}
			
			this.reportSettings = settings;
		}
		
		
		void CheckAndSetSource(object source) {
			if (source == null) {
				throw new MissingDataSourceException();
			}
			
			if (source is IList ||source is IListSource || source is IBindingList) {
				
				//DataTable
				this.dataSource = source;
				DataTable table = this.dataSource as DataTable;
				if (table != null) {
					
					this.dataMember = table.TableName;
					return;
				}

				//DataSet
				DataSet dataSet = this.dataSource as DataSet;
				if (dataSet != null) {
					if (dataSet.Tables.Count > 0) {
						DataTable tbl;
						if (String.IsNullOrEmpty(this.dataMember)){
							tbl = dataSet.Tables[0];
						} else {
							DataTableCollection tcol = dataSet.Tables;
							if (tcol.Contains(this.dataMember)) {
								tbl = tcol[this.dataMember];
								this.dataSource = tbl;
							}
						}
					}else {
						throw new ArgumentException("DataManager:No Tables in DataSet");
					}
					return;
				}
				
				//IList
				IList list = source as IList;
				if (list != null) {
					this.dataSource = list;
					this.dataMember = source.ToString();
					if (list.Count == 0) {
						//System.Console.WriteLine("List  mit {0} Rows",list.Count);
						throw new ArgumentException("No empty IList allowed");
					}
					return;
					
				}
//				if (source is IList) {
//					IList list = source as IList;
//					this.dataSource = list;
//					this.dataMember = source.ToString();
//					if (list.Count == 0) {
//						//System.Console.WriteLine("List  mit {0} Rows",list.Count);
//						throw new ArgumentException("No empty IList allowed");
//					}
//					return;
//				}
			} else {
				throw new ArgumentException ("DataManager:Wrong DataSource");
			}
		}
		
		void CheckConnection (ConnectionObject connectionObject) {
			try {
				connection = connectionObject.Connection;
				if (connection.State == ConnectionState.Open) {
					connection.Close();
				}
				connection.Open();
				connection.Close();
			} catch (Exception ) {
				throw;
			}
		}
		
		private DataSet FillDataSet() {
			try {
				if (this.connection.State == ConnectionState.Closed) {
					this.connection.Open();
				}
				
				OleDbCommand command = ((OleDbConnection)this.connection).CreateCommand();
				command.CommandText = reportSettings.CommandText;
				command.CommandType = reportSettings.CommandType;
				// We have to check if there are parameters for this Query, if so
				// add them to the command
				
				CheckForAndBuildParams(command,reportSettings);
				OleDbDataAdapter adapter = new OleDbDataAdapter(command);
				DataSet ds = new DataSet();
				ds.Locale = CultureInfo.CurrentCulture;
				adapter.Fill (ds);
				return ds;
			} catch (Exception) {
				throw;
			} finally {
				if (this.connection.State == ConnectionState.Open) {
					this.connection.Close();
				}
			}
		}
		
		
		private static void CheckForAndBuildParams (OleDbCommand cmd,ReportSettings reportSettings) {
			if (reportSettings.SqlParametersCollection != null && reportSettings.SqlParametersCollection.Count > 0) {
				SqlParameter rpPar;
				OleDbParameter oleDBPar = null;
				
				for (int i = 0;i < reportSettings.SqlParametersCollection.Count ; i++) {
					rpPar  = (SqlParameter)reportSettings.SqlParametersCollection[i];

					if (rpPar.DataType != System.Data.DbType.Binary) {
						oleDBPar = new OleDbParameter(rpPar.ParameterName,
						                              rpPar.DataType);
						oleDBPar.Value = rpPar.DefaultValue;
					} else {
						oleDBPar = new OleDbParameter(rpPar.ParameterName,
						                              System.Data.DbType.Binary);
					}
					
					oleDBPar.Direction = rpPar.ParameterDirection;
					cmd.Parameters.Add(oleDBPar);
					
				}
			}
		}
		
		private void CheckReportColumns() {
			if (this.reportSettings.SortColumnCollection.Count > 0) {
				
				if (this.dataViewStrategy.AvailableFields.Count > 0) {
					foreach (SortColumn col in this.reportSettings.SortColumnCollection) {
						string colName = col.ColumnName;
						AbstractColumn c = this.dataViewStrategy.AvailableFields.Find (colName);
						if (c == null) {
							string str = String.Format (CultureInfo.CurrentCulture,
							                            "<{0}> is not a member of <{1}>",colName,this.reportSettings.ReportName);
							throw new SharpReportException(str);
						}
					}
				}
			}
		}
		
		
		#region Event Handling
		private void NotifyListChanged (object sender, ListChangedEventArgs e) {
			if (this.ListChanged != null) {
				this.ListChanged (this,e);
			}
		}
		
		private void NotifyGroupChange (object sender,GroupChangedEventArgs e) {
			
			if (this.GroupChanged != null) {
				this.GroupChanged (this,e);
			}
		}
		
		#endregion
		
		public string DataMember {
			get {
				return dataMember;
			}
		}
		
		public ColumnCollection AvailableFields  {
			get {
				return this.dataViewStrategy.AvailableFields;
			}
			
		}
		
		
		public IHierarchicalArray  IHierarchicalArray {
			get {
				return (IHierarchicalArray)this.dataViewStrategy.IHierarchicalEnumerable;
			}
		}
		
		
		
		
		/*
		
		public void PerformHierarchy (IHierarchicalEnumerable list) {
			
			IEnumerator iter = list.GetEnumerator();
			System.Console.WriteLine("PerformHierarchy");
			if (iter != null) {
				while (iter.MoveNext()){
					GroupSeperator g = (GroupSeperator)iter.Current;
					System.Console.WriteLine("list {0} {1}",g.Path,g.ListIndex);
					
					CheckGroups (g);
				}
			} else {
				throw new SystemException("PerformHierarchy: No valid IEnumerator");
			}
		}
		
		private void CheckGroups(GroupSeperator sep) {
			System.Console.WriteLine("CheckGroups");
			IEnumerator children = ((IHierarchicalEnumerable)sep.GetChildren()).GetEnumerator();
			while (children.MoveNext()) {
				System.Console.WriteLine("children");
			}
		}
		
		public IHierarchicalEnumerable HierarchicalList {
			get {
				return hierarchicalList;
			}
		}
		 */
		
		
		#region SharpReportCore.IDataContainer interface implementation
		public object DataSource {
			get {
				return this.dataSource;
			}
			set {
				this.dataSource = value;
				Reset();
			}
		}
		
		public int CurrentRow {
			get {
				return this.dataViewStrategy.CurrentRow;
			}
		}
		
		public int Count {
			get {
				return this.dataViewStrategy.Count;
			}
		}
		
		
		public bool HasMoreData {
			get {
				if (this.dataViewStrategy.CurrentRow < this.dataViewStrategy.Count ){
					return true;
				} else {
					return false;
				}
			}
		}
		
		
		public bool DataBind() {
			this.dataViewStrategy.Bind();
			this.dataViewStrategy.GroupChanged += new EventHandler <GroupChangedEventArgs>(NotifyGroupChange);
			CheckReportColumns();
			return true;
		}
		
		public void Skip() {
			this.dataViewStrategy.CurrentRow ++;
		}
		
		
		public void FetchData(ReportItemCollection collection) {
			try {
				foreach (IItemRenderer item in collection) {
					this.dataViewStrategy.Fill(item);
				}
			} catch (Exception) {
			}
		}
		
		public string Filter {
			get {
				throw new NotImplementedException();
				
			}
			set {
				throw new NotImplementedException();
			}
		}
		#endregion
		
		
		
		#region System.Collections.IEnumerator interface implementation
		
		public object Current {
			get {
				throw new NotImplementedException("DataManager.Current");
			}
		}
		
		public void Reset() {
			this.dataViewStrategy.Reset();
			this.currentRow = -1;
		}
		
		public bool MoveNext() {
			try {
				this.currentRow ++;
				this.dataViewStrategy.CurrentRow = this.currentRow;
				return true;
			} catch (Exception) {
				return false;
			}
			
		}
		#endregion
		
		public bool IsGrouped {
			get {
				return this.dataViewStrategy.IsGrouped;
			}
		}
		
		#region System.IDisposable interface implementation
		public void Dispose() {
			this.connectionObject = null;
			this.dataViewStrategy = null;
		}
		#endregion
		
	}
}
