//------------------------------------------------------------------------------
// <autogenerated>
//     This code was generated by a tool.
//     Runtime Version: 1.1.4322.2032
//
//     Changes to this file may cause incorrect behavior and will be lost if 
//     the code is regenerated.
// </autogenerated>
//------------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Data;
using System.Data.OleDb;
using System.Globalization;

using ICSharpCode.Core;
	
using SharpReport;
using SharpReportCore;
	
/// <summary>
/// Abstract Class for all ReportGenerators
/// </summary>
/// <remarks>
/// 	created by - Forstmeier Peter
/// 	created on - 07.09.2005 14:21:07
/// </remarks>
/// 
using System.Windows.Forms;
namespace ReportGenerator {	
	
	public class AbstractReportGenerator : IReportGenerator,IDisposable {
	
		private ReportModel reportModel;
		private ReportGenerator reportGenerator;
		private Properties customizer;
		private SharpReportManager manager;
		
		public AbstractReportGenerator() {
		}
		
		public AbstractReportGenerator(Properties customizer,ReportModel reportModel){
			if (reportModel == null) {
				throw new ArgumentNullException("reportModel");
			}
			if (customizer == null) {
				throw new ArgumentNullException("customizer");
			}
			this.customizer = customizer;
			this.reportModel = reportModel;
			
			reportGenerator = (ReportGenerator)customizer.Get("Generator");
			manager = new SharpReportManager();
		}
		
		#region ReportGenerator.IReportGenerator interface implementation
		public virtual void GenerateReport() {
			if (this.reportModel == null) {
				throw new MissingModelException();
			}
			BuildStandartSections();
			manager.CreatePageHeader (this.reportModel);
			manager.CreatePageNumber(this.reportModel);
		}
		
		#endregion
		
		
		protected void BuildStandartSections () {
			foreach (ReportSection section in this.reportModel.SectionCollection) {
				section.Size = new Size (section.Size.Width,
				                         SharpReportCore.GlobalValues.DefaultSectionHeight);
			}
		}
		
		protected void AdjustAll () {
			AdjustNames(reportModel);
		}
		
		private static void AdjustNames (ReportModel model) {
			NameService nameService = new NameService();
			foreach (BaseSection section in model.SectionCollection) {
				foreach (IItemRenderer item in section.Items) {
					item.Name = nameService.CreateName(section.Items,item.Name);
				}
			}
		}
		
		#region Properties
		
		public Properties Customizer {
			get {
				return customizer;
			}
		}
		public ReportGenerator ReportGenerator {
			get {
				return reportGenerator;
			}
		}
		public ReportModel ReportModel {
			get {
				return reportModel;
			}
		}
		public SharpReportManager Manager {
			get {
				return manager;
			}
		}
		
		#endregion
		
		public void Dispose(){
			this.Dispose(true);
			GC.SuppressFinalize(this);
		}
		
		~AbstractReportGenerator(){
			Dispose(false);
		}
		
		protected  void Dispose(bool disposing){
			if (disposing) {
				// Free other state (managed objects).
				if (this.manager != null) {
					this.manager.Dispose();
				}
			}
			
			// Release unmanaged resources.
			// Set large fields to null.
			// Call Dispose on your base class.
		}
	
	}
}
