/*-------------------------------------------------------------------------
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by the 
Free Software Foundation; either version 2, or (at your option) any 
later version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
for more details.

You should have received a copy of the GNU General Public License along 
with this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than 
Coco/R itself) does not fall under the GNU General Public License.
-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------
  Trace output options
  0 | A: prints the states of the scanner automaton
  1 | F: prints the First and Follow sets of all nonterminals
  2 | G: prints the syntax graph of the productions
  3 | I: traces the computation of the First sets
  4 | J: prints the sets associated with ANYs and synchronisation sets
  6 | S: prints the symbol table (terminals, nonterminals, pragmas)
  7 | X: prints a cross reference list of all syntax symbols
  8 | P: prints statistics about the Coco run
  
  Trace output can be switched on by the pragma
    $ { digit | letter }
  in the attributed grammar or as a command-line option
  -------------------------------------------------------------------------*/

using System;
using System.IO;

namespace at.jku.ssw.Coco {

public class Coco {
	
	public static void Main (string[] arg) {
		Console.WriteLine("Coco/R (Jun 28, 2004)");
		string ATGName = null; 
		for (int i = 0; i < arg.Length; i++) {
			if (arg[i] == "-namespace" && i < arg.Length - 1) Tab.nsName = arg[++i];
			else if (arg[i] == "-frames" && i < arg.Length - 1) Tab.frameDir = arg[++i]; 
			else if (arg[i] == "-trace" && i < arg.Length - 1) Tab.SetDDT(arg[++i]); 
			else ATGName = arg[i];
		}
		if (arg.Length > 0 && ATGName != null) {
			int pos = ATGName.LastIndexOf('/');
			if (pos < 0) pos = ATGName.LastIndexOf('\\');
			string file = ATGName;
			string dir = ATGName.Substring(0, pos+1);
			
			Scanner.Init(file);
			Trace.Init(dir);
			Tab.Init(); 
			DFA.Init(file, dir); 
			ParserGen.Init(file, dir);

			Parser.Parse();

			Trace.Close();
			Console.WriteLine("{0} errors detected", Errors.count);
		} else {
			Console.WriteLine("Usage: Coco Grammar.ATG {{Option}}{0}" +
			                  "Options:{0}" +
			                  "  -namespace <namespaceName>{0}" +
			                  "  -frames    <frameFilesDirectory>{0}" +
			                  "  -trace   <traceString>{0}" +
			                  "Valid characters in the trace string:{0}" +
			                  "  A  trace automaton{0}" +
			                  "  F  list first/follow sets{0}" +
			                  "  G  print syntax graph{0}" +
			                  "  I  trace computation of first sets{0}" +
			                  "  J  list ANY and SYNC sets{0}" +
			                  "  P  print statistics{0}" +
			                  "  S  list symbol table{0}" +
			                  "  X  list cross reference table{0}" +
			                  "Scanner.frame and Parser.frame files needed in ATG directory{0}" +
                        "or in a directory specified in the -frames option.",
			                  Environment.NewLine);
		}
	}
} // end Coco

} // end namespace