﻿// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="Matthew Ward" email="mrward@users.sourceforge.net"/>
//     <version>$Revision: 2142 $</version>
// </file>

using System;
using System.Windows.Forms;
using ICSharpCode.SharpDevelop.Dom;
using ICSharpCode.SharpDevelop.Project;
using ICSharpCode.UnitTesting;
using NUnit.Framework;
using UnitTesting.Tests.Utils;

namespace UnitTesting.Tests.Tree
{
	/// <summary>
	/// Tests that if the parser is still running then we do not
	/// add the solution to the unit tests tree.
	/// </summary>
	[TestFixture]
	public class OpenUnitTestsPadWithSolutionOpenTestFixture
	{
		DerivedUnitTestsPad pad;
		
		[TestFixtureSetUp]
		public void SetUp()
		{
			Solution solution = new Solution();
			MockCSharpProject project = new MockCSharpProject();
			MockProjectContent projectContent = new MockProjectContent();
			projectContent.Project = project;
			projectContent.Language = LanguageProperties.None;
			ReferenceProjectItem refProjectItem = new ReferenceProjectItem(project);
			refProjectItem.Include = "NUnit.Framework";
			ProjectService.AddProjectItem(project, refProjectItem);
			solution.Folders.Add(project);
			
			pad = new DerivedUnitTestsPad(solution);
		}
		
		[TestFixtureTearDown]
		public void TearDown()
		{
			pad.Dispose();
		}
		
		[Test]
		public void NoSolutionAddedToTree()
		{
			Assert.AreEqual(0, pad.TestTreeView.GetProjects().Length);
		}
		
		/// <summary>
		/// The LoadSolutionProjectsThreadEnded event handler needs to be
		/// added before the unit tests pad checks the 
		/// LoadSolutionProjectsThreadRunning flag so we do not miss the
		/// event.
		/// </summary>
		[Test]
		public void ParserServiceLoadSolutionProjectsThreadEndedHandled()
		{
			Assert.IsTrue(pad.LoadSolutionProjectsThreadEndedHandled);
		}
	}
}
