﻿// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="Mike Krüger" email="mike@icsharpcode.net"/>
//     <version>$Revision: 1965 $</version>
// </file>

using System;
using System.Drawing;
using System.Windows.Forms;

namespace ICSharpCode.SharpDevelop.Gui.OptionPanels 
{
	public class PropertyGridPanel : AbstractOptionPanel
	{
		private PropertyGrid grid         = new PropertyGrid();
		
		public override bool ReceiveDialogMessage(DialogMessage message)
		{
			if (message == DialogMessage.OK) {
				
			}
			return true;
		}
		
		public PropertyGridPanel(string name, object customizer)// : base(name)
		{
			grid.SelectedObject = customizer;
			
			grid.Size = ClientSize;
			grid.Width  -= 16;
			grid.Height -= 16;
			
			grid.Location                   = new Point(8, 8);
			grid.CommandsVisibleIfAvailable = true;
//			grid.ActiveDocument             = null;
			grid.AutoScrollMinSize          = new Size(0, 0);
			grid.Anchor                     = AnchorStyles.Top | AnchorStyles.Bottom| AnchorStyles.Right |AnchorStyles.Left;
			grid.ToolbarVisible             = false;
			
			this.Controls.Add(grid);
		}
	}
}
