<?php
# SHDFS init configration
# Copyright (C) Digital Adventure Inc.
#
# 2010/05/27 hoshino

function shdfs_init_conf(){

	ini_set('memory_limit','2M') ;
	ini_set('max_execution_time',3600) ;

	$conf = array() ;
	# replicate host list
	# format
	# 'IP-ADDRESS:ServerName(http request host):BASE DIR'
	# sample
	# $conf['replication_hosts[] = '10.100.10.1:80:replicate.digiadv.co.jp:' ;
	# $conf['replication_hosts[] = '10.100.10.2:80:replicate.digiadv.co.jp:' ;
	$conf['replication_hosts'][] = '10.100.10.1:80:hadoop.digiadv.co.jp:' ;
	$conf['replication_hosts'][] = '10.100.10.2:80:hadoop.digiadv.co.jp:' ;
	$conf['replication_hosts'][] = '10.100.10.3:80:hadoop.digiadv.co.jp:' ;
	$conf['replication_hosts'][] = '10.100.10.4:80:hadoop.digiadv.co.jp:' ;
	$conf['replication_hosts'][] = '10.100.10.5:80:hadoop.digiadv.co.jp:' ;
	$conf['replication_hosts'][] = '10.100.10.6:80:hadoop.digiadv.co.jp:' ;
	$conf['replication_hosts'][] = '10.100.10.7:80:hadoop.digiadv.co.jp:' ;

	# umber of copies of content files, including your own
	$conf['replication_number'] = 3 ;

	# path the PHP CLI command. Called when deleting cache.
	$conf['php_cli_path'] = '/usr/local/bin/php' ;

	# This server without replication, the cache only when specified TRUE.
	# (TRUE or FALSE)
	$conf['disable_cache'] = FALSE ;
	$conf['disable_replicate'] = FALSE ;

	# If this value is larger than disk usage(%), replication stops working
	# renge : 1 - 99 (%)
	$conf['disk_usage_limit_of_replication'] = 95 ;

	# If this value is larger than disk usage(%), cache stops working
	# renge : 1 - 99 (%)
	$conf['disk_usage_limit_of_cache'] = 90 ;

	$conf['auto_garbage_collection'] = TRUE ;

	$conf['cache_lite_dir'] = '/tmp/' ; # The trailing "/" is required
	$conf['cache_lite_lifetime'] = 30 ;

	return $conf ;
}
?>