/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data;

import com.projity.association.AssociationList;
import com.projity.association.InvalidAssociationException;
import com.projity.company.UserUtil;
import com.projity.configuration.CircularDependencyException;
import com.projity.configuration.Configuration;
import com.projity.configuration.FieldDictionary;
import com.projity.configuration.Settings;
import com.projity.field.FieldValues;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeFactory;
import com.projity.grouping.core.VoidNodeImpl;
import com.projity.grouping.core.model.DefaultNodeModel;
import com.projity.grouping.core.model.NodeModelDataFactory;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.dependency.DependencyService;
import com.projity.pm.dependency.HasDependencies;
import com.projity.pm.key.HasId;
import com.projity.pm.key.uniqueid.UniqueIdException;
import com.projity.pm.resource.EnterpriseResource;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.resource.ResourcePool;
import com.projity.pm.resource.ResourcePoolFactory;
import com.projity.pm.snapshot.DataSnapshot;
import com.projity.pm.snapshot.Snapshottable;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.pm.task.SubProj;
import com.projity.pm.task.Task;
import com.projity.pm.task.TaskSnapshot;
import com.projity.server.access.ErrorLogger;
import com.projity.server.data.AssignmentData;
import com.projity.server.data.CommonDataObject;
import com.projity.server.data.DataObject;
import com.projity.server.data.DistributionComparator;
import com.projity.server.data.DistributionConverter;
import com.projity.server.data.DistributionData;
import com.projity.server.data.DocumentData;
import com.projity.server.data.EnterpriseResourceData;
import com.projity.server.data.LinkData;
import com.projity.server.data.ProjectData;
import com.projity.server.data.ResourceData;
import com.projity.server.data.SerializeUtil;
import com.projity.server.data.SerializedDataObject;
import com.projity.server.data.SerializedDataObjectFactory;
import com.projity.server.data.TaskData;
import com.projity.server.data.linker.Linker;
import com.projity.server.data.linker.ResourceLinker;
import com.projity.server.data.linker.TaskLinker;
import com.projity.session.Session;
import com.projity.session.SessionFactory;
import com.projity.strings.Messages;
import com.projity.undo.DataFactoryUndoController;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;

public class Serializer {
    public static final boolean TMP_FILES = false;
    protected Linker resourceLinker = new ResourceLinker(){

        public Object addTransformedObjects(Object object) throws IOException, UniqueIdException {
            EnterpriseResourceData enterpriseResourceData;
            Project project = (Project)this.parent;
            ResourceImpl resourceImpl = (ResourceImpl)object;
            ResourceData resourceData = new ResourceData();
            resourceData.setUniqueId(resourceImpl.getUniqueId());
            resourceData.setRole(resourceImpl.getRole());
            if (resourceImpl.isDefault()) {
                return null;
            }
            if (project.isMaster()) {
                enterpriseResourceData = (EnterpriseResourceData)Serializer.this.serialize((DataObject)resourceImpl.getGlobalResource(), EnterpriseResourceData.FACTORY, null);
            } else {
                enterpriseResourceData = new EnterpriseResourceData();
                enterpriseResourceData.setUniqueId(resourceImpl.getGlobalResource().getUniqueId());
            }
            String string = resourceImpl.getGlobalResource().getEmailAddress();
            enterpriseResourceData.setEmailAddress(string == null || string.length() == 0 ? null : string);
            resourceData.setEnterpriseResource(enterpriseResourceData);
            this.transformationMap.put(new Long(resourceImpl.getUniqueId()), resourceData);
            return resourceData;
        }

        public void executeFinally() {
            ((ProjectData)this.getTransformedParent()).setResources(this.transformed);
        }

        public boolean addOutlineElement(Object object, Object object2, long l) {
            if (object instanceof VoidNodeImpl) {
                return false;
            }
            ResourceData resourceData = (ResourceData)((Object)this.getTransformationMap().get(new Long(((Resource)object).getUniqueId())));
            ResourceData resourceData2 = object2 == null ? null : (ResourceData)((Object)this.getTransformationMap().get(new Long(((Resource)object2).getUniqueId())));
            EnterpriseResourceData enterpriseResourceData = resourceData.getEnterpriseResource();
            enterpriseResourceData.setParentResource(resourceData2 == null ? null : resourceData2.getEnterpriseResource());
            enterpriseResourceData.setChildPosition(l);
            return true;
        }
    };
    protected TaskLinker taskLinker = new TaskLinker(){

        public Object addTransformedObjects(Object object) throws IOException, UniqueIdException {
            Collection collection;
            TaskData taskData;
            boolean bl;
            NormalTask normalTask = (NormalTask)object;
            Project project = (Project)this.getParent();
            if (normalTask.getOwningProject() != project || normalTask.isExternal()) {
                return null;
            }
            final Map map = (Map)this.args[0];
            boolean bl2 = bl = !this.incremental || normalTask.isDirty();
            if (bl) {
                taskData = (TaskData)Serializer.this.serialize((DataObject)normalTask, TaskData.FACTORY, null);
                taskData.setNotes(normalTask.getNotes());
            } else {
                taskData = new TaskData();
                taskData.setUniqueId(normalTask.getUniqueId());
            }
            taskData.setStatus(bl ? 1 : 0);
            taskData.setProjectId(normalTask.getProjectId());
            if (normalTask.isSubproject()) {
                taskData.setSubprojectId(((SubProj)normalTask).getSubprojectUniqueId());
            }
            Collection collection2 = collection = this.flatAssignments == null ? new ArrayList() : this.flatAssignments;
            if (bl) {
                Serializer.forAssignments(normalTask, new AssignmentClosure(){

                    public void execute(Assignment assignment, int n) throws IOException {
                        EnterpriseResourceData enterpriseResourceData;
                        ResourceImpl resourceImpl = (ResourceImpl)assignment.getResource();
                        AssignmentData assignmentData = (AssignmentData)Serializer.this.serialize((DataObject)assignment, AssignmentData.FACTORY, null);
                        assignmentData.setStatus(1);
                        if (flatAssignments == null) {
                            assignmentData.setTask(taskData);
                        } else {
                            assignmentData.setTaskId(taskData.getUniqueId());
                        }
                        EnterpriseResourceData enterpriseResourceData2 = enterpriseResourceData = resourceImpl.isDefault() ? null : ((ResourceData)((Object)map.get(new Long(resourceImpl.getUniqueId())))).getEnterpriseResource();
                        if (flatAssignments == null) {
                            assignmentData.setResource(enterpriseResourceData);
                        } else {
                            assignmentData.setResourceId(enterpriseResourceData == null ? -1L : enterpriseResourceData.getUniqueId());
                        }
                        assignmentData.setSnapshotId(n);
                        assignmentData.setCachedStart(new Date(assignment.getStart()));
                        assignmentData.setCachedEnd(new Date(assignment.getEnd()));
                        assignmentData.setTimesheetStatus(assignment.getTimesheetStatus());
                        assignmentData.setLastTimesheetUpdate(new Date(assignment.getLastTimesheetUpdate()));
                        assignmentData.setWorkflowState(assignment.getWorkflowState());
                        assignmentData.setPercentComplete(assignment.getPercentComplete());
                        assignmentData.setDuration(assignment.getDuration());
                        collection.add(assignmentData);
                    }
                });
            }
            if (this.flatAssignments == null) {
                taskData.setAssignments(collection);
            }
            this.transformationMap.put(normalTask, taskData);
            return taskData;
        }

        public void executeFinally() {
            ((ProjectData)this.getTransformedParent()).setTasks(this.transformed);
        }

        public boolean addOutlineElement(Object object, Object object2, long l) {
            TaskData taskData;
            TaskData taskData2 = (TaskData)((Object)this.getTransformationMap().get(object));
            if (object instanceof VoidNodeImpl) {
                taskData2 = new TaskData();
                ((ProjectData)this.getTransformedParent()).getTasks().add(taskData2);
            }
            if (taskData2 == null) {
                return false;
            }
            TaskData taskData3 = taskData = object2 == null ? null : (TaskData)((Object)this.getTransformationMap().get(object2));
            if (taskData != null && taskData.isSubproject()) {
                taskData = null;
            }
            taskData2.setParentTask(taskData);
            taskData2.setChildPosition(l);
            if (object instanceof Task) {
                long l2;
                Task task = (Task)object;
                long l3 = l2 = taskData == null ? -1L : taskData.getUniqueId();
                if (l2 != task.getLastSavedParentId() || l != task.getLastSavedPosistion()) {
                    taskData2.setMoved(true);
                }
            }
            return true;
        }
    };
    protected File tmpDir = null;

    protected Map saveResources(Project project, ProjectData projectData) throws Exception {
        this.resourceLinker.setParent(project);
        this.resourceLinker.setTransformedParent(projectData);
        this.resourceLinker.init();
        this.resourceLinker.addTransformedObjects();
        this.resourceLinker.addOutline(null);
        return this.resourceLinker.getTransformationMap();
    }

    protected void saveTasks(Project project, ProjectData projectData, Map map, Collection collection, Collection collection2, boolean bl) throws Exception {
        Iterator iterator;
        TaskData taskData;
        Object object;
        ArrayList<Long> arrayList = null;
        ArrayList<Long> arrayList2 = null;
        if (bl) {
            arrayList = new ArrayList<Long>();
            arrayList2 = new ArrayList<Long>();
        }
        this.taskLinker.setIncremental(bl);
        this.taskLinker.setFlatAssignments(collection);
        this.taskLinker.setParent(project);
        this.taskLinker.setTransformedParent(projectData);
        this.taskLinker.setArgs(new Object[]{map});
        this.taskLinker.init();
        this.taskLinker.addTransformedObjects();
        this.taskLinker.addOutline(project.getTaskOutlineRoot());
        long l = project.getUniqueId();
        Object object2 = project.getTaskOutlineIterator();
        while (object2.hasNext()) {
            object = (NormalTask)object2.next();
            if (object.getProjectId() != l || object.isExternal() || (taskData = (TaskData)((Object)this.taskLinker.getTransformationMap().get(object))) == null || !(iterator = object.getPredecessorList().iterator()).hasNext()) continue;
            ArrayList<LinkData> arrayList3 = new ArrayList<LinkData>();
            while (iterator.hasNext()) {
                boolean bl2;
                Dependency dependency = (Dependency)iterator.next();
                boolean bl3 = bl2 = !bl || dependency.isDirty();
                if (!bl2) {
                    arrayList2.add(dependency.getPredecessorId());
                    arrayList2.add(dependency.getSuccessorId());
                    continue;
                }
                LinkData linkData = (LinkData)this.serialize((DataObject)dependency, LinkData.FACTORY, null);
                linkData.setDirty(dependency.isDirty());
                if (collection2 == null) {
                    linkData.setSuccessor(taskData);
                } else {
                    linkData.setSuccessorId(taskData.getUniqueId());
                }
                Task task = (Task)dependency.getPredecessor();
                TaskData taskData2 = (TaskData)((Object)this.taskLinker.getTransformationMap().get(task));
                if (collection2 == null) {
                    if (taskData2 != null && !taskData2.isExternal()) {
                        linkData.setPredecessor(taskData2);
                    } else {
                        linkData.setPredecessorId(task.getUniqueId());
                    }
                    arrayList3.add(linkData);
                    continue;
                }
                linkData.setPredecessorId(task.getUniqueId());
                collection2.add(linkData);
            }
            if (collection2 != null) continue;
            taskData.setPredecessors(arrayList3);
        }
        if (bl) {
            object2 = projectData.getTasks();
            if (object2 != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    taskData = (TaskData)((Object)object.next());
                    if (taskData.isDirty() || taskData.isMoved()) continue;
                    arrayList.add(taskData.getUniqueId());
                    object.remove();
                }
            }
            if (arrayList.size() > 0) {
                object = new long[arrayList.size()];
                int n = 0;
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    long l2 = (Long)iterator.next();
                    object[n++] = l2;
                }
                projectData.setUnchangedTasks((long[])object);
            }
            if (arrayList2.size() > 0) {
                object = new long[arrayList2.size()];
                int n = 0;
                iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    long l3 = (Long)iterator.next();
                    object[n++] = l3;
                }
                projectData.setUnchangedLinks((long[])object);
            }
        }
    }

    public DocumentData serializeDocument(Project project) throws Exception {
        return this.serializeProject(project, null, null, false);
    }

    public ProjectData serializeProject(Project project) throws Exception {
        return this.serializeProject(project, null, null, false);
    }

    public ProjectData serializeProject(Project project, Collection collection, Collection collection2, boolean bl) throws Exception {
        Object object;
        Object object2;
        if (project.isForceNonIncremental()) {
            bl = false;
        }
        boolean bl2 = bl && !project.isForceNonIncrementalDistributions();
        Count count = new Count("Project");
        ProjectData projectData = (ProjectData)this.serialize((DataObject)project, ProjectData.FACTORY, count);
        if (project.isForceNonIncremental()) {
            projectData.setVersion(0.0f);
        }
        projectData.setMaster(project.isMaster());
        count.dump();
        Map map = this.saveResources(project, projectData);
        this.saveTasks(project, projectData, map, collection, collection2, bl);
        long l = System.currentTimeMillis();
        ArrayList<DistributionData> arrayList = new DistributionConverter().createDistributionData(project, bl2);
        if (arrayList == null) {
            arrayList = new ArrayList<DistributionData>();
        }
        projectData.setDistributions(arrayList);
        projectData.setIncrementalDistributions(bl2);
        TreeMap treeMap = project.getDistributionMap();
        if (treeMap == null) {
            treeMap = new TreeMap(new DistributionComparator());
            project.setDistributionMap(treeMap);
        }
        TreeMap<DistributionData, DistributionData> treeMap2 = new TreeMap<DistributionData, DistributionData>((Comparator<DistributionData>)new DistributionComparator());
        Object object3 = arrayList.iterator();
        while (object3.hasNext()) {
            object2 = (DistributionData)object3.next();
            if (bl2) {
                object = (DistributionData)treeMap.get(object2);
                if (object == null) {
                    object2.setStatus(4);
                } else if (object.getWork() == object2.getWork() && object.getCost() == object2.getCost()) {
                    object2.setStatus(0);
                    object3.remove();
                } else {
                    object2.setStatus(1);
                }
            } else {
                object2.setStatus(4);
            }
            treeMap2.put((DistributionData)object2, (DistributionData)object2);
        }
        if (bl2 && treeMap.size() > 0) {
            object3 = new HashSet();
            object = project.getTaskOutlineIterator();
            while (object.hasNext()) {
                object2 = (Task)object.next();
                if (!bl || object2.isDirty()) continue;
                object3.add(object2.getUniqueId());
            }
            for (DistributionData distributionData : treeMap.values()) {
                if (treeMap2.containsKey(distributionData)) continue;
                if (object3.contains(distributionData.getTaskId())) {
                    distributionData.setStatus(0);
                    treeMap2.put(distributionData, distributionData);
                    continue;
                }
                distributionData.setStatus(8);
                arrayList.add(distributionData);
            }
        }
        project.setNewDistributionMap(treeMap2);
        System.out.println("Distributions generated in " + (System.currentTimeMillis() - l) + " ms");
        object3 = FieldValues.getValues((Collection)FieldDictionary.getInstance().getProjectFields(), (Object)project);
        if (project.getContainingSubprojectTask() != null) {
            object2 = Configuration.getFieldFromId((String)"Field.duration").getValue((Object)project.getContainingSubprojectTask(), null);
            ((HashMap)object3).put("Field.duration", object2);
        }
        projectData.setFieldValues((Map)object3);
        projectData.setGroup(project.getGroup());
        projectData.setDivision(project.getDivision());
        projectData.setExpenseType(project.getExpenseType());
        projectData.setProjectType(project.getProjectType());
        projectData.setProjectStatus(project.getProjectStatus());
        projectData.setExtraFields(project.getExtraFields());
        projectData.setAccessControlPolicy(project.getAccessControlPolicy());
        projectData.setCreationDate(project.getCreationDate());
        projectData.setLastModificationDate(project.getLastModificationDate());
        return projectData;
    }

    public Project deserializeLocalDocument(DocumentData documentData) throws IOException, ClassNotFoundException {
        return this.deserializeProject((ProjectData)documentData, false, (Session)SessionFactory.getInstance().getLocalSession(), null);
    }

    public Project deserializeProject(ProjectData projectData, boolean bl, Session session, Map map) throws IOException, ClassNotFoundException {
        return this.deserializeProject(projectData, bl, session, map, true);
    }

    public Project deserializeProject(ProjectData projectData, boolean bl, Session session, Map map, boolean bl2) throws IOException, ClassNotFoundException {
        Node node;
        Object object9;
        Object object2;
        Object object3;
        Object object42;
        Object object52;
        Object object6;
        Node node2;
        Object object7;
        Object object82;
        DataFactoryUndoController dataFactoryUndoController = new DataFactoryUndoController();
        Project project = (Project)Serializer.deserialize((DataObject)projectData, session);
        project.setUndoController(dataFactoryUndoController);
        project.setMaster(projectData.isMaster());
        project.setLocal(projectData.isLocal());
        project.setReadOnly(!projectData.canBeUsed());
        project.setCreationDate(projectData.getCreationDate());
        project.setLastModificationDate(projectData.getLastModificationDate());
        boolean bl3 = false;
        WorkCalendar workCalendar = project.getWorkCalendar();
        if (workCalendar == null) {
            workCalendar = CalendarService.getInstance().getDefaultInstance();
        }
        project.setWorkCalendar(workCalendar);
        project.setExtraFields(projectData.getExtraFields());
        project.setGroup(projectData.getGroup());
        project.setDivision(projectData.getDivision());
        project.setExpenseType(projectData.getExpenseType());
        project.setProjectType(projectData.getProjectType());
        project.setProjectStatus(projectData.getProjectStatus());
        project.setAccessControlPolicy(projectData.getAccessControlPolicy());
        project.postDeserialization();
        HashMap<EnterpriseResourceData, Node> hashMap = new HashMap<EnterpriseResourceData, Node>();
        ResourcePool resourcePool = ResourcePoolFactory.getInstance().createResourcePool(project.getName(), dataFactoryUndoController);
        resourcePool.setMaster(project.isMaster());
        resourcePool.setLocal(project.isLocal());
        resourcePool.updateOutlineTypes();
        Collection collection = projectData.getResources();
        if (collection != null) {
            Collections.sort((List)collection, new Comparator<ResourceData>(){

                @Override
                public int compare(ResourceData resourceData, ResourceData resourceData2) {
                    if (resourceData.getChildPosition() > resourceData2.getChildPosition()) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
        for (Object object82 : collection) {
            object7 = Serializer.deserializeResourceAndAddToPool((ResourceData)((Object)object82), resourcePool, session, map);
            hashMap.put(((ResourceData)((Object)object82)).getEnterpriseResource(), NodeFactory.getInstance().createNode(object7));
        }
        project.setResourcePool(resourcePool);
        if (collection != null) {
            for (Object object82 : collection) {
                object7 = ((ResourceData)((Object)object82)).getEnterpriseResource();
                EnterpriseResourceData enterpriseResourceData = ((EnterpriseResourceData)((Object)object7)).getParentResource();
                node2 = (Node)hashMap.get(object7);
                object6 = enterpriseResourceData == null ? null : (Node)hashMap.get((Object)enterpriseResourceData);
                project.getResourcePool().addToDefaultOutline((Node)object6, node2, (int)((EnterpriseResourceData)((Object)object7)).getChildPosition(), false);
                ((ResourceImpl)node2.getImpl()).getGlobalResource().setResourcePool(project.getResourcePool());
            }
            project.getResourcePool().getResourceOutline().getHierarchy().cleanVoidChildren();
            project.getResourcePool().getResourceOutline().getHierarchy().visitAll(new Closure(){
                int id = 1;

                public void execute(Object object) {
                    HasId hasId;
                    Node node = (Node)object;
                    if (node.getImpl() instanceof HasId && (hasId = (HasId)node.getImpl()).getId() > 0L) {
                        hasId.setId((long)this.id++);
                    }
                }
            });
        }
        Collection collection2 = projectData.getTasks();
        object82 = new HashMap();
        long l = project.getUniqueId();
        if (collection2 != null) {
            Dependency dependency;
            Collections.sort((List)collection2, new Comparator<TaskData>(){

                @Override
                public int compare(TaskData taskData, TaskData taskData2) {
                    if (!taskData.isExternal() && taskData2.isExternal()) {
                        return -1;
                    }
                    if (taskData.isExternal() && !taskData2.isExternal()) {
                        return 1;
                    }
                    if (taskData.getChildPosition() > taskData2.getChildPosition()) {
                        return 1;
                    }
                    return -1;
                }
            });
            object6 = collection2.iterator();
            while (object6.hasNext()) {
                node2 = null;
                object52 = (TaskData)((Object)object6.next());
                if (object52.isDirty()) {
                    bl3 = true;
                }
                if (object52.getSerialized() == null) {
                    if (!((TaskData)((Object)object52)).isTimesheetCreated()) continue;
                    node2 = new NormalTask(project);
                    node2.setName(object52.getName());
                    System.out.println("made new task in serializer " + node2 + " parent " + ((TaskData)((Object)object52)).getParentTask().getName());
                } else {
                    try {
                        node2 = (NormalTask)Serializer.deserialize((DataObject)object52, session);
                    }
                    catch (Exception exception) {
                        if (((TaskData)((Object)object52)).isSubproject()) {
                            try {
                                node2 = (NormalTask)Class.forName(Messages.getMetaString((String)"Subproject")).getConstructor(Project.class, Long.class).newInstance(project, ((TaskData)((Object)object52)).getSubprojectId());
                            }
                            catch (Exception exception2) {
                                exception2.printStackTrace();
                            }
                            node2.setUniqueId(object52.getUniqueId());
                            node2.setName(object52.getName());
                            ((SubProj)node2).setSubprojectFieldValues(((TaskData)((Object)object52)).getSubprojectFieldValues());
                        }
                        throw new IOException("Subproject:" + exception);
                    }
                }
                object82.put(object52, NodeFactory.getInstance().createNode((Object)node2));
                node2.setProject(project);
                project.initializeId((Task)node2);
                project.add((Task)node2);
                if (((TaskData)((Object)object52)).isExternal()) {
                    node2.setExternal(true);
                    node2.setProjectId(((TaskData)((Object)object52)).getProjectId());
                    node2.setAllSchedulesToCurrentDates();
                    project.addExternalTask((Task)node2);
                } else {
                    node2.setOwningProject(project);
                    node2.setProjectId(l);
                }
                if (((TaskData)((Object)object52)).isSubproject()) {
                    object42 = (SubProj)node2;
                    object42.setSubprojectUniqueId(((TaskData)((Object)object52)).getSubprojectId());
                    object42.setSubprojectFieldValues(((TaskData)((Object)object52)).getSubprojectFieldValues());
                    object42.setSchedulesFromSubprojectFieldValues();
                }
                if ((object42 = (WorkingCalendar)node2.getWorkCalendar()) != null && (object3 = (WorkingCalendar)CalendarService.findBaseCalendar((String)object42.getName())) != null && object3 != object42) {
                    node2.setWorkCalendar((WorkCalendar)object3);
                }
                if (((TaskData)((Object)object52)).getAssignments() == null) continue;
                object3 = ((TaskData)((Object)object52)).getAssignments().iterator();
                while (object3.hasNext()) {
                    object2 = (AssignmentData)((Object)object3.next());
                    object9 = object2.getResource();
                    dependency = object9 == null ? ResourceImpl.getUnassignedInstance() : (Resource)((Node)hashMap.get(object9)).getImpl();
                    node = null;
                    if (object2.getSerialized() != null) {
                        try {
                            node = (Assignment)Serializer.deserialize((DataObject)object2, session);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (object2.getSerialized() == null || object2.getSerialized() != null && node == null) {
                        node = Assignment.getInstance((Task)node2, (Resource)dependency, (double)1.0, (int)0);
                        if (node.getCachedStart() == null) {
                            System.out.println("==== no cached start found " + node2.getName());
                        } else {
                            node2.setActualStart(node.getCachedStart().getTime());
                            node2.setActualFinish(node.getCachedEnd().getTime());
                        }
                    }
                    node.getDetail().setTask((Task)node2);
                    node.getDetail().setResource((Resource)dependency);
                    node.setCachedStart(object2.getCachedStart());
                    node.setCachedEnd(object2.getCachedEnd());
                    node.setTimesheetStatus(object2.getTimesheetStatus());
                    long l2 = object2.getLastTimesheetUpdate() == null ? 0L : object2.getLastTimesheetUpdate().getTime();
                    node.setLastTimesheetUpdate(l2);
                    node.setWorkflowState(object2.getWorkflowState());
                    Integer n = new Integer(object2.getSnapshotId());
                    TaskSnapshot taskSnapshot = (TaskSnapshot)node2.getSnapshot((Object)n);
                    if (taskSnapshot == null) {
                        taskSnapshot = new TaskSnapshot();
                        taskSnapshot.setCurrentSchedule(node2.getCurrentSchedule());
                        node2.setSnapshot((Object)n, (DataSnapshot)taskSnapshot);
                    }
                    if (Snapshottable.TIMESHEET.equals(n)) {
                        node.setTimesheetAssignment(true);
                    }
                    taskSnapshot.addAssignment((Assignment)node);
                    if (object9 != null && Snapshottable.CURRENT.equals(n)) {
                        dependency.addAssignment((Assignment)node);
                    }
                    object2.emtpy();
                }
            }
            object6 = projectData.getReferringSubprojectTasks();
            if (collection2 != null && object6 != null) {
                object52 = new ArrayList(object6.size());
                project.setReferringSubprojectTasks((Collection)object52);
                object42 = object6.iterator();
                while (object42.hasNext()) {
                    object3 = (TaskData)((Object)object42.next());
                    object2 = object3.getName();
                    node2 = null;
                    try {
                        node2 = (NormalTask)Serializer.deserialize((DataObject)object3, session);
                    }
                    catch (Exception exception) {
                        if (((TaskData)((Object)object3)).isSubproject()) {
                            node2 = (NormalTask)project.getSubprojectHandler().createSubProj(((TaskData)((Object)object3)).getSubprojectId());
                            node2.setUniqueId(object3.getUniqueId());
                            node2.setName(object3.getName());
                            ((SubProj)node2).setSubprojectFieldValues(((TaskData)((Object)object3)).getSubprojectFieldValues());
                        }
                        throw new IOException("Subproject:" + exception);
                    }
                    node2.setName((String)object2);
                    node2.setProjectId(((TaskData)((Object)object3)).getProjectId());
                    ((ArrayList)object52).add(node2);
                }
            }
            for (Object object42 : projectData.getTasks()) {
                if (object42.getPredecessors() == null) continue;
                object3 = (Task)((Node)object82.get(object42)).getImpl();
                for (Object object9 : object42.getPredecessors()) {
                    dependency = (Dependency)Serializer.deserialize((DataObject)object9, session);
                    if (object9.getPredecessor() == null) {
                        System.out.println("null pred - this shouldn't happen. skipping");
                        continue;
                    }
                    node = (Task)((Node)object82.get((Object)object9.getPredecessor())).getImpl();
                    Serializer.connectDependency(dependency, (Task)node, (Task)object3);
                    object9.emtpy();
                }
            }
        }
        if (collection2 != null) {
            object6 = new HashMap();
            object52 = collection2.iterator();
            while (object52.hasNext()) {
                object42 = (TaskData)((Object)object52.next());
                object3 = object42.getParentTask();
                object2 = object42.getSerialized() == null && !object42.isTimesheetCreated() ? NodeFactory.getInstance().createVoidNode() : (Node)object82.get(object42);
                object9 = null;
                int n = -1;
                if (object42.isExternal()) {
                    node = (Node)object6.get(object42.getProjectId());
                    if (node != null) {
                        object9 = (Node)node.getParent();
                    }
                    if (object9 != null) {
                        n = object9.getIndex((TreeNode)node) + 1;
                        if (object9.isRoot()) {
                            object9 = null;
                        }
                    }
                }
                if (n == -1) {
                    object9 = object3 == null ? null : (Node)object82.get(object3);
                    n = (int)object42.getChildPosition();
                }
                if (object42.isTimesheetCreated()) {
                    System.out.println("new task " + object2 + "parent node is " + object9);
                }
                if (object2.getImpl() instanceof SubProj) {
                    node = (SubProj)object2.getImpl();
                    object6.put(node.getSubprojectUniqueId(), object2);
                }
                project.addToDefaultOutline(object9, object2, n, false);
                object42.emtpy();
            }
            project.getTaskOutline().getHierarchy().visitAll(new Closure(){
                int id = 1;

                public void execute(Object object) {
                    HasId hasId;
                    Node node = (Node)object;
                    if (node.getImpl() instanceof HasId && (hasId = (HasId)node.getImpl()).getId() > 0L) {
                        hasId.setId((long)this.id++);
                    }
                }
            });
        }
        if (collection != null) {
            for (Object object52 : collection) {
                object42 = ((ResourceData)((Object)object52)).getEnterpriseResource();
                ((ResourceData)((Object)object52)).emtpy();
                object42.emtpy();
            }
        }
        ((DefaultNodeModel)project.getTaskOutline()).setDataFactory((NodeModelDataFactory)project);
        project.initialize(bl, bl2 && !bl3);
        projectData.emtpy();
        new DistributionConverter().substractDistributionFromProject(project);
        if (bl3) {
            project.setForceNonIncremental(true);
        }
        if ((double)project.getVersion() < 1.2) {
            project.setForceNonIncrementalDistributions(true);
        }
        project.setVersion(1.2f);
        return project;
    }

    public static void connectDependency(Dependency dependency, Task task, Task task2) {
        try {
            DependencyService.getInstance().initDependency(dependency, (HasDependencies)task, (HasDependencies)task2, null);
        }
        catch (InvalidAssociationException invalidAssociationException) {
            dependency.setDisabled(true);
            try {
                DependencyService.getInstance().initDependency(dependency, (HasDependencies)task, (HasDependencies)task2, null);
            }
            catch (InvalidAssociationException invalidAssociationException2) {
                invalidAssociationException2.printStackTrace();
            }
            DependencyService.warnCircularCrossProjectLinkMessage((Object)task, (Object)task2);
        }
    }

    public static ResourceImpl deserializeResourceAndAddToPool(EnterpriseResourceData enterpriseResourceData, ResourcePool resourcePool, Session session) throws IOException, ClassNotFoundException {
        ResourceData resourceData = new ResourceData();
        resourceData.setEnterpriseResource(enterpriseResourceData);
        ResourceImpl resourceImpl = Serializer.deserializeResourceAndAddToPool(resourceData, resourcePool, session, null);
        Serializer.setRoles(resourceImpl, resourceData);
        return resourceImpl;
    }

    public static ResourceImpl deserializeResourceAndAddToPool(ResourceData resourceData, ResourcePool resourcePool, Session session, Map map) throws IOException, ClassNotFoundException {
        EnterpriseResourceData enterpriseResourceData;
        EnterpriseResource enterpriseResource;
        EnterpriseResourceData enterpriseResourceData2 = resourceData.getEnterpriseResource();
        if (map == null) {
            enterpriseResource = (EnterpriseResource)Serializer.deserialize((DataObject)enterpriseResourceData2, session);
            enterpriseResource.setUserAccount(enterpriseResourceData2.getUserAccount());
        } else {
            enterpriseResourceData = (EnterpriseResourceData)((Object)map.get(new Long(enterpriseResourceData2.getUniqueId())));
            if (enterpriseResourceData == null) {
                return null;
            }
            enterpriseResource = (EnterpriseResource)Serializer.deserialize((DataObject)enterpriseResourceData, session);
            enterpriseResource.setUserAccount(enterpriseResourceData.getUserAccount());
        }
        enterpriseResource.setGlobalWorkVector(enterpriseResourceData2.getGlobalWorkVector());
        enterpriseResource.setMaster(resourcePool.isMaster());
        enterpriseResourceData = resourceData.getSerialized() == null ? Serializer.createResourceFromEnterpriseResource(enterpriseResource) : (ResourceImpl)Serializer.deserialize((DataObject)resourceData, session);
        enterpriseResourceData.setGlobalResource(enterpriseResource);
        Serializer.setRoles((ResourceImpl)enterpriseResourceData, resourceData);
        WorkingCalendar workingCalendar = (WorkingCalendar)enterpriseResource.getWorkCalendar();
        if (workingCalendar == null) {
            enterpriseResource.setWorkCalendar((WorkCalendar)WorkingCalendar.getInstanceBasedOn((WorkCalendar)resourcePool.getDefaultCalendar()));
        } else {
            try {
                WorkCalendar workCalendar = CalendarService.findBaseCalendar((String)workingCalendar.getBaseCalendar().getName());
                if (workCalendar != null) {
                    workingCalendar.setBaseCalendar(workCalendar);
                }
            }
            catch (CircularDependencyException circularDependencyException) {
                circularDependencyException.printStackTrace();
            }
        }
        resourcePool.initializeId((Resource)enterpriseResource);
        resourcePool.add((Resource)enterpriseResourceData);
        return enterpriseResourceData;
    }

    private static void setRoles(ResourceImpl resourceImpl, ResourceData resourceData) {
        resourceImpl.setRole(resourceData.getRole());
        int[] nArray = resourceData.getEnterpriseResource().getAuthorizedRoles();
        if (nArray != null) {
            EnterpriseResource enterpriseResource = resourceImpl.getGlobalResource();
            enterpriseResource.setDefaultRole(nArray.length > 0 ? nArray[0] : 0);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < nArray.length; ++i) {
                hashSet.add(UserUtil.toExtendedRole((int)nArray[i], (boolean)resourceImpl.isUser()));
            }
            enterpriseResource.setAuthorizedRoles(hashSet);
            enterpriseResource.setLicense(resourceData.getEnterpriseResource().getLicense());
            enterpriseResource.setLicenseOptions(resourceData.getEnterpriseResource().getLicenseOptions());
        }
    }

    private static ResourceImpl createResourceFromEnterpriseResource(EnterpriseResource enterpriseResource) {
        ResourceImpl resourceImpl = new ResourceImpl();
        return resourceImpl;
    }

    public static void setEnterpriseResources(Collection collection, ResourcePool resourcePool, Session session) throws IOException, ClassNotFoundException {
        if (collection != null) {
            Object object;
            HashMap<EnterpriseResourceData, Node> hashMap = new HashMap<EnterpriseResourceData, Node>();
            for (EnterpriseResourceData enterpriseResourceData : collection) {
                object = Serializer.deserializeResourceAndAddToPool(enterpriseResourceData, resourcePool, session);
                hashMap.put(enterpriseResourceData, NodeFactory.getInstance().createNode(object));
            }
            for (EnterpriseResourceData enterpriseResourceData : collection) {
                object = enterpriseResourceData.getParentResource();
                Node node = (Node)hashMap.get((Object)enterpriseResourceData);
                Node node2 = object == null ? null : (Node)hashMap.get(object);
                resourcePool.addToDefaultOutline(node2, node, (int)enterpriseResourceData.getChildPosition(), false);
                ((ResourceImpl)node.getImpl()).getGlobalResource().setResourcePool(resourcePool);
            }
            resourcePool.getResourceOutline().getHierarchy().cleanVoidChildren();
        }
    }

    public static void forProjectDataDo(ProjectData projectData, Closure closure) {
        closure.execute((Object)projectData);
        if (projectData.getCalendar() != null) {
            closure.execute((Object)projectData.getCalendar());
        }
        for (SerializedDataObject serializedDataObject : projectData.getResources()) {
            closure.execute((Object)serializedDataObject);
            closure.execute((Object)serializedDataObject.getEnterpriseResource());
        }
        for (SerializedDataObject serializedDataObject : projectData.getTasks()) {
            closure.execute((Object)serializedDataObject);
            CollectionUtils.forAllDo((Collection)serializedDataObject.getAssignments(), (Closure)closure);
            CollectionUtils.forAllDo((Collection)serializedDataObject.getPredecessors(), (Closure)closure);
        }
    }

    public static void forProjectDataReversedDo(ProjectData projectData, Closure closure) {
        for (SerializedDataObject serializedDataObject : projectData.getTasks()) {
            CollectionUtils.forAllDo((Collection)serializedDataObject.getAssignments(), (Closure)closure);
            CollectionUtils.forAllDo((Collection)serializedDataObject.getPredecessors(), (Closure)closure);
            closure.execute((Object)serializedDataObject);
        }
        for (SerializedDataObject serializedDataObject : projectData.getResources()) {
            closure.execute((Object)serializedDataObject.getEnterpriseResource());
            closure.execute((Object)serializedDataObject);
        }
        if (projectData.getCalendar() != null) {
            closure.execute((Object)projectData.getCalendar());
        }
        closure.execute((Object)projectData);
    }

    public static void renumberProject(ProjectData projectData) {
        Serializer.forProjectDataDo(projectData, new IdClosure(){

            public void execute(Object object) {
                ((CommonDataObject)object).setUniqueId(this.id++);
            }
        });
    }

    protected void initTmpDir() throws IOException {
        this.tmpDir = new File(System.getProperty("user.home"), "projity_tmp");
        if (this.tmpDir.isDirectory()) {
            File[] fileArray = this.tmpDir.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    fileArray[i].delete();
                }
            }
        } else if (!this.tmpDir.exists()) {
            this.tmpDir.mkdir();
        }
    }

    protected void writeTmpFile(SerializedDataObject serializedDataObject, Count count) throws IOException {
        if (this.tmpDir != null && count != null) {
            try {
                File file = new File(this.tmpDir, serializedDataObject.getPrefix() + "_" + count.count);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                if (serializedDataObject.getSerialized() != null) {
                    fileOutputStream.write(serializedDataObject.getSerialized());
                }
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    public DataObject serialize(DataObject dataObject, SerializedDataObjectFactory serializedDataObjectFactory, Count count) throws IOException {
        SerializedDataObject serializedDataObject = SerializeUtil.serialize(dataObject, serializedDataObjectFactory);
        byte[] byArray = serializedDataObject.getSerialized();
        if (count != null) {
            count.add(byArray == null ? 0 : byArray.length);
        }
        return serializedDataObject;
    }

    public static DataObject serializeSingle(DataObject dataObject, SerializedDataObjectFactory serializedDataObjectFactory, Count count) throws IOException {
        SerializedDataObject serializedDataObject = SerializeUtil.serialize(dataObject, serializedDataObjectFactory);
        byte[] byArray = serializedDataObject.getSerialized();
        if (count != null) {
            count.add(byArray == null ? 0 : byArray.length);
        }
        return serializedDataObject;
    }

    public static DataObject deserialize(DataObject dataObject, Session session) throws IOException, ClassNotFoundException {
        return SerializeUtil.deserialize((SerializedDataObject)dataObject, session);
    }

    protected Collection serialize(Collection collection, SerializedDataObjectFactory serializedDataObjectFactory) throws IOException {
        if (collection == null) {
            return new ArrayList();
        }
        ArrayList<SerializedDataObject> arrayList = new ArrayList<SerializedDataObject>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(SerializeUtil.serialize((DataObject)iterator.next(), serializedDataObjectFactory));
        }
        return arrayList;
    }

    protected Collection deserialize(Collection collection, Session session) throws IOException, ClassNotFoundException {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(SerializeUtil.deserialize((SerializedDataObject)iterator.next(), session));
        }
        return arrayList;
    }

    public static void buildStructure(ProjectData projectData, Collection collection, Collection collection2, Collection collection3, Collection collection4, Collection collection5, Collection collection6) {
        collection2.addAll(collection5);
        projectData.setTasks(collection2);
        projectData.setResources(collection);
        projectData.setReferringSubprojectTasks(collection6);
        Map map = Serializer.createIdMap(collection);
        Map map2 = Serializer.createIdMap(collection2);
        Serializer.buildAssignmentsStructure(projectData, collection3, map, map2);
        Serializer.buildLinksStructure(projectData, collection4, map2);
    }

    public static void buildAssignmentsStructure(ProjectData projectData, Collection collection) {
        Serializer.buildAssignmentsStructure(projectData, collection, null, null);
    }

    public static void buildAssignmentsStructure(ProjectData projectData, Collection collection, Map map, Map map2) {
        Map map3;
        Map map4 = map == null ? Serializer.createIdMap(projectData.getResources()) : map;
        Map map5 = map3 = map2 == null ? Serializer.createIdMap(projectData.getTasks()) : map2;
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                AssignmentData assignmentData;
                ResourceData resourceData = (ResourceData)((Object)map4.get(new Long((assignmentData = (AssignmentData)((Object)iterator.next())).getResourceId())));
                assignmentData.setResource(resourceData == null ? null : resourceData.getEnterpriseResource());
                TaskData taskData = (TaskData)((Object)map3.get(new Long(assignmentData.getTaskId())));
                if (taskData == null) {
                    ErrorLogger.logOnce((String)"null task data", (String)("null task data - project " + projectData.getName()), null);
                    continue;
                }
                taskData.addAssignment(assignmentData);
            }
        }
    }

    public static void buildLinksStructure(ProjectData projectData, Collection collection) {
        Serializer.buildLinksStructure(projectData, collection, null);
    }

    public static void buildLinksStructure(ProjectData projectData, Collection collection, Map map) {
        Map map2;
        Map map3 = map2 = map == null ? Serializer.createIdMap(projectData.getTasks()) : map;
        if (collection != null) {
            for (LinkData linkData : collection) {
                TaskData taskData = (TaskData)((Object)map2.get(new Long(linkData.getPredecessorId())));
                TaskData taskData2 = (TaskData)((Object)map2.get(new Long(linkData.getSuccessorId())));
                if (taskData == null || taskData2 == null) continue;
                taskData2.addPredecessor(linkData);
                linkData.setPredecessor(taskData);
            }
        }
    }

    public static Map createIdMap(Collection collection) {
        HashMap<Long, DataObject> hashMap = new HashMap<Long, DataObject>();
        if (collection != null) {
            for (DataObject dataObject : collection) {
                hashMap.put(new Long(dataObject.getUniqueId()), dataObject);
            }
        }
        return hashMap;
    }

    public void printTaskDataHierarchy(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        this.printTaskDataHierarchy(collection, stringBuffer);
        System.out.println(stringBuffer);
    }

    public void printTaskDataHierarchy(Collection collection, final StringBuffer stringBuffer) {
        HashMap<Long, TreeSet<TaskData>> hashMap = new HashMap<Long, TreeSet<TaskData>>();
        for (TaskData taskData : collection) {
            if (taskData == null) continue;
            Long l = new Long(taskData.getParentTaskId());
            TreeSet<TaskData> treeSet = (TreeSet<TaskData>)hashMap.get(l);
            if (treeSet == null) {
                treeSet = new TreeSet<TaskData>(new Comparator(){

                    public int compare(Object object, Object object2) {
                        int n;
                        TaskData taskData = (TaskData)((Object)object);
                        TaskData taskData2 = (TaskData)((Object)object2);
                        int n2 = taskData.getChildPosition() < taskData2.getChildPosition() ? -1 : (n = taskData.getChildPosition() == taskData2.getChildPosition() ? 0 : 1);
                        if (n == 0) {
                            stringBuffer.append("Duplicates: task0=" + taskData.getName() + ", " + taskData.getParentTaskId() + ", " + taskData.getChildPosition() + " task1=" + taskData2.getName() + ", " + taskData2.getParentTaskId() + ", " + taskData2.getChildPosition() + "\n");
                        }
                        return n;
                    }
                });
            }
            treeSet.add(taskData);
            hashMap.put(l, treeSet);
        }
        this.buildTaskDataHierarchy(-1L, "\t", hashMap, stringBuffer);
    }

    private void buildTaskDataHierarchy(long l, String string, Map map, StringBuffer stringBuffer) {
        Object v = map.get(new Long(l));
        if (v == null) {
            return;
        }
        TreeSet treeSet = (TreeSet)((TreeSet)v).clone();
        for (TaskData taskData : treeSet) {
            stringBuffer.append(string).append(taskData.getName()).append(',').append(taskData.getUniqueId()).append('\n');
            if (taskData.getUniqueId() == -1L) continue;
            this.buildTaskDataHierarchy(taskData.getUniqueId(), string + "\t", map, stringBuffer);
        }
    }

    public static void forAssignments(NormalTask normalTask, AssignmentClosure assignmentClosure) throws IOException {
        for (int i = 0; i < Settings.numBaselines(); ++i) {
            AssociationList associationList;
            TaskSnapshot taskSnapshot = (TaskSnapshot)normalTask.getSnapshot((Object)new Integer(i));
            if (taskSnapshot == null || (associationList = taskSnapshot.getHasAssignments().getAssignments()).size() <= 0) continue;
            Iterator iterator = associationList.iterator();
            while (iterator.hasNext()) {
                assignmentClosure.execute((Assignment)iterator.next(), i);
            }
        }
    }

    public static interface AssignmentClosure {
        public void execute(Assignment var1, int var2) throws IOException;
    }

    class Count {
        int count;
        int size;
        int max;
        int min = Integer.MAX_VALUE;
        String typeLabel;

        public Count(String string) {
            this.typeLabel = string;
        }

        void reset() {
            this.count = 0;
            this.size = 0;
            this.max = 0;
            this.min = Integer.MAX_VALUE;
        }

        void add(int n) {
            ++this.count;
            this.size += n;
            if (n < this.min) {
                this.min = n;
            }
            if (n > this.max) {
                this.max = n;
            }
        }

        void dump() {
            System.out.println("Serialized " + this.count + " " + this.typeLabel + ", total=" + this.size + ", average=" + (this.count == 0 ? 0 : this.size / this.count) + ", min=" + this.min + ", max=" + this.max);
        }
    }

    private static abstract class IdClosure
    implements Closure {
        long id = 1L;

        private IdClosure() {
        }
    }
}

