/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.regexp;

import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.grammar.IDContextProvider2;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.util.DatatypeRef;
import com.sun.msv.verifier.regexp.REDocumentDeclaration;
import com.sun.msv.verifier.regexp.ResidualCalculator;
import com.sun.msv.verifier.regexp.Token;
import org.relaxng.datatype.Datatype;

public class StringToken
extends Token {
    public final String literal;
    public final IDContextProvider2 context;
    protected final ResidualCalculator resCalc;
    protected final boolean ignorable;
    public DatatypeRef refType;
    protected boolean saturated = false;
    private static final Datatype[] ignoredType = new Datatype[0];

    public StringToken(REDocumentDeclaration docDecl, String literal, IDContextProvider2 context) {
        this(docDecl.resCalc, literal, context, null);
    }

    public StringToken(REDocumentDeclaration docDecl, String literal, IDContextProvider2 context, DatatypeRef refType) {
        this(docDecl.resCalc, literal, context, refType);
    }

    public StringToken(ResidualCalculator resCalc, String literal, IDContextProvider2 context, DatatypeRef refType) {
        this.resCalc = resCalc;
        this.literal = literal;
        this.context = context;
        this.refType = refType;
        boolean bl = this.ignorable = literal.trim().length() == 0;
        if (this.ignorable && refType != null) {
            refType.types = ignoredType;
        }
    }

    public boolean match(ValueExp exp) {
        Object thisValue = exp.dt.createValue(this.literal, this.context);
        if (!exp.dt.sameValue(thisValue, exp.value)) {
            return false;
        }
        if (this.refType != null) {
            this.assignType(exp.dt);
        }
        if (exp.dt.getIdType() != 0 && this.context != null) {
            this.context.onID(exp.dt, this);
        }
        return true;
    }

    public boolean matchAnyString() {
        if (this.refType != null) {
            this.assignType(StringType.theInstance);
        }
        return true;
    }

    private void assignType(Datatype dt) {
        if (this.saturated) {
            if (this.refType.types != null && (this.refType.types[0] != dt || this.refType.types.length != 1)) {
                this.refType.types = null;
            }
        } else {
            this.refType.types = new Datatype[]{dt};
            this.saturated = true;
        }
    }

    boolean isIgnorable() {
        return this.ignorable;
    }
}

