/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Map;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TimeUnit;

public final class MPDUtility {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static CurrencySymbolPosition getSymbolPosition(int value) {
        CurrencySymbolPosition result;
        switch (value) {
            case 1: {
                result = CurrencySymbolPosition.AFTER;
                break;
            }
            case 2: {
                result = CurrencySymbolPosition.BEFORE_WITH_SPACE;
                break;
            }
            case 3: {
                result = CurrencySymbolPosition.AFTER_WITH_SPACE;
                break;
            }
            default: {
                result = CurrencySymbolPosition.BEFORE;
            }
        }
        return result;
    }

    public static final TimeUnit getDurationTimeUnits(int type) {
        TimeUnit units;
        switch (type & 0x1F) {
            case 3: {
                units = TimeUnit.MINUTES;
                break;
            }
            case 4: {
                units = TimeUnit.ELAPSED_MINUTES;
                break;
            }
            case 5: {
                units = TimeUnit.HOURS;
                break;
            }
            case 6: {
                units = TimeUnit.ELAPSED_HOURS;
                break;
            }
            case 8: {
                units = TimeUnit.ELAPSED_DAYS;
                break;
            }
            case 9: {
                units = TimeUnit.WEEKS;
                break;
            }
            case 10: {
                units = TimeUnit.ELAPSED_WEEKS;
                break;
            }
            case 11: {
                units = TimeUnit.MONTHS;
                break;
            }
            case 12: {
                units = TimeUnit.ELAPSED_MONTHS;
                break;
            }
            default: {
                units = TimeUnit.DAYS;
            }
        }
        return units;
    }

    public static Duration getAdjustedDuration(ProjectFile file, int duration, TimeUnit timeUnit) {
        Duration result;
        switch (timeUnit.getValue()) {
            case 2: {
                double unitsPerDay = file.getProjectHeader().getMinutesPerDay().doubleValue() * 10.0;
                double totalDays = (double)duration / unitsPerDay;
                result = Duration.getInstance(totalDays, timeUnit);
                break;
            }
            case 9: {
                double unitsPerDay = 14400.0;
                double totalDays = (double)duration / unitsPerDay;
                result = Duration.getInstance(totalDays, timeUnit);
                break;
            }
            case 3: {
                double unitsPerWeek = file.getProjectHeader().getMinutesPerWeek().doubleValue() * 10.0;
                double totalWeeks = (double)duration / unitsPerWeek;
                result = Duration.getInstance(totalWeeks, timeUnit);
                break;
            }
            case 10: {
                double unitsPerWeek = 100800.0;
                double totalWeeks = (double)duration / unitsPerWeek;
                result = Duration.getInstance(totalWeeks, timeUnit);
                break;
            }
            case 11: {
                double unitsPerMonth = 417600.0;
                double totalMonths = (double)duration / unitsPerMonth;
                result = Duration.getInstance(totalMonths, timeUnit);
                break;
            }
            default: {
                result = Duration.getInstance(duration, timeUnit);
            }
        }
        return result;
    }

    public static final Duration getDuration(double value, TimeUnit type) {
        double duration;
        switch (type.getValue()) {
            case 0: 
            case 7: {
                duration = value / 10.0;
                break;
            }
            case 1: 
            case 8: {
                duration = value / 600.0;
                break;
            }
            case 2: 
            case 9: {
                duration = value / 4800.0;
                break;
            }
            case 3: 
            case 10: {
                duration = value / 24000.0;
                break;
            }
            case 4: 
            case 11: {
                duration = value / 96000.0;
                break;
            }
            default: {
                duration = value;
            }
        }
        return Duration.getInstance(duration, type);
    }

    public static void dumpRow(Map row) {
        for (Map.Entry entry : row.entrySet()) {
            Object value = entry.getValue();
            System.out.println(entry.getKey() + " = " + value + " ( " + (value == null ? "" : value.getClass().getName()) + ")");
        }
    }

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii) {
        StringBuffer sb = new StringBuffer();
        if (buffer != null) {
            int count = offset + length;
            int loop = offset;
            while (loop < count) {
                sb.append(" ");
                sb.append(HEX_DIGITS[(buffer[loop] & 0xF0) >> 4]);
                sb.append(HEX_DIGITS[buffer[loop] & 0xF]);
                ++loop;
            }
            if (ascii) {
                sb.append("   ");
                loop = offset;
                while (loop < count) {
                    char c = (char)buffer[loop];
                    if (c > '\u00c8' || c < '\u001b') {
                        c = ' ';
                    }
                    sb.append(c);
                    ++loop;
                }
            }
        }
        return sb.toString();
    }

    public static final String hexdump(byte[] buffer, boolean ascii) {
        int length = 0;
        if (buffer != null) {
            length = buffer.length;
        }
        return MPDUtility.hexdump(buffer, 0, length, ascii);
    }

    public static final String hexdump(byte[] buffer, boolean ascii, int columns, String prefix) {
        StringBuffer sb = new StringBuffer();
        if (buffer != null) {
            int index = 0;
            DecimalFormat df = new DecimalFormat("00000");
            while (index < buffer.length) {
                if (index + columns > buffer.length) {
                    columns = buffer.length - index;
                }
                sb.append(prefix);
                sb.append(df.format(index));
                sb.append(":");
                sb.append(MPDUtility.hexdump(buffer, index, columns, ascii));
                sb.append('\n');
                index += columns;
            }
        }
        return sb.toString();
    }

    public static final void fileHexDump(String fileName, byte[] data) {
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            os.write(MPDUtility.hexdump(data, true, 16, "").getBytes());
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final void fileHexDump(String fileName, InputStream is) {
        try {
            byte[] data = new byte[is.available()];
            is.read(data);
            MPDUtility.fileHexDump(fileName, data);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final void fileDump(String fileName, byte[] data) {
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            os.write(data);
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

