/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.TipModel;
import com.l2fprod.common.swing.a;
import com.l2fprod.common.swing.plaf.JTipOfTheDayAddon;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import com.l2fprod.common.swing.plaf.TipOfTheDayUI;
import com.l2fprod.common.swing.tips.DefaultTipModel;
import java.awt.Component;
import java.awt.HeadlessException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JDialog;

public class JTipOfTheDay
extends JComponent {
    public static final String uiClassID = "l2fprod/TipOfTheDayUI";
    public static final String PREFERENCE_KEY = "ShowTipOnStartup";
    public static final String CURRENT_TIP_CHANGED_KEY = "currentTip";
    private TipModel b;
    private int c = 0;
    static Class a;

    public JTipOfTheDay() {
        this(new DefaultTipModel(new TipModel.Tip[0]));
    }

    public JTipOfTheDay(TipModel tipModel) {
        this.b = tipModel;
        this.updateUI();
    }

    public void updateUI() {
        this.setUI((TipOfTheDayUI)LookAndFeelAddons.getUI(this, a == null ? (a = JTipOfTheDay.a("com.l2fprod.common.swing.plaf.TipOfTheDayUI")) : a));
    }

    public void setUI(TipOfTheDayUI tipOfTheDayUI) {
        super.setUI(tipOfTheDayUI);
    }

    public TipOfTheDayUI getUI() {
        return (TipOfTheDayUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public TipModel getModel() {
        return this.b;
    }

    public void setModel(TipModel tipModel) {
        TipModel tipModel2 = this.b;
        this.b = tipModel;
        this.firePropertyChange("model", tipModel2, tipModel);
    }

    public int getCurrentTip() {
        return this.c;
    }

    public void setCurrentTip(int n2) {
        if (n2 < 0 || n2 >= this.getModel().getTipCount()) {
            throw new IllegalArgumentException("Current tip must be within the bounds [0, " + this.getModel().getTipCount() + "[");
        }
        int n3 = this.c;
        this.c = n2;
        this.firePropertyChange(CURRENT_TIP_CHANGED_KEY, n3, n2);
    }

    public void nextTip() {
        int n2 = this.getModel().getTipCount();
        if (n2 == 0) {
            return;
        }
        int n3 = this.c + 1;
        if (n3 >= n2) {
            n3 = 0;
        }
        this.setCurrentTip(n3);
    }

    public void previousTip() {
        int n2 = this.getModel().getTipCount();
        if (n2 == 0) {
            return;
        }
        int n3 = this.c - 1;
        if (n3 < 0) {
            n3 = n2 - 1;
        }
        this.setCurrentTip(n3);
    }

    public void showDialog(Component component) throws HeadlessException {
        this.showDialog(component, (ShowOnStartupChoice)null);
    }

    public boolean showDialog(Component component, Preferences preferences) throws HeadlessException {
        return this.showDialog(component, preferences, false);
    }

    public boolean showDialog(Component component, Preferences preferences, boolean bl) throws HeadlessException {
        if (preferences == null) {
            throw new IllegalArgumentException("Preferences can not be null");
        }
        a a2 = new a(this, preferences);
        return this.showDialog(component, a2, bl);
    }

    public boolean showDialog(Component component, ShowOnStartupChoice showOnStartupChoice) {
        return this.showDialog(component, showOnStartupChoice, false);
    }

    public boolean showDialog(Component component, ShowOnStartupChoice showOnStartupChoice, boolean bl) {
        if (showOnStartupChoice == null) {
            JDialog jDialog = this.a(component, showOnStartupChoice);
            jDialog.setVisible(true);
            jDialog.dispose();
            return true;
        }
        if (bl || showOnStartupChoice.isShowingOnStartup()) {
            JDialog jDialog = this.a(component, showOnStartupChoice);
            jDialog.setVisible(true);
            jDialog.dispose();
            return showOnStartupChoice.isShowingOnStartup();
        }
        return false;
    }

    public static boolean isShowingOnStartup(Preferences preferences) {
        return preferences.getBoolean(PREFERENCE_KEY, true);
    }

    public static void forceShowOnStartup(Preferences preferences) {
        preferences.remove(PREFERENCE_KEY);
    }

    protected final JDialog a(Component component, ShowOnStartupChoice showOnStartupChoice) {
        return this.getUI().createDialog(component, showOnStartupChoice);
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LookAndFeelAddons.contribute(new JTipOfTheDayAddon());
    }

    public static interface ShowOnStartupChoice {
        public void setShowingOnStartup(boolean var1);

        public boolean isShowingOnStartup();
    }
}

