/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.a;
import org.apache.commons.logging.b;
import org.apache.commons.logging.c;

public abstract class LogFactory {
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static Hashtable j = new Hashtable();
    static Class k;
    static Class l;

    protected LogFactory() {
    }

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    public static LogFactory getFactory() throws LogConfigurationException {
        String string;
        Object object;
        Enumeration<?> enumeration;
        Properties properties;
        LogFactory logFactory;
        ClassLoader classLoader;
        block20: {
            classLoader = (ClassLoader)AccessController.doPrivileged(new b());
            logFactory = LogFactory.a(classLoader);
            if (logFactory != null) {
                return logFactory;
            }
            properties = null;
            try {
                enumeration = LogFactory.a(classLoader, FACTORY_PROPERTIES);
                if (enumeration != null) {
                    properties = new Properties();
                    properties.load((InputStream)((Object)enumeration));
                    ((InputStream)((Object)enumeration)).close();
                }
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {}
            try {
                enumeration = System.getProperty(FACTORY_PROPERTY);
                if (enumeration != null) {
                    logFactory = LogFactory.a((String)((Object)enumeration), classLoader);
                }
            }
            catch (SecurityException securityException) {}
            if (logFactory == null) {
                try {
                    enumeration = LogFactory.a(classLoader, "META-INF/services/org.apache.commons.logging.LogFactory");
                    if (enumeration == null) break block20;
                    try {
                        object = new BufferedReader(new InputStreamReader((InputStream)((Object)enumeration), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        object = new BufferedReader(new InputStreamReader((InputStream)((Object)enumeration)));
                    }
                    string = ((BufferedReader)object).readLine();
                    ((BufferedReader)object).close();
                    if (string != null && !"".equals(string)) {
                        logFactory = LogFactory.a(string, classLoader);
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (logFactory == null && properties != null && (enumeration = properties.getProperty(FACTORY_PROPERTY)) != null) {
            logFactory = LogFactory.a((String)((Object)enumeration), classLoader);
        }
        if (logFactory == null) {
            logFactory = LogFactory.a(FACTORY_DEFAULT, (k == null ? (k = LogFactory.b(FACTORY_PROPERTY)) : k).getClassLoader());
        }
        if (logFactory != null) {
            LogFactory.a(classLoader, logFactory);
            if (properties != null) {
                enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    string = properties.getProperty((String)object);
                    logFactory.setAttribute((String)object, string);
                }
            }
        }
        return logFactory;
    }

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String string) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(ClassLoader classLoader) {
        Hashtable hashtable = j;
        synchronized (hashtable) {
            LogFactory logFactory = (LogFactory)j.get(classLoader);
            if (logFactory != null) {
                logFactory.release();
                j.remove(classLoader);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAll() {
        Hashtable hashtable = j;
        synchronized (hashtable) {
            Enumeration enumeration = j.elements();
            while (enumeration.hasMoreElements()) {
                LogFactory logFactory = (LogFactory)enumeration.nextElement();
                logFactory.release();
            }
            j.clear();
            return;
        }
    }

    protected static ClassLoader f() throws LogConfigurationException {
        ClassLoader classLoader = null;
        try {
            Method method = (l == null ? (l = LogFactory.b("java.lang.Thread")) : l).getMethod("getContextClassLoader", null);
            try {
                classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new LogConfigurationException("Unexpected IllegalAccessException", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException invocationTargetException2 = invocationTargetException;
                if (!(invocationTargetException.getTargetException() instanceof SecurityException)) {
                    throw new LogConfigurationException("Unexpected InvocationTargetException", invocationTargetException2.getTargetException());
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            classLoader = (k == null ? (k = LogFactory.b(FACTORY_PROPERTY)) : k).getClassLoader();
        }
        return classLoader;
    }

    private static LogFactory a(ClassLoader classLoader) {
        LogFactory logFactory = null;
        if (classLoader != null) {
            logFactory = (LogFactory)j.get(classLoader);
        }
        return logFactory;
    }

    private static void a(ClassLoader classLoader, LogFactory logFactory) {
        if (classLoader != null && logFactory != null) {
            j.put(classLoader, logFactory);
        }
    }

    protected static LogFactory a(String string, ClassLoader classLoader) throws LogConfigurationException {
        Object t2 = AccessController.doPrivileged(new a(classLoader, string));
        if (t2 instanceof LogConfigurationException) {
            throw (LogConfigurationException)t2;
        }
        return (LogFactory)t2;
    }

    private static InputStream a(ClassLoader classLoader, String string) {
        return (InputStream)AccessController.doPrivileged(new c(classLoader, string));
    }

    static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

