/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.b;
import org.apache.commons.collections.l;
import org.apache.commons.pool.BaseKeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.a;
import org.apache.commons.pool.impl.c;

public class GenericKeyedObjectPool
extends BaseKeyedObjectPool
implements KeyedObjectPool {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final int DEFAULT_MAX_TOTAL = -1;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    private int a = 8;
    private int b = 8;
    private int c = -1;
    private long d = -1L;
    private byte e = 1;
    private boolean f = false;
    private boolean g = false;
    private boolean h = false;
    private long i = -1L;
    private int j = 3;
    private long k = 1800000L;
    private HashMap l = null;
    private l m = null;
    private HashMap n = null;
    private int o = 0;
    private int p = 0;
    private KeyedPoolableObjectFactory q = null;
    private a r = null;
    private b s = null;
    private b t = null;

    public GenericKeyedObjectPool() {
        this(null, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory) {
        this(keyedPoolableObjectFactory, 8, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, Config config) {
        this(keyedPoolableObjectFactory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n2) {
        this(keyedPoolableObjectFactory, n2, 1, -1L, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n2, byte by, long l2) {
        this(keyedPoolableObjectFactory, n2, by, l2, 8, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n2, byte by, long l2, boolean bl, boolean bl2) {
        this(keyedPoolableObjectFactory, n2, by, l2, 8, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n2, byte by, long l2, int n3) {
        this(keyedPoolableObjectFactory, n2, by, l2, n3, false, false, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n2, byte by, long l2, int n3, boolean bl, boolean bl2) {
        this(keyedPoolableObjectFactory, n2, by, l2, n3, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n2, byte by, long l2, int n3, boolean bl, boolean bl2, long l3, int n4, long l4, boolean bl3) {
        this(keyedPoolableObjectFactory, n2, by, l2, n3, -1, bl, bl2, l3, n4, l4, bl3);
    }

    public GenericKeyedObjectPool(KeyedPoolableObjectFactory keyedPoolableObjectFactory, int n2, byte by, long l2, int n3, int n4, boolean bl, boolean bl2, long l3, int n5, long l4, boolean bl3) {
        this.q = keyedPoolableObjectFactory;
        this.b = n2;
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this.e = by;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
            }
        }
        this.d = l2;
        this.a = n3;
        this.c = n4;
        this.f = bl;
        this.g = bl2;
        this.i = l3;
        this.j = n5;
        this.k = l4;
        this.h = bl3;
        this.l = new HashMap();
        this.n = new HashMap();
        this.m = new l();
        this.a(this.i);
    }

    public synchronized int getMaxActive() {
        return this.b;
    }

    public synchronized void setMaxActive(int n2) {
        this.b = n2;
        this.notifyAll();
    }

    public synchronized int getMaxTotal() {
        return this.c;
    }

    public synchronized void setMaxTotal(int n2) {
        this.c = n2;
        this.notifyAll();
    }

    public synchronized byte getWhenExhaustedAction() {
        return this.e;
    }

    public synchronized void setWhenExhaustedAction(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this.e = by;
                this.notifyAll();
                return;
            }
        }
        throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
    }

    public synchronized long getMaxWait() {
        return this.d;
    }

    public synchronized void setMaxWait(long l2) {
        this.d = l2;
    }

    public synchronized int getMaxIdle() {
        return this.a;
    }

    public synchronized void setMaxIdle(int n2) {
        this.a = n2;
        this.notifyAll();
    }

    public synchronized boolean getTestOnBorrow() {
        return this.f;
    }

    public synchronized void setTestOnBorrow(boolean bl) {
        this.f = bl;
    }

    public synchronized boolean getTestOnReturn() {
        return this.g;
    }

    public synchronized void setTestOnReturn(boolean bl) {
        this.g = bl;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.i;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long l2) {
        this.i = l2;
        this.a(this.i);
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this.j;
    }

    public synchronized void setNumTestsPerEvictionRun(int n2) {
        this.j = n2;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.k;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long l2) {
        this.k = l2;
    }

    public synchronized boolean getTestWhileIdle() {
        return this.h;
    }

    public synchronized void setTestWhileIdle(boolean bl) {
        this.h = bl;
    }

    public synchronized void setConfig(Config config) {
        this.setMaxIdle(config.maxIdle);
        this.setMaxActive(config.maxActive);
        this.setMaxTotal(config.maxTotal);
        this.setMaxWait(config.maxWait);
        this.setWhenExhaustedAction(config.whenExhaustedAction);
        this.setTestOnBorrow(config.testOnBorrow);
        this.setTestOnReturn(config.testOnReturn);
        this.setTestWhileIdle(config.testWhileIdle);
        this.setNumTestsPerEvictionRun(config.numTestsPerEvictionRun);
        this.setMinEvictableIdleTimeMillis(config.minEvictableIdleTimeMillis);
        this.setTimeBetweenEvictionRunsMillis(config.timeBetweenEvictionRunsMillis);
    }

    public synchronized Object borrowObject(Object object) throws Exception {
        c c2;
        block18: {
            long l2 = System.currentTimeMillis();
            boolean bl = false;
            block9: while (true) {
                l l3;
                if (null == (l3 = (l)this.l.get(object))) {
                    l3 = new l();
                    this.l.put(object, l3);
                    this.m.add(object);
                }
                c2 = null;
                try {
                    c2 = (c)l3.a();
                    if (null != c2) {
                        --this.p;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {}
                if (null == c2) {
                    Object object2;
                    if (this.c > 0 && this.o + this.p >= this.c) {
                        this.clear();
                    }
                    int n2 = this.c(object);
                    if (!(this.b > 0 && n2 >= this.b || this.c > 0 && this.o + this.p >= this.c)) {
                        object2 = this.q.makeObject(object);
                        c2 = new c(this, object2);
                        bl = true;
                    } else {
                        switch (this.e) {
                            case 2: {
                                object2 = this.q.makeObject(object);
                                c2 = new c(this, object2);
                                break;
                            }
                            case 0: {
                                throw new NoSuchElementException();
                            }
                            case 1: {
                                try {
                                    if (this.d <= 0L) {
                                        this.wait();
                                    } else {
                                        this.wait(this.d);
                                    }
                                }
                                catch (InterruptedException interruptedException) {}
                                if (this.d <= 0L || System.currentTimeMillis() - l2 < this.d) continue block9;
                                throw new NoSuchElementException("Timeout waiting for idle object");
                            }
                            default: {
                                throw new IllegalArgumentException("whenExhaustedAction " + this.e + " not recognized.");
                            }
                        }
                    }
                }
                this.q.activateObject(object, c2.a);
                if (!this.f || this.q.validateObject(object, c2.a)) break block18;
                this.q.destroyObject(object, c2.a);
                if (bl) break;
            }
            throw new NoSuchElementException("Could not create a validated object");
        }
        this.a(object);
        return c2.a;
    }

    public synchronized void clear() {
        Iterator iterator = this.m.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            l l2 = (l)this.l.get(e2);
            Iterator iterator2 = l2.iterator();
            while (iterator2.hasNext()) {
                try {
                    this.q.destroyObject(e2, ((c)iterator2.next()).a);
                }
                catch (Exception exception) {}
                iterator2.remove();
            }
        }
        this.l.clear();
        this.m.clear();
        this.p = 0;
        this.notifyAll();
    }

    public synchronized void clear(Object object) {
        l l2 = (l)this.l.remove(object);
        if (null == l2) {
            return;
        }
        this.m.remove(object);
        Iterator iterator = l2.iterator();
        while (iterator.hasNext()) {
            try {
                this.q.destroyObject(object, ((c)iterator.next()).a);
            }
            catch (Exception exception) {}
            iterator.remove();
            --this.p;
        }
        this.notifyAll();
    }

    public synchronized int getNumActive() {
        return this.o;
    }

    public synchronized int getNumIdle() {
        return this.p;
    }

    public synchronized int getNumActive(Object object) {
        return this.c(object);
    }

    public synchronized int getNumIdle(Object object) {
        try {
            return ((l)this.l.get(object)).size();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object, Object object2) throws Exception {
        boolean bl = true;
        if (this.g && !this.q.validateObject(object, object2)) {
            bl = false;
            try {
                this.q.destroyObject(object, object2);
            }
            catch (Exception exception) {}
        } else {
            try {
                this.q.passivateObject(object, object2);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        boolean bl2 = false;
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            l l2 = (l)this.l.get(object);
            if (null == l2) {
                l2 = new l();
                this.l.put(object, l2);
                this.m.add(object);
            }
            this.b(object);
            if (this.a >= 0 && l2.size() >= this.a) {
                bl2 = true;
            } else if (bl) {
                l2.a(new c(this, object2));
                ++this.p;
            }
            this.notifyAll();
        }
        if (bl2) {
            try {
                this.q.destroyObject(object, object2);
                return;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object object, Object object2) throws Exception {
        GenericKeyedObjectPool genericKeyedObjectPool;
        try {
            this.q.destroyObject(object, object2);
            Object var4_3 = null;
            genericKeyedObjectPool = this;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            GenericKeyedObjectPool genericKeyedObjectPool2 = this;
            synchronized (genericKeyedObjectPool2) {
                this.b(object);
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (genericKeyedObjectPool) {
            this.b(object);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject(Object object) throws Exception {
        Object object2 = this.q.makeObject(object);
        GenericKeyedObjectPool genericKeyedObjectPool = this;
        synchronized (genericKeyedObjectPool) {
            this.a(object);
            this.returnObject(object, object2);
            return;
        }
    }

    public synchronized void close() throws Exception {
        this.clear();
        this.m = null;
        this.l = null;
        this.n = null;
        if (null != this.s) {
            this.s.b();
            this.s = null;
        }
        if (null != this.t) {
            this.t.b();
            this.t = null;
        }
        if (null != this.r) {
            this.r.a();
            this.r = null;
        }
    }

    public synchronized void setFactory(KeyedPoolableObjectFactory keyedPoolableObjectFactory) throws IllegalStateException {
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this.q = keyedPoolableObjectFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void evict() throws Exception {
        Object object = null;
        int n2 = 0;
        int n3 = this.a();
        while (n2 < n3) {
            block20: {
                block23: {
                    Object object2;
                    block21: {
                        block22: {
                            if (this.l.size() <= 0) break block20;
                            if (null == this.t) {
                                this.t = this.m.b();
                                object = null;
                                if (null != this.s) {
                                    this.s.b();
                                    this.s = null;
                                }
                            }
                            if (null != this.s) break block21;
                            if (this.t.hasNext()) break block22;
                            if (null != this.t) {
                                this.t.b();
                                this.t = this.m.b();
                                if (null != this.s) {
                                    this.s.b();
                                    this.s = null;
                                }
                            }
                            break block20;
                        }
                        object = this.t.next();
                        object2 = (l)this.l.get(object);
                        this.s = ((l)object2).a(((l)object2).size());
                    }
                    if (!this.s.hasPrevious()) break block23;
                    object2 = (c)this.s.previous();
                    boolean bl = false;
                    if (this.k > 0L && System.currentTimeMillis() - ((c)object2).b > this.k) {
                        bl = true;
                    } else if (this.h) {
                        boolean bl2 = false;
                        try {
                            this.q.activateObject(object, ((c)object2).a);
                            bl2 = true;
                        }
                        catch (Exception exception) {
                            bl = true;
                        }
                        if (bl2) {
                            if (!this.q.validateObject(object, ((c)object2).a)) {
                                bl = true;
                            } else {
                                try {
                                    this.q.passivateObject(object, ((c)object2).a);
                                }
                                catch (Exception exception) {
                                    bl = true;
                                }
                            }
                        }
                    }
                    if (bl) {
                        try {
                            this.s.remove();
                            --this.p;
                            this.q.destroyObject(object, ((c)object2).a);
                            if (((l)this.l.get(object)).isEmpty()) {
                                this.l.remove(object);
                                this.m.remove(object);
                            }
                            break block20;
                        }
                        catch (Exception exception) {}
                    }
                    break block20;
                }
                if (this.s != null) {
                    this.s.b();
                    this.s = null;
                }
            }
            ++n2;
        }
    }

    protected final synchronized void a(long l2) {
        if (null != this.r) {
            this.r.a();
            this.r = null;
        }
        if (l2 > 0L) {
            this.r = new a(this, l2);
            Thread thread = new Thread(this.r);
            thread.setDaemon(true);
            thread.start();
        }
    }

    private synchronized int a() {
        if (this.j >= 0) {
            return this.j;
        }
        return (int)Math.ceil((double)this.p / Math.abs((double)this.j));
    }

    private synchronized void a(Object object) {
        ++this.o;
        Integer n2 = (Integer)this.n.get(object);
        if (null == n2) {
            this.n.put(object, new Integer(1));
            return;
        }
        this.n.put(object, new Integer(n2 + 1));
    }

    private synchronized void b(Object object) {
        --this.o;
        Integer n2 = (Integer)this.n.get(object);
        if (null == n2) {
            return;
        }
        if (n2 <= 1) {
            this.n.remove(object);
            return;
        }
        this.n.put(object, new Integer(n2 - 1));
    }

    private synchronized int c(Object object) {
        int n2 = 0;
        Integer n3 = (Integer)this.n.get(object);
        if (null != n3) {
            n2 = n3;
        }
        return n2;
    }

    static long a(GenericKeyedObjectPool genericKeyedObjectPool) {
        return genericKeyedObjectPool.i;
    }

    static b b(GenericKeyedObjectPool genericKeyedObjectPool) {
        return genericKeyedObjectPool.s;
    }

    static b a(GenericKeyedObjectPool genericKeyedObjectPool, b b2) {
        genericKeyedObjectPool.s = b2;
        return genericKeyedObjectPool.s;
    }

    static b c(GenericKeyedObjectPool genericKeyedObjectPool) {
        return genericKeyedObjectPool.t;
    }

    static b b(GenericKeyedObjectPool genericKeyedObjectPool, b b2) {
        genericKeyedObjectPool.t = b2;
        return genericKeyedObjectPool.t;
    }

    public static class Config {
        public int maxIdle = 8;
        public int maxActive = 8;
        public int maxTotal = -1;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
    }
}

