/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.l;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.b;
import org.apache.commons.pool.impl.d;

public class GenericObjectPool
extends BaseObjectPool
implements ObjectPool {
    public static final byte WHEN_EXHAUSTED_FAIL = 0;
    public static final byte WHEN_EXHAUSTED_BLOCK = 1;
    public static final byte WHEN_EXHAUSTED_GROW = 2;
    public static final int DEFAULT_MAX_IDLE = 8;
    public static final int DEFAULT_MIN_IDLE = 0;
    public static final int DEFAULT_MAX_ACTIVE = 8;
    public static final byte DEFAULT_WHEN_EXHAUSTED_ACTION = 1;
    public static final long DEFAULT_MAX_WAIT = -1L;
    public static final boolean DEFAULT_TEST_ON_BORROW = false;
    public static final boolean DEFAULT_TEST_ON_RETURN = false;
    public static final boolean DEFAULT_TEST_WHILE_IDLE = false;
    public static final long DEFAULT_TIME_BETWEEN_EVICTION_RUNS_MILLIS = -1L;
    public static final int DEFAULT_NUM_TESTS_PER_EVICTION_RUN = 3;
    public static final long DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 1800000L;
    private int a = 8;
    private int b = 0;
    private int c = 8;
    private long d = -1L;
    private byte e = 1;
    private boolean f = false;
    private boolean g = false;
    private boolean h = false;
    private long i = -1L;
    private int j = 3;
    private long k = 1800000L;
    private l l = null;
    private PoolableObjectFactory m = null;
    private int n = 0;
    private d o = null;
    private org.apache.commons.collections.b p = null;

    public GenericObjectPool() {
        this(null, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory) {
        this(poolableObjectFactory, 8, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, Config config) {
        this(poolableObjectFactory, config.maxActive, config.whenExhaustedAction, config.maxWait, config.maxIdle, config.minIdle, config.testOnBorrow, config.testOnReturn, config.timeBetweenEvictionRunsMillis, config.numTestsPerEvictionRun, config.minEvictableIdleTimeMillis, config.testWhileIdle);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n2) {
        this(poolableObjectFactory, n2, 1, -1L, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n2, byte by, long l2) {
        this(poolableObjectFactory, n2, by, l2, 8, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n2, byte by, long l2, boolean bl, boolean bl2) {
        this(poolableObjectFactory, n2, by, l2, 8, 0, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n2, byte by, long l2, int n3) {
        this(poolableObjectFactory, n2, by, l2, n3, 0, false, false, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n2, byte by, long l2, int n3, boolean bl, boolean bl2) {
        this(poolableObjectFactory, n2, by, l2, n3, 0, bl, bl2, -1L, 3, 1800000L, false);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n2, byte by, long l2, int n3, boolean bl, boolean bl2, long l3, int n4, long l4, boolean bl3) {
        this(poolableObjectFactory, n2, by, l2, n3, 0, bl, bl2, l3, n4, l4, bl3);
    }

    public GenericObjectPool(PoolableObjectFactory poolableObjectFactory, int n2, byte by, long l2, int n3, int n4, boolean bl, boolean bl2, long l3, int n5, long l4, boolean bl3) {
        this.m = poolableObjectFactory;
        this.c = n2;
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this.e = by;
                break;
            }
            default: {
                throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
            }
        }
        this.d = l2;
        this.a = n3;
        this.b = n4;
        this.f = bl;
        this.g = bl2;
        this.i = l3;
        this.j = n5;
        this.k = l4;
        this.h = bl3;
        this.l = new l();
        this.a(this.i);
    }

    public synchronized int getMaxActive() {
        return this.c;
    }

    public synchronized void setMaxActive(int n2) {
        this.c = n2;
        this.notifyAll();
    }

    public synchronized byte getWhenExhaustedAction() {
        return this.e;
    }

    public synchronized void setWhenExhaustedAction(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this.e = by;
                this.notifyAll();
                return;
            }
        }
        throw new IllegalArgumentException("whenExhaustedAction " + by + " not recognized.");
    }

    public synchronized long getMaxWait() {
        return this.d;
    }

    public synchronized void setMaxWait(long l2) {
        this.d = l2;
        this.notifyAll();
    }

    public synchronized int getMaxIdle() {
        return this.a;
    }

    public synchronized void setMaxIdle(int n2) {
        this.a = n2;
        this.notifyAll();
    }

    public synchronized void setMinIdle(int n2) {
        this.b = n2;
        this.notifyAll();
    }

    public synchronized int getMinIdle() {
        return this.b;
    }

    public synchronized boolean getTestOnBorrow() {
        return this.f;
    }

    public synchronized void setTestOnBorrow(boolean bl) {
        this.f = bl;
    }

    public synchronized boolean getTestOnReturn() {
        return this.g;
    }

    public synchronized void setTestOnReturn(boolean bl) {
        this.g = bl;
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.i;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long l2) {
        this.i = l2;
        this.a(this.i);
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this.j;
    }

    public synchronized void setNumTestsPerEvictionRun(int n2) {
        this.j = n2;
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.k;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long l2) {
        this.k = l2;
    }

    public synchronized boolean getTestWhileIdle() {
        return this.h;
    }

    public synchronized void setTestWhileIdle(boolean bl) {
        this.h = bl;
    }

    public synchronized void setConfig(Config config) {
        this.setMaxIdle(config.maxIdle);
        this.setMinIdle(config.minIdle);
        this.setMaxActive(config.maxActive);
        this.setMaxWait(config.maxWait);
        this.setWhenExhaustedAction(config.whenExhaustedAction);
        this.setTestOnBorrow(config.testOnBorrow);
        this.setTestOnReturn(config.testOnReturn);
        this.setTestWhileIdle(config.testWhileIdle);
        this.setNumTestsPerEvictionRun(config.numTestsPerEvictionRun);
        this.setMinEvictableIdleTimeMillis(config.minEvictableIdleTimeMillis);
        this.setTimeBetweenEvictionRunsMillis(config.timeBetweenEvictionRunsMillis);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object borrowObject() throws Exception {
        long l2 = System.currentTimeMillis();
        boolean bl = false;
        block24: while (true) {
            GenericObjectPool genericObjectPool;
            b b2 = null;
            GenericObjectPool genericObjectPool2 = this;
            synchronized (genericObjectPool2) {
                this.b();
                try {
                    b2 = (b)this.l.a();
                }
                catch (NoSuchElementException noSuchElementException) {}
                if (null == b2 && this.c > 0 && this.n >= this.c) {
                    switch (this.e) {
                        case 2: {
                            break;
                        }
                        case 0: {
                            throw new NoSuchElementException();
                        }
                        case 1: {
                            try {
                                if (this.d <= 0L) {
                                    this.wait();
                                } else {
                                    this.wait(this.d);
                                }
                            }
                            catch (InterruptedException interruptedException) {}
                            if (this.d > 0L && System.currentTimeMillis() - l2 >= this.d) {
                                throw new NoSuchElementException("Timeout waiting for idle object");
                            }
                            continue block24;
                        }
                        default: {
                            throw new IllegalArgumentException("whenExhaustedAction " + this.e + " not recognized.");
                        }
                    }
                }
                ++this.n;
            }
            if (null == b2) {
                try {
                    Object object = this.m.makeObject();
                    b2 = new b(this, object);
                    bl = true;
                }
                catch (Exception exception) {
                    genericObjectPool = this;
                    synchronized (genericObjectPool) {
                        --this.n;
                        this.notifyAll();
                        throw exception;
                    }
                }
            }
            try {
                this.m.activateObject(b2.a);
                if (!this.f || this.m.validateObject(b2.a)) return b2.a;
                throw new Exception("validateObject failed");
            }
            catch (Exception exception) {
                genericObjectPool = this;
                synchronized (genericObjectPool) {
                    --this.n;
                    this.notifyAll();
                }
                try {
                    this.m.destroyObject(b2.a);
                }
                catch (Exception exception2) {}
                if (bl) throw new NoSuchElementException("Could not create a validated object");
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateObject(Object object) throws Exception {
        GenericObjectPool genericObjectPool;
        this.b();
        try {
            this.m.destroyObject(object);
            Object var3_2 = null;
            genericObjectPool = this;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            GenericObjectPool genericObjectPool2 = this;
            synchronized (genericObjectPool2) {
                --this.n;
                this.notifyAll();
            }
            throw throwable;
        }
        synchronized (genericObjectPool) {
            --this.n;
            this.notifyAll();
        }
    }

    public synchronized void clear() {
        this.b();
        Iterator iterator = this.l.iterator();
        while (iterator.hasNext()) {
            try {
                this.m.destroyObject(((b)iterator.next()).a);
            }
            catch (Exception exception) {}
            iterator.remove();
        }
        this.l.clear();
        this.notifyAll();
    }

    public synchronized int getNumActive() {
        this.b();
        return this.n;
    }

    public synchronized int getNumIdle() {
        this.b();
        return this.l.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) throws Exception {
        this.b();
        boolean bl = true;
        if (this.g && !this.m.validateObject(object)) {
            bl = false;
        } else {
            try {
                this.m.passivateObject(object);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        boolean bl2 = !bl;
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            --this.n;
            if (this.a >= 0 && this.l.size() >= this.a) {
                bl2 = true;
            } else if (bl) {
                this.l.a(new b(this, object));
            }
            this.notifyAll();
        }
        if (bl2) {
            try {
                this.m.destroyObject(object);
                return;
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void close() throws Exception {
        this.clear();
        this.l = null;
        this.m = null;
        if (null != this.p) {
            this.p.b();
            this.p = null;
        }
        this.a(-1L);
        super.close();
    }

    public synchronized void setFactory(PoolableObjectFactory poolableObjectFactory) throws IllegalStateException {
        this.b();
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this.m = poolableObjectFactory;
    }

    public synchronized void evict() throws Exception {
        block20: {
            block22: {
                block21: {
                    this.b();
                    if (this.l.isEmpty()) break block20;
                    if (null == this.p) break block21;
                    if (this.p.hasPrevious()) break block22;
                    this.p.b();
                }
                this.p = this.l.a(this.l.size());
            }
            int n2 = 0;
            int n3 = this.e();
            while (n2 < n3) {
                if (!this.p.hasPrevious()) {
                    this.p.b();
                    this.p = this.l.a(this.l.size());
                } else {
                    boolean bl = false;
                    b b2 = (b)this.p.previous();
                    if (this.k > 0L && System.currentTimeMillis() - b2.b > this.k) {
                        bl = true;
                    } else if (this.h) {
                        boolean bl2 = false;
                        try {
                            this.m.activateObject(b2.a);
                            bl2 = true;
                        }
                        catch (Exception exception) {
                            bl = true;
                        }
                        if (bl2) {
                            if (!this.m.validateObject(b2.a)) {
                                bl = true;
                            } else {
                                try {
                                    this.m.passivateObject(b2.a);
                                }
                                catch (Exception exception) {
                                    bl = true;
                                }
                            }
                        }
                    }
                    if (bl) {
                        try {
                            this.p.remove();
                            this.m.destroyObject(b2.a);
                        }
                        catch (Exception exception) {}
                    }
                }
                ++n2;
            }
        }
    }

    private void c() throws Exception {
        int n2 = this.d();
        int n3 = 0;
        while (n3 < n2 && this.d() > 0) {
            this.addObject();
            ++n3;
        }
    }

    private synchronized int d() {
        int n2 = this.getMinIdle() - this.getNumIdle();
        if (this.c > 0) {
            int n3 = Math.max(0, this.getMaxActive() - this.getNumActive() - this.getNumIdle());
            n2 = Math.min(n2, n3);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject() throws Exception {
        Object object = this.m.makeObject();
        GenericObjectPool genericObjectPool = this;
        synchronized (genericObjectPool) {
            ++this.n;
            this.returnObject(object);
            return;
        }
    }

    protected final synchronized void a(long l2) {
        if (null != this.o) {
            this.o.a();
            this.o = null;
        }
        if (l2 > 0L) {
            this.o = new d(this, l2);
            Thread thread = new Thread(this.o);
            thread.setDaemon(true);
            thread.start();
        }
    }

    private int e() {
        if (this.j >= 0) {
            return this.j;
        }
        return (int)Math.ceil((double)this.l.size() / Math.abs((double)this.j));
    }

    static void a(GenericObjectPool genericObjectPool) throws Exception {
        genericObjectPool.c();
    }

    static org.apache.commons.collections.b b(GenericObjectPool genericObjectPool) {
        return genericObjectPool.p;
    }

    static org.apache.commons.collections.b a(GenericObjectPool genericObjectPool, org.apache.commons.collections.b b2) {
        genericObjectPool.p = b2;
        return genericObjectPool.p;
    }

    public static class Config {
        public int maxIdle = 8;
        public int minIdle = 0;
        public int maxActive = 8;
        public long maxWait = -1L;
        public byte whenExhaustedAction = 1;
        public boolean testOnBorrow = false;
        public boolean testOnReturn = false;
        public boolean testWhileIdle = false;
        public long timeBetweenEvictionRunsMillis = -1L;
        public int numTestsPerEvictionRun = 3;
        public long minEvictableIdleTimeMillis = 1800000L;
    }
}

