/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class ErrorCollector {
    protected LinkedList warnings = null;
    protected LinkedList errors = null;
    protected CompilerConfiguration configuration;

    public ErrorCollector(CompilerConfiguration configuration) {
        this.configuration = configuration;
    }

    public void addCollectorContents(ErrorCollector er) {
        if (er.errors != null) {
            if (this.errors == null) {
                this.errors = er.errors;
            } else {
                this.errors.addAll(this.errors);
            }
        }
        if (er.warnings != null) {
            if (this.warnings == null) {
                this.warnings = er.warnings;
            } else {
                this.warnings.addAll(this.warnings);
            }
        }
    }

    public void addErrorAndContinue(Message message) {
        if (this.errors == null) {
            this.errors = new LinkedList();
        }
        this.errors.add(message);
    }

    public void addError(Message message) throws CompilationFailedException {
        this.addErrorAndContinue(message);
        if (this.errors != null && this.errors.size() >= this.configuration.getTolerance()) {
            this.failIfErrors();
        }
    }

    public void addError(Message message, boolean fatal) throws CompilationFailedException {
        if (fatal) {
            this.addFatalError(message);
        } else {
            this.addError(message);
        }
    }

    public void addError(SyntaxException error, SourceUnit source) throws CompilationFailedException {
        this.addError(Message.create(error, source), error.isFatal());
    }

    public void addFatalError(Message message) throws CompilationFailedException {
        this.addError(message);
        this.failIfErrors();
    }

    public void addException(Exception cause, SourceUnit source) throws CompilationFailedException {
        this.addError(new ExceptionMessage(cause, this.configuration.getDebug(), source));
        this.failIfErrors();
    }

    public boolean hasErrors() {
        return this.errors != null;
    }

    protected void failIfErrors() throws CompilationFailedException {
        if (this.hasErrors()) {
            throw new MultipleCompilationErrorsException(this);
        }
    }

    private void write(PrintWriter writer, Janitor janitor, List messages, String txt) {
        if (messages == null || messages.size() == 0) {
            return;
        }
        Iterator iterator = messages.iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            message.write(writer, janitor);
            if (!this.configuration.getDebug() || !(message instanceof SyntaxErrorMessage)) continue;
            SyntaxErrorMessage sem = (SyntaxErrorMessage)message;
            sem.getCause().printStackTrace(writer);
        }
        writer.println();
        writer.print(messages.size());
        writer.print(" " + txt);
        if (messages.size() > 1) {
            writer.print("s");
        }
        writer.println();
    }

    public void write(PrintWriter writer, Janitor janitor) {
        this.write(writer, janitor, this.warnings, "warning");
        this.write(writer, janitor, this.errors, "error");
    }
}

