/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Types {
    private static final Map TEXTS = new HashMap();
    private static final Map LOOKUP = new HashMap();
    private static final Map DESCRIPTIONS;

    public static boolean ofType(int specific, int general) {
        if (general == specific) {
            return true;
        }
        switch (general) {
            case 1000: {
                return true;
            }
            case 1001: {
                return specific >= 0 && specific <= 830;
            }
            case 1002: {
                switch (specific) {
                    case -1: 
                    case 5: 
                    case 320: {
                        return true;
                    }
                }
                break;
            }
            case 1003: {
                switch (specific) {
                    case -1: 
                    case 5: 
                    case 20: 
                    case 320: {
                        return true;
                    }
                }
                break;
            }
            case 1100: {
                return specific == 100 || specific >= 210 && specific <= 216 || specific >= 166 && specific <= 168 || specific >= 285 && specific <= 287 || specific >= 350 && specific <= 352;
            }
            case 1101: {
                return specific >= 120 && specific <= 128;
            }
            case 1102: {
                return specific >= 200 && specific <= 282 || specific >= 160 && specific <= 164 || specific >= 340 && specific <= 342;
            }
            case 1103: {
                return specific >= 160 && specific <= 164;
            }
            case 1107: {
                return specific >= 340 && specific <= 342 || specific == 97;
            }
            case 1104: {
                return specific == 75 || specific == 77;
            }
            case 1105: {
                return specific == 90 || specific == 94;
            }
            case 1106: {
                return specific == 70 || specific == 80;
            }
            case 1200: {
                switch (specific) {
                    case 201: 
                    case 250: 
                    case 260: {
                        return true;
                    }
                }
            }
            case 1235: {
                switch (specific) {
                    case 97: 
                    case 160: 
                    case 251: 
                    case 253: 
                    case 261: 
                    case 263: 
                    case 815: {
                        return true;
                    }
                }
                break;
            }
            case 1210: {
                switch (specific) {
                    case 250: 
                    case 252: 
                    case 260: 
                    case 262: {
                        return true;
                    }
                }
                break;
            }
            case 1220: {
                switch (specific) {
                    case 70: 
                    case 75: 
                    case 77: 
                    case 80: 
                    case 90: 
                    case 94: 
                    case 162: 
                    case 164: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 340: 
                    case 341: 
                    case 342: 
                    case 544: {
                        return true;
                    }
                }
                return specific >= 120 && specific <= 128 || specific >= 200 && specific <= 215 || specific == 100 || specific >= 210 && specific <= 216 || specific >= 166 && specific <= 168 || specific >= 285 && specific <= 287 || specific >= 350 && specific <= 352;
            }
            case 1230: {
                switch (specific) {
                    case 200: 
                    case 201: 
                    case 206: 
                    case 253: 
                    case 263: {
                        return true;
                    }
                }
                break;
            }
            case 1300: {
                return specific >= 500 && specific <= 701;
            }
            case 1301: {
                return specific >= 5 && specific <= 340;
            }
            case 1310: {
                return specific >= 400 && specific <= 451;
            }
            case 1320: {
                return specific == 450 || specific == 451;
            }
            case 1325: {
                switch (specific) {
                    case 200: 
                    case 201: {
                        return true;
                    }
                }
                break;
            }
            case 1330: {
                return specific >= 610 && specific <= 612;
            }
            case 1331: {
                return specific == 610 || specific == 611;
            }
            case 1420: {
                if (specific == 440) {
                    return true;
                }
            }
            case 1340: {
                return specific >= 600 && specific <= 608;
            }
            case 1430: {
                if (specific == 440) {
                    return true;
                }
            }
            case 1341: {
                return specific >= 601 && specific <= 608;
            }
            case 1350: {
                switch (specific) {
                    case 570: 
                    case 571: 
                    case 572: {
                        return true;
                    }
                }
                break;
            }
            case 1360: {
                return specific >= 700 && specific <= 701;
            }
            case 1361: {
                switch (specific) {
                    case 530: 
                    case 531: 
                    case 532: 
                    case 533: 
                    case 539: 
                    case 545: 
                    case 573: {
                        return true;
                    }
                }
                break;
            }
            case 1370: {
                return specific >= 800 && specific <= 830;
            }
            case 1400: {
                return specific >= 531 && specific <= 533;
            }
            case 1410: {
                return specific >= 500 && specific <= 521;
            }
            case 1500: {
                switch (specific) {
                    case 10: 
                    case 20: 
                    case 30: 
                    case 40: 
                    case 50: 
                    case 60: {
                        return true;
                    }
                }
                break;
            }
            case 1501: {
                switch (specific) {
                    case 10: 
                    case 30: 
                    case 50: {
                        return true;
                    }
                }
                break;
            }
            case 1502: {
                switch (specific) {
                    case 20: 
                    case 40: 
                    case 60: {
                        return true;
                    }
                }
                break;
            }
            case 2000: {
                return specific == 60 || specific == 300;
            }
            case 2001: {
                return specific == 40 || specific == 300;
            }
            case 2002: {
                switch (specific) {
                    case 10: 
                    case 300: 
                    case 540: 
                    case 584: {
                        return true;
                    }
                }
                break;
            }
            case 2003: {
                switch (specific) {
                    case 30: 
                    case 70: 
                    case 440: {
                        return true;
                    }
                }
                break;
            }
            case 2004: {
                if (specific == 20) {
                    return true;
                }
            }
            case 2005: {
                return specific == 577 || specific == 578;
            }
            case 2006: {
                if (specific >= 400 && specific <= 451) {
                    return true;
                }
                switch (specific) {
                    case 50: 
                    case 546: 
                    case 812: 
                    case 901: {
                        return true;
                    }
                }
                break;
            }
            case 2007: {
                if (Types.ofType(specific, 1301)) {
                    switch (specific) {
                        case 10: 
                        case 30: 
                        case 50: 
                        case 97: 
                        case 160: 
                        case 200: 
                        case 201: 
                        case 250: 
                        case 260: {
                            return true;
                        }
                    }
                    return false;
                }
                switch (specific) {
                    case 544: 
                    case 902: 
                    case 903: 
                    case 904: {
                        return false;
                    }
                }
                return true;
            }
            case 2008: {
                switch (specific) {
                    case 50: 
                    case 200: 
                    case 201: 
                    case 251: 
                    case 253: 
                    case 261: 
                    case 263: {
                        return false;
                    }
                }
                return !Types.ofType(specific, 1911);
            }
            case 1901: {
                return specific >= 70 && specific <= 282;
            }
            case 1902: {
                switch (specific) {
                    case 815: 
                    case 817: 
                    case 819: {
                        return true;
                    }
                }
                break;
            }
            case 1903: {
                switch (specific) {
                    case 542: 
                    case 543: 
                    case 544: 
                    case 546: 
                    case 610: 
                    case 611: 
                    case 612: {
                        return true;
                    }
                }
                break;
            }
            case 1904: {
                return specific >= 400 && specific <= 451;
            }
            case 1905: {
                return specific == 30;
            }
            case 1900: {
                if (specific >= 70 && specific <= 282) {
                    return true;
                }
                if (specific >= 400 && specific <= 451) {
                    return true;
                }
                switch (specific) {
                    case 30: 
                    case 542: 
                    case 543: 
                    case 544: 
                    case 546: 
                    case 610: 
                    case 611: 
                    case 612: 
                    case 812: 
                    case 815: 
                    case 817: 
                    case 819: {
                        return true;
                    }
                }
                break;
            }
            case 1911: {
                switch (specific) {
                    case 546: 
                    case 810: 
                    case 811: 
                    case 812: 
                    case 814: 
                    case 817: 
                    case 819: 
                    case 830: {
                        return true;
                    }
                }
            }
            case 1910: {
                if (specific >= 400 && specific <= 451) {
                    return true;
                }
                switch (specific) {
                    case 542: 
                    case 543: 
                    case 610: 
                    case 611: 
                    case 612: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static String getText(int type) {
        Integer key = new Integer(type);
        String text = "";
        if (TEXTS.containsKey(key)) {
            text = (String)TEXTS.get(key);
        }
        return text;
    }

    private static void addTranslation(String text, int type) {
        Integer key = new Integer(type);
        TEXTS.put(key, text);
        LOOKUP.put(text, key);
    }

    public static String getDescription(int type) {
        Integer typeKey = new Integer(type);
        if (DESCRIPTIONS.containsKey(typeKey)) {
            return (String)DESCRIPTIONS.get(typeKey);
        }
        return "<>";
    }

    private static void addDescription(int type, String description) {
        Types.addDescription(new Integer(type), description);
    }

    private static void addDescription(Integer type, String description) {
        if (description.startsWith("<") && description.endsWith(">")) {
            DESCRIPTIONS.put(type, description);
        } else {
            DESCRIPTIONS.put(type, '\"' + description + '\"');
        }
    }

    static {
        Types.addTranslation("\n", 5);
        Types.addTranslation("{", 10);
        Types.addTranslation("}", 20);
        Types.addTranslation("[", 30);
        Types.addTranslation("]", 40);
        Types.addTranslation("(", 50);
        Types.addTranslation(")", 60);
        Types.addTranslation(".", 70);
        Types.addTranslation("..", 75);
        Types.addTranslation("...", 77);
        Types.addTranslation("->", 80);
        Types.addTranslation("=~", 90);
        Types.addTranslation("==~", 94);
        Types.addTranslation("~", 97);
        Types.addTranslation("=", 100);
        Types.addTranslation("!=", 120);
        Types.addTranslation("===", 121);
        Types.addTranslation("!==", 122);
        Types.addTranslation("==", 123);
        Types.addTranslation("<", 124);
        Types.addTranslation("<=", 125);
        Types.addTranslation(">", 126);
        Types.addTranslation(">=", 127);
        Types.addTranslation("<=>", 128);
        Types.addTranslation("!", 160);
        Types.addTranslation("||", 162);
        Types.addTranslation("&&", 164);
        Types.addTranslation("||=", 166);
        Types.addTranslation("&&=", 168);
        Types.addTranslation("+", 200);
        Types.addTranslation("-", 201);
        Types.addTranslation("*", 202);
        Types.addTranslation("/", 203);
        Types.addTranslation("\\", 204);
        Types.addTranslation("%", 205);
        Types.addTranslation("**", 206);
        Types.addTranslation("+=", 210);
        Types.addTranslation("-=", 211);
        Types.addTranslation("*=", 212);
        Types.addTranslation("/=", 213);
        Types.addTranslation("\\=", 214);
        Types.addTranslation("%=", 215);
        Types.addTranslation("**=", 216);
        Types.addTranslation("++", 250);
        Types.addTranslation("--", 260);
        Types.addTranslation("<<", 280);
        Types.addTranslation(">>", 281);
        Types.addTranslation(">>>", 282);
        Types.addTranslation("<<=", 285);
        Types.addTranslation(">>=", 286);
        Types.addTranslation(">>>=", 287);
        Types.addTranslation("&", 341);
        Types.addTranslation("^", 342);
        Types.addTranslation("|=", 350);
        Types.addTranslation("&=", 351);
        Types.addTranslation("^=", 352);
        Types.addTranslation(",", 300);
        Types.addTranslation(":", 310);
        Types.addTranslation(";", 320);
        Types.addTranslation("?", 330);
        Types.addTranslation("|", 340);
        Types.addTranslation("${}", 903);
        Types.addTranslation("abstract", 510);
        Types.addTranslation("as", 552);
        Types.addTranslation("assert", 585);
        Types.addTranslation("break", 574);
        Types.addTranslation("case", 577);
        Types.addTranslation("catch", 581);
        Types.addTranslation("class", 531);
        Types.addTranslation("const", 700);
        Types.addTranslation("continue", 575);
        Types.addTranslation("def", 530);
        Types.addTranslation("defmacro", 530);
        Types.addTranslation("default", 578);
        Types.addTranslation("do", 570);
        Types.addTranslation("else", 562);
        Types.addTranslation("extends", 541);
        Types.addTranslation("final", 511);
        Types.addTranslation("finally", 582);
        Types.addTranslation("for", 572);
        Types.addTranslation("goto", 701);
        Types.addTranslation("if", 561);
        Types.addTranslation("in", 573);
        Types.addTranslation("implements", 540);
        Types.addTranslation("import", 551);
        Types.addTranslation("instanceof", 544);
        Types.addTranslation("interface", 532);
        Types.addTranslation("mixin", 533);
        Types.addTranslation("native", 512);
        Types.addTranslation("new", 546);
        Types.addTranslation("package", 550);
        Types.addTranslation("private", 500);
        Types.addTranslation("property", 545);
        Types.addTranslation("protected", 501);
        Types.addTranslation("public", 502);
        Types.addTranslation("return", 560);
        Types.addTranslation("static", 521);
        Types.addTranslation("super", 543);
        Types.addTranslation("switch", 576);
        Types.addTranslation("synchronized", 520);
        Types.addTranslation("this", 542);
        Types.addTranslation("throw", 583);
        Types.addTranslation("throws", 584);
        Types.addTranslation("transient", 513);
        Types.addTranslation("try", 580);
        Types.addTranslation("volatile", 514);
        Types.addTranslation("while", 571);
        Types.addTranslation("true", 610);
        Types.addTranslation("false", 611);
        Types.addTranslation("null", 612);
        Types.addTranslation("void", 600);
        Types.addTranslation("boolean", 601);
        Types.addTranslation("byte", 602);
        Types.addTranslation("int", 604);
        Types.addTranslation("short", 603);
        Types.addTranslation("long", 605);
        Types.addTranslation("float", 606);
        Types.addTranslation("double", 607);
        Types.addTranslation("char", 608);
        DESCRIPTIONS = new HashMap();
        Iterator iterator = LOOKUP.keySet().iterator();
        while (iterator.hasNext()) {
            String text = (String)iterator.next();
            Integer key = (Integer)LOOKUP.get(text);
            Types.addDescription(key, text);
        }
        Types.addDescription(5, "<newline>");
        Types.addDescription(251, "<prefix ++>");
        Types.addDescription(252, "<postfix ++>");
        Types.addDescription(261, "<prefix -->");
        Types.addDescription(262, "<postfix -->");
        Types.addDescription(253, "<positive>");
        Types.addDescription(263, "<negative>");
        Types.addDescription(400, "<string literal>");
        Types.addDescription(440, "<identifier>");
        Types.addDescription(450, "<integer>");
        Types.addDescription(451, "<decimal>");
        Types.addDescription(800, "<compilation unit>");
        Types.addDescription(801, "<class>");
        Types.addDescription(802, "<interface>");
        Types.addDescription(803, "<mixin>");
        Types.addDescription(804, "<method>");
        Types.addDescription(814, "<method call>");
        Types.addDescription(805, "<property>");
        Types.addDescription(806, "<parameter>");
        Types.addDescription(810, "<list>");
        Types.addDescription(811, "<map>");
        Types.addDescription(820, "<tuple>");
        Types.addDescription(812, "<gstring>");
        Types.addDescription(815, "<cast>");
        Types.addDescription(816, "<block>");
        Types.addDescription(817, "<closure>");
        Types.addDescription(819, "<ternary>");
        Types.addDescription(818, "<label>");
        Types.addDescription(830, "<variable declaration>");
        Types.addDescription(901, "<start of gstring tokens>");
        Types.addDescription(902, "<end of gstring tokens>");
        Types.addDescription(903, "<start of gstring expression>");
        Types.addDescription(904, "<end of gstring expression>");
        Types.addDescription(1100, "<assignment operator>");
        Types.addDescription(1101, "<comparison operator>");
        Types.addDescription(1102, "<math operator>");
        Types.addDescription(1103, "<logical operator>");
        Types.addDescription(1107, "<bitwise operator>");
        Types.addDescription(1104, "<range operator>");
        Types.addDescription(1105, "<regex comparison operator>");
        Types.addDescription(1106, "<dereference operator>");
        Types.addDescription(1200, "<prefix operator>");
        Types.addDescription(1210, "<postfix operator>");
        Types.addDescription(1220, "<infix operator>");
        Types.addDescription(1300, "<keyword>");
        Types.addDescription(1310, "<literal>");
        Types.addDescription(1320, "<number>");
        Types.addDescription(1330, "<named value>");
        Types.addDescription(1331, "<truth value>");
        Types.addDescription(1340, "<primitive type>");
        Types.addDescription(1341, "<creatable primitive type>");
        Types.addDescription(1350, "<loop>");
        Types.addDescription(1360, "<reserved keyword>");
        Types.addDescription(1370, "<synthetic>");
        Types.addDescription(1400, "<type declaration>");
        Types.addDescription(1410, "<declaration modifier>");
        Types.addDescription(1420, "<type name>");
        Types.addDescription(1430, "<creatable type name>");
        Types.addDescription(1500, "<matched container>");
        Types.addDescription(1501, "<left of matched container>");
        Types.addDescription(1502, "<right of matched container>");
        Types.addDescription(2005, "<valid in a switch body>");
    }
}

