/*
 * Decompiled with CFR 0.152.
 */
package com.projity.dialog.calendar;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.projity.configuration.Settings;
import com.projity.contrib.calendar.ContribIntervals;
import com.projity.dialog.AbstractDialog;
import com.projity.dialog.ButtonPanel;
import com.projity.dialog.calendar.CalendarView;
import com.projity.dialog.calendar.NewBaseCalendarDialog;
import com.projity.dialog.options.CalendarDialogBox;
import com.projity.options.CalendarOption;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.calendar.DayDescriptor;
import com.projity.pm.calendar.InvalidCalendarException;
import com.projity.pm.calendar.WorkRange;
import com.projity.pm.calendar.WorkRangeException;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.pm.calendar.WorkingHours;
import com.projity.pm.graphic.IconManager;
import com.projity.pm.graphic.frames.GraphicManager;
import com.projity.pm.task.Project;
import com.projity.pm.task.ProjectFactory;
import com.projity.strings.Messages;
import com.projity.undo.CalendarEdit;
import com.projity.undo.UndoController;
import com.projity.util.Alert;
import com.projity.util.DateTime;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoableEditSupport;

public class ChangeWorkingTimeDialogBox
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private UndoController undoController;
    private Form form;
    WorkingHours defaultWorkingHours = WorkingHours.getDefault();
    boolean unsaved = false;
    JComboBox calendarType;
    CalendarView sdCalendar;
    JRadioButton unknownWorkingTime;
    JRadioButton defaultWorkingTime;
    JRadioButton nonWorking;
    JRadioButton working;
    ButtonGroup datesSetting;
    JTextField[] timeStart;
    JTextField[] timeEnd;
    JLabel notEditable;
    JLabel caution;
    boolean dirtyWorkingHours = false;
    ContribIntervals lastSelection = new ContribIntervals();
    boolean[] lastWeekSelection = new boolean[7];
    JCheckBox test;
    JComponent cal;
    JButton newCalendar;
    JButton options;
    SimpleDateFormat hourFormat = DateTime.dateFormatInstance("H:mm");
    JLabel basedOnText;
    List documentCalendars;
    List projectCalendars;
    WorkingCalendar editedCalendar;
    boolean restrict;
    private Project project;
    private Calendar _calendar = DateTime.calendarInstance();

    private void setEditable(boolean bl) {
    }

    public static ChangeWorkingTimeDialogBox getInstance(Frame frame, Project project, WorkingCalendar workingCalendar, List list, boolean bl, UndoController undoController) {
        return new ChangeWorkingTimeDialogBox(frame, project, workingCalendar, list, bl, undoController);
    }

    private ChangeWorkingTimeDialogBox(Frame frame, Project project, WorkingCalendar workingCalendar, List list, boolean bl, UndoController undoController) {
        super(frame, Messages.getString("ChangeWorkingTimeDialogBox.ChangeWorkingTime"), true);
        this.documentCalendars = list;
        this.project = project;
        this.restrict = bl;
        this.undoController = undoController;
        ProjectFactory projectFactory = GraphicManager.getInstance(this).getProjectFactory();
        ArrayList arrayList = projectFactory.getPortfolio().extractCalendars();
        this.projectCalendars = new ArrayList();
        for (WorkingCalendar workingCalendar2 : arrayList) {
            if (workingCalendar2.isBaseCalendar()) continue;
            this.projectCalendars.add(workingCalendar2);
        }
        this.newCalendar = new JButton(Messages.getString("ChangeWorkingTimeDialogBox.New"));
        this.addDocHelp("Change_Working_Time_Dialog");
        this.form = new Form();
        this.form.setCalendar(workingCalendar);
    }

    private void setCal(WorkingCalendar workingCalendar) {
        this.editedCalendar = workingCalendar;
        this.form.setCalendar(CalendarService.getInstance().makeScratchCopy(workingCalendar));
        this.calendarType.setSelectedItem(this.editedCalendar);
    }

    private void fillInCalendarNames() {
        ArrayList arrayList = new ArrayList();
        CalendarService calendarService = CalendarService.getInstance();
        arrayList.addAll(calendarService.getBaseCalendars());
        arrayList.addAll(this.projectCalendars);
        if (this.documentCalendars != null) {
            arrayList.addAll(this.documentCalendars);
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this.calendarType.setModel(defaultComboBoxModel);
    }

    private void clearLastSelection() {
        this.lastSelection.clear();
        for (int i2 = 0; i2 < 7; ++i2) {
            this.lastWeekSelection[i2] = false;
        }
    }

    protected void initControls() {
        this.calendarType = new JComboBox();
        this.calendarType.setRenderer(new ListRenderer());
        this.fillInCalendarNames();
        this.basedOnText = new JLabel();
        this.sdCalendar = new CalendarView();
        this.unknownWorkingTime = new JRadioButton();
        this.notEditable = new JLabel(Messages.getString("ChangeWorkingTimeDialogBox.NotEdiableMessage"));
        this.caution = new JLabel(Messages.getString("ChangeWorkingTimeDialogBox.ModificationMessage"));
        this.notEditable.setVisible(false);
        this.caution.setVisible(false);
        this.defaultWorkingTime = new JRadioButton(Messages.getString("ChangeWorkingTimeDialogBox.UseDefault"));
        this.nonWorking = new JRadioButton(Messages.getString("ChangeWorkingTimeDialogBox.NonWorkingTime"));
        this.working = new JRadioButton(Messages.getString("ChangeWorkingTimeDialogBox.NonDefaultWorkingTime"));
        this.datesSetting = new ButtonGroup();
        this.datesSetting.add(this.unknownWorkingTime);
        this.datesSetting.add(this.defaultWorkingTime);
        this.datesSetting.add(this.nonWorking);
        this.datesSetting.add(this.working);
        this.timeStart = new JTextField[Settings.CALENDAR_INTERVALS];
        this.timeEnd = new JTextField[Settings.CALENDAR_INTERVALS];
        DocumentListener documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ChangeWorkingTimeDialogBox.this.dirtyWorkingHours = true;
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ChangeWorkingTimeDialogBox.this.dirtyWorkingHours = true;
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ChangeWorkingTimeDialogBox.this.dirtyWorkingHours = true;
            }
        };
        for (int i2 = 0; i2 < this.timeStart.length; ++i2) {
            this.timeStart[i2] = new JTextField("");
            this.timeStart[i2].setEnabled(false);
            this.timeStart[i2].getDocument().addDocumentListener(documentListener);
            this.timeEnd[i2] = new JTextField("");
            this.timeEnd[i2].setEnabled(false);
            this.timeEnd[i2].getDocument().addDocumentListener(documentListener);
        }
        this.defaultWorkingTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeWorkingTimeDialogBox.this.setWorkingHours(null);
                CalendarService calendarService = CalendarService.getInstance();
                WorkingCalendar workingCalendar = ChangeWorkingTimeDialogBox.this.form.getCalendar();
                calendarService.makeDefaultDays(workingCalendar, ChangeWorkingTimeDialogBox.this.sdCalendar.getSelectedFixedIntervals(), ChangeWorkingTimeDialogBox.this.sdCalendar.getSelectedWeekDays());
                ChangeWorkingTimeDialogBox.this.dirtyWorkingHours = false;
                ChangeWorkingTimeDialogBox.this.updateWorkingHours();
                ChangeWorkingTimeDialogBox.this.updateView();
                ChangeWorkingTimeDialogBox.this.clearLastSelection();
            }
        });
        this.nonWorking.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChangeWorkingTimeDialogBox.this.setWorkingHours(null);
                CalendarService calendarService = CalendarService.getInstance();
                WorkingCalendar workingCalendar = ChangeWorkingTimeDialogBox.this.form.getCalendar();
                WorkingCalendar workingCalendar2 = workingCalendar.makeScratchCopy();
                try {
                    calendarService.setDaysNonWorking(workingCalendar2, ChangeWorkingTimeDialogBox.this.sdCalendar.getSelectedFixedIntervals(), ChangeWorkingTimeDialogBox.this.sdCalendar.getSelectedWeekDays());
                    calendarService.setDaysNonWorking(workingCalendar, ChangeWorkingTimeDialogBox.this.sdCalendar.getSelectedFixedIntervals(), ChangeWorkingTimeDialogBox.this.sdCalendar.getSelectedWeekDays());
                }
                catch (InvalidCalendarException invalidCalendarException) {
                    Alert.error(invalidCalendarException.getMessage(), ChangeWorkingTimeDialogBox.this);
                    return;
                }
                ChangeWorkingTimeDialogBox.this.dirtyWorkingHours = false;
                ChangeWorkingTimeDialogBox.this.updateWorkingHours();
                ChangeWorkingTimeDialogBox.this.updateView();
                ChangeWorkingTimeDialogBox.this.clearLastSelection();
            }
        });
        this.working.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalendarService calendarService = CalendarService.getInstance();
                WorkingCalendar workingCalendar = ChangeWorkingTimeDialogBox.this.form.getCalendar();
                ChangeWorkingTimeDialogBox.this.setWorkingHours(ChangeWorkingTimeDialogBox.this.defaultWorkingHours);
                WorkingCalendar workingCalendar2 = workingCalendar.makeScratchCopy();
                try {
                    calendarService.setDaysWorkingHours(workingCalendar2, ChangeWorkingTimeDialogBox.this.sdCalendar.getSelectedFixedIntervals(), ChangeWorkingTimeDialogBox.this.sdCalendar.getSelectedWeekDays(), ChangeWorkingTimeDialogBox.this.defaultWorkingHours);
                    calendarService.setDaysWorkingHours(workingCalendar, ChangeWorkingTimeDialogBox.this.sdCalendar.getSelectedFixedIntervals(), ChangeWorkingTimeDialogBox.this.sdCalendar.getSelectedWeekDays(), ChangeWorkingTimeDialogBox.this.defaultWorkingHours);
                    ChangeWorkingTimeDialogBox.this.dirtyWorkingHours = false;
                    ChangeWorkingTimeDialogBox.this.updateWorkingHours();
                    ChangeWorkingTimeDialogBox.this.updateView();
                }
                catch (WorkRangeException workRangeException) {
                    workRangeException.printStackTrace();
                }
                catch (InvalidCalendarException invalidCalendarException) {
                    Alert.error(invalidCalendarException.getMessage(), ChangeWorkingTimeDialogBox.this);
                    return;
                }
                ChangeWorkingTimeDialogBox.this.clearLastSelection();
            }
        });
        this.sdCalendar.addPropertyChangeListener(new PropertyChangeListener(){
            final CalendarService service = CalendarService.getInstance();

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("lastDisplayedDate".equals(string) || "firstDisplayedDate".equals(string)) {
                    ChangeWorkingTimeDialogBox.this.updateView();
                } else if ("selectedDates".equals(string)) {
                    ChangeWorkingTimeDialogBox.this.updateWorkingHours();
                }
                ChangeWorkingTimeDialogBox.this.dirtyWorkingHours = false;
            }
        });
        this.setCal(this.form.getCalendar());
        this.calendarType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkingCalendar workingCalendar = (WorkingCalendar)ChangeWorkingTimeDialogBox.this.calendarType.getSelectedItem();
                if (workingCalendar != ChangeWorkingTimeDialogBox.this.form.getCalendar()) {
                    ChangeWorkingTimeDialogBox.this.setNewCalendar(workingCalendar);
                    ChangeWorkingTimeDialogBox.this.setEditable(ChangeWorkingTimeDialogBox.this.isCalEditable(workingCalendar));
                }
            }
        });
        this.calendarType.setEnabled(!this.restrict);
        this.setEditable(this.isCalEditable(this.form.getCalendar()));
        this.newCalendar.setVisible(!this.restrict);
    }

    private boolean isCalEditable(WorkingCalendar workingCalendar) {
        boolean bl = this.projectCalendars.contains(workingCalendar);
        if (GraphicManager.getInstance().isEditingMasterProject()) {
            bl = true;
        }
        return bl;
    }

    private void setNewCalendar(WorkingCalendar workingCalendar) {
        this.saveIfNeeded();
        this.setCal(workingCalendar);
        this.updateView();
    }

    private void saveWorkingHoursChanges(boolean bl) {
        try {
            WorkingHours workingHours = new WorkingHours();
            for (int i2 = 0; i2 < this.timeStart.length; ++i2) {
                String string = this.timeStart[i2].getText();
                String string2 = this.timeEnd[i2].getText();
                if (string == null || string2 == null || string.length() <= 0 || string2.length() <= 0) {
                    if (string.length() == 0 && string2.length() == 0) break;
                    Alert.warn(Messages.getString("Message.badTimeFormat"), this);
                    return;
                }
                workingHours.setInterval(i2, this.parseTime(string), this.parseTime(string2));
            }
            CalendarService calendarService = CalendarService.getInstance();
            WorkingCalendar workingCalendar = this.form.getCalendar();
            WorkingCalendar workingCalendar2 = workingCalendar.makeScratchCopy();
            calendarService.setDaysWorkingHours(workingCalendar2, this.lastSelection, this.lastWeekSelection, workingHours);
            calendarService.setDaysWorkingHours(workingCalendar, this.lastSelection, this.lastWeekSelection, workingHours);
            this.unsaved = false;
            if (bl) {
                this.saveCalendar();
            } else {
                this.unsaved = true;
            }
        }
        catch (WorkRangeException workRangeException) {
            Alert.warn(Messages.getString("Message.badTimeIntervals"), this);
        }
        catch (ParseException parseException) {
            Alert.warn(Messages.getString("Message.badTimeFormat"), this);
        }
        catch (InvalidCalendarException invalidCalendarException) {
            Alert.warn(invalidCalendarException.getMessage(), this);
            return;
        }
        this.updateView();
    }

    private void saveCalendar() {
        this.unsaved = false;
        CalendarService calendarService = CalendarService.getInstance();
        WorkingCalendar workingCalendar = this.form.getCalendar();
        UndoableEditSupport undoableEditSupport = this.undoController.getEditSupport();
        if (undoableEditSupport != null) {
            undoableEditSupport.postEdit(new CalendarEdit(this.editedCalendar, workingCalendar));
        }
        calendarService.assignCalendar(this.editedCalendar, workingCalendar);
        calendarService.saveAndUpdate(this.editedCalendar);
    }

    public void saveIfNeeded() {
        if (this.dirtyWorkingHours) {
            this.saveWorkingHoursChanges(true);
        } else if (this.unsaved) {
            this.saveCalendar();
        }
    }

    public long getTimeInMillis(int n2, int n3) {
        this._calendar.setTimeInMillis(0L);
        this._calendar.set(11, n2);
        this._calendar.set(12, n3);
        return this._calendar.getTimeInMillis();
    }

    private String formatTime(long l2) {
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(l2);
        return this.hourFormat.format(gregorianCalendar.getTime());
    }

    private long parseTime(String string) throws ParseException {
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTime(this.hourFormat.parse(string));
        return gregorianCalendar.getTimeInMillis();
    }

    private void setWorkingHours(WorkingHours workingHours) {
        if (workingHours != null && workingHours.getDuration() == 0L) {
            workingHours = null;
        }
        for (int i2 = 0; i2 < this.timeStart.length; ++i2) {
            this.timeStart[i2].setEnabled(workingHours != null);
            this.timeEnd[i2].setEnabled(workingHours != null);
            if (workingHours != null) continue;
            this.timeStart[i2].setText("");
            this.timeEnd[i2].setText("");
        }
        if (workingHours != null) {
            int n2;
            int n3 = workingHours.getIntervals().size();
            for (n2 = 0; n2 < Settings.CALENDAR_INTERVALS; ++n2) {
                WorkRange workRange = workingHours.getInterval(n2);
                if (workRange != null) {
                    String string = this.formatTime(workRange.getStart());
                    this.timeStart[n2].setText(string);
                    this.timeEnd[n2].setText(this.formatTime(workRange.getEnd()));
                    continue;
                }
                this.timeStart[n2].setText("");
                this.timeEnd[n2].setText("");
            }
            this.clearLastSelection();
            this.lastSelection.addAll((Collection)this.sdCalendar.getSelectedFixedIntervals());
            for (n2 = 0; n2 < 7; ++n2) {
                this.lastWeekSelection[n2] = this.sdCalendar.getSelectedWeekDays()[n2];
            }
        }
        this.dirtyWorkingHours = false;
    }

    protected void updateView() {
        DayDescriptor dayDescriptor;
        CalendarService calendarService = CalendarService.getInstance();
        WorkingCalendar workingCalendar = this.form.getCalendar();
        if (workingCalendar.isBaseCalendar()) {
            this.basedOnText.setText(" ");
        } else {
            this.basedOnText.setText(Messages.getString("ChangeWorkingTimeDialogBox.BasedOn") + workingCalendar.getBaseCalendar().getName());
        }
        long l2 = this.sdCalendar.getFirstDisplayedDate();
        long l3 = this.sdCalendar.getLastDisplayedDate();
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(l2);
        this.sdCalendar.setFlaggedDates(null);
        this.sdCalendar.setColorDates(null);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        while (gregorianCalendar.getTimeInMillis() <= l3) {
            dayDescriptor = calendarService.getDay(workingCalendar, gregorianCalendar.getTimeInMillis());
            if (dayDescriptor.isModified()) {
                arrayList.add(new Long(gregorianCalendar.getTimeInMillis()));
            }
            if (!dayDescriptor.isWorking()) {
                arrayList2.add(new Long(gregorianCalendar.getTimeInMillis()));
            }
            ((Calendar)gregorianCalendar).add(5, 1);
        }
        if (arrayList.size() > 0) {
            this.sdCalendar.setFlaggedDates(this.toLongArray(arrayList));
        }
        if (arrayList2.size() > 0) {
            this.sdCalendar.setColorDates(this.toLongArray(arrayList2));
        }
        boolean[] blArray = new boolean[7];
        boolean[] blArray2 = new boolean[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            dayDescriptor = calendarService.getWeekDay(workingCalendar, i2 + 1);
            if (dayDescriptor.isModified()) {
                blArray2[i2] = true;
            }
            if (dayDescriptor.isWorking()) continue;
            blArray[i2] = true;
        }
        this.sdCalendar.setColorWeekDates(blArray);
        this.sdCalendar.setFlaggedWeekDates(blArray2);
    }

    public long[] toLongArray(ArrayList arrayList) {
        long[] lArray = new long[arrayList.size()];
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            lArray[n2] = (Long)iterator.next();
            ++n2;
        }
        return lArray;
    }

    private void updateWorkingHours() {
        DayDescriptor dayDescriptor;
        CalendarService calendarService = CalendarService.getInstance();
        if (this.dirtyWorkingHours) {
            this.saveWorkingHoursChanges(false);
        }
        if ((dayDescriptor = calendarService.getDay(this.form.getCalendar(), this.sdCalendar.getSelectedFixedIntervals(), this.sdCalendar.getSelectedWeekDays())) == null) {
            this.datesSetting.setSelected(this.unknownWorkingTime.getModel(), true);
            this.setWorkingHours(null);
        } else if (!dayDescriptor.isModified()) {
            this.datesSetting.setSelected(this.defaultWorkingTime.getModel(), true);
            this.setWorkingHours(dayDescriptor.getWorkingHours());
        } else if (!dayDescriptor.isWorking()) {
            this.datesSetting.setSelected(this.nonWorking.getModel(), true);
            this.setWorkingHours(null);
        } else {
            this.datesSetting.setSelected(this.working.getModel(), true);
            this.setWorkingHours(dayDescriptor.getWorkingHours());
        }
        this.dirtyWorkingHours = true;
    }

    private JComponent createSettingsPanel() {
        FormLayout formLayout = new FormLayout("100dlu", "p,0dlu ,p,3dlu ,p,3dlu p,3dlu,p,0dlu ,p,0dlu ,p,3dlu ,p,3dlu ,p,3dlu ,p,3dlu ,p,3dlu ,p,3dlu ,p,3dlu ,p,3dlu ,p");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.addLabel(Messages.getString("ChangeWorkingTimeDialogBox.For"));
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add(this.calendarType);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add(this.basedOnText);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add(this.notEditable);
        defaultFormBuilder.add(this.caution);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add(this.defaultWorkingTime);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add(this.nonWorking);
        defaultFormBuilder.nextLine(2);
        defaultFormBuilder.add(this.working);
        defaultFormBuilder.nextLine(2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(new JLabel(Messages.getString("ChangeWorkingTimeDialogBox.From")));
        jPanel.add(new JLabel(Messages.getString("ChangeWorkingTimeDialogBox.To")));
        defaultFormBuilder.add(jPanel);
        for (int i2 = 0; i2 < this.timeStart.length; ++i2) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(1, 2));
            jPanel2.add(this.timeStart[i2]);
            jPanel2.add(this.timeEnd[i2]);
            defaultFormBuilder.nextLine(2);
            defaultFormBuilder.add(jPanel2);
        }
        return defaultFormBuilder.getPanel();
    }

    public JComponent createContentPanel() {
        this.initControls();
        FormLayout formLayout = new FormLayout("300dlu:grow", "p,p,fill:260dlu:grow");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(this.createSettingsPanel());
        jSplitPane.setRightComponent(this.sdCalendar);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(IconManager.getIcon("calendar.back"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                long l2 = ChangeWorkingTimeDialogBox.this.sdCalendar.getFirstDisplayedDate();
                GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
                gregorianCalendar.setTimeInMillis(ChangeWorkingTimeDialogBox.this.sdCalendar.getLastDisplayedDate());
                int n2 = 0;
                while (gregorianCalendar.getTimeInMillis() > l2) {
                    ((Calendar)gregorianCalendar).add(2, -1);
                    ++n2;
                }
                gregorianCalendar.setTimeInMillis(l2);
                ((Calendar)gregorianCalendar).add(2, -n2);
                ChangeWorkingTimeDialogBox.this.sdCalendar.setFirstDisplayedDate(gregorianCalendar.getTimeInMillis());
            }
        });
        JButton jButton2 = new JButton(IconManager.getIcon("calendar.today"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
                gregorianCalendar.setTimeInMillis(System.currentTimeMillis());
                gregorianCalendar.set(5, 1);
                ChangeWorkingTimeDialogBox.this.sdCalendar.setFirstDisplayedDate(gregorianCalendar.getTimeInMillis());
            }
        });
        JButton jButton3 = new JButton(IconManager.getIcon("calendar.forward"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
                gregorianCalendar.setTimeInMillis(ChangeWorkingTimeDialogBox.this.sdCalendar.getLastDisplayedDate());
                ((Calendar)gregorianCalendar).add(5, 1);
                ChangeWorkingTimeDialogBox.this.sdCalendar.setFirstDisplayedDate(gregorianCalendar.getTimeInMillis());
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jSplitPane);
        return defaultFormBuilder.getPanel();
    }

    public Object getBean() {
        return this.form;
    }

    public ButtonPanel createButtonPanel() {
        this.createOkCancelButtons();
        this.newCalendar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewBaseCalendarDialog newBaseCalendarDialog = NewBaseCalendarDialog.getInstance(ChangeWorkingTimeDialogBox.this.owner, null);
                if (newBaseCalendarDialog.doModal()) {
                    ChangeWorkingTimeDialogBox.this.fillInCalendarNames();
                    WorkingCalendar workingCalendar = newBaseCalendarDialog.getNewCalendar();
                    ChangeWorkingTimeDialogBox.this.setNewCalendar(workingCalendar);
                }
            }
        });
        this.options = new JButton(Messages.getString("ChangeWorkingTimeDialogBox.Options"));
        this.options.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CalendarDialogBox calendarDialogBox;
                CalendarOption calendarOption = ChangeWorkingTimeDialogBox.this.project.getCalendarOption();
                if (calendarOption == null) {
                    calendarOption = CalendarOption.getInstance();
                }
                if ((calendarDialogBox = CalendarDialogBox.getInstance((Frame)ChangeWorkingTimeDialogBox.this.getOwner(), calendarOption)).doModal()) {
                    calendarOption = CalendarOption.getNewInstance();
                    calendarDialogBox.getForm().copyToOption(calendarOption);
                    CalendarOption.setInstance(calendarOption);
                    ChangeWorkingTimeDialogBox.this.project.setCalendarOption(calendarOption);
                }
            }
        });
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.addButton(this.newCalendar);
        buttonPanel.addButton(this.options);
        buttonPanel.addButton(this.ok);
        buttonPanel.addButton(this.cancel);
        buttonPanel.add(this.getHelpButton());
        return buttonPanel;
    }

    public void onOk() {
        this.saveIfNeeded();
        super.onOk();
    }

    class ListRenderer
    extends DefaultListCellRenderer {
        private Icon resourceIcon = IconManager.getIcon("man");
        private Icon greenCircle = IconManager.getIcon("greenCircle");

        ListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n2, bl, bl2);
            if (ChangeWorkingTimeDialogBox.this.documentCalendars != null && ChangeWorkingTimeDialogBox.this.documentCalendars.contains(object)) {
                this.setIcon(this.resourceIcon);
            } else if (ChangeWorkingTimeDialogBox.this.projectCalendars.contains(object)) {
                this.setIcon(this.greenCircle);
            }
            return component;
        }
    }

    public static class Form {
        protected WorkingCalendar calendar;

        public WorkingCalendar getCalendar() {
            return this.calendar;
        }

        public void setCalendar(WorkingCalendar workingCalendar) {
            this.calendar = workingCalendar;
        }
    }
}

