/*
 * Decompiled with CFR 0.152.
 */
package com.projity.field;

import com.projity.configuration.Configuration;
import com.projity.configuration.FieldDictionary;
import com.projity.contrib.util.Log;
import com.projity.contrib.util.LogFactory;
import com.projity.datatype.Duration;
import com.projity.datatype.DurationFormat;
import com.projity.datatype.Hyperlink;
import com.projity.datatype.Money;
import com.projity.datatype.PercentFormat;
import com.projity.datatype.RateFormat;
import com.projity.datatype.Work;
import com.projity.document.Document;
import com.projity.field.DelegatesFields;
import com.projity.field.FieldAccessible;
import com.projity.field.FieldContext;
import com.projity.field.FieldConverter;
import com.projity.field.FieldParseException;
import com.projity.field.Finder;
import com.projity.field.InvalidFormulaException;
import com.projity.field.ObjectRef;
import com.projity.field.OptionsFilter;
import com.projity.field.Range;
import com.projity.field.Select;
import com.projity.grouping.core.GroupNodeImpl;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.VoidNodeImpl;
import com.projity.grouping.core.hierarchy.BelongsToHierarchy;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.WalkersNodeModel;
import com.projity.grouping.core.summaries.NodeWalker;
import com.projity.grouping.core.summaries.SummaryNames;
import com.projity.grouping.core.summaries.SummaryVisitor;
import com.projity.grouping.core.summaries.SummaryVisitorFactory;
import com.projity.options.CalendarOption;
import com.projity.options.EditOption;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.pm.task.BelongsToDocument;
import com.projity.pm.task.Project;
import com.projity.pm.time.Interval;
import com.projity.scripting.ScriptedFormula;
import com.projity.server.data.DataObject;
import com.projity.strings.Messages;
import com.projity.util.ClassUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Field
implements SummaryNames,
Cloneable,
Comparable,
Finder,
Comparator {
    static Log log = LogFactory.getLog(FieldDictionary.class);
    private static final String EMPTY_STRING = "";
    private static final String PASSWORD_MASK = "********";
    private static final String NON_IMPLEMENTED = "<not implemented>";
    public static final String NOT_APPLICABLE = "<N/A>";
    public static final String NO_CHOICE = "";
    public static final String MULTIPLE_VALUES = Messages.getString("Symbol.multipleValues");
    private String configurationId;
    private String id;
    private String name;
    private String englishName;
    private Select select = null;
    private OptionsFilter filter = null;
    private FieldAccessible accessControl = null;
    private ScriptedFormula formula = null;
    private int summary = -1;
    private int groupSummary = -1;
    private Range range = null;
    private Integer ZERO = new Integer(0);
    private boolean nameField = false;
    private boolean map = false;
    private String url = null;
    private boolean image = false;
    private boolean startValue = false;
    private boolean endValue = false;
    boolean dateOnly = false;
    private String extraCategory = null;
    private static Class[] getterParams = new Class[0];
    private static Class[] getterIndexedParams = new Class[]{Integer.TYPE};
    private static Class[] getterContextParams = new Class[]{FieldContext.class};
    private static Class[] getterIndexedContextParams = new Class[]{Integer.TYPE, FieldContext.class};
    private String property;
    private String referencedObjectProperty = null;
    private String referencedIdProperty = null;
    private String finder = null;
    private Class clazz = null;
    private Method methodGet = null;
    private Method methodSet = null;
    private Method methodReset = null;
    private Method methodReadOnly = null;
    private Method methodHide = null;
    private Method methodOptions = null;
    private Method finderMethod = null;
    private Class internalType = null;
    private Class externalType = null;
    private Class displayType = null;
    private Object defaultValue = null;
    private String errorMessage = null;
    private int textWidth = Integer.MAX_VALUE;
    private int columnWidth = 0;
    private int svgColumnWidth = 0;
    private Comparator comparator = null;
    private boolean getHasNoContext = false;
    private boolean setHasNoContext = false;
    private boolean resetHasNoContext = false;
    private boolean readOnlyHasNoContext = false;
    private boolean hideHasNoContext = false;
    private boolean optionsHasNoContext = false;
    private boolean readOnly = false;
    private boolean dontLimitToChoices = false;
    private boolean scalar = true;
    private boolean vector = false;
    private boolean cantReset = false;
    private boolean hideZeroValues = false;
    private boolean callValidateOnClear = false;
    private boolean password = false;
    private boolean money = false;
    private boolean percent = false;
    private boolean duration = false;
    private boolean rate = false;
    private boolean work = false;
    private boolean date = false;
    private boolean zeroBasedIndex = false;
    private int indexes = 0;
    private int index = 0;
    private boolean memo = false;
    private boolean dynamicOptions = false;
    private boolean hasToolTip = false;
    private boolean validOnObjectCreate = true;
    private boolean dirtiesWholeDocument = false;
    private String action = null;
    private boolean graphical = false;
    private FieldContext specialFieldContext = null;
    public String lookupTypes = null;
    private boolean server;
    private String help = null;
    private String alias = null;
    private boolean custom = false;
    static SimpleDateFormat f = new SimpleDateFormat("E");

    public String toString() {
        return this.getName();
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public Range getRange() {
        return this.range;
    }

    public final void setProperty(String string) {
        this.property = string;
    }

    public final void setClass(Class clazz) {
        this.clazz = clazz;
    }

    public final Class getClazz() {
        return this.clazz;
    }

    public boolean isApplicable(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof DelegatesFields && ((DelegatesFields)object).delegates(this)) {
            return true;
        }
        return this.isApplicable(object.getClass());
    }

    public boolean isApplicable(Class clazz) {
        return this.clazz.isAssignableFrom(clazz);
    }

    public boolean isApplicable(Class[] classArray) {
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (!this.isApplicable(classArray[i2])) continue;
            return true;
        }
        return false;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final void setEnglishName(String string) {
        this.englishName = string;
    }

    public Select getSelect() {
        return this.select;
    }

    public final void setSelect(Select select) {
        this.select = select;
    }

    public final String convertIdToString(Object object) {
        if (this.select == null) {
            log.error("calling convertIdToString on non select field" + this.getName());
            return null;
        }
        return (String)this.select.getKey(object);
    }

    public final void setSum(String string) {
        this.setSummary(string);
    }

    public final void setSummary(String string) {
        this.summary = SummaryVisitorFactory.getSummaryId(string);
        if (this.summary == -1) {
            log.warn("unknown summary type: " + string + " for field " + this.getName());
        }
    }

    public final void setGroupSum(String string) {
        this.groupSummary = SummaryVisitorFactory.getSummaryId(string);
        if (this.groupSummary == -1) {
            log.warn("unknown summary type: " + string + " for field " + this.getName());
        }
    }

    public final void setExternalType(Class clazz) {
        this.externalType = clazz;
    }

    public final void setTextWidth(int n2) {
        this.textWidth = n2;
    }

    public int getTextWidth(Object object, FieldContext fieldContext) {
        return this.textWidth;
    }

    public int getTextWidth() {
        return this.textWidth;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(int n2) {
        this.columnWidth = n2;
    }

    public int getColumnWidth(boolean bl) {
        return bl ? this.getSvgColumnWidth() : this.getColumnWidth();
    }

    public int getSvgColumnWidth() {
        return this.svgColumnWidth;
    }

    public void setSvgColumnWidth(int n2) {
        this.svgColumnWidth = n2;
    }

    public final void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public Comparator getComparator() {
        if (this.comparator == null) {
            return ClassUtils.getComparator(this.getDisplayType());
        }
        return this.comparator;
    }

    public int getSummary() {
        return this.summary;
    }

    public int getGroupSummary() {
        return this.groupSummary;
    }

    public SummaryVisitor getSummaryVisitor(int n2, boolean bl) {
        return SummaryVisitorFactory.getInstance(n2, this.getDisplayType(), bl);
    }

    public SummaryVisitor getSummaryVisitor(boolean bl) {
        return this.getSummaryVisitor(this.summary, bl);
    }

    public boolean hasOptions() {
        return this.select != null;
    }

    public boolean isHasOptions() {
        return this.hasOptions();
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public boolean isHasFilter() {
        return this.hasFilter();
    }

    public Object[] getOptions(Object object) {
        if (this.select == null) {
            return null;
        }
        Object[] objectArray = this.select.getKeyArray();
        if (this.filter == null) {
            return objectArray;
        }
        return this.filter.getOptions(objectArray, this.select.getValueList(), object);
    }

    public boolean hasDynamicSelect() {
        return this.select != null && !this.select.isStatic();
    }

    public Class getDisplayType() {
        return this.displayType;
    }

    public String typeName() {
        if (this.isPercent()) {
            return "Percent";
        }
        if (this.isImage()) {
            return "Image";
        }
        if (this.isDate()) {
            return "Date";
        }
        if (this.isDuration()) {
            return "Duration";
        }
        String string = this.getDisplayType().toString();
        int n2 = string.lastIndexOf(".");
        if (n2 != -1) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    public String internalTypeName() {
        String string = this.internalType.toString();
        int n2 = string.lastIndexOf(".");
        if (n2 != -1) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    private String toText(Object object, Object object2) {
        if (object == null) {
            return "";
        }
        if (this.defaultValue != null && this.hideZeroValues && this.defaultValue.equals(object)) {
            return "";
        }
        Format format = this.getFormat(object2);
        if (format != null) {
            return format.format(object);
        }
        if (this.isHyperlink()) {
            return ((Hyperlink)object).toString();
        }
        return FieldConverter.toString(object, this.getDisplayType(), null);
    }

    public String toExternalText(Object object, Object object2) {
        if (this.hasOptions()) {
            return this.convertValueToStringUsingOptions(object);
        }
        return this.toText(object, object2);
    }

    public final String getText(Object object, FieldContext fieldContext) {
        if (!this.isApplicable(object)) {
            return NOT_APPLICABLE;
        }
        if (this.password) {
            return PASSWORD_MASK;
        }
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        Object object2 = null;
        try {
            object2 = this.getValue(object, fieldContext);
            if (this.hasOptions()) {
                return this.convertValueToStringUsingOptions(object2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        return this.toText(object2, object);
    }

    public final String getText(Node node, WalkersNodeModel walkersNodeModel, FieldContext fieldContext) {
        Object object = node.getImpl();
        if (!this.isApplicable(object)) {
            return NOT_APPLICABLE;
        }
        if (this.password) {
            return PASSWORD_MASK;
        }
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        Object object2 = null;
        try {
            object2 = this.getValue(node, walkersNodeModel, fieldContext);
            if (this.hasOptions()) {
                return this.convertValueToStringUsingOptions(object2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        return this.toText(object2, object);
    }

    public final String getText(ObjectRef objectRef, FieldContext fieldContext) {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (objectRef.getCollection() != null) {
            return "" + this.getCommonValue(objectRef.getCollection(), true, true);
        }
        if (objectRef.getNode() != null) {
            return this.getText(objectRef.getNode(), objectRef.getNodeModel(), fieldContext);
        }
        return this.getText(objectRef.getObject(), fieldContext);
    }

    public String convertValueToStringUsingOptions(Object object) {
        String string = (String)this.select.getKey(object);
        if (string != null) {
            return string;
        }
        if (object instanceof String) {
            return object.toString();
        }
        if (!this.dontLimitToChoices) {
            return "";
        }
        return object.toString();
    }

    public int getSummaryForGroup() {
        if (this.groupSummary != -1) {
            return this.groupSummary;
        }
        return this.summary;
    }

    private boolean nodeHasNonSummarizedValue(Node node, WalkersNodeModel walkersNodeModel) {
        int n2 = this.summary;
        if (node.getImpl() instanceof GroupNodeImpl) {
            n2 = this.getSummaryForGroup();
        }
        return n2 == -1 || n2 == -4 || !walkersNodeModel.isSummary(node);
    }

    public boolean hasSummary() {
        return this.summary != -1;
    }

    public Object getValue(Node node, WalkersNodeModel walkersNodeModel, FieldContext fieldContext) {
        Object object;
        Object object2 = node.getImpl();
        if (object2 instanceof VoidNodeImpl) {
            return null;
        }
        if (!(object2 instanceof GroupNodeImpl) && this.isHidden(object2, fieldContext)) {
            return null;
        }
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if ("Field.duration".equals(this.id) && object2 instanceof GroupNodeImpl) {
            Document document = walkersNodeModel.getDocument();
            if (document == null || !(document instanceof Project)) {
                return null;
            }
            WorkingCalendar workingCalendar = (WorkingCalendar)((Project)document).getWorkCalendar();
            Field field = FieldDictionary.getInstance().getFieldFromId("Field.start");
            Field field2 = FieldDictionary.getInstance().getFieldFromId("Field.finish");
            Date date = (Date)Field.getSummarizedValueForField(field, node, walkersNodeModel, fieldContext);
            Date date2 = (Date)Field.getSummarizedValueForField(field2, node, walkersNodeModel, fieldContext);
            double d2 = workingCalendar.compare(date2.getTime(), date.getTime(), false);
            object = new Duration(Duration.getInstance(d2 / (double)CalendarOption.getInstance().getMillisPerDay(), 2));
        } else if (this.nodeHasNonSummarizedValue(node, walkersNodeModel)) {
            object = this.getValue(object2, fieldContext);
            if (this.hasOptions()) {
                object = this.convertValueToStringUsingOptions(object);
            }
        } else {
            object = Field.getSummarizedValueForField(this, node, walkersNodeModel, fieldContext);
        }
        if (this.isWork() && object != null) {
            ((Work)object).setWork(true);
        }
        return object;
    }

    public Object getValue(ObjectRef objectRef, FieldContext fieldContext) {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (objectRef.getCollection() != null) {
            return this.getCommonValue(objectRef.getCollection(), true, false);
        }
        if (objectRef.getNode() != null) {
            return this.getValue(objectRef.getNode(), objectRef.getNodeModel(), fieldContext);
        }
        return this.getValue(objectRef.getObject(), fieldContext);
    }

    private static Object getSummarizedValueForField(Field field, Node node, WalkersNodeModel walkersNodeModel, FieldContext fieldContext) {
        Object object;
        if (fieldContext == null) {
            fieldContext = field.specialFieldContext;
        }
        NodeWalker nodeWalker = (NodeWalker)field.getSummaryVisitor((object = node.getImpl()) instanceof GroupNodeImpl ? field.getSummaryForGroup() : field.getSummary(), object instanceof Document);
        nodeWalker.setNode(node);
        nodeWalker.setNodeModel(walkersNodeModel);
        nodeWalker.setContext(fieldContext);
        nodeWalker.setField(field);
        Object object2 = nodeWalker.getSummary();
        if (object2 instanceof Double) {
            object2 = ClassUtils.doubleToObject((Double)object2, field.getDisplayType());
        }
        if (object instanceof GroupNodeImpl && field.hasOptions()) {
            object2 = field.convertValueToStringUsingOptions(object2);
        }
        return object2;
    }

    private Object getPropertyValue(Object object, FieldContext fieldContext) {
        Object object2 = null;
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (this.isFormula()) {
            object2 = this.evaluateFormula(object);
        } else {
            if (this.methodGet == null) {
                return null;
            }
            try {
                if (this.getHasNoContext) {
                    Object[] objectArray;
                    if (this.isIndexed()) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = new Integer(this.index);
                    } else {
                        objectArray = new Object[]{};
                    }
                    object2 = this.methodGet.invoke(object, objectArray);
                } else {
                    Object[] objectArray;
                    if (this.isIndexed()) {
                        Object[] objectArray3 = new Object[2];
                        objectArray3[0] = new Integer(this.index);
                        objectArray = objectArray3;
                        objectArray3[1] = fieldContext;
                    } else {
                        Object[] objectArray4 = new Object[1];
                        objectArray = objectArray4;
                        objectArray4[0] = fieldContext;
                    }
                    object2 = this.methodGet.invoke(object, objectArray);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.out.println("Bad field " + this);
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Bad field " + this);
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("Bad field " + this);
                invocationTargetException.printStackTrace();
            }
        }
        return object2;
    }

    public Object getValue(Object object) {
        return this.getValue(object, null);
    }

    public Object getValue(Object object, FieldContext fieldContext) {
        DelegatesFields delegatesFields;
        if (!this.isApplicable(object)) {
            return null;
        }
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        Object object2 = null;
        if (object instanceof DelegatesFields && (delegatesFields = (DelegatesFields)object).delegates(this)) {
            object2 = delegatesFields.getDelegatedFieldValue(this);
            return object2;
        }
        object2 = this.getPropertyValue(object, fieldContext);
        if (this.isMap()) {
            if (object2 == null) {
                return null;
            }
            object2 = ((Map)object2).get(this.getId());
        }
        if (this.hasExternalType()) {
            if (FieldContext.isScripting(fieldContext)) {
                if (this.isDuration()) {
                    object2 = Duration.millis((Long)object2);
                }
            } else {
                try {
                    object2 = FieldConverter.convert(object2, this.externalType, fieldContext);
                }
                catch (FieldParseException fieldParseException) {
                    fieldParseException.printStackTrace();
                    object2 = null;
                }
            }
        }
        if (this.hideZeroValues && this.isZero(object2)) {
            return null;
        }
        return object2;
    }

    public boolean isZero(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue() == 0.0;
        }
        if (object instanceof String) {
            return ((String)object).length() == 0;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public final void setText(Object var1_1, String var2_2, FieldContext var3_3) throws FieldParseException {
        if (var3_3 == null) {
            var3_3 = this.specialFieldContext;
        }
        if (this.isReadOnly(var1_1, var3_3)) {
            return;
        }
        var4_4 = this.preprocessText(var1_1, var2_2, var3_3);
        if (var4_4 == var2_2) {
            var5_5 = this.getFormat(var1_1);
            if (var5_5 != null) {
                try {
                    var4_4 = var5_5.parseObject(var2_2);
                }
                catch (ParseException var6_6) {
                    var5_5 = this.getSecondaryFormat(var1_1);
                    var7_7 = false;
                    if (var5_5 != null) {
                        try {
                            var4_4 = var5_5.parseObject(var2_2);
                            var7_7 = true;
                        }
                        catch (ParseException var8_8) {
                            // empty catch block
                        }
                    }
                    if (var7_7) ** GOTO lbl25
                    throw new FieldParseException(var6_6);
                }
            } else {
                var4_4 = FieldConverter.convert(var2_2, this.hasExternalType() != false ? this.externalType : this.internalType, var3_3);
            }
        }
lbl25:
        // 5 sources

        this.setInternalValueAndUpdate(var1_1, this, var4_4, var3_3);
    }

    public final void setText(Node node, WalkersNodeModel walkersNodeModel, String string, FieldContext fieldContext) throws FieldParseException {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (this.isReadOnly(node, walkersNodeModel, fieldContext)) {
            return;
        }
        Object object = node.getImpl();
        Object object2 = this.preprocessText(object, string, fieldContext);
        if (object2 == string) {
            Format format = this.getFormat(object);
            if (format != null) {
                try {
                    object2 = format.parseObject(string);
                }
                catch (ParseException parseException) {
                    throw new FieldParseException(parseException);
                }
            } else {
                object2 = FieldConverter.convert(string, this.hasExternalType() ? this.externalType : this.internalType, fieldContext);
            }
        }
        this.setValue(node, walkersNodeModel, this, object2, fieldContext);
    }

    public final void setText(ObjectRef objectRef, String string, FieldContext fieldContext) throws FieldParseException {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (objectRef.getCollection() != null) {
            Iterator iterator = objectRef.getCollection().iterator();
            while (iterator.hasNext()) {
                this.setText(iterator.next(), string, fieldContext);
            }
        } else if (objectRef.getNode() != null) {
            this.setText(objectRef.getNode(), objectRef.getNodeModel(), string, fieldContext);
        } else {
            this.setText(objectRef.getObject(), string, fieldContext);
        }
    }

    public void setValue(Node node, WalkersNodeModel walkersNodeModel, Object object, Object object2, FieldContext fieldContext) throws FieldParseException {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        Object object3 = node.getImpl();
        this.setValue(object3, object, object2, fieldContext);
    }

    public void setValue(Object object, Object object2, Object object3, FieldContext fieldContext) throws FieldParseException {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (this.hasOptions()) {
            if (object3 instanceof String) {
                object3 = this.preprocessText(object, (String)object3, fieldContext);
            }
        } else {
            if (object3 instanceof String && this.hasExternalType()) {
                object3 = FieldConverter.convert(object3, this.externalType, fieldContext);
            }
            if (object3 == null) {
                throw new FieldParseException(this.errorMessage(object3, object));
            }
        }
        this.setInternalValueAndUpdate(object, object2, object3, fieldContext);
    }

    private void setInternalValueAndUpdate(Object object, Object object2, Object object3, FieldContext fieldContext) throws FieldParseException {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (this.setInternalValue(object, object3, fieldContext) && (fieldContext == null || !fieldContext.isNoUpdate())) {
            this.fireEvent(object, object2, fieldContext);
        }
    }

    public void fireEvent(Object object, Object object2, FieldContext fieldContext) {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (object instanceof BelongsToDocument && object2 != null && !FieldContext.isNoUpdate(fieldContext)) {
            Document document = ((BelongsToDocument)object).getDocument();
            document.getObjectEventManager().fireUpdateEvent(object2, object, this);
            if (this.isDirtiesWholeDocument()) {
                document.setAllChildrenDirty(true);
            }
        }
    }

    public boolean setValue(Object object, Object object2, Object object3) {
        try {
            this.setValue(object, object2, object3, null);
            return true;
        }
        catch (FieldParseException fieldParseException) {
            return false;
        }
    }

    public void setValue(ObjectRef objectRef, Object object, Object object2, FieldContext fieldContext) throws FieldParseException {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (objectRef.getCollection() != null) {
            Iterator iterator = objectRef.getCollection().iterator();
            while (iterator.hasNext()) {
                this.setValue(iterator.next(), object, object2, fieldContext);
            }
        } else if (objectRef.getNode() != null) {
            this.setValue(objectRef.getNode(), objectRef.getNodeModel(), object, object2, fieldContext);
        } else {
            this.setValue(objectRef.getObject(), object, object2, fieldContext);
        }
    }

    public String syntaxErrorForField() {
        return this.errorMessage(null, null);
    }

    private String errorMessage(Object object, Object object2) {
        String string = this.errorMessage != null ? this.errorMessage : (this.isDuration() ? "Message.invalidDuration" : (this.isDate() ? "Message.invalidDate" : (this.isRate() ? "Message.invalidRate" : (this.isMoney() ? "Message.invalidCost" : "Message.invalidInput"))));
        return Messages.getString(string);
    }

    public Object getMultipleValueForType() {
        if (this.isDuration()) {
            return Duration.ZERO;
        }
        if (this.isDate()) {
            return null;
        }
        if (this.isPercent()) {
            return ClassUtils.PERCENT_MULTIPLE_VALUES;
        }
        return ClassUtils.getMultipleValueForType(this.internalType);
    }

    public boolean setInternalValue(Object object, Object object2, FieldContext fieldContext) throws FieldParseException {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (!FieldContext.isForceValue(fieldContext) && this.isReadOnly(object, fieldContext)) {
            return false;
        }
        if (object2 != null && object2.equals(this.getValue(object, fieldContext))) {
            return false;
        }
        if (this.hasExternalType() && (object2 = FieldConverter.convert(object2, this.internalType, fieldContext)) == null && !this.isMap()) {
            return false;
        }
        if (this.range != null) {
            this.range.validate(object2, this);
        }
        if (this.methodSet == null) {
            return false;
        }
        if (FieldContext.isParseOnly(fieldContext)) {
            return false;
        }
        try {
            if (this.isMap()) {
                Map map = (Map)this.getPropertyValue(object, fieldContext);
                map.put(this.getId(), object2);
            } else if (this.setHasNoContext) {
                Object[] objectArray;
                if (this.isIndexed()) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = new Integer(this.index);
                    objectArray = objectArray2;
                    objectArray2[1] = object2;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = object2;
                }
                this.methodSet.invoke(object, objectArray);
            } else {
                Object[] objectArray;
                if (this.isIndexed()) {
                    Object[] objectArray4 = new Object[3];
                    objectArray4[0] = new Integer(this.index);
                    objectArray4[1] = object2;
                    objectArray = objectArray4;
                    objectArray4[2] = fieldContext;
                } else {
                    Object[] objectArray5 = new Object[2];
                    objectArray5[0] = object2;
                    objectArray = objectArray5;
                    objectArray5[1] = fieldContext;
                }
                this.methodSet.invoke(object, objectArray);
            }
            if (object instanceof DataObject && (fieldContext == null || !fieldContext.isNoDirty())) {
                ((DataObject)object).setDirty(true);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FieldParseException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            invocationTargetException.printStackTrace();
            if (throwable != null && throwable instanceof FieldParseException) {
                throw (FieldParseException)throwable;
            }
            throw new FieldParseException(throwable.getMessage());
        }
        return true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isReadOnly(Node node, WalkersNodeModel walkersNodeModel, FieldContext fieldContext) {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (node.getImpl() instanceof GroupNodeImpl) {
            return true;
        }
        if (this.summary == -4 && walkersNodeModel.isSummary(node)) {
            return true;
        }
        if (!this.nodeHasNonSummarizedValue(node, walkersNodeModel)) {
            return true;
        }
        return this.isReadOnly(node.getImpl(), fieldContext);
    }

    public boolean isReadOnly(ObjectRef objectRef, FieldContext fieldContext) {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (objectRef.getCollection() != null) {
            Iterator iterator = objectRef.getCollection().iterator();
            while (iterator.hasNext()) {
                if (!this.isReadOnly(iterator.next(), fieldContext)) continue;
                return true;
            }
            return false;
        }
        if (objectRef.getNode() != null) {
            return this.isReadOnly(objectRef.getNode(), objectRef.getNodeModel(), fieldContext);
        }
        return this.isReadOnly(objectRef.getObject(), fieldContext);
    }

    public boolean isReadOnly(Object object, FieldContext fieldContext) {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (this.readOnly) {
            return true;
        }
        if (!this.isApplicable(object)) {
            return true;
        }
        if (this.isFormula()) {
            return true;
        }
        if (object instanceof BelongsToHierarchy && this.summary != -1 && ((BelongsToHierarchy)object).isParent()) {
            return true;
        }
        if (ClassUtils.isObjectReadOnly(object)) {
            return true;
        }
        if (ClassUtils.isObjectFieldReadOnly(object, this)) {
            return true;
        }
        if (object instanceof DelegatesFields && ((DelegatesFields)object).delegates(this)) {
            return true;
        }
        Boolean bl = (Boolean)this.invokeContextMethod(this.methodReadOnly, object, fieldContext, this.readOnlyHasNoContext);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public boolean isHidden(Object object, FieldContext fieldContext) {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (this.methodHide == null) {
            return false;
        }
        Boolean bl = (Boolean)this.invokeContextMethod(this.methodHide, object, fieldContext, this.hideHasNoContext);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public Object mapStringToValue(String string) {
        if (this.select == null) {
            return null;
        }
        try {
            return this.select.getValue(string);
        }
        catch (Select.InvalidChoiceException invalidChoiceException) {
            return null;
        }
    }

    public String mapValueToString(Object object) {
        if (this.select == null) {
            return null;
        }
        return (String)this.select.getKey(object);
    }

    protected Object preprocessText(Object object, String string, FieldContext fieldContext) throws FieldParseException {
        Object object2;
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (this.select != null) {
            if (string == null) {
                return null;
            }
            if (string.trim().length() == 0 && this.select.isAllowNull()) {
                string = " ";
            }
            try {
                object2 = this.select.getValue(string);
            }
            catch (Select.InvalidChoiceException invalidChoiceException) {
                throw new FieldParseException(Messages.getString("Message.invalidChoice") + ": " + string);
            }
            if (!(object2 != null || this.select.isAllowNull() && string == " ")) {
                throw new FieldParseException(Messages.getString("Message.invalidChoice") + ": " + string);
            }
        } else {
            object2 = this.isBoolean() ? Boolean.valueOf(string) : string;
        }
        return object2;
    }

    public boolean isValidChoice(String string) {
        try {
            this.preprocessText(null, string, null);
        }
        catch (FieldParseException fieldParseException) {
            return false;
        }
        return true;
    }

    private final void setAccessorMethods() {
        if (this.clazz != null && this.property != null) {
            Class[] classArray;
            StringBuffer stringBuffer = new StringBuffer(this.property);
            stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
            this.methodGet = MethodUtils.getAccessibleMethod(this.clazz, "get" + stringBuffer, this.isIndexed() ? getterIndexedContextParams : getterContextParams);
            if (this.methodGet == null) {
                this.methodGet = MethodUtils.getAccessibleMethod(this.clazz, "is" + stringBuffer, this.isIndexed() ? getterIndexedContextParams : getterContextParams);
            }
            if (this.methodGet == null) {
                this.getHasNoContext = true;
                this.methodGet = MethodUtils.getAccessibleMethod(this.clazz, "get" + stringBuffer, this.isIndexed() ? getterIndexedParams : getterParams);
                if (this.methodGet == null) {
                    this.methodGet = MethodUtils.getAccessibleMethod(this.clazz, "is" + stringBuffer, this.isIndexed() ? getterIndexedParams : getterParams);
                }
            }
            if (this.methodGet != null) {
                this.internalType = this.methodGet.getReturnType();
            } else {
                log.error("Not getter found for field " + this.getId());
            }
            String string = "set" + stringBuffer;
            if (this.isIndexed()) {
                Class[] classArray2 = new Class[3];
                classArray2[0] = Integer.TYPE;
                classArray2[1] = this.internalType;
                classArray = classArray2;
                classArray2[2] = FieldContext.class;
            } else {
                Class[] classArray3 = new Class[2];
                classArray3[0] = this.internalType;
                classArray = classArray3;
                classArray3[1] = FieldContext.class;
            }
            this.methodSet = MethodUtils.getAccessibleMethod(this.clazz, string, classArray);
            if (this.methodSet == null) {
                Class[] classArray4;
                this.setHasNoContext = true;
                String string2 = "set" + stringBuffer;
                if (this.isIndexed()) {
                    Class[] classArray5 = new Class[2];
                    classArray5[0] = Integer.TYPE;
                    classArray4 = classArray5;
                    classArray5[1] = this.internalType;
                } else {
                    Class[] classArray6 = new Class[1];
                    classArray4 = classArray6;
                    classArray6[0] = this.internalType;
                }
                this.methodSet = MethodUtils.getAccessibleMethod(this.clazz, string2, classArray4);
            }
            if (this.methodSet == null && !this.readOnly) {
                log.warn("No setter found for non-read-only field: " + this.getId());
            }
            this.methodReset = MethodUtils.getAccessibleMethod(this.clazz, "fieldReset" + stringBuffer, getterContextParams);
            this.resetHasNoContext = this.methodReset == null;
            if (this.resetHasNoContext) {
                this.methodReset = MethodUtils.getAccessibleMethod(this.clazz, "fieldReset" + stringBuffer, getterParams);
            }
            this.methodReadOnly = MethodUtils.getAccessibleMethod(this.clazz, "isReadOnly" + stringBuffer, getterContextParams);
            this.readOnlyHasNoContext = this.methodReadOnly == null;
            if (this.readOnlyHasNoContext) {
                this.methodReadOnly = MethodUtils.getAccessibleMethod(this.clazz, "isReadOnly" + stringBuffer, getterParams);
            }
            this.methodHide = MethodUtils.getAccessibleMethod(this.clazz, "fieldHide" + stringBuffer, this.isIndexed() ? getterIndexedContextParams : getterContextParams);
            this.hideHasNoContext = this.methodHide == null;
            if (this.hideHasNoContext) {
                this.methodHide = MethodUtils.getAccessibleMethod(this.clazz, "fieldHide" + stringBuffer, this.isIndexed() ? getterIndexedParams : getterParams);
            }
            this.methodOptions = MethodUtils.getAccessibleMethod(this.clazz, "fieldOptions" + stringBuffer, getterContextParams);
            this.optionsHasNoContext = this.methodOptions == null;
            if (this.optionsHasNoContext) {
                this.methodOptions = MethodUtils.getAccessibleMethod(this.clazz, "fieldOptions" + stringBuffer, getterParams);
            }
        }
    }

    private final Object invokeContextMethod(Method method, Object object, FieldContext fieldContext, boolean bl) {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (method == null) {
            return null;
        }
        try {
            if (bl) {
                if (this.isIndexed()) {
                    return method.invoke(object, new Integer(this.getIndex()), null);
                }
                return method.invoke(object, (Object[])null);
            }
            if (this.isIndexed()) {
                return method.invoke(object, new Integer(this.getIndex()), fieldContext);
            }
            return method.invoke(object, fieldContext);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return null;
    }

    private boolean hasExternalType() {
        return this.externalType != null && this.externalType != this.internalType;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getIdWithoutPrefix() {
        int n2 = this.id.indexOf(46);
        if (n2 != -1) {
            return this.id.substring(n2 + 1);
        }
        return this.id;
    }

    private int getDefaultColumnWidth() {
        if (this.isDuration()) {
            return 75;
        }
        if (this.isDate()) {
            return 115;
        }
        if (this.isMoney()) {
            return 100;
        }
        if (this.isRate()) {
            return 75;
        }
        if (this.getDisplayType() == Boolean.class) {
            return 40;
        }
        return 150;
    }

    private int getSvgDefaultColumnWidth() {
        if (this.isDate()) {
            return 130;
        }
        return this.getDefaultColumnWidth();
    }

    public boolean build() {
        this.configurationId = this.id;
        boolean bl = true;
        if (this.id == null) {
            log.error("Field has no id!");
            bl = false;
        }
        if (this.property == null) {
            log.error("Field has no property:" + this.id);
            bl = false;
        }
        if (this.name == null) {
            this.name = Messages.getString(this.id);
        }
        this.setAccessorMethods();
        this.map = Map.class.isAssignableFrom(this.internalType);
        if (this.isWork()) {
            this.setExternalType(Work.class);
        } else if (this.isDuration()) {
            this.setExternalType(Duration.class);
        } else if (this.isDate()) {
            this.setExternalType(Date.class);
        } else if (this.isMoney() && !this.isRate()) {
            this.setExternalType(Money.class);
        }
        Class clazz = this.displayType = this.externalType == null ? this.internalType : this.externalType;
        if (this.displayType != null && this.displayType.isPrimitive()) {
            this.externalType = this.displayType = ClassUtils.primitiveToObjectClass(this.displayType);
        }
        if (this.finder != null) {
            this.finderMethod = ClassUtils.staticMethodFromFullName(this.finder, new Class[]{Object.class, Object.class});
            if (this.finderMethod == null) {
                log.error("invalid finder method " + this.finder + " for field" + this.name);
            }
        }
        if (this.columnWidth == 0) {
            this.columnWidth = this.getDefaultColumnWidth();
        }
        if (this.svgColumnWidth == 0) {
            this.svgColumnWidth = this.getSvgDefaultColumnWidth();
        }
        return bl;
    }

    public void setType(String string) {
        try {
            this.setExternalType(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public String getName() {
        if (this.getAlias() != null) {
            return this.getAlias();
        }
        return this.name;
    }

    public String getDefaultName() {
        return this.name;
    }

    public boolean isBoolean() {
        return this.getDisplayType() == Boolean.class;
    }

    public boolean isDuration() {
        return this.duration;
    }

    public void setDuration(boolean bl) {
        this.duration = bl;
    }

    public boolean isCallValidateOnClear() {
        return this.callValidateOnClear;
    }

    public void setCallValidateOnClear(boolean bl) {
        this.callValidateOnClear = bl;
    }

    public boolean isCantReset() {
        return this.cantReset;
    }

    public void setCantReset(boolean bl) {
        this.cantReset = bl;
    }

    public boolean isMoney() {
        return this.money;
    }

    public void setMoney(boolean bl) {
        this.money = bl;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public boolean isDontLimitToChoices() {
        return this.dontLimitToChoices;
    }

    public void setDontLimitToChoices(boolean bl) {
        this.dontLimitToChoices = bl;
    }

    public boolean isFormula() {
        return this.formula != null;
    }

    public void setFormula(String string, String string2, String string3) {
        throw new RuntimeException("setFormula");
    }

    public void clearFormula() {
        this.formula = null;
    }

    public Object evaluateFormula(Object object) {
        try {
            return this.formula.evaluate(object);
        }
        catch (InvalidFormulaException invalidFormulaException) {
            log.error("Formula is invalid " + this.formula.getText());
            return null;
        }
    }

    public boolean isHideZeroValues() {
        return this.hideZeroValues;
    }

    public void setHideZeroValues(boolean bl) {
        this.hideZeroValues = bl;
    }

    public boolean isPassword() {
        return this.password;
    }

    public void setPassword(boolean bl) {
        this.password = bl;
    }

    public boolean isPercent() {
        return this.percent;
    }

    public void setPercent(boolean bl) {
        this.percent = bl;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean isScalar() {
        return this.scalar;
    }

    public void setScalar(boolean bl) {
        this.scalar = bl;
    }

    public boolean isVector() {
        return this.vector;
    }

    public void setVector(boolean bl) {
        this.vector = bl;
    }

    public int getIndexes() {
        return this.indexes;
    }

    public void setIndexes(int n2) {
        this.indexes = n2;
    }

    public void setBoundsField(String string) {
        if (this.indexes > 0) {
            ClassUtils.setStaticField(string, this.indexes);
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n2) {
        this.index = n2;
    }

    public boolean isIndexed() {
        return this.indexes != 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public Field createIndexedField(int n2) {
        Field field = (Field)this.clone();
        field.setIndex(n2);
        String string = "";
        if (field.isZeroBasedIndex()) {
            if (n2 > 0) {
                string = string + n2;
            }
        } else {
            string = string + (n2 + 1);
        }
        field.setId(this.getId().replaceFirst("#", string));
        field.setName(this.getName().replaceFirst("#", string));
        return field;
    }

    public static Field createIntervalField(Field field, Interval interval) {
        FieldContext fieldContext = new FieldContext();
        fieldContext.setInterval(interval);
        Field field2 = (Field)field.clone();
        field2.specialFieldContext = new FieldContext();
        return field2;
    }

    public String getLabel() {
        if (this.specialFieldContext == null) {
            return this.getName();
        }
        long l2 = this.specialFieldContext.getInterval().getStart();
        return f.format(new Date(l2));
    }

    public boolean isDate() {
        return this.date;
    }

    public void setDate(boolean bl) {
        this.date = bl;
    }

    public int compareTo(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Field)) {
            throw new ClassCastException();
        }
        Field field = (Field)object;
        if (this.configurationId == field.configurationId) {
            return this.index - field.index;
        }
        return this.getName().compareTo(field.getName());
    }

    public void setValueForEach(Collection collection, Object object, FieldContext fieldContext, Object object2) {
        if (fieldContext == null) {
            fieldContext = this.specialFieldContext;
        }
        if (collection == null) {
            return;
        }
        for (Object e2 : collection) {
            try {
                this.setValue(e2, object2, object, fieldContext);
            }
            catch (FieldParseException fieldParseException) {
                fieldParseException.printStackTrace();
            }
        }
    }

    public Object getCommonValue(Collection collection, boolean bl, boolean bl2) {
        Comparator comparator;
        if (collection == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        Object object = null;
        Comparator comparator2 = comparator = bl2 ? ComparableComparator.getInstance() : this.getComparator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Object object2 = bl2 ? this.getText(e2, null) : this.getValue(e2, null);
            if (object == null) {
                object = object2;
                continue;
            }
            if (0 == comparator.compare(object2, object)) continue;
            object = null;
            break;
        }
        if (object == null && bl) {
            object = this.getMultipleValueForType();
        }
        return object;
    }

    public String getCommonValueString(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        Object object = this.getCommonValue(collection, false, true);
        if (object == null) {
            return MULTIPLE_VALUES;
        }
        return object.toString();
    }

    public Object findFirstInCollection(Object object, Collection collection) {
        for (Object e2 : collection) {
            if (0 != this.getComparator().compare(this.getValue(e2, null), object)) continue;
            return e2;
        }
        return null;
    }

    public Object[] findAllInCollection(Object object, Collection collection) {
        ArrayList arrayList = new ArrayList();
        for (Object e2 : collection) {
            if (0 != this.getComparator().compare(this.getValue(e2, null), object)) continue;
            arrayList.add(e2);
        }
        return arrayList.toArray();
    }

    public boolean isWork() {
        return this.work;
    }

    public boolean isDurationOrWork() {
        return this.isWork() || this.isDuration();
    }

    public void setWork(boolean bl) {
        this.setDuration(bl);
        this.work = bl;
    }

    public void setFinder(String string) {
        this.finder = string;
    }

    public Object find(Object object, Collection collection) {
        if (this.finderMethod == null) {
            return this.findFirstInCollection(object, collection);
        }
        try {
            return this.finderMethod.invoke(null, object, collection);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int compare(Object object, Object object2) {
        return this.getComparator().compare(this.getValue(object, null), this.getValue(object2, null));
    }

    public boolean isRate() {
        return this.rate;
    }

    public void setRate(boolean bl) {
        this.rate = bl;
    }

    public boolean isZeroBasedIndex() {
        return this.zeroBasedIndex;
    }

    public void setZeroBasedIndex(boolean bl) {
        this.zeroBasedIndex = bl;
    }

    public double getScaleFactor() {
        if (this.isWork() || this.isDuration()) {
            return CalendarOption.getInstance().getMillisPerDay();
        }
        return 1.0;
    }

    public Format getFormat() {
        return this.getFormat(null);
    }

    public Format getFormat(Object object) {
        if (this.isWork()) {
            return DurationFormat.getWorkInstance();
        }
        if (this.isRate()) {
            return RateFormat.getInstance(object, this.isMoney(), this.isPercent(), true);
        }
        if (this.isMoney()) {
            return Money.getMoneyFormatInstance();
        }
        if (this.isDuration()) {
            return DurationFormat.getInstance();
        }
        if (this.isPercent()) {
            return PercentFormat.getInstance();
        }
        if (this.isDate()) {
            return EditOption.getInstance().getDateFormat();
        }
        if (this.displayType == Double.class || this.displayType == Float.class || this.displayType == Integer.class) {
            return NumberFormat.getInstance();
        }
        return null;
    }

    private Format getSecondaryFormat(Object object) {
        if (this.isMoney()) {
            return NumberFormat.getInstance();
        }
        return null;
    }

    public boolean isNumber() {
        return this.displayType == Double.class || this.displayType == Float.class || this.displayType == Integer.class || this.displayType == Long.class;
    }

    public int getHorizontalAlignment() {
        if (this.isImage() || this.isBoolean()) {
            return 0;
        }
        if (this.isWork() || this.isRate() || this.isMoney() || this.isDuration() || this.isDate() || this.isPercent() || this.isNumber()) {
            return 4;
        }
        return 2;
    }

    public static Object value(Field field, Node node, NodeModel nodeModel) {
        return field.getValue(node, nodeModel, null);
    }

    public static Object value(Field field, Object object) {
        return field.getValue(object, null);
    }

    public String getProperty() {
        return this.property;
    }

    public String getReferencedObjectProperty() {
        return this.referencedObjectProperty;
    }

    public void setReferencedObjectProperty(String string) {
        this.referencedObjectProperty = string;
    }

    public String getReferencedIdProperty() {
        return this.referencedIdProperty;
    }

    public void setReferencedIdProperty(String string) {
        this.referencedIdProperty = string;
    }

    public Object getValueFromProperty(Object object) {
        if (this.property == null) {
            return null;
        }
        try {
            return PropertyUtils.getProperty(object, this.property);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public Object getReferencedObject(Object object) {
        if (this.referencedObjectProperty == null) {
            return null;
        }
        try {
            return PropertyUtils.getProperty(object, this.referencedObjectProperty);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public Long getReferencedId(Object object) {
        Long l2 = null;
        if (this.referencedIdProperty != null) {
            try {
                l2 = (Long)PropertyUtils.getProperty(object, this.referencedIdProperty);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return l2;
    }

    public boolean isLink() {
        return this.referencedObjectProperty != null || this.referencedIdProperty != null;
    }

    public boolean isMemo() {
        return this.memo;
    }

    public void setMemo(boolean bl) {
        this.memo = bl;
    }

    public boolean isNameField() {
        return this.nameField;
    }

    public void setNameField(boolean bl) {
        this.nameField = bl;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public boolean isStandardType() {
        boolean bl = this.isDuration() || this.isRate() || this.hasOptions() || this.isMoney();
        return !bl;
    }

    public final boolean isDynamicOptions() {
        return this.dynamicOptions;
    }

    public final void setDynamicOptions(boolean bl) {
        this.dynamicOptions = bl;
    }

    public void copyData(Object object, Object object2) {
        if (this.isReadOnly(object, null)) {
            return;
        }
        Object object3 = this.getValue(object2, null);
        this.setValue(object, null, object3);
    }

    public static void copyData(Collection collection, Object object, Object object2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((Field)iterator.next()).copyData(object, object2);
        }
    }

    public static void copyData(Object object, Map map) throws FieldParseException {
        for (String string : map.keySet()) {
            FieldContext fieldContext;
            Field field = Configuration.getFieldFromId(string);
            if (field.isReadOnly(object, fieldContext = field.specialFieldContext)) continue;
            Object v2 = map.get(string);
            if (v2 instanceof String) {
                field.setText(object, (String)map.get(string), fieldContext);
                continue;
            }
            field.setValue(object, v2, fieldContext);
        }
    }

    public static void copyData(Map map, Object object, Collection collection) {
        FieldContext fieldContext = null;
        for (Field field : collection) {
            fieldContext = field.specialFieldContext;
            String string = field.getText(object, fieldContext);
            map.put(field.getId(), string);
        }
    }

    public final boolean isHasToolTip() {
        return this.hasToolTip;
    }

    public final void setHasToolTip(boolean bl) {
        this.hasToolTip = bl;
    }

    public final boolean isMap() {
        return this.map;
    }

    public final String getExtraCategory() {
        return this.extraCategory;
    }

    public final void setExtraCategory(String string) {
        this.extraCategory = string;
    }

    public boolean isExtra() {
        return this.extraCategory != null;
    }

    public Object convertValueForExport(Object object) {
        if (object instanceof Duration) {
            object = ((Duration)object).getAsDays();
        }
        return object;
    }

    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(String string) {
        this.url = string;
    }

    public final boolean isHyperlink() {
        return this.getUrl() != null;
    }

    public final boolean isValidOnObjectCreate() {
        return this.validOnObjectCreate;
    }

    public final void setValidOnObjectCreate(boolean bl) {
        this.validOnObjectCreate = bl;
    }

    public final boolean isDirtiesWholeDocument() {
        return this.dirtiesWholeDocument;
    }

    public final void setDirtiesWholeDocument(boolean bl) {
        this.dirtiesWholeDocument = bl;
    }

    public final String getAction() {
        return this.action;
    }

    public final void setAction(String string) {
        this.action = string;
    }

    public void invokeAction(Object object) {
        if (this.action == null || object == null) {
            return;
        }
        Object object2 = this.getValue(object, null);
        if (object2 instanceof Hyperlink) {
            ((Hyperlink)object2).invoke();
        }
    }

    public final boolean isImage() {
        return this.image;
    }

    public final void setImage(boolean bl) {
        this.image = bl;
    }

    public String dump() {
        return ToStringBuilder.reflectionToString(this);
    }

    public FieldContext getSpecialFieldContext() {
        return this.specialFieldContext;
    }

    public void setSpecialFieldContext(FieldContext fieldContext) {
        this.specialFieldContext = fieldContext;
    }

    public Comparator getComparator(boolean bl) {
        if (bl) {
            return this;
        }
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return Field.this.compare(object2, object);
            }
        };
    }

    public boolean isComparable() {
        return !this.isImage();
    }

    public OptionsFilter getFilter() {
        return this.filter;
    }

    public void setFilter(OptionsFilter optionsFilter) {
        this.filter = optionsFilter;
    }

    public FieldAccessible getAccessControl() {
        return this.accessControl;
    }

    public void setAccessControl(FieldAccessible fieldAccessible) {
        this.accessControl = fieldAccessible;
    }

    public boolean isAuthorized(int n2) {
        return this.accessControl == null || this.accessControl.isAuthorized(n2);
    }

    public boolean isGraphical() {
        return this.graphical;
    }

    public void setGraphical(boolean bl) {
        this.graphical = bl;
    }

    public String getLookupTypes() {
        return this.lookupTypes;
    }

    public void setLookupTypes(String string) {
        this.lookupTypes = string;
    }

    public boolean isServer() {
        return this.server;
    }

    public void setServer(boolean bl) {
        this.server = bl;
    }

    public static String getMetadataStringHeader() {
        return "Name\tId (for API)\tAPI type\tPOD type\tRead Only\tNotes";
    }

    public String getMetadataString() {
        String string = this.getName() + "\t" + this.getIdWithoutPrefix() + "\t" + this.internalTypeName() + "\t" + this.typeName() + "\t" + this.isReadOnly() + "\t";
        if (this.hasDynamicSelect()) {
            string = string + "Choices are dynamic";
        } else if (this.select != null) {
            string = string + this.select.documentOptions();
        }
        return string;
    }

    public boolean isStartValue() {
        return this.startValue;
    }

    public void setStartValue(boolean bl) {
        this.startValue = bl;
    }

    public boolean isEndValue() {
        return this.endValue;
    }

    public void setEndValue(boolean bl) {
        this.endValue = bl;
    }

    public boolean isDateOnly() {
        return this.dateOnly;
    }

    public void setDateOnly(boolean bl) {
        this.dateOnly = bl;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String string) {
        this.help = string;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean bl) {
        this.custom = bl;
    }

    public String getSummaryType() {
        if (this.isStartValue()) {
            return "min";
        }
        if (this.isEndValue()) {
            return "max";
        }
        int n2 = this.getGroupSummary();
        if (n2 == -1) {
            n2 = this.getSummary();
        }
        switch (n2) {
            case 3: {
                return "sum";
            }
            case 2: 
            case 6: 
            case 7: {
                return "count";
            }
            case 4: 
            case 5: {
                return "average";
            }
        }
        return null;
    }
}

