/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core;

import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeFactory;
import com.projity.grouping.core.OutlineCollection;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelDataFactory;
import com.projity.grouping.core.model.NodeModelFactory;

public class OutlineCollectionImpl
implements OutlineCollection {
    private int currentOutline = 0;
    private NodeModelDataFactory dataFactory = null;
    private NodeModel[] outlines;

    public OutlineCollectionImpl(int n2, NodeModelDataFactory nodeModelDataFactory) {
        this.outlines = new NodeModel[n2];
        this.dataFactory = nodeModelDataFactory;
    }

    public NodeModel getOutline() {
        return this.getOutline(this.currentOutline);
    }

    public NodeModel getDefaultOutline() {
        return this.getOutline(0);
    }

    public NodeModel getOutline(int n2) {
        NodeModel nodeModel = this.outlines[n2];
        if (nodeModel == null && n2 == 0) {
            this.outlines[n2] = nodeModel = NodeModelFactory.getInstance().createNodeModel(this.dataFactory);
            if (this.dataFactory != null) {
                this.dataFactory.initOutline(nodeModel);
                nodeModel.setUndoController(this.dataFactory.getUndoController());
            }
        }
        return nodeModel;
    }

    public NodeModel[] getOutlines() {
        return this.outlines;
    }

    public int getCurrentOutline() {
        return this.currentOutline;
    }

    public void setCurrentOutline(int n2) {
        this.currentOutline = n2;
    }

    public void addToDefaultOutline(Node node, Node node2) {
        this.getDefaultOutline().add(node, node2, 0);
    }

    public void addToDefaultOutline(Node node, Node node2, int n2, boolean bl) {
        this.getDefaultOutline().add(node, node2, n2, bl ? 1 : 0);
    }

    public void addToAll(Object object, NodeModel nodeModel) {
        for (int i2 = 0; i2 < this.outlines.length; ++i2) {
            if (this.outlines[i2] == null || this.outlines[i2] == nodeModel || this.outlines[i2].search(object) != null) continue;
            this.outlines[i2].add(NodeFactory.getInstance().createNode(object), 0);
        }
    }

    public void removeFromAll(Object object, NodeModel nodeModel) {
        for (int i2 = 0; i2 < this.outlines.length; ++i2) {
            Node node;
            if (this.outlines[i2] == null || this.outlines[i2] == nodeModel || (node = this.outlines[i2].search(object)) == null) continue;
            this.outlines[i2].remove(node, 0);
        }
    }
}

