/*
 * Decompiled with CFR 0.152.
 */
package com.projity.options;

import com.projity.datatype.Duration;
import com.projity.util.DateTime;
import java.io.Serializable;
import java.util.GregorianCalendar;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CalendarOption
implements Serializable {
    private static final long serialVersionUID = -6714103946319228798L;
    private static CalendarOption instance = null;
    private static CalendarOption defaultInstance = null;
    int weekStartsOn = 1;
    int fiscalYearStartsIn = 0;
    int defaultStartHour = 8;
    int defaultEndHour = 17;
    GregorianCalendar defaultStartTime = DateTime.calendarInstance();
    GregorianCalendar defaultEndTime = DateTime.calendarInstance();
    double hoursPerDay = 8.0;
    double hoursPerWeek = 40.0;
    double daysPerMonth = 20.0;
    long defaultDuration = Duration.setAsEstimated((long)(3600000.0 * this.hoursPerDay), true);
    boolean addedCalendarTimeIsNonStop = false;

    public final boolean isAddedCalendarTimeIsNonStop() {
        return this.addedCalendarTimeIsNonStop;
    }

    public final void setAddedCalendarTimeIsNonStop(boolean bl) {
        this.addedCalendarTimeIsNonStop = bl;
    }

    public static CalendarOption getInstance() {
        if (instance == null) {
            instance = new CalendarOption();
        }
        return instance;
    }

    public static CalendarOption getNewInstance() {
        return new CalendarOption();
    }

    public static CalendarOption getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new CalendarOption();
        }
        return defaultInstance;
    }

    public static final void setInstance(CalendarOption calendarOption) {
        instance = calendarOption;
    }

    private CalendarOption() {
        this.defaultStartTime.set(11, this.defaultStartHour);
        this.defaultStartTime.set(12, 0);
        this.defaultStartTime.set(13, 0);
        this.defaultStartTime.set(14, 0);
        this.defaultEndTime.set(11, this.defaultEndHour);
        this.defaultEndTime.set(12, 0);
        this.defaultEndTime.set(13, 0);
        this.defaultEndTime.set(14, 0);
    }

    public double getFractionOfDayThatIsWorking() {
        return this.hoursPerDay / 24.0;
    }

    public double getDaysPerMonth() {
        return this.daysPerMonth;
    }

    public void setDaysPerMonth(double d2) {
        this.daysPerMonth = d2;
    }

    public long getMillisPerDay() {
        return (long)(3600000.0 * this.hoursPerDay);
    }

    public int getFiscalYearStartsIn() {
        return this.fiscalYearStartsIn;
    }

    public void setFiscalYearStartsIn(int n2) {
        this.fiscalYearStartsIn = n2;
    }

    public double getHoursPerDay() {
        return this.hoursPerDay;
    }

    public void setHoursPerDay(double d2) {
        this.hoursPerDay = d2;
        this.defaultDuration = Duration.setAsEstimated((long)(3600000.0 * d2), true);
    }

    public double getHoursPerWeek() {
        return this.hoursPerWeek;
    }

    public void setHoursPerWeek(double d2) {
        this.hoursPerWeek = d2;
    }

    public int getWeekStartsOn() {
        return this.weekStartsOn;
    }

    public void setWeekStartsOn(int n2) {
        this.weekStartsOn = n2;
    }

    public double hoursPerMonth() {
        return this.hoursPerDay * this.daysPerMonth;
    }

    public GregorianCalendar getDefaultEndTime() {
        return this.defaultEndTime;
    }

    public void setDefaultEndTime(GregorianCalendar gregorianCalendar) {
        this.defaultEndTime = gregorianCalendar;
    }

    public GregorianCalendar getDefaultStartTime() {
        return this.defaultStartTime;
    }

    public void setDefaultStartTime(GregorianCalendar gregorianCalendar) {
        this.defaultStartTime = gregorianCalendar;
    }

    public long makeValidStart(long l2, boolean bl) {
        l2 = DateTime.minuteFloor(l2);
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(l2);
        int n2 = gregorianCalendar.get(1);
        int n3 = gregorianCalendar.get(6);
        if (bl || gregorianCalendar.get(11) == 0 && gregorianCalendar.get(12) == 0) {
            gregorianCalendar.set(11, this.getDefaultStartTime().get(11));
            gregorianCalendar.set(12, this.getDefaultStartTime().get(12));
            gregorianCalendar.set(1, n2);
            gregorianCalendar.set(6, n3);
        }
        return gregorianCalendar.getTimeInMillis();
    }

    public long makeValidEnd(long l2, boolean bl) {
        l2 = DateTime.minuteFloor(l2);
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(l2);
        if (bl || gregorianCalendar.get(11) == 0 && gregorianCalendar.get(12) == 0) {
            gregorianCalendar.set(11, this.getDefaultEndTime().get(11));
            gregorianCalendar.set(12, this.getDefaultEndTime().get(12));
        }
        return gregorianCalendar.getTimeInMillis();
    }

    public long getDefaultDuration() {
        return this.defaultDuration;
    }

    public void setDefaultDuration(long l2) {
        this.defaultDuration = l2;
    }

    public final int getDefaultEndHour() {
        return this.defaultEndHour;
    }

    public final void setDefaultEndHour(int n2) {
        this.defaultEndHour = n2;
    }

    public final int getDefaultStartHour() {
        return this.defaultStartHour;
    }

    public final void setDefaultStartHour(int n2) {
        this.defaultStartHour = n2;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

