/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.criticalpath;

import com.projity.association.AssociationList;
import com.projity.datatype.Duration;
import com.projity.grouping.core.Node;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.SubProj;
import com.projity.pm.task.Task;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class TaskSchedule
implements Cloneable {
    public static final int CURRENT = 0;
    public static final int EARLY = -1;
    public static final int LATE = 1;
    private double percentComplete = 0.0;
    private long rawDuration;
    private long start;
    private long finish;
    private Task task;
    private int type;
    private boolean forward = true;
    private long dependencyDate = -1L;
    private long remainingDependencyDate = 0L;

    public TaskSchedule() {
    }

    public TaskSchedule(Task task, int n2) {
        this.init(task, n2);
        this.start = 0L;
        this.finish = 0L;
    }

    public void init(Task task, int n2) {
        this.task = task;
        this.type = n2;
        if (n2 == -1) {
            this.forward = true;
        } else if (n2 == 1) {
            this.forward = false;
        }
        this.dependencyDate = -1L;
        this.invalidate();
    }

    public void initSerialized(Task task, int n2) {
        this.task = task;
        this.type = n2;
        if (n2 == -1) {
            this.forward = true;
        } else if (n2 == 1) {
            this.forward = false;
        }
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeDouble(this.percentComplete);
        objectOutputStream.writeLong(this.rawDuration);
        objectOutputStream.writeLong(this.start);
        objectOutputStream.writeLong(this.finish);
    }

    public static TaskSchedule deserialize(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        TaskSchedule taskSchedule = new TaskSchedule();
        taskSchedule.setPercentComplete(objectInputStream.readDouble());
        taskSchedule.setRawDuration(objectInputStream.readLong());
        taskSchedule.setStart(objectInputStream.readLong());
        taskSchedule.setFinish(objectInputStream.readLong());
        return taskSchedule;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object cloneWithTask(Task task) {
        TaskSchedule taskSchedule = (TaskSchedule)this.clone();
        taskSchedule.setTask(task);
        taskSchedule.invalidate();
        return taskSchedule;
    }

    public long getBegin() {
        return this.forward ? this.start : -this.finish;
    }

    public long getEnd() {
        return this.forward ? this.finish : -this.start;
    }

    public long getWindowBegin() {
        return this.forward ? this.task.getWindowEarlyStart() : -this.task.getWindowLateFinish();
    }

    public long getWindowEnd() {
        return this.forward ? this.task.getWindowEarlyFinish() : -this.task.getWindowLateStart();
    }

    public void setBegin(long l2) {
        if (this.forward) {
            this.start = l2;
        } else {
            this.finish = -l2;
        }
    }

    public void setEnd(long l2) {
        if (this.forward) {
            this.finish = l2;
        } else {
            this.start = -l2;
        }
    }

    public long getBeginDependency() {
        if (this.dependencyDate == -1L) {
            this.dependencyDate = this.calcDependencyDate();
        }
        return this.dependencyDate;
    }

    public final void invalidate() {
        if (this.task != null && this.task.isSubproject() && !((SubProj)((Object)this.task)).isValidAndOpen()) {
            return;
        }
        this.start = 0L;
        this.finish = 0L;
        this.dependencyDate = -1L;
    }

    public void copyDatesAfterClone(TaskSchedule taskSchedule) {
        this.start = taskSchedule.start;
        this.finish = taskSchedule.finish;
        this.dependencyDate = taskSchedule.dependencyDate;
    }

    final void invalidateDependencyDate() {
        this.dependencyDate = -1L;
    }

    public final double getPercentComplete() {
        return this.percentComplete;
    }

    public final void setPercentComplete(double d2) {
        this.percentComplete = d2;
    }

    public final long getRawDuration() {
        return this.rawDuration;
    }

    public final void setRawDuration(long l2) {
        this.rawDuration = l2;
    }

    private final boolean isLate() {
        return this.type == 1;
    }

    public final long getDependencyDate() {
        return this.dependencyDate;
    }

    public final void setDependencyDate(long l2) {
        this.dependencyDate = l2;
    }

    public final long getFinish() {
        return this.finish;
    }

    public final void setFinish(long l2) {
        this.finish = l2;
    }

    public final long getStart() {
        return this.start;
    }

    public final void setStart(long l2) {
        this.start = l2;
    }

    public TaskSchedule getOppositeSchedule() {
        return this.task.getSchedule(this.forward ? 1 : -1);
    }

    public final boolean isForward() {
        return this.forward;
    }

    public void setForward(boolean bl) {
        if (this.forward != bl) {
            this.forward = bl;
            long l2 = this.start;
            this.start = -this.finish;
            this.finish = -l2;
            this.dependencyDate = -this.dependencyDate;
            this.remainingDependencyDate = -this.remainingDependencyDate;
        }
    }

    public final void setRemainingDependencyDate(long l2) {
        this.remainingDependencyDate = l2;
    }

    public final long getRemainingDependencyDate() {
        return this.remainingDependencyDate;
    }

    final boolean affectsCriticalPath(CalculationContext calculationContext) {
        if (this.task.isOrWasCritical()) {
            return true;
        }
        this.calcStartAndFinish(calculationContext);
        long l2 = this.getEnd();
        long l3 = -this.getOppositeSchedule().getBegin();
        return l3 < l2;
    }

    final void calcDates(CalculationContext calculationContext) {
        Cloneable cloneable;
        long l2 = this.getBegin();
        long l3 = this.getEnd();
        long l4 = 0L;
        long l5 = 0L;
        boolean bl = this.task.isSubproject() && !((SubProj)((Object)this.task)).isValidAndOpen();
        boolean bl2 = this.task.isExternal();
        if (!bl2 && !bl) {
            if (calculationContext.taskReferenceType == 1) {
                this.assignDatesFromChildren(calculationContext);
            } else {
                this.calcStartAndFinish(calculationContext);
            }
            l4 = this.getBegin();
            l5 = this.getEnd();
            boolean bl3 = this.task.isReverseScheduled();
            if (!calculationContext.earlyOnly && bl3) {
                cloneable = this.getOppositeSchedule();
                l4 = -((TaskSchedule)cloneable).getEnd();
                l5 = -((TaskSchedule)cloneable).getBegin();
            }
            if (calculationContext.assign && !bl) {
                cloneable = this.task.getCurrentSchedule();
                if (l4 < 0L) {
                    ((TaskSchedule)cloneable).setStart(-l5);
                    ((TaskSchedule)cloneable).setFinish(-l4);
                    ((TaskSchedule)cloneable).setRemainingDependencyDate(-this.remainingDependencyDate);
                } else {
                    ((TaskSchedule)cloneable).setStart(l4);
                    ((TaskSchedule)cloneable).setFinish(l5);
                    ((TaskSchedule)cloneable).setRemainingDependencyDate(this.remainingDependencyDate);
                }
                ((TaskSchedule)cloneable).setDependencyDate(this.dependencyDate);
                if (calculationContext.taskReferenceType == 1) {
                    super.updateDurationFromDates();
                    ((NormalTask)((TaskSchedule)cloneable).task).assignActualDatesFromChildren();
                }
            }
        } else if (bl2) {
            TaskSchedule taskSchedule = this.task.getCurrentSchedule();
            l4 = taskSchedule.getBegin();
            l5 = taskSchedule.getEnd();
            l2 = 0L;
        }
        if (l2 == l4 && l3 == l5 && !bl) {
            return;
        }
        if (bl) {
            l4 = l2;
            l5 = l3;
        }
        AssociationList associationList = this.task.getDependencyList(!this.forward);
        cloneable = this.task.getWbsParentTask();
        TaskSchedule taskSchedule = null;
        long l6 = 0L;
        if (cloneable != null) {
            taskSchedule = ((Task)cloneable).getSchedule(this.type);
            l6 = taskSchedule.getEnd();
        }
        if (calculationContext.taskReferenceType == -1) {
            if (l2 != l4) {
                this.flagChildren();
                this.setDependencyDate(l4);
                if (l6 == l3) {
                    this.setEnd(-1L);
                } else {
                    this.setEnd(0L);
                }
            }
            return;
        }
        if (associationList.isEmpty()) {
            Dependency dependency;
            if (!this.task.isExternal() && this.task != calculationContext.sentinel && (dependency = (Dependency)calculationContext.sentinel.getDependencyList(this.forward).find(this.forward, this.task)) != null) {
                dependency.calcDependencyDate(this.forward, l4, l5, false);
                calculationContext.sentinel.setCalculationStateCount(calculationContext.stateCount);
                calculationContext.sentinel.getSchedule(this.type).setDependencyDate(-1L);
            }
        } else {
            for (Dependency dependency : associationList) {
                if (dependency.isDisabled()) continue;
                Task task = (Task)dependency.getTask(!this.forward);
                TaskSchedule taskSchedule2 = task.getSchedule(this.type);
                long l7 = task.getDependencyList(this.forward).size();
                long l8 = l4;
                if (l7 > 0L) {
                    boolean bl4 = !task.isWbsParent() && task.hasDuration();
                    l8 = dependency.calcDependencyDate(this.forward, l4, l5, bl4);
                    if (l7 > 1L) {
                        l8 = -1L;
                    }
                }
                taskSchedule2.setDependencyDate(l8);
                task.setCalculationStateCount(calculationContext.stateCount);
            }
        }
        if (cloneable != null && ((Task)cloneable).getCalculationStateCount() != calculationContext.stateCount) {
            long l9 = taskSchedule.getBegin();
            if (l3 == 0L || l3 == -1L) {
                ((Task)cloneable).setCalculationStateCount(calculationContext.stateCount);
            } else if (l3 != l5 && (l5 > l6 || l3 == l6) || l2 != l4 && (l4 < l9 || l2 == l9)) {
                ((Task)cloneable).setCalculationStateCount(calculationContext.stateCount);
            }
        }
        if (calculationContext.pass == 1) {
            this.task.setCalculationStateCount(calculationContext.stateCount + 1);
        }
    }

    private void flagChildren() {
        int n2 = this.task.getCalculationStateCount();
        Collection collection = this.task.getWbsChildrenNodes();
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = ((Node)iterator.next()).getImpl();
            if (!(object instanceof Task)) continue;
            ((Task)object).setCalculationStateCount(n2);
        }
    }

    private void updateDurationFromDates() {
        this.setRawDuration(this.task.getEffectiveWorkCalendar().compare(this.getFinish(), this.getStart(), false));
    }

    public void assignDatesFromChildren(CalculationContext calculationContext) {
        long l2;
        Collection collection = this.task.getWbsChildrenNodes();
        if (collection == null) {
            return;
        }
        long l3 = Long.MAX_VALUE;
        long l4 = Long.MIN_VALUE;
        Iterator iterator = collection.iterator();
        boolean bl = false;
        int n2 = this.type;
        if (calculationContext != null && calculationContext.pass == 3) {
            n2 = 0;
        }
        while (iterator.hasNext()) {
            long l5;
            Object object = ((Node)iterator.next()).getImpl();
            if (!(object instanceof NormalTask)) continue;
            NormalTask normalTask = (NormalTask)object;
            bl |= normalTask.isEstimated();
            TaskSchedule taskSchedule = normalTask.getSchedule(n2);
            l2 = taskSchedule.getBegin();
            if (l2 != 0L) {
                l3 = Math.min(l3, l2);
            }
            if ((l5 = taskSchedule.getEnd()) == 0L) continue;
            l4 = Math.max(l4, l5);
        }
        if (l3 == Long.MAX_VALUE || l3 == 0L) {
            return;
        }
        this.setBegin(l3);
        if (l4 == Long.MIN_VALUE || l4 == 0L) {
            return;
        }
        this.setEnd(l4);
        l2 = this.task.getEffectiveWorkCalendar().compare(l4, l3, false);
        l2 = Duration.setAsEstimated(l2, bl);
        ((NormalTask)this.task).setEstimated(bl);
        this.setRawDuration(l2);
    }

    long calcDependencyDate() {
        long l2 = 0L;
        AssociationList associationList = this.task.getDependencyList(this.forward);
        for (Dependency dependency : associationList) {
            if (dependency.isDisabled()) continue;
            long l3 = dependency.getDate(this.forward);
            if (l2 == 0L) {
                l2 = l3;
                continue;
            }
            l2 = Math.max(l2, l3);
        }
        this.setDependencyDate(l2);
        return l2;
    }

    private void calcStartAndFinish(CalculationContext calculationContext) {
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        boolean bl;
        long l7 = this.getBeginDependency();
        Task task = this.task.getWbsParentTask();
        boolean bl2 = bl = !this.task.hasDuration();
        if (task != null) {
            TaskSchedule taskSchedule = task.getSchedule(this.type);
            long l8 = taskSchedule.getBeginDependency();
            long l9 = taskSchedule.getWindowBegin();
            if (l8 == 0L || l9 != 0L && l9 > l8) {
                l8 = l9;
            }
            if (l8 != 0L && (l7 == 0L || l8 > l7)) {
                l7 = this.task.getEffectiveWorkCalendar().add(l8, 0L, bl);
            }
        }
        if (this.task.isInSubproject()) {
            l7 = Math.max(l7, calculationContext.forward ? this.task.getOwningProject().getStartConstraint() : -this.task.getOwningProject().getEnd());
        }
        if ((l6 = this.getWindowBegin()) != 0L) {
            if (l7 == 0L) {
                l7 = l6;
            } else if (l6 < l7) {
                if (this.task.startsBeforeProject()) {
                    l7 = l6;
                }
            } else {
                l7 = l6;
            }
        }
        if ((l5 = this.getWindowEnd()) != 0L) {
            if (l7 == 0L) {
                l7 = Long.MIN_VALUE;
            }
            l7 = Math.max(l7, this.task.calcOffsetFrom(l5, l5, false, false, bl));
        }
        if (calculationContext.honorRequiredDates) {
            l4 = -this.getOppositeSchedule().getWindowBegin();
            if (l4 != 0L) {
                if (l7 == 0L) {
                    l7 = Long.MAX_VALUE;
                }
                l7 = Math.min(l7, this.task.calcOffsetFrom(l4, this.dependencyDate, false, false, bl));
            }
            if ((l3 = -this.getOppositeSchedule().getWindowEnd()) != 0L) {
                if (l7 == 0L) {
                    l7 = Long.MAX_VALUE;
                }
                l7 = Math.min(l7, l3);
            }
        }
        if (l7 == 0L && !this.task.isWbsParent()) {
            l7 = calculationContext.boundary;
        }
        if (this.task.isSubproject()) {
            SubProj subProj = (SubProj)((Object)this.task);
            if (!subProj.isValidAndOpen()) {
                return;
            }
            if (this.task.getPredecessorList().size() == 0 && this.task.getConstraintDate() == 0L) {
                return;
            }
            l7 = Math.max(l7, calculationContext.forward ? subProj.getSubproject().getStartConstraint() : -subProj.getSubproject().getEnd());
        }
        if (Duration.millis(l4 = this.task.getLevelingDelay()) != 0L) {
            l7 = this.task.getEffectiveWorkCalendar().add(l7, l4, bl);
        }
        l3 = l7;
        if (this.forward == calculationContext.forward) {
            this.setRemainingDependencyDate(l3);
        }
        if (calculationContext.forward && (l2 = this.task.getActualStart()) != 0L) {
            l7 = l2;
        }
        this.setBegin(l7);
        l2 = this.task.calcOffsetFrom(l7, l3, true, true, true);
        this.setEnd(l2);
    }

    public void dump() {
        System.out.println("Task " + this.task + " schedule " + this.type + " start " + new Date(this.start) + " finish " + new Date(this.finish));
    }

    public String toString() {
        return "Task " + this.task + " schedule " + this.type + " begin " + new Date(this.getBegin()) + " end " + new Date(this.getEnd()) + " start " + new Date(this.start) + " finish " + new Date(this.finish);
    }

    public static Date d(long l2) {
        return new Date(Math.abs(l2));
    }

    static class CalculationContext {
        int stateCount;
        boolean forward;
        boolean honorRequiredDates;
        Task sentinel;
        int taskReferenceType;
        long boundary;
        boolean earlyOnly;
        boolean assign;
        int scheduleType;
        int pass;

        CalculationContext() {
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }
    }
}

