/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.network;

import com.projity.pm.graphic.graph.GraphRenderer;
import com.projity.pm.graphic.graph.GraphUI;
import com.projity.pm.graphic.graph.GraphZone;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.network.Network;
import com.projity.pm.graphic.network.NetworkRenderer;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.util.List;
import java.util.ListIterator;

public abstract class NetworkUI
extends GraphUI {
    public NetworkUI(Network network, GraphRenderer graphRenderer) {
        super(network, graphRenderer);
    }

    public int getZoom() {
        return ((Network)this.getGraph()).getZoom();
    }

    void resetForms() {
        ((NetworkRenderer)this.graphRenderer).resetForms();
    }

    public boolean isEditing(GraphicNode graphicNode) {
        return ((NetworkRenderer)this.graphRenderer).getEditor().isEditing(graphicNode);
    }

    public void editNode(GraphicNode graphicNode) {
        ((NetworkRenderer)this.graphRenderer).getEditor().initEditorComponent(graphicNode, this.getZoom(), graphicNode == null ? null : ((NetworkRenderer)this.graphRenderer).getBounds(graphicNode));
    }

    public List getEditorChange() {
        return ((NetworkRenderer)this.graphRenderer).getEditor().getCellEditorChange();
    }

    public GraphicNode getEditorNode() {
        return ((NetworkRenderer)this.graphRenderer).getEditor().getNode();
    }

    public GraphZone getNodeAt(double d2, double d3) {
        ListIterator listIterator = this.graph.getModel().getNodeIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator.next();
            GeneralPath generalPath = ((NetworkRenderer)this.graphRenderer).getShape(graphicNode);
            if (generalPath == null || !generalPath.contains(d2, d3)) continue;
            return graphicNode == null ? null : new GraphZone(graphicNode);
        }
        return null;
    }

    public boolean isOnBarEdge(GraphicNode graphicNode, double d2, double d3) {
        double d4 = this.config.getNetworkCellSelectionSquare();
        GeneralPath generalPath = ((NetworkRenderer)this.graphRenderer).getShape(graphicNode);
        double d5 = -1.0;
        double d6 = -1.0;
        double d7 = -1.0;
        double d8 = -1.0;
        PathIterator pathIterator = generalPath.getPathIterator(null);
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(this.segment);
            switch (n2) {
                case 0: {
                    d7 = this.segment[0];
                    d8 = this.segment[1];
                    d5 = d7;
                    d6 = d8;
                }
                case 1: 
                case 4: {
                    double d9 = n2 == 4 ? d7 : this.segment[0];
                    double d10 = n2 == 4 ? d8 : this.segment[1];
                    if (!(Line2D.ptSegDist(d5, d6, d9, d10, d2, d3) <= d4)) break;
                    return true;
                }
            }
            d5 = this.segment[0];
            d6 = this.segment[1];
            pathIterator.next();
        }
        return false;
    }

    public void updateShapes() {
    }
}

