/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.network.rendering;

import com.projity.graphic.configuration.BarFormat;
import com.projity.grouping.core.Node;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.network.rendering.FormComponent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Closure;

public class FormatSelector {
    protected List selectedFormats;
    protected GraphParams params;
    protected Map formMap = new HashMap();
    FormatSelectionFunctor selectionFunctor = new FormatSelectionFunctor();

    public FormatSelector(GraphParams graphParams) {
        this.params = graphParams;
        this.selectedFormats = new LinkedList();
    }

    void selectFormats(GraphicNode graphicNode) {
        Node node = graphicNode.getNode();
        Object object = node.getImpl();
        this.selectionFunctor.initialize();
        this.params.getBarStyles().apply(object, this.selectionFunctor);
    }

    private FormComponent getForm(BarFormat barFormat, int n2, boolean bl) {
        FormComponent formComponent = (FormComponent)this.formMap.get(barFormat.getId());
        if (formComponent == null) {
            formComponent = new FormComponent(this.selectedFormats, n2, bl, this.params.useTextures());
            this.formMap.put(barFormat.getId(), formComponent);
        }
        return formComponent;
    }

    FormComponent getForm(int n2, boolean bl) {
        if (this.selectedFormats.size() == 0) {
            return null;
        }
        BarFormat barFormat = (BarFormat)this.selectedFormats.get(0);
        return this.getForm(barFormat, n2, bl);
    }

    public FormComponent getForm(GraphicNode graphicNode, int n2, boolean bl) {
        this.selectFormats(graphicNode);
        return this.getForm(n2, bl);
    }

    public void resetForms() {
        this.formMap.clear();
    }

    private class FormatSelectionFunctor
    implements Closure {
        private FormatSelectionFunctor() {
        }

        void initialize() {
            FormatSelector.this.selectedFormats.clear();
        }

        public void execute(Object object) {
            BarFormat barFormat = (BarFormat)object;
            if (!barFormat.isMain()) {
                return;
            }
            FormatSelector.this.selectedFormats.add(barFormat);
        }
    }
}

