/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet;

import com.projity.association.InvalidAssociationException;
import com.projity.datatype.Duration;
import com.projity.field.Field;
import com.projity.field.FieldParseException;
import com.projity.graphic.configuration.ActionList;
import com.projity.graphic.configuration.CellStyle;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.model.NodeModel;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.dependency.DependencyService;
import com.projity.pm.dependency.DependencyType;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.spreadsheet.SpreadSheetColumnModel;
import com.projity.pm.graphic.spreadsheet.SpreadSheetUtils;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheetModel;
import com.projity.util.ClassUtils;
import com.projity.util.Environment;
import java.util.LinkedList;

public class SpreadSheetModel
extends CommonSpreadSheetModel {
    protected boolean readOnly;

    public SpreadSheetModel(NodeModelCache nodeModelCache, SpreadSheetColumnModel spreadSheetColumnModel, CellStyle cellStyle, ActionList actionList) {
        super(nodeModelCache, spreadSheetColumnModel, cellStyle, actionList);
    }

    public int getColumnCount() {
        return this.colModel.getFieldColumnCount();
    }

    public Field getFieldInColumn(int n2) {
        return SpreadSheetUtils.getFieldInColumn(n2, this.colModel);
    }

    public Field getFieldInNonTranslatedColumn(int n2) {
        return this.colModel.getFieldInNonTranslatedColumn(n2);
    }

    public Object getValueAt(int n2, int n3) {
        return SpreadSheetUtils.getValueAt(n2, n3, this.getRowMultiple(), this.cache, this.colModel, this.fieldContext);
    }

    public String getColumnName(int n2) {
        if (n2 == 0) {
            return "";
        }
        return this.getFieldInColumn(n2).getName();
    }

    public void setValueAt(Object object, int n2, int n3) {
        if (this.isReadOnly()) {
            return;
        }
        if (n3 == 0) {
            return;
        }
        Field field = this.getFieldInColumn(n3);
        boolean bl = "Field.userRole".equals(field.getId());
        NodeModel nodeModel = this.getCache().getModel();
        if (!(nodeModel.isLocal() || nodeModel.isMaster() || Environment.getStandAlone() || bl)) {
            return;
        }
        Object object2 = this.getValueAt(n2, n3);
        if (object2 == null && "".equals(object)) {
            return;
        }
        Node node = this.getNodeInRow(n2);
        try {
            if (node.isVoid()) {
                if (object == null) {
                    this.getCache().getModel().setFieldValue(field, node, this, object, this.fieldContext, 3);
                } else {
                    Node node2;
                    LinkedList linkedList = this.getPreviousVisibleNodesFromRow(n2);
                    if (linkedList != null && (node2 = this.getNextNonVoidSiblingFromRow(n2)) != null && node2.getParent() == linkedList.getFirst()) {
                        linkedList = null;
                    }
                    this.getCache().getModel().replaceImplAndSetFieldValue(node, linkedList, this.getFieldInColumn(n3), this, object, this.fieldContext, 3);
                }
            } else if (node.getImpl() instanceof Dependency) {
                Dependency dependency = (Dependency)node.getImpl();
                DependencyService dependencyService = DependencyService.getInstance();
                try {
                    Duration duration = (Duration)(n3 == 4 ? object : this.getValueAt(n2, 4));
                    int n4 = DependencyType.mapStringToValue((String)(n3 == 3 ? object : this.getValueAt(n2, 3)));
                    dependencyService.setFields(dependency, duration.getEncodedMillis(), n4, this);
                    dependencyService.update(dependency, this);
                }
                catch (InvalidAssociationException invalidAssociationException) {
                    invalidAssociationException.printStackTrace();
                }
            } else {
                this.getCache().getModel().setFieldValue(field, node, this, object, this.fieldContext, 3);
            }
        }
        catch (FieldParseException fieldParseException) {
            throw new RuntimeException(fieldParseException);
        }
    }

    public boolean isRowEditable(int n2) {
        if (this.isReadOnly()) {
            return false;
        }
        NodeModel nodeModel = this.getCache().getModel();
        Node node = this.getNodeInRow(n2);
        if (node.isVoid()) {
            return true;
        }
        return !ClassUtils.isObjectReadOnly(node.getImpl());
    }

    public boolean isCellEditable(int n2, int n3) {
        if (this.isReadOnly()) {
            return false;
        }
        if (n3 == 0) {
            return false;
        }
        Field field = this.getFieldInColumn(n3);
        if (field.getLookupTypes() != null) {
            return false;
        }
        Node node = this.getNodeInRow(n2);
        NodeModel nodeModel = this.getCache().getModel();
        if (node.isVoid() && !nodeModel.isLocal() && !nodeModel.isMaster() && "Field.userRole".equals(field.getId())) {
            return false;
        }
        if (node.isVoid()) {
            return true;
        }
        return !field.isReadOnly(node, this.getCache().getWalkersModel(), null);
    }

    private int findFieldColumn(Field field) {
        return this.colModel.findFieldColumn(field);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }
}

