/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet;

import com.projity.configuration.Dictionary;
import com.projity.configuration.FieldDictionary;
import com.projity.field.Field;
import com.projity.field.FieldContext;
import com.projity.graphic.configuration.SpreadSheetFieldArray;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelDataFactory;
import com.projity.grouping.core.model.NodeModelFactory;
import com.projity.grouping.core.transform.ViewTransformer;
import com.projity.grouping.core.transform.filtering.BelongsToCollectionFilter;
import com.projity.grouping.core.transform.filtering.NodeFilter;
import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projity.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projity.pm.graphic.model.transform.NodeCacheTransformer;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.SpreadSheetColumnModel;
import com.projity.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projity.strings.Messages;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpreadSheetUtils {
    public static void setFieldsAndContext(SpreadSheet spreadSheet, NodeModelCache nodeModelCache, String string, String string2, boolean bl) {
        SpreadSheetFieldArray spreadSheetFieldArray = (SpreadSheetFieldArray)Dictionary.get(string, Messages.getString(string2));
        spreadSheet.setCache(nodeModelCache, spreadSheetFieldArray, spreadSheetFieldArray.getCellStyle(), spreadSheetFieldArray.getActionList());
        FieldContext fieldContext = new FieldContext();
        fieldContext.setLeftAssociation(bl);
        ((SpreadSheetModel)spreadSheet.getModel()).setFieldContext(fieldContext);
        ((SpreadSheetModel)spreadSheet.getModel()).getCache().update();
    }

    public static void createCollectionSpreadSheet(SpreadSheet spreadSheet, Collection collection, String string, String string2, String string3, boolean bl, NodeModelDataFactory nodeModelDataFactory, int n2) {
        NodeModel nodeModel = NodeModelFactory.getInstance().createNodeModelFromCollection(collection, nodeModelDataFactory);
        nodeModel.getHierarchy().setNbEndVoidNodes(n2);
        ReferenceNodeModelCache referenceNodeModelCache = NodeModelCacheFactory.getInstance().createReferenceCache(nodeModel, null, (bl ? 2 : 4) | 1);
        NodeModelCache nodeModelCache = NodeModelCacheFactory.getInstance().createFilteredCache(referenceNodeModelCache, Messages.getString(string), null);
        SpreadSheetUtils.setFieldsAndContext(spreadSheet, nodeModelCache, string2, string3, bl);
    }

    public static void updateCollectionSpreadSheet(SpreadSheet spreadSheet, Collection collection, NodeModelDataFactory nodeModelDataFactory, int n2) {
        spreadSheet.clearActions();
        NodeModel nodeModel = spreadSheet.getCache().getModel();
        NodeModelFactory.getInstance().updateNodeModelFromCollection(nodeModel, collection, nodeModelDataFactory, n2);
    }

    public static SpreadSheet createFilteredSpreadsheet(DocumentFrame documentFrame, boolean bl, String string, String string2, String string3, boolean bl2, String[] stringArray) {
        NodeModelCache nodeModelCache = documentFrame.createCache(bl, Messages.getString(string));
        nodeModelCache.update();
        return SpreadSheetUtils.createFilteredSpreadsheet(nodeModelCache, string2, string3, bl2, stringArray);
    }

    public static SpreadSheet createFilteredSpreadsheet(NodeModelCache nodeModelCache, String string, String string2, boolean bl, String[] stringArray) {
        SpreadSheet spreadSheet = new SpreadSheet();
        spreadSheet.setSpreadSheetCategory(bl ? "taskAssignmentSpreadsheet" : "resourceAssignmentSpreadsheet");
        SpreadSheetUtils.setFieldsAndContext(spreadSheet, nodeModelCache, string, string2, bl);
        return spreadSheet;
    }

    public static void updateFilteredSpreadsheet(SpreadSheet spreadSheet, Collection collection) {
        ViewTransformer viewTransformer = ((NodeCacheTransformer)spreadSheet.getCache().getVisibleNodes().getTransformer()).getTransformer();
        NodeFilter nodeFilter = viewTransformer.getHiddenFilter();
        if (nodeFilter instanceof BelongsToCollectionFilter) {
            ((BelongsToCollectionFilter)nodeFilter).setSelectedNodesImpl(collection, true);
        }
    }

    public static JScrollPane makeSpreadsheetScrollPane(SpreadSheet spreadSheet) {
        JScrollPane jScrollPane = new JScrollPane(spreadSheet);
        jScrollPane.getViewport().addChangeListener(new ChangeListener(){
            private Dimension olddmain = null;

            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        return jScrollPane;
    }

    public static List getFieldsForCategory(String string) {
        if (string.equals("projectSpreadsheet")) {
            return FieldDictionary.getInstance().getProjectFields();
        }
        if (string.equals("taskSpreadsheet")) {
            return FieldDictionary.getInstance().getTaskFields();
        }
        if (string.equals("resourceSpreadsheet")) {
            return FieldDictionary.getInstance().getResourceFields();
        }
        if (string.equals("taskAssignmentSpreadsheet") || string.equals("resourceAssignmentSpreadsheet")) {
            return FieldDictionary.getInstance().getAssignmentFields();
        }
        if (string.equals("dependencySpreadsheet")) {
            return FieldDictionary.getInstance().getDependencyFields();
        }
        return null;
    }

    public static GraphicNode getNodeFromCacheRow(int n2, int n3, NodeModelCache nodeModelCache) {
        return (GraphicNode)nodeModelCache.getElementAt(n2 / n3);
    }

    public static Node getNodeInRow(int n2, int n3, NodeModelCache nodeModelCache) {
        GraphicNode graphicNode = SpreadSheetUtils.getNodeFromCacheRow(n2, n3, nodeModelCache);
        if (graphicNode == null) {
            return null;
        }
        return graphicNode.getNode();
    }

    public static Field getFieldInColumn(int n2, SpreadSheetColumnModel spreadSheetColumnModel) {
        return spreadSheetColumnModel.getFieldInColumn(n2);
    }

    public static Object getValueAt(int n2, int n3, int n4, NodeModelCache nodeModelCache, SpreadSheetColumnModel spreadSheetColumnModel, FieldContext fieldContext) {
        Node node = SpreadSheetUtils.getNodeInRow(n2, n4, nodeModelCache);
        return SpreadSheetUtils.getValueAt(node, n3, nodeModelCache, spreadSheetColumnModel, fieldContext);
    }

    public static Object getValueAt(Node node, int n2, NodeModelCache nodeModelCache, SpreadSheetColumnModel spreadSheetColumnModel, FieldContext fieldContext) {
        if (node.isVoid()) {
            return n2 == 0 ? "" : null;
        }
        return SpreadSheetUtils.getFieldInColumn(n2, spreadSheetColumnModel).getValue(node, nodeModelCache.getWalkersModel(), fieldContext);
    }
}

