/*
 * Decompiled with CFR 0.152.
 */
package com.projity.reports.adapter;

import com.projity.configuration.Configuration;
import com.projity.datatype.Duration;
import com.projity.datatype.Money;
import com.projity.datatype.Rate;
import com.projity.field.Field;
import com.projity.grouping.core.model.WalkersNodeModel;
import com.projity.grouping.core.transform.filtering.PredicatedNodeFilterIterator;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.task.Project;
import com.projity.pm.task.Task;
import com.projity.reports.adapter.DataSource;
import com.projity.strings.Messages;
import com.projity.timescale.TimeInterval;
import com.projity.timescale.TimeIterator;
import java.util.Collection;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.apache.commons.collections.Predicate;

public class DataSourceProvider
implements JRDataSourceProvider {
    public static final int PROJECT = 0;
    public static final int PROJECTS_TREE = 1;
    public static final int PROJECTS_FLAT = 2;
    public static final int TASKS_TREE = 3;
    public static final int TASKS_FLAT = 4;
    public static final int RESOURCES_TREE = 5;
    public static final int RESOURCES_FLAT = 6;
    public static final int ASSIGNMENTS = 7;
    public static final int PREDECESSORS = 8;
    public static final int SUCCESSORS = 9;
    public static final int TASKS_ASSIGNMENTS_TREE = 10;
    public static final int RESOURCES_ASSIGNMENTS_TREE = 11;
    public static final int TASKS_ASSIGNMENTS_FLAT = 12;
    public static final int RESOURCES_ASSIGNMENTS_FLAT = 13;
    public static final int ASSIGNMENTS_PROJECT_BASED = 14;
    public static final int ASSIGNMENTS_RESOURCE_BASED = 15;
    public static final String REPORT_VIEW = Messages.getString("View.Report");
    public static final String PROJECT_REPORT_VIEW = Messages.getString("View.ProjectReport");
    public static final String TASK_REPORT_VIEW = Messages.getString("View.TaskReport");
    public static final String RESOURCE_REPORT_VIEW = Messages.getString("View.ResourceReport");
    public static final String COLLECTION_TYPE_PROPERTY = "collectionType";
    public static final String OUTLINE_PROPERTY = "outline";
    public static final String TIME_BASED = "timeBased";
    private static DataSourceProvider instance = null;
    private JRField[] reportFields = null;
    HashMap map = new HashMap();

    public static DataSourceProvider getInstance() {
        if (instance == null) {
            instance = new DataSourceProvider();
        }
        return instance;
    }

    public boolean supportsGetFieldsOperation() {
        return true;
    }

    private void initFields() {
        Collection collection = Configuration.getAllFields();
        this.reportFields = new JRField[collection.size()];
        boolean bl = false;
        for (Field field : collection) {
            JRDesignField jRDesignField = new JRDesignField();
            jRDesignField.setName(field.getId());
            jRDesignField.setDescription(field.getName());
            jRDesignField.setValueClass(field.getClazz());
            jRDesignField.setValueClassName(field.getDisplayType().getName());
            this.map.put(jRDesignField, field);
        }
    }

    public JRField[] getFields(JasperReport jasperReport) throws JRException, UnsupportedOperationException {
        if (this.reportFields == null) {
            this.initFields();
        }
        return this.reportFields;
    }

    public JRDataSource create(JasperReport jasperReport) throws JRException {
        DataSource dataSource = new DataSource();
        return dataSource;
    }

    public static String getViewName(JasperReport jasperReport) {
        String string = jasperReport.getProperty(COLLECTION_TYPE_PROPERTY);
        int n2 = Integer.parseInt(string);
        switch (n2) {
            case 0: {
                return REPORT_VIEW;
            }
            case 1: 
            case 2: {
                return PROJECT_REPORT_VIEW;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 14: {
                return TASK_REPORT_VIEW;
            }
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 15: {
                return RESOURCE_REPORT_VIEW;
            }
        }
        return null;
    }

    public static DataSource createDataSource(JasperReport jasperReport, Project project, PredicatedNodeFilterIterator predicatedNodeFilterIterator, WalkersNodeModel walkersNodeModel) throws JRException {
        DataSource dataSource = new DataSource();
        boolean bl = jasperReport.getProperty(TIME_BASED) != null;
        String string = jasperReport.getProperty(COLLECTION_TYPE_PROPERTY);
        if (string == null) {
            throw new JRException("must specify collectionType property in report definition");
        }
        int n2 = Integer.parseInt(string);
        int n3 = 0;
        String string2 = jasperReport.getProperty(OUTLINE_PROPERTY);
        if (string2 != null) {
            n3 = Integer.parseInt(string2);
        }
        Predicate predicate = null;
        boolean bl2 = false;
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                predicate = Project.instanceofPredicate();
                bl2 = true;
                break;
            }
            case 2: {
                predicate = Project.instanceofPredicate();
                break;
            }
            case 3: {
                predicate = Task.instanceofPredicate();
                bl2 = true;
                break;
            }
            case 4: {
                predicate = Task.instanceofPredicate();
                break;
            }
            case 5: {
                predicate = ResourceImpl.instanceofPredicate();
                bl2 = true;
                break;
            }
            case 6: {
                predicate = ResourceImpl.instanceofPredicate();
                break;
            }
            case 10: {
                bl2 = true;
                break;
            }
            case 11: {
                bl2 = true;
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                predicate = Assignment.instanceofPredicate();
                break;
            }
            case 15: {
                predicate = Assignment.instanceofPredicate();
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                throw new JRException("Supreport collection type " + n2 + " not yet implemented");
            }
        }
        dataSource.setTimeBased(bl);
        dataSource.setProject(project);
        dataSource.setIterator(predicatedNodeFilterIterator);
        dataSource.setNodeModel(walkersNodeModel);
        dataSource.setNodeBased(bl2);
        dataSource.setPredicate(predicate);
        return dataSource;
    }

    public void dispose(JRDataSource jRDataSource) throws JRException {
        this.map.clear();
    }

    public static Object fieldValueConverterToPrimitiveType(Field field, Object object) {
        if (object == null) {
            return null;
        }
        if (field.isRate()) {
            return new Double(((Rate)object).getValue());
        }
        if (field.isMoney()) {
            return new Double(((Money)object).doubleValue());
        }
        if (field.isDurationOrWork()) {
            return new Long(((Duration)object).longValue());
        }
        return object;
    }

    public static JasperDesign addTimescale(JasperDesign jasperDesign, TimeIterator timeIterator, Class clazz) {
        String string = jasperDesign.getProperty("timeBasedField");
        JRBand jRBand = jasperDesign.getPageHeader();
        JRElement[] jRElementArray = jRBand.getElements();
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < jRElementArray.length; ++i2) {
            n2 = jRElementArray[i2].getX() + jRElementArray[i2].getWidth() > n2 ? jRElementArray[i2].getX() + jRElementArray[i2].getWidth() : n2;
            n3 = jRElementArray[i2].getY() > n3 ? jRElementArray[i2].getY() : n3;
        }
        JRDesignReportFont jRDesignReportFont = new JRDesignReportFont();
        jRDesignReportFont.setFontName("Arial");
        jRDesignReportFont.setSize(10);
        jRDesignReportFont.setPdfFontName("Helvetica");
        try {
            while (timeIterator.hasNext()) {
                TimeInterval timeInterval = timeIterator.next();
                String string2 = "TIME";
                string2 = string2 + timeInterval.getStart();
                string2 = string2 + "_";
                string2 = string2 + timeInterval.getEnd();
                string2 = string2 + "_" + string;
                System.out.println("time based field is " + string2);
                JRDesignField jRDesignField = new JRDesignField();
                jRDesignField.setName(string2);
                jRDesignField.setValueClass(clazz);
                jasperDesign.addField((JRField)jRDesignField);
                System.out.println("column header is " + timeInterval.getText2());
                JRDesignBand jRDesignBand = (JRDesignBand)jasperDesign.getColumnHeader();
                JRDesignStaticText jRDesignStaticText = new JRDesignStaticText();
                jRDesignStaticText.setX(n2);
                jRDesignStaticText.setY(0);
                jRDesignStaticText.setWidth(80);
                jRDesignStaticText.setHeight(15);
                jRDesignStaticText.setTextAlignment((byte)3);
                jRDesignStaticText.setFont((JRFont)jRDesignReportFont);
                jRDesignStaticText.setText(timeInterval.getText1());
                jRDesignStaticText.setPrintWhenDetailOverflows(true);
                jRDesignBand.addElement((JRDesignElement)jRDesignStaticText);
                JRDesignBand jRDesignBand2 = (JRDesignBand)jasperDesign.getDetail();
                JRDesignTextField jRDesignTextField = new JRDesignTextField();
                jRDesignTextField.setX(n2);
                jRDesignTextField.setY(0);
                jRDesignTextField.setWidth(80);
                jRDesignTextField.setHeight(15);
                jRDesignTextField.setTextAlignment((byte)3);
                jRDesignTextField.setFont((JRFont)jRDesignReportFont);
                JRDesignExpression jRDesignExpression = new JRDesignExpression();
                jRDesignExpression.setValueClass(clazz);
                jRDesignExpression.setText("$F{" + string2 + "}");
                jRDesignTextField.setExpression((JRExpression)jRDesignExpression);
                jRDesignTextField.setPrintWhenDetailOverflows(true);
                jRDesignBand2.addElement((JRDesignElement)jRDesignTextField);
                n2 += 80;
            }
        }
        catch (JRException jRException) {
            jRException.printStackTrace();
        }
        return jasperDesign;
    }
}

