/*
 * Decompiled with CFR 0.152.
 */
package com.projity.script.object;

import com.projity.script.object.TimeWindow;
import com.projity.timescale.CalendarUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.commons.lang.time.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeIntervals
implements Serializable,
Cloneable {
    static final long serialVersionUID = 18828392223063L;
    public static final int DAY = 1;
    public static final int WEEK = 2;
    public static final int MONTH = 3;
    public static final int QUARTER = 4;
    public static final int YEAR = 5;
    public static final int ETERNITY = 1000000;
    public static final int MIN_SCALE = 1;
    public static final int MAX_SCALE = 2;
    protected static final int DEFAULT_WINDOW_COUNT = 3;
    protected static final int WINDOW_INTERVALS = 50;
    protected LinkedList<TimeWindow> win = new LinkedList();
    protected int scale = 1;
    protected int translation;
    protected int winId;
    protected float center;
    protected LinkedList<TimeWindow> history = new LinkedList();
    protected long start;
    protected long end;

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n2) {
        if (n2 >= 1 && n2 <= 2) {
            this.scale = n2;
        }
    }

    public LinkedList<TimeWindow> getWin() {
        return this.win;
    }

    public long getStart() {
        if (this.win.size() == 0) {
            return 0L;
        }
        return this.win.getFirst().getS();
    }

    public long getEnd() {
        if (this.win.size() == 0) {
            return Long.MAX_VALUE;
        }
        return this.win.getLast().getE();
    }

    public TimeWindow getCenterWin() {
        int n2 = this.win.size();
        if (n2 == 0) {
            return null;
        }
        int n3 = n2 / 2;
        if (n2 % 2 == 1) {
            return this.win.get(n3);
        }
        TimeWindow timeWindow = new TimeWindow();
        timeWindow.setS(this.win.get(n3 - 1).calculateCenter());
        timeWindow.setE(this.win.get(n3).calculateCenter());
        return timeWindow;
    }

    public int getTranslation() {
        return this.translation;
    }

    public void setTranslation(int n2) {
        this.translation = n2;
    }

    public float getCenter() {
        return this.center;
    }

    public void setCenter(float f2) {
        this.center = f2;
    }

    public void update() {
        if (this.win.size() > 0) {
            this.update(this.win.getFirst().getS(), this.end);
        }
    }

    public void update(long l2, long l3) {
        this.update(l2, l3, 3);
    }

    public void update(long l2, long l3, int n2) {
        this.start = l2;
        this.end = l3;
        this.win.clear();
        this.history.clear();
        TimeIntervals.generateWindows(this.scale, l2, 0L, Long.MAX_VALUE, n2, this.win);
        TimeIntervals.indexWindows(this.winId, this.win);
        this.history.addAll(this.win);
    }

    protected static void indexWindows(int n2, LinkedList<TimeWindow> linkedList) {
        int n3 = n2;
        for (TimeWindow timeWindow : linkedList) {
            timeWindow.setId(n3++);
        }
    }

    public TimeIntervals translate(int n2) {
        TimeWindow timeWindow;
        Object object;
        int n3;
        int n4;
        int n5;
        TimeIntervals timeIntervals = new TimeIntervals();
        timeIntervals.setScale(this.scale);
        LinkedList<TimeWindow> linkedList = timeIntervals.getWin();
        if (n2 == 0 || this.win.size() == 0) {
            return timeIntervals;
        }
        if (n2 > 0) {
            timeIntervals.winId = this.winId + this.win.size();
            n5 = timeIntervals.winId - 1 + n2;
            n4 = timeIntervals.winId;
            n3 = Math.min(this.history.getLast().getId(), n5);
            if (n4 <= n3) {
                object = this.history.listIterator();
                while (object.hasNext()) {
                    timeWindow = (TimeWindow)object.next();
                    if (timeWindow.getId() != timeIntervals.winId) continue;
                    object.previous();
                    break;
                }
                while (n4 <= n3 && object.hasNext()) {
                    timeWindow = (TimeWindow)object.next();
                    linkedList.add(timeWindow);
                    ++n4;
                }
            }
            object = new LinkedList();
            TimeIntervals.generateWindows(this.scale, (linkedList.size() > 0 ? linkedList : this.win).getLast().getE(), this.start, this.end, n5 - n4 + 1, (LinkedList<TimeWindow>)object);
            TimeIntervals.indexWindows(timeIntervals.winId + timeIntervals.getWin().size(), (LinkedList<TimeWindow>)object);
            timeIntervals.getWin().addAll((Collection<TimeWindow>)object);
            this.history.addAll((Collection<TimeWindow>)object);
        } else {
            timeIntervals.winId = this.winId - 1;
            n5 = timeIntervals.winId + 1 + n2;
            n4 = timeIntervals.winId;
            n3 = Math.max(this.history.getFirst().getId(), n5);
            if (n4 >= n3) {
                object = this.history.listIterator(this.history.size() - 1);
                while (object.hasPrevious()) {
                    timeWindow = (TimeWindow)object.previous();
                    if (timeWindow.getId() != timeIntervals.winId) continue;
                    object.next();
                    break;
                }
                while (n4 >= n3) {
                    timeWindow = (TimeWindow)object.previous();
                    linkedList.addFirst(timeWindow);
                    --n4;
                }
            }
            object = new LinkedList();
            TimeIntervals.generateWindows(this.scale, (linkedList.size() > 0 ? linkedList : this.win).getFirst().getS(), this.start, this.end, n5 - n4 - 1, (LinkedList<TimeWindow>)object);
            TimeIntervals.indexWindows(n5, (LinkedList<TimeWindow>)object);
            timeIntervals.getWin().addAll(0, (Collection<TimeWindow>)object);
            this.history.addAll(0, (Collection<TimeWindow>)object);
        }
        n5 = 0;
        for (TimeWindow timeWindow2 : timeIntervals.getWin()) {
            if (n2 > 0) {
                this.win.removeFirst();
                this.win.addLast(timeWindow2);
                ++n5;
                continue;
            }
            this.win.removeLast();
            this.win.addFirst(timeWindow2);
            --n5;
        }
        this.winId += n5;
        timeIntervals.setTranslation(n5);
        return timeIntervals;
    }

    public static int generateWindows(int n2, long l2, long l3, long l4, int n3, LinkedList<TimeWindow> linkedList) {
        TimeWindow timeWindow = null;
        if (n3 > 0) {
            for (int i2 = 0; i2 <= n3; ++i2) {
                TimeWindow timeWindow2 = TimeIntervals.generateWindow(l2, n2, 1);
                if (timeWindow != null) {
                    timeWindow.setE(timeWindow2.getS());
                    linkedList.add(timeWindow);
                }
                l2 = timeWindow2.getE();
                timeWindow = timeWindow2;
            }
        } else {
            for (int i3 = 0; i3 >= n3; --i3) {
                TimeWindow timeWindow3 = TimeIntervals.generateWindow(l2, n2, -1);
                if (timeWindow != null) {
                    timeWindow.setS(timeWindow3.getE());
                    linkedList.addFirst(timeWindow);
                }
                l2 = timeWindow3.getS();
                timeWindow = timeWindow3;
            }
        }
        return n3;
    }

    public static TimeWindow generateWindow(long l2, int n2, int n3) {
        long l3;
        int n4;
        int n5 = 0;
        int n6 = 1;
        int n7 = 1;
        switch (n2) {
            case 1: {
                n4 = 5;
                n5 = 3;
                break;
            }
            case 2: {
                n4 = 3;
                n5 = 2;
                break;
            }
            case 3: {
                n4 = 2;
                n5 = 2;
                n7 = 3;
                break;
            }
            case 4: {
                n4 = 2;
                n5 = 1;
                n6 = 3;
                break;
            }
            case 5: {
                n4 = 1;
                n5 = 1;
                break;
            }
            default: {
                return null;
            }
        }
        Calendar calendar = Calendar.getInstance(DateUtils.UTC_TIME_ZONE, Locale.US);
        calendar.setTimeInMillis(l2);
        TimeIntervals.floorCal(n2, calendar);
        long l4 = calendar.getTimeInMillis();
        TimeIntervals.floorCal(n2 + 1, calendar);
        long l5 = calendar.getTimeInMillis();
        calendar.setTimeInMillis(l4);
        while ((l3 = calendar.getTimeInMillis()) >= l5) {
            l4 = l3;
            calendar.add(n4, -n6);
        }
        calendar.setTimeInMillis(l4);
        calendar.add(n4, n3 * n6 * 50);
        TimeWindow timeWindow = new TimeWindow();
        if (n3 > 0) {
            timeWindow.setS(l4);
        } else {
            timeWindow.setE(l4);
        }
        if (n3 > 0) {
            timeWindow.setE(calendar.getTimeInMillis());
        } else {
            timeWindow.setS(calendar.getTimeInMillis());
        }
        return timeWindow;
    }

    private static void floorCal(int n2, Calendar calendar) {
        switch (n2) {
            case 1: {
                CalendarUtil.dayFloor(calendar);
                break;
            }
            case 2: {
                CalendarUtil.weekFloor(calendar);
                break;
            }
            case 3: {
                CalendarUtil.monthFloor(calendar);
                break;
            }
            case 4: {
                CalendarUtil.monthFloor(calendar);
                calendar.set(2, calendar.get(2) / 3 * 3);
                break;
            }
            case 5: {
                CalendarUtil.yearFloor(calendar);
            }
        }
    }

    public Object clone() {
        try {
            TimeIntervals timeIntervals = (TimeIntervals)super.clone();
            timeIntervals.win = new LinkedList();
            timeIntervals.history = new LinkedList();
            for (TimeWindow timeWindow : this.win) {
                timeIntervals.win.add(timeWindow);
            }
            for (TimeWindow timeWindow : this.history) {
                timeIntervals.history.add(timeWindow);
            }
            return timeIntervals;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

