/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data;

import com.projity.pm.key.uniqueid.UniqueIdException;
import com.projity.server.data.CommonDataObject;
import com.projity.server.data.DataObject;
import com.projity.session.SessionFactory;

public class SerializedDataObject
extends CommonDataObject {
    static final long serialVersionUID = 16280304846919L;
    public static final int UPDATE = 1;
    public static final int MOVE = 2;
    protected int status;
    protected byte[] serialized;
    protected long uniqueId = -1L;
    protected String name;

    public byte[] getSerialized() {
        return this.serialized;
    }

    public void setSerialized(byte[] byArray) {
        this.serialized = byArray;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n2) {
        this.status = n2;
    }

    public void emtpy() {
        this.serialized = null;
        this.name = null;
        this.status = 0;
    }

    public int getType() {
        return 0;
    }

    public String getPrefix() {
        if (this.getType() == 0) {
            return "Company";
        }
        if (this.getType() == 1) {
            return "Calendar";
        }
        if (this.getType() == 2) {
            return "Project";
        }
        if (this.getType() == 3) {
            return "EnterpriseResource";
        }
        if (this.getType() == 4) {
            return "Resource";
        }
        if (this.getType() == 5) {
            return "Task";
        }
        if (this.getType() == 6) {
            return "Assignment";
        }
        if (this.getType() == 7) {
            return "Link";
        }
        if (this.getType() == 8) {
            return "BankingInfo";
        }
        if (this.getType() == 9) {
            return "CreditCardBankingInfo";
        }
        if (this.getType() == 10) {
            return "CheckBankingInfo";
        }
        if (this.getType() == 11) {
            return "User";
        }
        if (this.getType() == 12) {
            return "PartnerUser";
        }
        if (this.getType() == 13) {
            return "PartnerCompany";
        }
        return "Unknown";
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(long l2) {
        this.uniqueId = l2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isLocal() {
        return SerializedDataObject.isLocal(this);
    }

    public boolean isDirty() {
        return (this.status & 1) == 1;
    }

    public void setDirty(boolean bl) {
        this.status = bl ? (this.status |= 1) : 0;
    }

    public boolean isMoved() {
        return (this.status & 2) == 2;
    }

    public void setMoved(boolean bl) {
        if (bl) {
            this.status |= 2;
        }
    }

    public String toString() {
        return this.name;
    }

    public static boolean isLocal(DataObject dataObject) {
        return SerializedDataObject.isLocal(dataObject.getUniqueId());
    }

    public static boolean isLocal(long l2) {
        return l2 < 1000000000L;
    }

    public static void makeGlobal(DataObject dataObject) throws UniqueIdException {
        if (SerializedDataObject.isLocal(dataObject)) {
            dataObject.setUniqueId(SessionFactory.getInstance().getSession(false).getId());
        }
    }

    public boolean isExternal() {
        return false;
    }
}

