/*
 * Decompiled with CFR 0.152.
 */
package com.projity.util;

import com.projity.util.DateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class Factory {

    public static class DatePool
    extends BasePoolableObjectFactory {
        private static GenericObjectPool pool = new GenericObjectPool(new DatePool());

        public Object makeObject() throws Exception {
            return new Date();
        }

        public static Date getInstance(long l2) {
            Date date = DatePool.getInstance();
            date.setTime(l2);
            return date;
        }

        public static Date getInstance() {
            try {
                return (Date)pool.borrowObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public static void recycle(Date date) {
            try {
                pool.returnObject(date);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static class GregorianCalendarPool
    extends BasePoolableObjectFactory {
        private static GenericObjectPool pool = new GenericObjectPool(new GregorianCalendarPool());

        public Object makeObject() throws Exception {
            return DateTime.calendarInstance();
        }

        public static GregorianCalendar getInstance() {
            try {
                return (GregorianCalendar)pool.borrowObject();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public static void recycle(GregorianCalendar gregorianCalendar) {
            try {
                pool.returnObject(gregorianCalendar);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

