/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections.h;
import org.apache.commons.digester.BeanPropertySetterRule;
import org.apache.commons.digester.CallMethodRule;
import org.apache.commons.digester.CallParamRule;
import org.apache.commons.digester.FactoryCreateRule;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.ObjectParamRule;
import org.apache.commons.digester.ParserFeatureSetterFactory;
import org.apache.commons.digester.PathCallParamRule;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.RulesBase;
import org.apache.commons.digester.SetNestedPropertiesRule;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.digester.SetPropertyRule;
import org.apache.commons.digester.SetRootRule;
import org.apache.commons.digester.SetTopRule;
import org.apache.commons.digester.StackAction;
import org.apache.commons.digester.Substitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Digester
extends DefaultHandler {
    protected StringBuffer a = new StringBuffer();
    protected h b = new h();
    protected h c = new h(10);
    protected ClassLoader d = null;
    protected boolean e = false;
    protected EntityResolver f;
    protected HashMap g = new HashMap();
    protected ErrorHandler h = null;
    protected SAXParserFactory i = null;
    protected Locator j = null;
    protected String k = "";
    protected boolean l = false;
    protected HashMap m = new HashMap();
    protected h n = new h();
    protected SAXParser o = null;
    protected String p = null;
    protected XMLReader q = null;
    protected Object r = null;
    protected Rules s = null;
    protected String t = "http://www.w3.org/2001/XMLSchema";
    protected String u = null;
    protected h v = new h();
    protected boolean w = false;
    protected boolean x = false;
    protected Log y = LogFactory.getLog("org.apache.commons.digester.Digester");
    protected Log z = LogFactory.getLog("org.apache.commons.digester.Digester.sax");
    protected Substitutor A;
    private HashMap C = new HashMap();
    private ContentHandler D = null;
    private StackAction E = null;
    protected List B = new ArrayList(5);

    public Digester() {
    }

    public Digester(SAXParser sAXParser) {
        this.o = sAXParser;
    }

    public Digester(XMLReader xMLReader) {
        this.q = xMLReader;
    }

    public String findNamespaceURI(String string) {
        h h2 = (h)this.m.get(string);
        if (h2 == null) {
            return null;
        }
        try {
            return (String)h2.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.d != null) {
            return this.d;
        }
        if (this.w && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.d = classLoader;
    }

    public int getCount() {
        return this.v.size();
    }

    public String getCurrentElementName() {
        String string = this.k;
        int n2 = string.lastIndexOf(47);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        return string;
    }

    public int getDebug() {
        return 0;
    }

    public void setDebug(int n2) {
    }

    public ErrorHandler getErrorHandler() {
        return this.h;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.h = errorHandler;
    }

    public SAXParserFactory getFactory() {
        if (this.i == null) {
            this.i = SAXParserFactory.newInstance();
            this.i.setNamespaceAware(this.l);
            this.i.setValidating(this.x);
        }
        return this.i;
    }

    public boolean getFeature(String string) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.getFactory().getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.getFactory().setFeature(string, bl);
    }

    public Log getLogger() {
        return this.y;
    }

    public void setLogger(Log log) {
        this.y = log;
    }

    public Log getSAXLogger() {
        return this.z;
    }

    public void setSAXLogger(Log log) {
        this.z = log;
    }

    public String getMatch() {
        return this.k;
    }

    public boolean getNamespaceAware() {
        return this.l;
    }

    public void setNamespaceAware(boolean bl) {
        this.l = bl;
    }

    public void setPublicId(String string) {
        this.p = string;
    }

    public String getPublicId() {
        return this.p;
    }

    public String getRuleNamespaceURI() {
        return this.getRules().getNamespaceURI();
    }

    public void setRuleNamespaceURI(String string) {
        this.getRules().setNamespaceURI(string);
    }

    public SAXParser getParser() {
        if (this.o != null) {
            return this.o;
        }
        try {
            if (this.x && this.u != null) {
                Properties properties = new Properties();
                properties.put("SAXParserFactory", this.getFactory());
                if (this.u != null) {
                    properties.put("schemaLocation", this.u);
                    properties.put("schemaLanguage", this.t);
                }
                this.o = ParserFeatureSetterFactory.newSAXParser(properties);
            } else {
                this.o = this.getFactory().newSAXParser();
            }
        }
        catch (Exception exception) {
            this.y.error("Digester.getParser: ", exception);
            return null;
        }
        return this.o;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.getParser().getProperty(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.getParser().setProperty(string, object);
    }

    public XMLReader getReader() {
        try {
            return this.getXMLReader();
        }
        catch (SAXException sAXException) {
            this.y.error("Cannot get XMLReader", sAXException);
            return null;
        }
    }

    public Rules getRules() {
        if (this.s == null) {
            this.s = new RulesBase();
            this.s.setDigester(this);
        }
        return this.s;
    }

    public void setRules(Rules rules) {
        this.s = rules;
        this.s.setDigester(this);
    }

    public String getSchema() {
        return this.u;
    }

    public void setSchema(String string) {
        this.u = string;
    }

    public String getSchemaLanguage() {
        return this.t;
    }

    public void setSchemaLanguage(String string) {
        this.t = string;
    }

    public boolean getUseContextClassLoader() {
        return this.w;
    }

    public void setUseContextClassLoader(boolean bl) {
        this.w = bl;
    }

    public boolean getValidating() {
        return this.x;
    }

    public void setValidating(boolean bl) {
        this.x = bl;
    }

    public XMLReader getXMLReader() throws SAXException {
        EntityResolver entityResolver;
        XMLReader xMLReader;
        if (this.q == null) {
            this.q = this.getParser().getXMLReader();
        }
        this.q.setDTDHandler(this);
        this.q.setContentHandler(this);
        if (this.f == null) {
            xMLReader = this.q;
            entityResolver = this;
        } else {
            xMLReader = this.q;
            entityResolver = this.f;
        }
        xMLReader.setEntityResolver(entityResolver);
        this.q.setErrorHandler(this);
        return this.q;
    }

    public Substitutor getSubstitutor() {
        return this.A;
    }

    public void setSubstitutor(Substitutor substitutor) {
        this.A = substitutor;
    }

    public ContentHandler getCustomContentHandler() {
        return this.D;
    }

    public void setCustomContentHandler(ContentHandler contentHandler) {
        this.D = contentHandler;
    }

    public void setStackAction(StackAction stackAction) {
        this.E = stackAction;
    }

    public StackAction getStackAction() {
        return this.E;
    }

    public Map getCurrentNamespaces() {
        if (!this.l) {
            this.y.warn("Digester is not namespace aware");
        }
        HashMap hashMap = new HashMap();
        Iterator iterator = this.m.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            try {
                hashMap.put(entry.getKey(), ((h)entry.getValue()).peek());
            }
            catch (RuntimeException runtimeException) {
                this.y.error(runtimeException.getMessage(), runtimeException);
                throw runtimeException;
            }
        }
        return hashMap;
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.D != null) {
            this.D.characters(cArray, n2, n3);
            return;
        }
        if (this.z.isDebugEnabled()) {
            this.z.debug("characters(" + new String(cArray, n2, n3) + ")");
        }
        this.a.append(cArray, n2, n3);
    }

    public void endDocument() throws SAXException {
        if (this.z.isDebugEnabled()) {
            String string;
            Log log;
            if (this.getCount() > 1) {
                log = this.z;
                string = "endDocument():  " + this.getCount() + " elements left";
            } else {
                log = this.z;
                string = "endDocument()";
            }
            log.debug(string);
        }
        Iterator iterator = this.getRules().rules().iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            try {
                rule.finish();
            }
            catch (Exception exception) {
                this.y.error("Finish event threw exception", exception);
                throw this.createSAXException(exception);
            }
            catch (Error error) {
                this.y.error("Finish event threw error", error);
                throw error;
            }
        }
        this.clear();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4;
        Digester digester;
        int n2;
        List list;
        String string5;
        if (this.D != null) {
            this.D.endElement(string, string2, string3);
            return;
        }
        boolean bl = this.y.isDebugEnabled();
        if (bl) {
            if (this.z.isDebugEnabled()) {
                this.z.debug("endElement(" + string + "," + string2 + "," + string3 + ")");
            }
            this.y.debug("  match='" + this.k + "'");
            this.y.debug("  bodyText='" + this.a + "'");
        }
        if ((string5 = string2) == null || string5.length() < 1) {
            string5 = string3;
        }
        if ((list = (List)this.c.pop()) != null && list.size() > 0) {
            String string6 = this.a.toString();
            Substitutor substitutor = this.getSubstitutor();
            if (substitutor != null) {
                string6 = substitutor.substitute(string6);
            }
            int n3 = 0;
            while (n3 < list.size()) {
                try {
                    Rule rule = (Rule)list.get(n3);
                    if (bl) {
                        this.y.debug("  Fire body() for " + rule);
                    }
                    rule.body(string, string5, string6);
                }
                catch (Exception exception) {
                    this.y.error("Body event threw exception", exception);
                    throw this.createSAXException(exception);
                }
                catch (Error error) {
                    this.y.error("Body event threw error", error);
                    throw error;
                }
                ++n3;
            }
        } else if (bl) {
            this.y.debug("  No rules found matching '" + this.k + "'.");
        }
        this.a = (StringBuffer)this.b.pop();
        if (bl) {
            this.y.debug("  Popping body text '" + this.a.toString() + "'");
        }
        if (list != null) {
            int n4 = 0;
            while (n4 < list.size()) {
                int n5 = list.size() - n4 - 1;
                try {
                    Rule rule = (Rule)list.get(n5);
                    if (bl) {
                        this.y.debug("  Fire end() for " + rule);
                    }
                    rule.end(string, string5);
                }
                catch (Exception exception) {
                    this.y.error("End event threw exception", exception);
                    throw this.createSAXException(exception);
                }
                catch (Error error) {
                    this.y.error("End event threw error", error);
                    throw error;
                }
                ++n4;
            }
        }
        if ((n2 = this.k.lastIndexOf(47)) >= 0) {
            digester = this;
            string4 = this.k.substring(0, n2);
        } else {
            digester = this;
            string4 = "";
        }
        digester.k = string4;
    }

    public void endPrefixMapping(String string) throws SAXException {
        h h2;
        if (this.z.isDebugEnabled()) {
            this.z.debug("endPrefixMapping(" + string + ")");
        }
        if ((h2 = (h)this.m.get(string)) == null) {
            return;
        }
        try {
            h2.pop();
            if (h2.empty()) {
                this.m.remove(string);
            }
            return;
        }
        catch (EmptyStackException emptyStackException) {
            throw this.createSAXException("endPrefixMapping popped too many times");
        }
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        if (this.z.isDebugEnabled()) {
            this.z.debug("ignorableWhitespace(" + new String(cArray, n2, n3) + ")");
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.D != null) {
            this.D.processingInstruction(string, string2);
            return;
        }
        if (this.z.isDebugEnabled()) {
            this.z.debug("processingInstruction('" + string + "','" + string2 + "')");
        }
    }

    public Locator getDocumentLocator() {
        return this.j;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.z.isDebugEnabled()) {
            this.z.debug("setDocumentLocator(" + locator + ")");
        }
        this.j = locator;
    }

    public void skippedEntity(String string) throws SAXException {
        if (this.z.isDebugEnabled()) {
            this.z.debug("skippedEntity(" + string + ")");
        }
    }

    public void startDocument() throws SAXException {
        if (this.z.isDebugEnabled()) {
            this.z.debug("startDocument()");
        }
        this.b();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = this.y.isDebugEnabled();
        if (this.D != null) {
            this.D.startElement(string, string2, string3, attributes);
            return;
        }
        if (this.z.isDebugEnabled()) {
            this.z.debug("startElement(" + string + "," + string2 + "," + string3 + ")");
        }
        this.b.push(this.a);
        if (bl) {
            this.y.debug("  Pushing body text '" + this.a.toString() + "'");
        }
        this.a = new StringBuffer();
        String string4 = string2;
        if (string4 == null || string4.length() < 1) {
            string4 = string3;
        }
        StringBuffer stringBuffer = new StringBuffer(this.k);
        if (this.k.length() > 0) {
            stringBuffer.append('/');
        }
        stringBuffer.append(string4);
        this.k = stringBuffer.toString();
        if (bl) {
            this.y.debug("  New match='" + this.k + "'");
        }
        List list = this.getRules().match(string, this.k);
        this.c.push(list);
        if (list != null && list.size() > 0) {
            Substitutor substitutor = this.getSubstitutor();
            if (substitutor != null) {
                attributes = substitutor.substitute(attributes);
            }
            int n2 = 0;
            while (n2 < list.size()) {
                try {
                    Rule rule = (Rule)list.get(n2);
                    if (bl) {
                        this.y.debug("  Fire begin() for " + rule);
                    }
                    rule.begin(string, string4, attributes);
                }
                catch (Exception exception) {
                    this.y.error("Begin event threw exception", exception);
                    throw this.createSAXException(exception);
                }
                catch (Error error) {
                    this.y.error("Begin event threw error", error);
                    throw error;
                }
                ++n2;
            }
            return;
        }
        if (bl) {
            this.y.debug("  No rules found matching '" + this.k + "'.");
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        h h2;
        if (this.z.isDebugEnabled()) {
            this.z.debug("startPrefixMapping(" + string + "," + string2 + ")");
        }
        if ((h2 = (h)this.m.get(string)) == null) {
            h2 = new h();
            this.m.put(string, h2);
        }
        h2.push(string2);
    }

    public void notationDecl(String string, String string2, String string3) {
        if (this.z.isDebugEnabled()) {
            this.z.debug("notationDecl(" + string + "," + string2 + "," + string3 + ")");
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        if (this.z.isDebugEnabled()) {
            this.z.debug("unparsedEntityDecl(" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.f = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.f;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if (this.z.isDebugEnabled()) {
            this.z.debug("resolveEntity('" + string + "', '" + string2 + "')");
        }
        if (string != null) {
            this.p = string;
        }
        URL uRL = null;
        if (string != null) {
            uRL = (URL)this.g.get(string);
        }
        if (this.u != null && uRL == null && string2 != null) {
            uRL = (URL)this.g.get(string2);
        }
        if (uRL == null) {
            if (string2 == null) {
                if (this.y.isDebugEnabled()) {
                    this.y.debug(" Cannot resolve entity: '" + uRL + "'");
                }
                return null;
            }
            if (this.y.isDebugEnabled()) {
                this.y.debug(" Trying to resolve using system ID '" + string2 + "'");
            }
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("Malformed URL '" + string2 + "' : " + malformedURLException.getMessage());
            }
        }
        if (this.y.isDebugEnabled()) {
            this.y.debug(" Resolving to alternate DTD '" + uRL + "'");
        }
        try {
            return this.createInputSourceFromURL(uRL);
        }
        catch (Exception exception) {
            throw this.createSAXException(exception);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.y.error("Parse Error at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage(), sAXParseException);
        if (this.h != null) {
            this.h.error(sAXParseException);
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.y.error("Parse Fatal Error at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage(), sAXParseException);
        if (this.h != null) {
            this.h.fatalError(sAXParseException);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.h != null) {
            this.y.warn("Parse Warning Error at line " + sAXParseException.getLineNumber() + " column " + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage(), sAXParseException);
            this.h.warning(sAXParseException);
        }
    }

    public void log(String string) {
        this.y.info(string);
    }

    public void log(String string, Throwable throwable) {
        this.y.error(string, throwable);
    }

    public Object parse(File file) throws IOException, SAXException {
        this.b();
        InputSource inputSource = new InputSource(new FileInputStream(file));
        inputSource.setSystemId(file.toURL().toString());
        this.getXMLReader().parse(inputSource);
        this.a();
        return this.r;
    }

    public Object parse(InputSource inputSource) throws IOException, SAXException {
        this.b();
        this.getXMLReader().parse(inputSource);
        this.a();
        return this.r;
    }

    public Object parse(InputStream inputStream) throws IOException, SAXException {
        this.b();
        InputSource inputSource = new InputSource(inputStream);
        this.getXMLReader().parse(inputSource);
        this.a();
        return this.r;
    }

    public Object parse(Reader reader) throws IOException, SAXException {
        this.b();
        InputSource inputSource = new InputSource(reader);
        this.getXMLReader().parse(inputSource);
        this.a();
        return this.r;
    }

    public Object parse(String string) throws IOException, SAXException {
        this.b();
        InputSource inputSource = this.createInputSourceFromURL(string);
        this.getXMLReader().parse(inputSource);
        this.a();
        return this.r;
    }

    public Object parse(URL uRL) throws IOException, SAXException {
        this.b();
        InputSource inputSource = this.createInputSourceFromURL(uRL);
        this.getXMLReader().parse(inputSource);
        this.a();
        return this.r;
    }

    public void register(String string, URL uRL) {
        if (this.y.isDebugEnabled()) {
            this.y.debug("register('" + string + "', '" + uRL + "'");
        }
        this.g.put(string, uRL);
    }

    public void register(String string, String string2) {
        if (this.y.isDebugEnabled()) {
            this.y.debug("register('" + string + "', '" + string2 + "'");
        }
        try {
            this.g.put(string, new URL(string2));
            return;
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Malformed URL '" + string2 + "' : " + malformedURLException.getMessage());
        }
    }

    public InputSource createInputSourceFromURL(URL uRL) throws MalformedURLException, IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        InputStream inputStream = uRLConnection.getInputStream();
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(uRL.toExternalForm());
        this.B.add(inputSource);
        return inputSource;
    }

    public InputSource createInputSourceFromURL(String string) throws MalformedURLException, IOException {
        return this.createInputSourceFromURL(new URL(string));
    }

    public void addRule(String string, Rule rule) {
        rule.setDigester(this);
        this.getRules().add(string, rule);
    }

    public void addRuleSet(RuleSet ruleSet) {
        String string = this.getRuleNamespaceURI();
        String string2 = ruleSet.getNamespaceURI();
        if (this.y.isDebugEnabled()) {
            String string3;
            Log log;
            if (string2 == null) {
                log = this.y;
                string3 = "addRuleSet() with no namespace URI";
            } else {
                log = this.y;
                string3 = "addRuleSet() with namespace URI " + string2;
            }
            log.debug(string3);
        }
        this.setRuleNamespaceURI(string2);
        ruleSet.addRuleInstances(this);
        this.setRuleNamespaceURI(string);
    }

    public void addBeanPropertySetter(String string) {
        this.addRule(string, new BeanPropertySetterRule());
    }

    public void addBeanPropertySetter(String string, String string2) {
        this.addRule(string, new BeanPropertySetterRule(string2));
    }

    public void addCallMethod(String string, String string2) {
        this.addRule(string, new CallMethodRule(string2));
    }

    public void addCallMethod(String string, String string2, int n2) {
        this.addRule(string, new CallMethodRule(string2, n2));
    }

    public void addCallMethod(String string, String string2, int n2, String[] stringArray) {
        this.addRule(string, new CallMethodRule(string2, n2, stringArray));
    }

    public void addCallMethod(String string, String string2, int n2, Class[] classArray) {
        this.addRule(string, new CallMethodRule(string2, n2, classArray));
    }

    public void addCallParam(String string, int n2) {
        this.addRule(string, new CallParamRule(n2));
    }

    public void addCallParam(String string, int n2, String string2) {
        this.addRule(string, new CallParamRule(n2, string2));
    }

    public void addCallParam(String string, int n2, boolean bl) {
        this.addRule(string, new CallParamRule(n2, bl));
    }

    public void addCallParam(String string, int n2, int n3) {
        this.addRule(string, new CallParamRule(n2, n3));
    }

    public void addCallParamPath(String string, int n2) {
        this.addRule(string, new PathCallParamRule(n2));
    }

    public void addObjectParam(String string, int n2, Object object) {
        this.addRule(string, new ObjectParamRule(n2, object));
    }

    public void addFactoryCreate(String string, String string2) {
        this.addFactoryCreate(string, string2, false);
    }

    public void addFactoryCreate(String string, Class clazz) {
        this.addFactoryCreate(string, clazz, false);
    }

    public void addFactoryCreate(String string, String string2, String string3) {
        this.addFactoryCreate(string, string2, string3, false);
    }

    public void addFactoryCreate(String string, Class clazz, String string2) {
        this.addFactoryCreate(string, clazz, string2, false);
    }

    public void addFactoryCreate(String string, ObjectCreationFactory objectCreationFactory) {
        this.addFactoryCreate(string, objectCreationFactory, false);
    }

    public void addFactoryCreate(String string, String string2, boolean bl) {
        this.addRule(string, new FactoryCreateRule(string2, bl));
    }

    public void addFactoryCreate(String string, Class clazz, boolean bl) {
        this.addRule(string, new FactoryCreateRule(clazz, bl));
    }

    public void addFactoryCreate(String string, String string2, String string3, boolean bl) {
        this.addRule(string, new FactoryCreateRule(string2, string3, bl));
    }

    public void addFactoryCreate(String string, Class clazz, String string2, boolean bl) {
        this.addRule(string, new FactoryCreateRule(clazz, string2, bl));
    }

    public void addFactoryCreate(String string, ObjectCreationFactory objectCreationFactory, boolean bl) {
        objectCreationFactory.setDigester(this);
        this.addRule(string, new FactoryCreateRule(objectCreationFactory, bl));
    }

    public void addObjectCreate(String string, String string2) {
        this.addRule(string, new ObjectCreateRule(string2));
    }

    public void addObjectCreate(String string, Class clazz) {
        this.addRule(string, new ObjectCreateRule(clazz));
    }

    public void addObjectCreate(String string, String string2, String string3) {
        this.addRule(string, new ObjectCreateRule(string2, string3));
    }

    public void addObjectCreate(String string, String string2, Class clazz) {
        this.addRule(string, new ObjectCreateRule(string2, clazz));
    }

    public void addSetNestedProperties(String string) {
        this.addRule(string, new SetNestedPropertiesRule());
    }

    public void addSetNestedProperties(String string, String string2, String string3) {
        this.addRule(string, new SetNestedPropertiesRule(string2, string3));
    }

    public void addSetNestedProperties(String string, String[] stringArray, String[] stringArray2) {
        this.addRule(string, new SetNestedPropertiesRule(stringArray, stringArray2));
    }

    public void addSetNext(String string, String string2) {
        this.addRule(string, new SetNextRule(string2));
    }

    public void addSetNext(String string, String string2, String string3) {
        this.addRule(string, new SetNextRule(string2, string3));
    }

    public void addSetRoot(String string, String string2) {
        this.addRule(string, new SetRootRule(string2));
    }

    public void addSetRoot(String string, String string2, String string3) {
        this.addRule(string, new SetRootRule(string2, string3));
    }

    public void addSetProperties(String string) {
        this.addRule(string, new SetPropertiesRule());
    }

    public void addSetProperties(String string, String string2, String string3) {
        this.addRule(string, new SetPropertiesRule(string2, string3));
    }

    public void addSetProperties(String string, String[] stringArray, String[] stringArray2) {
        this.addRule(string, new SetPropertiesRule(stringArray, stringArray2));
    }

    public void addSetProperty(String string, String string2, String string3) {
        this.addRule(string, new SetPropertyRule(string2, string3));
    }

    public void addSetTop(String string, String string2) {
        this.addRule(string, new SetTopRule(string2));
    }

    public void addSetTop(String string, String string2, String string3) {
        this.addRule(string, new SetTopRule(string2, string3));
    }

    public void clear() {
        this.k = "";
        this.b.clear();
        this.n.clear();
        this.p = null;
        this.v.clear();
        this.C.clear();
        this.D = null;
    }

    public Object peek() {
        try {
            return this.v.peek();
        }
        catch (EmptyStackException emptyStackException) {
            this.y.warn("Empty stack (returning null)");
            return null;
        }
    }

    public Object peek(int n2) {
        try {
            return this.v.peek(n2);
        }
        catch (EmptyStackException emptyStackException) {
            this.y.warn("Empty stack (returning null)");
            return null;
        }
    }

    public Object pop() {
        try {
            Object object = this.v.pop();
            if (this.E != null) {
                object = this.E.onPop(this, null, object);
            }
            return object;
        }
        catch (EmptyStackException emptyStackException) {
            this.y.warn("Empty stack (returning null)");
            return null;
        }
    }

    public void push(Object object) {
        if (this.E != null) {
            object = this.E.onPush(this, null, object);
        }
        if (this.v.size() == 0) {
            this.r = object;
        }
        this.v.push(object);
    }

    public void push(String string, Object object) {
        h h2;
        if (this.E != null) {
            object = this.E.onPush(this, string, object);
        }
        if ((h2 = (h)this.C.get(string)) == null) {
            h2 = new h();
            this.C.put(string, h2);
        }
        h2.push(object);
    }

    public Object pop(String string) {
        Object object = null;
        h h2 = (h)this.C.get(string);
        if (h2 == null) {
            if (this.y.isDebugEnabled()) {
                this.y.debug("Stack '" + string + "' is empty");
            }
            throw new EmptyStackException();
        }
        object = h2.pop();
        if (this.E != null) {
            object = this.E.onPop(this, string, object);
        }
        return object;
    }

    public Object peek(String string) {
        return this.peek(string, 0);
    }

    public Object peek(String string, int n2) {
        Object object = null;
        h h2 = (h)this.C.get(string);
        if (h2 == null) {
            if (this.y.isDebugEnabled()) {
                this.y.debug("Stack '" + string + "' is empty");
            }
            throw new EmptyStackException();
        }
        object = h2.peek(n2);
        return object;
    }

    public boolean isEmpty(String string) {
        boolean bl = true;
        h h2 = (h)this.C.get(string);
        if (h2 != null) {
            bl = h2.isEmpty();
        }
        return bl;
    }

    public Object getRoot() {
        return this.r;
    }

    public void resetRoot() {
        this.r = null;
    }

    protected final void a() {
        Iterator iterator = this.B.iterator();
        while (iterator.hasNext()) {
            InputSource inputSource = (InputSource)iterator.next();
            try {
                inputSource.getByteStream().close();
            }
            catch (IOException iOException) {}
        }
    }

    protected final void b() {
        if (this.e) {
            return;
        }
        this.e = true;
    }

    public Object peekParams() {
        try {
            return this.n.peek();
        }
        catch (EmptyStackException emptyStackException) {
            this.y.warn("Empty stack (returning null)");
            return null;
        }
    }

    public Object peekParams(int n2) {
        try {
            return this.n.peek(n2);
        }
        catch (EmptyStackException emptyStackException) {
            this.y.warn("Empty stack (returning null)");
            return null;
        }
    }

    public Object popParams() {
        try {
            if (this.y.isTraceEnabled()) {
                this.y.trace("Popping params");
            }
            return this.n.pop();
        }
        catch (EmptyStackException emptyStackException) {
            this.y.warn("Empty stack (returning null)");
            return null;
        }
    }

    public void pushParams(Object object) {
        if (this.y.isTraceEnabled()) {
            this.y.trace("Pushing params");
        }
        this.n.push(object);
    }

    public SAXException createSAXException(String string, Exception exception) {
        Object object;
        if (exception != null && exception instanceof InvocationTargetException && (object = ((InvocationTargetException)exception).getTargetException()) != null && object instanceof Exception) {
            exception = (Exception)object;
        }
        if (this.j != null) {
            object = "Error at line " + this.j.getLineNumber() + " char " + this.j.getColumnNumber() + ": " + string;
            if (exception != null) {
                return new SAXParseException((String)object, this.j, exception);
            }
            return new SAXParseException((String)object, this.j);
        }
        this.y.error("No Locator!");
        if (exception != null) {
            return new SAXException(string, exception);
        }
        return new SAXException(string);
    }

    public SAXException createSAXException(Exception exception) {
        Throwable throwable;
        if (exception instanceof InvocationTargetException && (throwable = ((InvocationTargetException)exception).getTargetException()) != null && throwable instanceof Exception) {
            exception = (Exception)throwable;
        }
        return this.createSAXException(exception.getMessage(), exception);
    }

    public SAXException createSAXException(String string) {
        return this.createSAXException(string, null);
    }
}

