/*
 * Decompiled with CFR 0.152.
 */
package com.projity.datatype;

import com.projity.datatype.Rate;
import com.projity.field.Field;
import com.projity.util.ClassUtils;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class PercentFormat
extends Format {
    private static NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private static NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
    public static double NULL_VALUE = -987654.321;
    private static Format percentFormatterInstance = null;

    public static Format getInstance() {
        if (percentFormatterInstance == null) {
            percentFormatterInstance = new PercentFormat();
        }
        return percentFormatterInstance;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        Number number = PERCENT_FORMAT.parse(string, parsePosition);
        if (number == null && (number = NUMBER_FORMAT.parse(string, parsePosition)) != null) {
            number = new Double(number.doubleValue() / 100.0);
        }
        return number;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (ClassUtils.isMultipleValue(object)) {
            stringBuffer.append(Field.MULTIPLE_VALUES);
            return stringBuffer;
        }
        if (ClassUtils.isDefaultValue(object)) {
            return stringBuffer;
        }
        Object object2 = object instanceof Rate ? new Double(((Rate)object).getValue()) : object;
        PERCENT_FORMAT.format(object2, stringBuffer, fieldPosition);
        return stringBuffer;
    }

    public String format(double d2) {
        return this.format(new Double(d2));
    }

    public static boolean isSpecialValue(Double d2) {
        return d2.equals(ClassUtils.PERCENT_MULTIPLE_VALUES) || d2 == NULL_VALUE;
    }
}

