/*
 * Decompiled with CFR 0.152.
 */
package com.projity.field;

import com.projity.configuration.Configuration;
import com.projity.document.Document;
import com.projity.document.ObjectEvent;
import com.projity.field.Field;
import java.util.HashSet;
import java.util.Iterator;

public abstract class AlgorithmFieldUpdater
extends Thread {
    Object eventSource;
    Document document;
    protected HashSet inputFields = new HashSet();
    protected HashSet outputFields = new HashSet();

    public AlgorithmFieldUpdater(Object object, Document document) {
        this.eventSource = object;
        this.document = document;
    }

    public void run() {
        this.fireOutputEvents(this.eventSource, null);
    }

    public void fireOutputEvents(Object object, Object object2) {
        Iterator iterator = this.outputFields.iterator();
        ObjectEvent objectEvent = ObjectEvent.getInstance(object);
        objectEvent.setObject(object2);
        while (iterator.hasNext() && !this.isInterrupted()) {
            Field field = (Field)iterator.next();
            objectEvent.setField(field);
            this.document.getObjectEventManager().fire(objectEvent);
        }
        objectEvent.recycle();
    }

    public boolean inputContains(Field field) {
        return this.inputFields.contains(field);
    }

    public boolean outputContains(Field field) {
        return this.outputFields.contains(field);
    }

    protected void addInputField(String string) {
        Field field = Configuration.getFieldFromId(string);
        if (field == null) {
            Field.log.error("could not add input field (probably not yet implemented)" + string);
        } else {
            this.inputFields.add(field);
        }
    }

    protected void addOutputField(String string) {
        Field field = Configuration.getFieldFromId(string);
        if (field == null) {
            Field.log.error("could not add output field (probably not yet implemented)" + string);
        } else {
            this.outputFields.add(field);
        }
    }
}

