/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.calendar;

import com.projity.pm.calendar.InvalidCalendarIntersectionException;
import com.projity.pm.calendar.WorkDay;
import com.projity.strings.Messages;
import java.io.Serializable;

public class WorkWeek
implements Cloneable,
Serializable {
    static final long serialVersionUID = 2555674567677L;
    public static final int DAYS_IN_WEEK = 7;
    public static final long MS_IN_WEEK = 604800000L;
    WorkDay[] workDay = new WorkDay[7];
    private static String WEEKDAY_MASK = new String(Messages.getString("Calendar.WeekdayBitMaskFromSundayToSaturday"));
    private long workingDuration = 0L;

    public Object clone() {
        WorkWeek workWeek = new WorkWeek();
        for (int i2 = 0; i2 < 7; ++i2) {
            workWeek.workDay[i2] = this.workDay[i2] == null ? null : (WorkDay)this.workDay[i2].clone();
        }
        return workWeek;
    }

    public WorkWeek(WorkDay[] workDayArray) {
        this.workDay = (WorkDay[])workDayArray.clone();
        this.updateWorkingDuration();
    }

    public WorkWeek() {
        for (int i2 = 0; i2 < 7; ++i2) {
            this.workDay[i2] = null;
        }
    }

    public WorkDay getWeekDay(int n2) {
        return this.workDay[n2];
    }

    WorkWeek intersectWith(WorkWeek workWeek) throws InvalidCalendarIntersectionException {
        WorkWeek workWeek2 = new WorkWeek();
        for (int i2 = 0; i2 < 7; ++i2) {
            workWeek2.workDay[i2] = this.workDay[i2].intersectWith(workWeek.getWeekDay(i2));
        }
        workWeek2.updateWorkingDuration();
        if (workWeek2.getDuration() == 0L) {
            throw new InvalidCalendarIntersectionException();
        }
        return workWeek2;
    }

    public void setWeekDay(int n2, WorkDay workDay) {
        if (workDay != null) {
            workDay.initialize();
        }
        this.workDay[n2] = workDay;
        this.updateWorkingDuration();
    }

    public void setWeekDays(WorkDay workDay) {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (WEEKDAY_MASK.charAt(i2) != '1') continue;
            this.setWeekDay(i2, workDay);
        }
        this.updateWorkingDuration();
    }

    public void setWeekends(WorkDay workDay) {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (WEEKDAY_MASK.charAt(i2) != '0') continue;
            this.setWeekDay(i2, workDay);
        }
        this.updateWorkingDuration();
    }

    public void addDaysFrom(WorkWeek workWeek) {
        for (int i2 = 0; i2 < 7; ++i2) {
            if (workWeek.workDay[i2] != null) {
                this.workDay[i2] = workWeek.workDay[i2];
            }
            this.workDay[i2].initialize();
        }
        this.updateWorkingDuration();
    }

    void updateWorkingDuration() {
        this.workingDuration = 0L;
        for (int i2 = 0; i2 < 7; ++i2) {
            if (this.workDay[i2] == null) continue;
            this.workingDuration += this.workDay[i2].getDuration();
        }
    }

    public final long getDuration() {
        return this.workingDuration;
    }
}

