/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.resource;

import com.projity.configuration.Settings;
import com.projity.document.Document;
import com.projity.document.ObjectEvent;
import com.projity.document.ObjectEventManager;
import com.projity.document.ObjectSelectionEventManager;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeList;
import com.projity.grouping.core.OutlineCollection;
import com.projity.grouping.core.OutlineCollectionImpl;
import com.projity.grouping.core.model.AssignmentNodeModel;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelDataFactory;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.pm.resource.EnterpriseResource;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.task.Project;
import com.projity.undo.DataFactoryUndoController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ResourcePool
implements Document,
NodeModelDataFactory {
    private String name = "";
    private ArrayList resourceList = new ArrayList();
    private ArrayList projects = new ArrayList();
    private ObjectEventManager objectEventManager = new ObjectEventManager();
    private int resourceIdCounter = 0;
    private WorkingCalendar defaultCalendar;
    private static ResourcePool globalPool = null;
    private transient HashMap<Long, Resource> idMap = null;
    private OutlineCollection resourceOutlines = new OutlineCollectionImpl(Settings.numHierarchies(), this);
    private transient boolean isDirty = false;
    protected boolean master;
    protected boolean local;
    protected transient DataFactoryUndoController undoController;

    protected ResourcePool(String string, DataFactoryUndoController dataFactoryUndoController) {
        this.name = string;
        globalPool = this;
        this.defaultCalendar = CalendarService.getInstance().getDefaultInstance();
        this.undoController = dataFactoryUndoController;
    }

    public static ResourcePool createRourcePool(String string, DataFactoryUndoController dataFactoryUndoController) {
        ResourcePool resourcePool = new ResourcePool(string, dataFactoryUndoController);
        resourcePool.initializeOutlines();
        return resourcePool;
    }

    public Resource findById(long l2) {
        if (this.idMap == null) {
            this.idMap = new HashMap();
            for (Resource resource : this.getResourceList()) {
                this.idMap.put(resource.getUniqueId(), resource);
            }
        }
        return this.idMap.get(l2);
    }

    public void initializeId(Resource resource) {
        long l2 = ++this.resourceIdCounter;
        resource.setId(l2);
    }

    public void initializeOutlines() {
        int n2 = Settings.numHierarchies();
        for (int i2 = 0; i2 < n2; ++i2) {
            NodeModel nodeModel = this.resourceOutlines.getOutline(i2);
            if (nodeModel == null) continue;
            if (nodeModel instanceof AssignmentNodeModel) {
                AssignmentNodeModel assignmentNodeModel = (AssignmentNodeModel)nodeModel;
                assignmentNodeModel.setDocument(this);
            }
            this.initOutline(nodeModel);
        }
    }

    public void addAndInitializeId(Resource resource) {
        this.add(resource);
        this.initializeId(resource);
    }

    public void add(Resource resource) {
        this.resourceList.add(resource);
    }

    public void remove(Resource resource) {
        this.resourceList.remove(resource);
    }

    public ResourceImpl newResourceInstance() {
        EnterpriseResource enterpriseResource = new EnterpriseResource(this.isLocal(), this);
        ResourceImpl resourceImpl = new ResourceImpl(enterpriseResource);
        this.addAndInitializeId(resourceImpl);
        return resourceImpl;
    }

    public Resource createScriptedResource() {
        ResourceImpl resourceImpl = this.newResourceInstance();
        this.resourceOutlines.addToAll(resourceImpl, null);
        return resourceImpl;
    }

    public ArrayList getResourceList() {
        return this.resourceList;
    }

    public static Resource findResourceByName(Object object, Object object2) {
        Iterator iterator = ((ResourcePool)object2).getResourceList().iterator();
        String string = (String)object;
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!resource.getName().equals(string)) continue;
            return resource;
        }
        return null;
    }

    public static Resource findResourceByInitials(Object object, Object object2) {
        Iterator iterator = ((ResourcePool)object2).getResourceList().iterator();
        int n2 = (Integer)object;
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (resource.getId() != (long)n2) continue;
            return resource;
        }
        return null;
    }

    public NodeModel getResourceOutline() {
        NodeModel nodeModel = this.resourceOutlines.getOutline();
        return nodeModel;
    }

    public NodeModel getResourceOutline(int n2) {
        NodeModel nodeModel = this.resourceOutlines.getOutline(n2);
        return nodeModel;
    }

    public void addToDefaultOutline(Node node, Node node2) {
        this.resourceOutlines.addToDefaultOutline(node, node2);
    }

    public void addToDefaultOutline(Node node, Node node2, int n2, boolean bl) {
        this.resourceOutlines.addToDefaultOutline(node, node2, n2, bl);
    }

    public Object createUnvalidatedObject(NodeModel nodeModel, Object object) {
        EnterpriseResource enterpriseResource = new EnterpriseResource(this.isLocal(), this);
        ResourceImpl resourceImpl = new ResourceImpl(enterpriseResource);
        resourceImpl.getGlobalResource().setMaster(this.isMaster());
        resourceImpl.getGlobalResource().setLocal(this.isLocal());
        this.addUnvalidatedObject(resourceImpl, nodeModel, object);
        return resourceImpl;
    }

    public void addUnvalidatedObject(Object object, NodeModel nodeModel, Object object2) {
    }

    public void validateObject(Object object, NodeModel nodeModel, Object object2, Object object3, boolean bl) {
        if (!(object instanceof Resource)) {
            return;
        }
        Resource resource = (Resource)object;
        ((ResourceImpl)resource).getGlobalResource().setResourcePool(this);
        this.add(resource);
        if (bl) {
            this.initializeId(resource);
        }
        this.resourceOutlines.addToAll(object, nodeModel);
    }

    public void remove(Object object, NodeModel nodeModel, boolean bl, boolean bl2, boolean bl3) {
        this.remove((Resource)object);
        this.resourceOutlines.removeFromAll(object, nodeModel);
    }

    public void addProject(Project project) {
        this.projects.add(project);
    }

    public void removeProject(Project project) {
        this.projects.remove(project);
    }

    public ArrayList getProjects() {
        return this.projects;
    }

    public void addObjectListener(ObjectEvent.Listener listener) {
        this.objectEventManager.addListener(listener);
    }

    public void removeObjectListener(ObjectEvent.Listener listener) {
        this.objectEventManager.removeListener(listener);
    }

    public ObjectEventManager getObjectEventManager() {
        return this.objectEventManager;
    }

    public void fireUpdateEvent(Object object, Object object2) {
        this.objectEventManager.fireUpdateEvent(object, object2);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int fireMultipleTransaction(int n2, boolean bl) {
        return 0;
    }

    public final WorkCalendar getDefaultCalendar() {
        return this.defaultCalendar;
    }

    public ArrayList extractCalendars() {
        return WorkingCalendar.extractCalendars(this.resourceList);
    }

    public final boolean isGroupDirty() {
        return this.isDirty;
    }

    public final void setGroupDirty(boolean bl) {
        System.out.println("ResourcePool.setGroupDirty(" + bl + ")");
        this.isDirty = bl;
        if (bl) {
            for (Project project : this.getProjects()) {
                project.setGroupDirty(true);
            }
        }
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean bl) {
        this.master = bl;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean bl) {
        this.local = bl;
    }

    public void updateOutlineTypes() {
        NodeModel[] nodeModelArray = this.resourceOutlines.getOutlines();
        for (int i2 = 0; i2 < nodeModelArray.length; ++i2) {
            this.initOutline(nodeModelArray[i2]);
        }
    }

    public void initOutline(NodeModel nodeModel) {
        if (nodeModel != null) {
            nodeModel.setLocal(this.local);
            nodeModel.setMaster(this.master);
        }
    }

    public DataFactoryUndoController getUndoController() {
        return this.undoController;
    }

    public void setUndoController(DataFactoryUndoController dataFactoryUndoController) {
        this.undoController = dataFactoryUndoController;
    }

    public void rollbackUnvalidated(NodeModel nodeModel, Object object) {
    }

    public NodeModelDataFactory getFactoryToUseForChildOfParent(Object object) {
        return this;
    }

    public void setAllChildrenDirty(boolean bl) {
    }

    public boolean containsAssignments() {
        return true;
    }

    public static final Object[] userResources() {
        Iterator iterator = globalPool.getResourceList().iterator();
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!resource.isUser()) continue;
            arrayList.add(resource);
        }
        return arrayList.toArray();
    }

    public static final Resource findResource(String string) {
        return ResourcePool.findResourceByName(string, globalPool);
    }

    public List getChildrenResoures(Resource resource) {
        NodeModel nodeModel = this.getResourceOutline();
        Node node = nodeModel.search(resource);
        return NodeList.nodeListToImplList(nodeModel.getChildren(node));
    }

    public Resource getRbsParentResource(Resource resource) {
        Node node;
        NodeModel nodeModel = this.getResourceOutline();
        Node node2 = nodeModel.getParent(node = nodeModel.search(resource));
        if (node2 == null || node2.isVoid()) {
            return null;
        }
        return (Resource)node2.getImpl();
    }

    public void setLocalParent(Resource resource, Resource resource2) {
        Node node = this.getResourceOutline().search(resource);
        Node node2 = resource2 == null ? null : this.getResourceOutline().search(resource2);
        this.setLocalParent(node, node2);
    }

    public void setLocalParent(Node node, Node node2) {
        Resource resource = (Resource)node.getImpl();
        Resource resource2 = (Resource)(node2 == null ? null : node2.getImpl());
        if (this.getRbsParentResource(resource) == resource2) {
            return;
        }
        Node node3 = this.getResourceOutline().search(this.getRbsParentResource(resource));
        if (node3 != null) {
            node3.getChildren().remove(node);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(node);
        this.getResourceOutline().move(node2, arrayList, -1, 3);
    }

    public ObjectSelectionEventManager getObjectSelectionEventManager() {
        return null;
    }
}

