/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.scheduling;

import com.projity.datatype.Duration;
import com.projity.pm.assignment.Allocation;
import com.projity.pm.scheduling.SchedulingRule;
import com.projity.strings.Messages;
import com.projity.util.Alert;

public class FixedDuration
implements SchedulingRule {
    private static FixedDuration instance = null;

    public String toString() {
        return Messages.getString("FixedDuration.FixedDuration");
    }

    public void adjustRemainingUnits(Allocation allocation, double d2, double d3, boolean bl, boolean bl2) {
        allocation.adjustRemainingUnits(d2, d3, bl, bl2);
    }

    public void adjustRemainingDuration(Allocation allocation, long l2, boolean bl) {
        allocation.adjustRemainingDuration(Duration.millis(l2), bl);
    }

    public void adjustRemainingWork(Allocation allocation, long l2, boolean bl) {
        long l3 = allocation.getRemainingWork();
        this.adjustRemainingWork(allocation, l2, l3, bl);
    }

    public void adjustRemainingWork(Allocation allocation, long l2, long l3, boolean bl) {
        l2 = Duration.millis(l2);
        double d2 = allocation.getRemainingUnits();
        if (l3 == 0L) {
            allocation.adjustRemainingDuration((long)((double)l2 / d2), bl);
            Alert.warn(Messages.getString("FixedDuration.TheDurationMessage"));
        } else {
            allocation.adjustRemainingUnits(d2 * (double)l2 / (double)l3, d2, bl, false);
        }
    }

    private FixedDuration() {
    }

    public static FixedDuration getInstance() {
        if (instance == null) {
            instance = new FixedDuration();
        }
        return instance;
    }
}

