/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.resource;

import com.projity.menu.HyperLinkToolTip;
import com.projity.util.ClassLoaderUtils;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JToolTip;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.JComponentModifier;
import org.apache.batik.util.gui.resource.JToolbarButton;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceFormatException;
import org.apache.batik.util.gui.resource.ResourceManager;

public class ButtonFactory
extends ResourceManager {
    private static final String ICON_SUFFIX = ".icon";
    private static final String TEXT_SUFFIX = ".text";
    private static final String MNEMONIC_SUFFIX = ".mnemonic";
    private static final String ACTION_SUFFIX = ".action";
    private static final String SELECTED_SUFFIX = ".selected";
    public static final String TOOLTIP_SUFFIX = ".tooltip";
    public static final String HELP_SUFFIX = ".help";
    public static final String DEMO_SUFFIX = ".demo";
    public static final String DOC_SUFFIX = ".doc";
    private ActionMap actions;
    protected ClassLoader classLoader;

    public ButtonFactory(ResourceBundle resourceBundle, ActionMap actionMap) {
        super(resourceBundle);
        this.actions = actionMap;
        this.classLoader = ClassLoaderUtils.getLocalClassLoader();
    }

    public JButton createJButton(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JButton jButton;
        try {
            jButton = new JButton(this.getString(string + TEXT_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            jButton = new JButton();
        }
        this.initializeButton(jButton, string);
        return jButton;
    }

    public AbstractButton createJToolbarButton(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JToolbarButton jToolbarButton = new JToolbarButton(){

            public Point getToolTipLocation(MouseEvent mouseEvent) {
                if (this.getToolTipText().startsWith("<html>")) {
                    return new Point(0, this.getHeight() - 2);
                }
                return super.getToolTipLocation(mouseEvent);
            }

            public JToolTip createToolTip() {
                if (this.getToolTipText().startsWith("<html>")) {
                    HyperLinkToolTip hyperLinkToolTip = new HyperLinkToolTip();
                    hyperLinkToolTip.setComponent(this);
                    return hyperLinkToolTip;
                }
                return super.createToolTip();
            }
        };
        this.initializeButton(jToolbarButton, string);
        return jToolbarButton;
    }

    public JRadioButton createJRadioButton(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JRadioButton jRadioButton = new JRadioButton(this.getString(string + TEXT_SUFFIX));
        this.initializeButton(jRadioButton, string);
        try {
            jRadioButton.setSelected(this.getBoolean(string + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jRadioButton;
    }

    public JCheckBox createJCheckBox(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JCheckBox jCheckBox = new JCheckBox(this.getString(string + TEXT_SUFFIX));
        this.initializeButton(jCheckBox, string);
        try {
            jCheckBox.setSelected(this.getBoolean(string + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return jCheckBox;
    }

    protected void initializeButton(AbstractButton abstractButton, String string) throws ResourceFormatException, MissingListenerException {
        Object object;
        Object object2;
        try {
            object2 = this.actions.getAction(this.getString(string + ACTION_SUFFIX));
            if (object2 == null) {
                throw new MissingListenerException("", "Action", string + ACTION_SUFFIX);
            }
            abstractButton.setAction((Action)object2);
            abstractButton.setText(this.getString(string + TEXT_SUFFIX));
            if (object2 instanceof JComponentModifier) {
                ((JComponentModifier)object2).addJComponent(abstractButton);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            object2 = this.getString(string + ICON_SUFFIX);
            object = this.classLoader.getResource((String)object2);
            if (object != null) {
                abstractButton.setIcon(new ImageIcon((URL)object));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            object2 = this.getString(string + MNEMONIC_SUFFIX);
            if (((String)object2).length() != 1) {
                throw new ResourceFormatException("Malformed mnemonic", this.bundle.getClass().getName(), string + MNEMONIC_SUFFIX);
            }
            abstractButton.setMnemonic(((String)object2).charAt(0));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            object2 = this.getStringOrNull(string + TOOLTIP_SUFFIX);
            if (object2 != null) {
                object = this.getStringOrNull(string + HELP_SUFFIX);
                String string2 = this.getStringOrNull(string + DEMO_SUFFIX);
                String string3 = this.getStringOrNull(string + DOC_SUFFIX);
                if (string3 != null) {
                    object2 = HyperLinkToolTip.helpTipText((String)object2, (String)object, string2, string3);
                }
                abstractButton.setToolTipText((String)object2);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

