/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.ExceptionMessage;

public class ResolveVisitor
extends ClassCodeVisitorSupport
implements ExpressionTransformer {
    private ClassNode currentClass;
    private static final String[] DEFAULT_IMPORTS = new String[]{"java.lang.", "java.io.", "java.net.", "java.util.", "groovy.lang.", "groovy.util."};
    private CompilationUnit compilationUnit;
    private Map cachedClasses = new HashMap();
    private static final Object NO_CLASS = new Object();
    private static final Object SCRIPT = new Object();
    private SourceUnit source;
    private VariableScope currentScope;
    private boolean isTopLevelProperty = true;
    private boolean inClosure = false;

    public ResolveVisitor(CompilationUnit cu) {
        this.compilationUnit = cu;
    }

    public void startResolving(ClassNode node, SourceUnit source) {
        this.source = source;
        this.visitClass(node);
    }

    public void visitConstructor(ConstructorNode node) {
        this.visitAnnotations(node);
        VariableScope oldScope = this.currentScope;
        this.currentScope = node.getVariableScope();
        Parameter[] paras = node.getParameters();
        for (int i = 0; i < paras.length; ++i) {
            ClassNode t = paras[i].getType();
            this.resolveOrFail(t, node);
        }
        ClassNode[] exceptions = node.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            ClassNode t = exceptions[i];
            this.resolveOrFail(t, node);
        }
        Statement code = node.getCode();
        if (code != null) {
            code.visit(this);
        }
        this.currentScope = oldScope;
    }

    public void visitSwitch(SwitchStatement statement) {
        Expression exp = statement.getExpression();
        statement.setExpression(this.transform(exp));
        List list = statement.getCaseStatements();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            CaseStatement caseStatement = (CaseStatement)iter.next();
            caseStatement.visit(this);
        }
        statement.getDefaultStatement().visit(this);
    }

    public void visitMethod(MethodNode node) {
        this.visitAnnotations(node);
        VariableScope oldScope = this.currentScope;
        this.currentScope = node.getVariableScope();
        Parameter[] paras = node.getParameters();
        for (int i = 0; i < paras.length; ++i) {
            ClassNode t = paras[i].getType();
            this.resolveOrFail(t, node);
            if (!paras[i].hasInitialExpression()) continue;
            Expression init = paras[i].getInitialExpression();
            paras[i].setInitialExpression(this.transform(init));
        }
        ClassNode[] exceptions = node.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            ClassNode t = exceptions[i];
            this.resolveOrFail(t, node);
        }
        this.resolveOrFail(node.getReturnType(), node);
        Statement code = node.getCode();
        if (code != null) {
            code.visit(this);
        }
        this.currentScope = oldScope;
    }

    public void visitField(FieldNode node) {
        this.visitAnnotations(node);
        ClassNode t = node.getType();
        this.resolveOrFail(t, node);
        Expression init = node.getInitialExpression();
        node.setInitialValueExpression(this.transform(init));
    }

    public void visitProperty(PropertyNode node) {
        this.visitAnnotations(node);
        ClassNode t = node.getType();
        this.resolveOrFail(t, node);
        Statement code = node.getGetterBlock();
        if (code != null) {
            code.visit(this);
        }
        if ((code = node.getSetterBlock()) != null) {
            code.visit(this);
        }
    }

    public void visitIfElse(IfStatement ifElse) {
        this.visitStatement(ifElse);
        ifElse.setBooleanExpression((BooleanExpression)this.transform(ifElse.getBooleanExpression()));
        ifElse.getIfBlock().visit(this);
        ifElse.getElseBlock().visit(this);
    }

    private void resolveOrFail(ClassNode type, String msg, ASTNode node) {
        if (this.resolve(type)) {
            return;
        }
        this.addError("unable to resolve class " + type.getName() + " " + msg, node);
    }

    private void resolveOrFail(ClassNode type, ASTNode node, boolean prefereImports) {
        if (prefereImports && this.resolveAliasFromModule(type)) {
            return;
        }
        this.resolveOrFail(type, node);
    }

    private void resolveOrFail(ClassNode type, ASTNode node) {
        this.resolveOrFail(type, "", node);
    }

    private boolean resolve(ClassNode type) {
        String name = type.getName();
        return this.resolve(type, true, true, true);
    }

    private boolean resolve(ClassNode type, boolean testModuleImports, boolean testDefaultImports, boolean testStaticInnerClasses) {
        if (type.isResolved()) {
            return true;
        }
        if (type.isArray()) {
            ClassNode element = type.getComponentType();
            boolean resolved = this.resolve(element, testModuleImports, testDefaultImports, testStaticInnerClasses);
            if (resolved) {
                ClassNode cn = element.makeArray();
                type.setRedirect(cn);
            }
            return resolved;
        }
        if (this.currentClass == type) {
            return true;
        }
        if (this.currentClass.getNameWithoutPackage().equals(type.getName())) {
            type.setRedirect(this.currentClass);
            return true;
        }
        return this.resolveFromModule(type, testModuleImports) || this.resolveFromCompileUnit(type) || this.resovleFromDefaultImports(type, testDefaultImports) || this.resolveFromStaticInnerClasses(type, testStaticInnerClasses) || this.resolveFromClassCache(type) || this.resolveToClass(type) || this.resolveToScript(type);
    }

    private boolean resolveFromClassCache(ClassNode type) {
        String name = type.getName();
        Object val = this.cachedClasses.get(name);
        if (val == null || val == NO_CLASS) {
            return false;
        }
        this.setClass(type, (Class)val);
        return true;
    }

    private long getTimeStamp(Class cls) {
        Long o;
        try {
            Field field = cls.getField("__timeStamp");
            o = (Long)field.get(null);
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
        return o;
    }

    private boolean isSourceNewer(URL source, Class cls) {
        try {
            long lastMod;
            if (source.getProtocol().equals("file")) {
                String path = source.getPath().replace('/', File.separatorChar).replace('|', ':');
                File file = new File(path);
                lastMod = file.lastModified();
            } else {
                lastMod = source.openConnection().getLastModified();
            }
            return lastMod > this.getTimeStamp(cls);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean resolveToScript(ClassNode type) {
        String name = type.getName();
        if (this.cachedClasses.get(name) == NO_CLASS) {
            return false;
        }
        if (this.cachedClasses.get(name) == SCRIPT) {
            this.cachedClasses.put(name, NO_CLASS);
        }
        if (name.startsWith("java.")) {
            return type.isResolved();
        }
        if (name.indexOf(36) != -1) {
            return type.isResolved();
        }
        ModuleNode module = this.currentClass.getModule();
        if (module.hasPackageName() && name.indexOf(46) == -1) {
            return type.isResolved();
        }
        GroovyClassLoader gcl = this.compilationUnit.getClassLoader();
        URL url = null;
        try {
            url = gcl.getResourceLoader().loadGroovySource(name);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url != null) {
            if (type.isResolved()) {
                Class cls = type.getTypeClass();
                if (!this.isSourceNewer(url, cls)) {
                    return true;
                }
                this.cachedClasses.remove(type.getName());
                type.setRedirect(null);
            }
            SourceUnit su = this.compilationUnit.addSource(url);
            this.currentClass.getCompileUnit().addClassNodeToCompile(type, su);
            return true;
        }
        return type.isResolved();
    }

    private boolean resolveFromStaticInnerClasses(ClassNode type, boolean testStaticInnerClasses) {
        if (testStaticInnerClasses &= type.hasPackageName()) {
            String name;
            String replacedPointType = name = type.getName();
            int lastPoint = replacedPointType.lastIndexOf(46);
            replacedPointType = replacedPointType.substring(0, lastPoint) + "$" + replacedPointType.substring(lastPoint + 1);
            type.setName(replacedPointType);
            if (this.resolve(type, false, false, true)) {
                return true;
            }
            type.setName(name);
        }
        return false;
    }

    private boolean resovleFromDefaultImports(ClassNode type, boolean testDefaultImports) {
        if (testDefaultImports &= !type.hasPackageName()) {
            int size = DEFAULT_IMPORTS.length;
            for (int i = 0; i < size; ++i) {
                String packagePrefix = DEFAULT_IMPORTS[i];
                String name = type.getName();
                String fqn = packagePrefix + name;
                type.setName(fqn);
                if (this.resolve(type, false, false, false)) {
                    return true;
                }
                type.setName(name);
            }
            String name = type.getName();
            if (name.equals("BigInteger")) {
                type.setRedirect(ClassHelper.BigInteger_TYPE);
                return true;
            }
            if (name.equals("BigDecimal")) {
                type.setRedirect(ClassHelper.BigDecimal_TYPE);
                return true;
            }
        }
        return false;
    }

    private boolean resolveFromCompileUnit(ClassNode type) {
        CompileUnit compileUnit = this.currentClass.getCompileUnit();
        if (compileUnit == null) {
            return false;
        }
        ClassNode cuClass = compileUnit.getClass(type.getName());
        if (cuClass != null) {
            if (type != cuClass) {
                type.setRedirect(cuClass);
            }
            return true;
        }
        return false;
    }

    private void setClass(ClassNode n, Class cls) {
        ClassNode cn = ClassHelper.make(cls);
        n.setRedirect(cn);
    }

    private void ambigousClass(ClassNode type, ClassNode iType, String name, boolean resolved) {
        if (resolved && !type.getName().equals(iType.getName())) {
            this.addError("reference to " + name + " is ambigous, both class " + type.getName() + " and " + iType.getName() + " match", type);
        } else {
            type.setRedirect(iType);
        }
    }

    private boolean resolveAliasFromModule(ClassNode type) {
        String name;
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return false;
        }
        String pname = name = type.getName();
        int index = name.length();
        do {
            ClassNode aliasedNode;
            if ((aliasedNode = module.getImport(pname = name.substring(0, index))) == null) continue;
            if (pname.length() == name.length()) {
                type.setRedirect(aliasedNode);
                return true;
            }
            String newName = aliasedNode.getName() + name.substring(pname.length());
            type.setName(newName);
            if (this.resolve(type, true, true, true)) {
                return true;
            }
            type.setName(name);
        } while ((index = pname.lastIndexOf(46)) != -1);
        return false;
    }

    private boolean resolveFromModule(ClassNode type, boolean testModuleImports) {
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return false;
        }
        String name = type.getName();
        if (!type.hasPackageName() && module.hasPackageName()) {
            type.setName(module.getPackageName() + name);
        }
        List moduleClasses = module.getClasses();
        Iterator iter = moduleClasses.iterator();
        while (iter.hasNext()) {
            ClassNode mClass = (ClassNode)iter.next();
            if (!mClass.getName().equals(type.getName())) continue;
            if (mClass != type) {
                type.setRedirect(mClass);
            }
            return true;
        }
        type.setName(name);
        if (testModuleImports) {
            if (this.resolveAliasFromModule(type)) {
                return true;
            }
            boolean resolved = false;
            if (module.hasPackageName()) {
                type.setName(module.getPackageName() + name);
                resolved = this.resolve(type, false, false, false);
            }
            List packages = module.getImportPackages();
            ClassNode iType = ClassHelper.makeWithoutCaching(name);
            Iterator iter2 = packages.iterator();
            while (iter2.hasNext()) {
                String packagePrefix = (String)iter2.next();
                String fqn = packagePrefix + name;
                iType.setName(fqn);
                if (this.resolve(iType, false, false, true)) {
                    this.ambigousClass(type, iType, name, resolved);
                    return true;
                }
                iType.setName(name);
            }
            if (!resolved) {
                type.setName(name);
            }
            return resolved;
        }
        return false;
    }

    private boolean resolveToClass(ClassNode type) {
        String name = type.getName();
        if (this.cachedClasses.get(name) == NO_CLASS) {
            return false;
        }
        if (this.currentClass.getModule().hasPackageName() && name.indexOf(46) == -1) {
            return false;
        }
        GroovyClassLoader loader = this.compilationUnit.getClassLoader();
        Class cls = null;
        try {
            cls = loader.loadClass(name, false, true);
        }
        catch (ClassNotFoundException cnfe) {
            this.cachedClasses.put(name, SCRIPT);
            return false;
        }
        catch (CompilationFailedException cfe) {
            this.compilationUnit.getErrorCollector().addErrorAndContinue(new ExceptionMessage(cfe, true, this.source));
            return false;
        }
        if (cls == null) {
            return false;
        }
        this.cachedClasses.put(name, cls);
        this.setClass(type, cls);
        return cls.getClassLoader() == loader;
    }

    public Expression transform(Expression exp) {
        if (exp == null) {
            return null;
        }
        if (exp instanceof VariableExpression) {
            return this.transformVariableExpression((VariableExpression)exp);
        }
        if (exp.getClass() == PropertyExpression.class) {
            return this.transformPropertyExpression((PropertyExpression)exp);
        }
        if (exp instanceof DeclarationExpression) {
            return this.transformDeclarationExpression((DeclarationExpression)exp);
        }
        if (exp instanceof BinaryExpression) {
            return this.transformBinaryExpression((BinaryExpression)exp);
        }
        if (exp instanceof MethodCallExpression) {
            return this.transformMethodCallExpression((MethodCallExpression)exp);
        }
        if (exp instanceof ClosureExpression) {
            return this.transformClosureExpression((ClosureExpression)exp);
        }
        if (exp instanceof ConstructorCallExpression) {
            return this.transformConstructorCallExpression((ConstructorCallExpression)exp);
        }
        this.resolveOrFail(exp.getType(), exp);
        return exp.transformExpression(this);
    }

    private String lookupClassName(PropertyExpression pe) {
        String name = "";
        for (Expression it = pe; it != null; it = it.getObjectExpression()) {
            if (it instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)it;
                if (ve == VariableExpression.SUPER_EXPRESSION || ve == VariableExpression.THIS_EXPRESSION) {
                    return null;
                }
                name = ve.getName() + "." + name;
                break;
            }
            if (it.getClass() != (class$org$codehaus$groovy$ast$expr$PropertyExpression == null ? ResolveVisitor.class$("org.codehaus.groovy.ast.expr.PropertyExpression") : class$org$codehaus$groovy$ast$expr$PropertyExpression)) {
                return null;
            }
            PropertyExpression current = it;
            String propertyPart = current.getPropertyAsString();
            if (propertyPart == null || propertyPart.equals("class")) {
                return null;
            }
            name = propertyPart + "." + name;
        }
        if (name.length() > 0) {
            return name.substring(0, name.length() - 1);
        }
        return null;
    }

    private Expression correctClassClassChain(PropertyExpression pe) {
        LinkedList<PropertyExpression> stack = new LinkedList<PropertyExpression>();
        ClassExpression found = null;
        for (Expression it = pe; it != null; it = it.getObjectExpression()) {
            if (it instanceof ClassExpression) {
                found = (ClassExpression)it;
                break;
            }
            if (it.getClass() != (class$org$codehaus$groovy$ast$expr$PropertyExpression == null ? ResolveVisitor.class$("org.codehaus.groovy.ast.expr.PropertyExpression") : class$org$codehaus$groovy$ast$expr$PropertyExpression)) {
                return pe;
            }
            stack.addFirst((PropertyExpression)it);
        }
        if (found == null) {
            return pe;
        }
        if (stack.isEmpty()) {
            return pe;
        }
        Object stackElement = stack.removeFirst();
        if (stackElement.getClass() != PropertyExpression.class) {
            return pe;
        }
        PropertyExpression classPropertyExpression = (PropertyExpression)stackElement;
        String propertyNamePart = classPropertyExpression.getPropertyAsString();
        if (propertyNamePart == null || !propertyNamePart.equals("class")) {
            return pe;
        }
        if (stack.isEmpty()) {
            return found;
        }
        stackElement = stack.removeFirst();
        if (stackElement.getClass() != PropertyExpression.class) {
            return pe;
        }
        PropertyExpression classPropertyExpressionContainer = (PropertyExpression)stackElement;
        classPropertyExpressionContainer.setObjectExpression(found);
        return pe;
    }

    protected Expression transformPropertyExpression(PropertyExpression pe) {
        ClassExpression ce;
        ClassNode type;
        ClassNode type2;
        boolean itlp = this.isTopLevelProperty;
        Expression objectExpression = pe.getObjectExpression();
        this.isTopLevelProperty = objectExpression.getClass() != PropertyExpression.class;
        objectExpression = this.transform(objectExpression);
        Expression property = this.transform(pe.getProperty());
        this.isTopLevelProperty = itlp;
        boolean spreadSafe = pe.isSpreadSafe();
        pe = new PropertyExpression(objectExpression, property, pe.isSafe());
        pe.setSpreadSafe(spreadSafe);
        String className = this.lookupClassName(pe);
        if (className != null && this.resolve(type2 = ClassHelper.make(className))) {
            return new ClassExpression(type2);
        }
        if (objectExpression instanceof ClassExpression && pe.getPropertyAsString() != null && this.resolve(type = ClassHelper.make((ce = (ClassExpression)objectExpression).getType().getName() + "$" + pe.getPropertyAsString()), false, false, false)) {
            return new ClassExpression(type);
        }
        if (this.isTopLevelProperty) {
            return this.correctClassClassChain(pe);
        }
        return pe;
    }

    protected Expression transformVariableExpression(VariableExpression ve) {
        if (ve.getName().equals("this")) {
            return VariableExpression.THIS_EXPRESSION;
        }
        if (ve.getName().equals("super")) {
            return VariableExpression.SUPER_EXPRESSION;
        }
        Variable v = ve.getAccessedVariable();
        if (v instanceof DynamicVariable) {
            ClassNode t = ClassHelper.make(ve.getName());
            if (this.resolve(t)) {
                for (VariableScope scope = this.currentScope; scope != null && !scope.isRoot() && !scope.isRoot() && scope.getReferencedClassVariables().remove(ve.getName()) != null; scope = scope.getParent()) {
                }
                ClassExpression ce = new ClassExpression(t);
                ce.setSourcePosition(ve);
                return ce;
            }
            if (!this.inClosure && ve.isInStaticContext()) {
                this.addError("the name " + v.getName() + " doesn't refer to a declared variable or class. The static" + " scope requires to declare variables before using them. If the variable should have" + " been a class check the spelling.", ve);
            }
        }
        this.resolveOrFail(ve.getType(), ve);
        return ve;
    }

    protected Expression transformBinaryExpression(BinaryExpression be) {
        Expression left = this.transform(be.getLeftExpression());
        if (be.getOperation().getType() == 1100 && left instanceof ClassExpression) {
            ClassExpression ce = (ClassExpression)left;
            this.addError("you tried to assign a value to " + ce.getType().getName(), be.getLeftExpression());
            return be;
        }
        if (left instanceof ClassExpression && be.getRightExpression() instanceof ListExpression) {
            ListExpression list = (ListExpression)be.getRightExpression();
            ClassExpression ce = (ClassExpression)left;
            if (list.getExpressions().isEmpty()) {
                return new ClassExpression(left.getType().makeArray());
            }
        }
        Expression right = this.transform(be.getRightExpression());
        BinaryExpression ret = new BinaryExpression(left, be.getOperation(), right);
        ret.setSourcePosition(be);
        return ret;
    }

    protected Expression transformClosureExpression(ClosureExpression ce) {
        Statement code;
        boolean oldInClosure = this.inClosure;
        this.inClosure = true;
        Parameter[] paras = ce.getParameters();
        if (paras != null) {
            for (int i = 0; i < paras.length; ++i) {
                ClassNode t = paras[i].getType();
                this.resolveOrFail(t, ce);
            }
        }
        if ((code = ce.getCode()) != null) {
            code.visit(this);
        }
        ClosureExpression newCe = new ClosureExpression(paras, code);
        newCe.setVariableScope(ce.getVariableScope());
        newCe.setSourcePosition(ce);
        this.inClosure = oldInClosure;
        return newCe;
    }

    protected Expression transformConstructorCallExpression(ConstructorCallExpression cce) {
        ClassNode type = cce.getType();
        this.resolveOrFail(type, cce);
        Expression expr = cce.transformExpression(this);
        return expr;
    }

    protected Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression obj = mce.getObjectExpression();
        Expression newObject = this.transform(obj);
        Expression args = this.transform(mce.getArguments());
        Expression method = this.transform(mce.getMethod());
        MethodCallExpression ret = new MethodCallExpression(newObject, method, args);
        ret.setSafe(mce.isSafe());
        ret.setImplicitThis(mce.isImplicitThis());
        ret.setSpreadSafe(mce.isSpreadSafe());
        ret.setSourcePosition(mce);
        return ret;
    }

    protected Expression transformDeclarationExpression(DeclarationExpression de) {
        Expression oldLeft = de.getLeftExpression();
        Expression left = this.transform(oldLeft);
        if (left != oldLeft) {
            ClassExpression ce = (ClassExpression)left;
            this.addError("you tried to assign a value to " + ce.getType().getName(), oldLeft);
            return de;
        }
        Expression right = this.transform(de.getRightExpression());
        if (right == de.getRightExpression()) {
            return de;
        }
        return new DeclarationExpression((VariableExpression)left, de.getOperation(), right);
    }

    public void visitAnnotations(AnnotatedNode node) {
        Map annotionMap = node.getAnnotations();
        if (annotionMap.isEmpty()) {
            return;
        }
        Iterator it = annotionMap.values().iterator();
        while (it.hasNext()) {
            AnnotationNode an = (AnnotationNode)it.next();
            if (an.isBuiltIn()) continue;
            ClassNode type = an.getClassNode();
            this.resolveOrFail(type, "unable to find class for annotation", an);
        }
    }

    public void visitClass(ClassNode node) {
        ClassNode sn;
        ClassNode oldNode = this.currentClass;
        this.currentClass = node;
        ModuleNode module = node.getModule();
        if (!module.hasImportsResolved()) {
            List l = module.getImports();
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                ImportNode element = (ImportNode)iter.next();
                ClassNode type = element.getType();
                if (this.resolve(type, false, false, false)) continue;
                this.addError("unable to resolve class " + type.getName(), type);
            }
            module.setImportsResolved(true);
        }
        if ((sn = node.getUnresolvedSuperClass()) != null) {
            this.resolveOrFail(sn, node, true);
        }
        ClassNode[] interfaces = node.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.resolveOrFail(interfaces[i], node, true);
        }
        super.visitClass(node);
        this.currentClass = oldNode;
    }

    public void visitReturnStatement(ReturnStatement statement) {
        statement.setExpression(this.transform(statement.getExpression()));
    }

    public void visitAssertStatement(AssertStatement as) {
        as.setBooleanExpression((BooleanExpression)this.transform(as.getBooleanExpression()));
        as.setMessageExpression(this.transform(as.getMessageExpression()));
    }

    public void visitCaseStatement(CaseStatement statement) {
        statement.setExpression(this.transform(statement.getExpression()));
        statement.getCode().visit(this);
    }

    public void visitCatchStatement(CatchStatement cs) {
        this.resolveOrFail(cs.getExceptionType(), cs);
        if (cs.getExceptionType() == ClassHelper.DYNAMIC_TYPE) {
            cs.getVariable().setType(ClassHelper.make(Exception.class));
        }
        super.visitCatchStatement(cs);
    }

    public void visitForLoop(ForStatement forLoop) {
        forLoop.setCollectionExpression(this.transform(forLoop.getCollectionExpression()));
        this.resolveOrFail(forLoop.getVariableType(), forLoop);
        super.visitForLoop(forLoop);
    }

    public void visitSynchronizedStatement(SynchronizedStatement sync) {
        sync.setExpression(this.transform(sync.getExpression()));
        super.visitSynchronizedStatement(sync);
    }

    public void visitThrowStatement(ThrowStatement ts) {
        ts.setExpression(this.transform(ts.getExpression()));
    }

    public void visitWhileLoop(WhileStatement loop) {
        loop.setBooleanExpression((BooleanExpression)this.transform(loop.getBooleanExpression()));
        super.visitWhileLoop(loop);
    }

    public void visitExpressionStatement(ExpressionStatement es) {
        es.setExpression(this.transform(es.getExpression()));
    }

    public void visitBlockStatement(BlockStatement block) {
        VariableScope oldScope = this.currentScope;
        this.currentScope = block.getVariableScope();
        super.visitBlockStatement(block);
        this.currentScope = oldScope;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }
}

