// Shimakuma-Green Image Viewer
// Version:3.1910
// Copyright (c) 2018-2019 Mitsuhiro Tsuda.

(function(window, $){

	window.s14vToggleUnit = function(b){
		if ($("#preview *").length>0){ $("#preview").toggle(); }
	};
	window.s14vToggleInfo = function(){
		if ($("#infoview").css("display") == "block"){ $("#infoview").hide(); }
		else { $("#infoview").show(); }
	};
	window.s14vToggleEditor = function(){};
	window.s14vToggleAnnote = function(){};
	window.s14vUpdateSize = function(w,h){
		if ($("#preview").length>0){ $("#preview").css("height",(h - 122)+"px"); }
	};
	window.s14vUpdateRect = function(x,y,w,h,rx,ry,rw,rh,rot){};
	window.s14vAdjustSize = function(){
		var wid = $(window).width();
		var hei = $(window).height();
		return {"width":wid, "height":hei};
	};

	// Tools
	window.s14vHideMyTools = function(){};
	window.s14vPreviewFileId = "1";
	window.s14vPreviewCanvasId = "";

	// Context Menu
	$("body").on("contextmenu", function(event){ event.preventDefault(); });

}(window, window.jQuery));


(function(window, $){

	var list = [];

	jQuery(window).ready(function(){

		var dropper = $("#viewer");

		dropper.on("drop",function(event){

			event.stopPropagation();
			event.preventDefault();

			$("#preview *").remove();
			$("#subview *").remove();

			if (contains( event.originalEvent.dataTransfer.types, "text/uri-list")){
				var link = event.originalEvent.dataTransfer.getData("text/uri-list");
				window.Shimakuma.Viewer.loadIn("viewer", {
					path: "",
					name: link,
					type: "json"
				});
			}
			else if(contains( event.originalEvent.dataTransfer.types, "Files")){
				var file = event.originalEvent.dataTransfer.files[0];
				var fileReader = new FileReader();
				fileReader.onload = function(event) {
					var json = JSON.parse(event.target.result);
					window.Shimakuma.Viewer.forcedInJson("viewer", json);
				}
				fileReader.readAsText(file);
			}
			else {
				cancelEvent(event);
			}
			return false;
		});

		var cancelEvent = function(event) {
			//event.preventDefault();
			//event.stopPropagation();
			return false;
		};

		function contains(list, value) {
			for( var i = 0; i < list.length; ++i ) {
				if (list[i] === value) return true;
			}
			return false;
		}

		dropper.on("dragenter dragover", function(event){
			if (contains( event.originalEvent.dataTransfer.types, "text/uri-list")){
				event.preventDefault();
			}
			else if(contains( event.originalEvent.dataTransfer.types, "Files")){
				event.preventDefault();
			}
			else {
				return false;
			}
		});

	});

	$("#infoview #s14v-mfload").on("click",function(){
		var link = $("#infoview input#s14v-mfurl").val();
		if (link != ""){

			$("#preview *").remove();
			$("#subview *").remove();

			window.Shimakuma.Viewer.loadIn("viewer", {
				path: "",
				name: link,
				type: "json"
			});
		}
		return false;
	});
	$("#infoview #s14v-mfclear").on("click",function(){
		$("#infoview input#s14v-mfurl").val("");
		return false;
	});

}(window, window.jQuery));
