/**************************************************************************/
/*  Mana : A kana(romaji)-kanji conversion engine using ChaSen algorithm.    */
/*  Copyright (C) 2003, 2004  Yamagata Yoriyuki                           */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2 of the License, or (at  */
/*  your option) any later version.                                       */
/*                                                                        */
/*  This program is distributed in the hope that it will be useful, but   */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of            */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     */
/*  General Public License for more details.                              */
/**************************************************************************/

/* $Id: darts.c 39 2004-11-14 19:58:01Z yori $ */

#include <caml/memory.h>
#include <caml/mlvalues.h>
#include <caml/alloc.h>
#include "chalib.h"
#include "dartsdic.h"
#include "tools.h"

#define DIC_BUFSIZ 256

value darts_open (value dname, value lexname, value datname){
  CAMLparam3(dname, lexname, datname);
  darts_t *da;

  da = da_open (String_val(dname), 
		String_val(lexname), 
		String_val(datname));

  CAMLreturn ((value)da);
}

value get_darts (value v){
  CAMLparam1 (v);
  int dic_no;

  dic_no = Long_val(v);
  CAMLreturn ((value)Da_dicfile[dic_no]);
}

value ndicfile (value unit){
  CAMLparam1(unit);
  CAMLreturn (Val_long(Da_ndicfile));
}

value darts_lookup (value da, value string, value pos, value len){
  CAMLparam4(da, string, pos, len);
  CAMLlocal1(mrph_array);
  int count = 0;
  long index_buffer[DIC_BUFSIZ];
  da_lex_t lex_data[DIC_BUFSIZ];
  mrph_t *mrph_buffer[16 * DIC_BUFSIZ];
  int i, num;

  num =
    da_lookup((darts_t *)da, 
	      String_val(string) + Long_val(pos), 
	      Long_val(len),
	      index_buffer, 
	      DIC_BUFSIZ);

  for (i = 0; i < num; i++) {
    int nlex, j, keyword_len;
    nlex = da_get_lex((darts_t*)da,
		      index_buffer[i],
		      lex_data, &keyword_len);

    for (j = 0; j < nlex; j++) {
      mrph_t *new_mrph;
      char *keyword;
      keyword = copy_new_string(String_val(string)+Long_val(pos), 
				keyword_len);
      
      new_mrph = (mrph_t *)malloc (sizeof (mrph_t));
      new_mrph->keyword = keyword;
      new_mrph->keyword_len = keyword_len;
      new_mrph->is_undef = 0;
      new_mrph->darts = (darts_t *)da;
      memcpy(new_mrph, lex_data + j, sizeof(da_lex_t));
      mrph_buffer[count++] = new_mrph;
    }
  }

  mrph_array = alloc(count, 0);
  for (i = 0; i < count; i++){
    Store_field (mrph_array, i, (value)mrph_buffer[i]);
  }

  CAMLreturn (mrph_array);

}
