open ScmTypes
open ScmEval
open Lexing

let interactive = Array.length Sys.argv = 1

let prompt () = 
  if interactive then
    (print_string "? ";
     flush stdout)

let open_script name = 
  let ch = open_in name in
  let exec_line = input_line ch in
    if String.length exec_line <= 2 ||
      String.sub exec_line 0 2 <> "#!"  then
	seek_in ch 0;
    ch 

let eof_stream s =
  try Stream.empty s; true
  with Stream.Failure -> false

let main () =
  if interactive then 
    (print_string "Schoca Shell (Version 0.2.3) by Christoph Bauer\n\n? ";
     flush stdout);
  let input_channel = 
    if interactive then stdin
    else open_script Sys.argv.(1) in
  let lexbuf = Lexing.from_channel input_channel in
  let prompt =
    if interactive then 
      fun v -> 
	print_string ("==> " ^ string_of_datum v ^ "\n? "); 
	flush stdout;
	v
    else fun v -> v in
  let exc_loop () =
    try ignore( ScmSchoca.parse_stream ~prompt lexbuf );
    with 
      | ScmEval.Quit | Exit -> ()
      | e ->
	  if not interactive then raise e
	  else 
	    (print_string ("Exception: " ^ Printexc.to_string e ^ "\n? ");
	     flush stdout) 
  in exc_loop ()

in 
 main ()
     
