(* 8 5) 
; ==> 40

''a 
; ==> (quote a)

(+ 3 4)
; ==> 7

((if #f + *) 3 4)
; 12

((lambda (x) (+ x x)) 4)
; ==> 8

((lambda x x) 3 4 5 6 7)
; ==> (3 4 5 6 7)

((lambda (x y . z) z) 3 4 5 6 7)
; ==> (5 6 7)

(if (> 3 2) 'yes 'no)
; ==> yes
(if (> 2 3) 'yes 'no)
; ==> no
(if (> 3 2) (- 3 2) (+ 3 2))
; ==> 1

(define x 1)
x
; ==> 1
(set! x 4)
x
; ==> 4

(cond
   ((> 3 2) 'greater)
   ((< 3 2) 'less))
; ==> greater

(cond
 ((> 3 3) 'greater)
 ((< 3 3) 'less)
 (else 'equal))
; ==> equal

(case (* 2 3)
  ((2 3 5 7) 'prime)
  ((1 4 6 8 9) 'composite))
; ==> composite

(case (car '(c d))
  ((a) 'a)
  ((b) 'b))
; ==> #unspecified

(case (car '(c d))
  ((a e i o u) 'vowel)
  ((w y) 'semivowel)
  (else 'consonant))
; ==> consonent

(and (= 2 2) (> 2 1))
; ==> #t

(and (= 2 2) (< 2 1))
; ==> #f

(and 1 2 'c '(f g))
; ==> (f g)

(and)
; ==> #t

(or (= 2 2) (> 2 1))
; ==> #t

(or (= 2 2) (< 2 1))
; ==> #t

(or #f #f #f)
; ==> #f

(define x 0)
(begin (set! x 5) (+ x 1))
; ==> 6

(let 
    ((x 2) (y 3))
  (* x y))
; ==> 6

(let
   ((x 2) (y 3))
  (let* ((x 7) (z (+ x y)))
    (* z x)))
; ==> 70

(letrec ((even?
	  (lambda (n)
	    (if (zero? n) #t
		(odd? (- n 1)))))
	 (odd?
	  (lambda (n)
	    (if (zero? n) #f
		(even? (- n 1))))))
  (even? 88))
; ==> #t

(begin 
  (display "4 plus 1 equals ")
  (display (+ 4 1)))
; ==> #unspecified, prints "4 plus 1 equals 5"

(do ((vec (make-vector 5))
     (i 0 (+ i 1)))
    ((= i 5) vec)
  (vector-set! vec i i))
; ==> #(0 1 2 3 4)

(let
    ((x '(1 3 5 7 9)))
  (do
      ((x x (cdr x))
       (sum 0 (+ sum (car x))))
      ((null? x) sum)))
; ==> 25

(let loop 
    ((numbers '(3 -2 1 6 -5))
     (nonneg '())
     (neg '()))
  (cond
   ((null? numbers) (list nonneg neg))
   ((>= (car numbers) 0)
    (loop (cdr numbers) 
	  (cons (car numbers) nonneg) neg))
   ((< (car numbers) 0)
       (loop (cdr numbers) nonneg 
	     (cons (car numbers) neg)))))
; ==> (6 1 3) (-5 -2)

(force (delay (+ 1 2)))
; ==> 3

`(list ,(+ 1 2) 4)
; ==> (list 3 4)

(let ((name 'a))
  `(list ,name ',name))
; ==> (list a (quote a))

`(a ,(+ 1 2) ,@(map abs '(4 -5 6)) b)
; ==> (list a 3 4 5 6 b)

`((foo ,(- 10 3)) ,@(cdr '(c)) . ,(car '(cons)))
; fies!
; ==> ((foo 7) . cons)

`#(10 5 ,(+ 2 2) ,@(map (lambda (n) (+ n 1)) '(1 2)) 8)
; => #(10 5 4 2 3 8)

;; nested quasi quotes
;; hairy!
`(a `(b ,(+ 1 2) ,(foo ,(+ 1 3) d) e) f)
; ==> (a `(b ,(+ 1 2) ,(foo 4 d) e) f)

(let ((name1 'x)
      (name2 'y))
  `(a `(b ,,name1 ,',name2 d) e))
; ==> (a `(b ,x ,'y d) e) 


(define fac (lambda (n) (if (zero? n) 1 (* n (fac (- n 1))))))
(fac 12)
; ==> 479001600

(define (fac n) 
  (if (zero? n) 1 (* n (fac (- n 1)))))
(fac 12)
; ==> 479001600


(define (fac . n) 
  (if (zero? n) 1 (* n (fac (- n 1)))))
(fac 12)
; ==> 479001600

(define add3
  (lambda (x) (+ x 3)))
(add3 3)
; ==> 6

(define first car)
(first '(1 2))
; ==> 1

(let 
    ((x 5))
  (define foo (lambda (y) (bar x y)))
  (define bar (lambda (a b) (+ (* a b) a)))
  (foo (+ x 3)))
; ==> 45

(eqv? #t #t)
; ==> #t

(eqv? #f #f)
; ==> #t

(define gen-counter
  (lambda ()
    (let ((n 0))
      (lambda () (set! n (+ n 1)) n))))

(let ((g (gen-counter)))
  (eqv? g g))
; ==> #t

(eqv? (gen-counter) (gen-counter))
; ==>  #f

(define gen-looser
  (lambda ()
    (let ((n 0))
      (lambda () (set! n (+ n 1)) 27))))

(let ((g (gen-looser)))
  (eqv? g g))
; ==> #t
(eqv? (gen-looser) (gen-looser))
; ?

(letrec 
    ((f (lambda ()
	  (if eqv? f g) 'both 'f))
     (g (lambda ()
	  (if eqv? f g) 'both 'g)))
  (eqv? f g))
; ?

(letrec 
    ((f (lambda ()
	  (if eqv? f g) 'f 'both))
     (g (lambda ()
	  (if eqv? f g) 'g 'both)))
  (eqv? f g))     
; ==> #f

(eqv? 'a 'a)
; ==> #t

(eqv? 'a 'b)
; ==> #f

(eqv? 2 2)
; ==> #t

(eqv? () ())
; ==> #t

(eqv? 1000000000 1000000000)
; ==> #t

(eqv? (cons 1 2) (cons 1 2))
; ==> #f

(eqv? (lambda () 1)
      (lambda () 2))
; ==> #f

(eqv? #f 'nil)
; ==> #f

(let ((p (lambda (x) x)))
  (eqv? p p))
; ==> #t

(eq? 'a 'a)
; ==> #t

(eq? (list 'a) (list 'a))
; ==> #f

(equal? 'a 'a)
; ==> #t

(equal? '(a) '(a))
; ==> #t

(equal? (make-vector 5 'a)
	(make-vector 5 'a))
; ==> #t

(odd? 1)
; ==> #t
(odd? 88)
; ==> #f

(even? 1)
; ==> #f
(even? 88)
; ==> #t

(max 1 4 1 2 6)
; ==> 6
(max 3 4)
; ==> 4

(max 3.9 4)
; ==> 4.

(+ 3)
; ==> 3

(+)
; ==> 0

(*)
; ==> 1

(* 3)
; ==> 3

(/ 3)
; ==> 1/3

(/ 3 4 5)
; ==> 3/20

(abs -7)
; ==> 7

(modulo 13 4)
; ==> 1

(remainder 13 4)
; ==> 1

(modulo -13 4)
; ==> 3

(remainder -13 4)
; ==> -1

(modulo 13 -4)
; ==> -3

(remainder 13 -4)
; ==> 1

(modulo -13  -4)
; ==> -1

(remainder -13 -4)
; ==> -1

(remainder -13 -4.0)
; ==> -1.0

'(a . (b . (c . (d . (e . ())))))
; ==> (a b c d e)

'(a b c d . e)
; ==> (a b c d . e)

(complex? 3+4i)
; ==> #t

(complex? 3)
; ==> #t

(real? 3)
; ==> #t

(real? -2.5+0.0)
; ==> #t

(real? #e1e10)
; ==> #t


(rational? 6/10)
; ==> #t

(rational? 6/3)
; ==> #t

(integer? 3+0i)
; ==> #t

(integer? 3.0)
; ==> #t

(integer? 8/4)
; ==> #t


(string->number "100")
; ==> 100

(string->number "100" 16)
; ==> 256

(string->number "1e2")
; ==> 100

(string->number "15##")
; ==> 1500.0

'#f
; ==> #f

(not 3)
; ==> #f

(not #f)
; ==> #t

(not '())
; ==> #f

(boolean? '#t)
; ==> #t

(boolean? 0)
; ==> #f

'(a . (b . (c . (d . (e. ())))))
; ==> (a b c d e)

'(a . (b . (c . d)))
; ==> (a b c . d)

(define x (list 'a 'b 'c))
(define y x)
y
; ==> (a b c)
(list? y)
; ==> #t

(set-cdr! x 4)
x
; ==> (a . 4)
(eqv? x y)
; ==> #t
y
; ==> (a . 4)
(list? y)
; ==> #f

(set-cdr! x x)
(list? x)
; ==> #f

(pair? '(a . b))
; ==> #t

(pair? '(a b c))
; ==> #t

(cons 'a ())
; ==> (a)

(cons '(a b) 'c)
; ==> ((a b) . c)

(list)
; ==> ()

(length '())
; ==> 0

(length '(a b c))
; ==> 3

(length '(a b (a b c)))
; ==> 3

(append '(a) '(b) '(c))
; ==> (a b c)

(append '(x) '(y))
; ==> (x y)

(append '(a) '(b c d))
; ==> (a b c d)

(append '(a (b)) '((c)))
; ==> (a (b) (c))

(append '() 'a)
; ==> a

(append '(a b) '(c . d))
; ==> (a b c . d)

(reverse '(a b c))
; ==> (c b a)

(reverse '(a (b c) d (e (f))))
; ==> ((e (f))  d (b c) a)

(memq 'a '(a b c))
; ==> (a b c)
(memq 'b '(a b c))
; ==> (b c)
(memq 'a '(b c d))
; ==> #f

(memq (list 'a) '(b (a) c))
; ==> #f

(member (list 'a) '(b (a) c))
; ==> ((a) c)

(memv 101 '(100 101 102))
; ==> (101 102)

(define e '((a 1) (b 2) (c 3)))
(assq 'a e)
; ==> (a 1)
(assq 'b e)
; ==> (b 2)
(assq 'd e)
; ==> #f

(assoc (list 'a) '(((b)) ((a)) ((c))))
; ==> (a)

(assq (list 'a) '(((b)) ((a)) ((c))))
; ==> #f

(assv 5 '((2 3) (5 7) (11 13)))
; ==> (5 7)

(symbol->string 'flying-fish)
; ==> "flying-fish"

(string->symbol "foo")
; ==> foo

(string->symbol "Foo")
; ==> Foo

(symbol? 'foo)
; ==> #t

(char<? #\A #\B)
; ==> #t

(char-ci=? #\A #\a)
; ==> #t

(integer->char 65)
; ==> #\A

(char->integer #\A)
; ==> 65

(string? "hallo")
; ==> #t

(string #\a #\b #\c)
; ==> "abc"

(string-length "foo")
; ==> 3

(define s (make-string 12 #\a))
(string-set! s 1 #\b)
s
; => "abaaaaaaaaaa"
(string-ref s 1)
; ==> #\b

(string>? "abc" "bcd")
; ==> #f

(string-ci=? "Foo" "foo")
; ==> #t

(substring "foobar" 3 6)
; ==> "bar"

(string-append "fo" "o" "bar")
; ==> foobar

(vector 'a 'b 'c)
; ==> #(a b c)

(procedure? car)
; ==> #t

(procedure? 'car)
; ==> #f

(apply + (list 3 4))
; ==> 7

(define compose 
  (lambda (f g)
    (lambda args 
      (f (apply g args)))))
((compose sqrt *) 12 75)
; ==> 30

(map cadr '((a b) (d e) (g h)))
; ==> (b e h)

(map (lambda (n) (expt n n))
     '(1 2 3 4 5))
; ==> (1 4 27 256 3125)

(map + '(1 2 3) '(4 5 6))
; ==> 5 7 9

(let ((count 0))
  (map (lambda (ignored)
	 (set! count (+ count 1))
	 count)
       '(a b)))
; ==> (1 2) or (2 1)
;              ^^^^^ schoca output

(let ((v (make-vector 5)))
  (for-each
   (lambda (i)
     (vector-set! v i (* i i)))
   '(0 1 2 3 4))
  v)
; ==> #(0 1 4 9 16)

(call-with-current-continuation
 (lambda (exit)
   (for-each (lambda (x)
	       (if (negative? x)
		   (exit x)))
	     '(54 0 37 -3 245 19))
   #t))     
; ==> -3

(define my-list-length
  (lambda (obj)
    (call-with-current-continuation
     (lambda (return)
       (letrec ((r
		 (lambda (obj)
		   (cond ((null? obj) 0)
			 ((pair? obj) (+ (r (cdr obj)) 1))
			 (else (return #f))))))
	 (r obj))))))

     
(my-list-length '(1 2 3 4))
; ==>  4

(my-list-length '(a b . c))
;  ==>  #f

(force (delay (+ 1 2)))               
;  ==>  3

(let ((p (delay (+ 1 2))))
(list (force p) (force p)))
; (3 3)

(define a-stream
  (letrec ((next
	    (lambda (n)
	      (cons n (delay (next (+ n 1)))))))
    (next 0)))
(define head car)
(define tail
  (lambda (stream) (force (cdr stream))))

(head (tail (tail a-stream)))

; ==> 2



(define count 0)
(define p
  (delay (begin (set! count (+ count 1))
		(if (> count x)
		    count
		    (force p)))))
(define x 5)
p
;; ==>  #delayed
(force p)
;; ==>  6
p
;                                      ==>  a promise, still
(begin (set! x 10)
     (force p)) 
;; ==>  6

(call-with-values (lambda () (values 4 5))
  (lambda (a b) b))
; ==> 5


(call-with-values * -)
; ==> -1

(eval '(* 7 3) (scheme-report-environment 5))
; ==> 21

(char-upper-case? #\A)
; ==> #t

(char-lower-case? #\A)
; ==> #f

(char-numeric? #\A)
; ==> #f

(char-alphabetic? #\A)
; ==> #t

(getenv "HOME")
; ==> ?

(list->string '(#\a #\b #\c))
; ==> "abc"

(string->list "abc")
; ==> (#\a #\b #\c)

(gcd 32 -36)
; ==> 4

(gcd)
; ==> 0

(lcm 32 -36)
; => 288

(lcm 32.0 -36)
; ==> 288.0

(lcm)
; ==> 1

(numerator (/ 6 4))
; ==> 3

(denominator (/ 6 4))
; ==> 2

 (denominator
       (exact->inexact (/ 6 4)))
; ==> 2.0

(quit)
